#!/usr/bin/perl

package eBay::API::XML::DataType::ListingDurationDefinitionsType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. ListingDurationDefinitionsType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::DataType::ListingDurationDefinitionsType

=head1 DESCRIPTION

A container node for sets of durations, each set describing the durations allowed for
one listing type.



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::DataType::ListingDurationDefinitionsType inherits from the L<eBay::API::XML::BaseDataType> class

=cut

use eBay::API::XML::BaseDataType;
our @ISA = ("eBay::API::XML::BaseDataType");

use eBay::API::XML::DataType::ListingDurationDefinitionType;


my @gaProperties = ( [ 'ListingDuration', 'ns:ListingDurationDefinitionType', '1'
	     ,'eBay::API::XML::DataType::ListingDurationDefinitionType', '1' ]
                    );
push @gaProperties, @{eBay::API::XML::BaseDataType::getPropertiesList()};

my @gaAttributes = ( [ 'Version', 'xs:int', '', '', '' ]
                    );
push @gaAttributes, @{eBay::API::XML::BaseDataType::getAttributesList()};

=head1 Subroutines:

=cut

sub new {
  my $classname = shift;
  my %args = @_;
  my $self = $classname->SUPER::new(%args);
  return $self;
}

sub isScalar {
   return 0; 
}



=head2 setListingDuration()

Contains the duration periods that apply to a certain listing type.

#    Argument: reference to an array  
                      of 'ns:ListingDurationDefinitionType'

=cut

sub setListingDuration {
  my $self = shift;
  $self->{'ListingDuration'} = 
		$self->convertArray_To_RefToArrayIfNeeded(@_);
}

=head2 getListingDuration()

  Calls: GetCategoryFeatures
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

#    Returns: reference to an array  
                      of 'ns:ListingDurationDefinitionType'

=cut

sub getListingDuration {
  my $self = shift;
  return $self->_getDataTypeArray('ListingDuration');
}




=head2 setVersion()

The current version of the feature. Some features (for example, ShippingTermsRequired)
do not have version numbers.

#    Argument: 'xs:int'

=cut

sub setVersion {
  my $self = shift;
  $self->{'Version'} = shift
}

=head2 getVersion()

  Calls: GetCategoryFeatures
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

#    Returns: 'xs:int'

=cut

sub getVersion {
  my $self = shift;
  return $self->{'Version'};
}



##  Attribute and Property lists
sub getPropertiesList {
   my $self = shift;
   return \@gaProperties;
}

sub getAttributesList {
   my $self = shift;
   return \@gaAttributes;
}



1;   
