package ZooZ;
$ZooZ::VERSION = '1.9.1';
use strict;
use warnings;

# ABSTRACT: A Perl/Tk GUI builder in pure Perl/Tk. 

1;

__END__

=pod

=encoding UTF-8

=head1 NAME

ZooZ - A Perl/Tk GUI builder in pure Perl/Tk. 

=head1 VERSION

version 1.9.1

=head1 SYNOPSIS

    % zooz

=head1 DESCRIPTION

ZooZ is a GUI builder for Perl/Tk written in pure Perl/Tk. It has the
following features:

=over 4

=item *

Intuitive interface.

=item *

Support for a wide variety of widgets.

=item *

Ability to save/load projects.

=item *

Ability to dump stand-alone Perl code.

=item *

Ability to dump code as a Perl module in the form of a Perl/Tk mega widget.

=item *

Includes a simple IDE for defining variables and subroutines.

=back

=head1 STATUS AND LIMITATIONS

ZooZ is an on-going effort, and will probably stay so for a long time. At this stage,
though, I consider it to be very usable. There are some major limitations though.
For a comprehensive list of missing features, you can look at the Progress.txt
file that comes in the root directory of the distribution. If you think there is
something else that should be included in that file, then drop me a note.

=head1 REQUIREMENTS

To run ZooZ, you need Tk804, which in turn needs Perl 5.8 or better.
I will probably support Tk800 sometime in the future, in which case
any Perl5 version will be supported.

In addition Tk::ToolBar is required. Again, I will probably make this
optional in a future release.

=head1 OPTIONAL COMPONENTS

Tk::CodeText is optional. If present it will be used in the simple
IDE to highlight user-entered Perl code. If missing, a regular
Tk::Text will be used.

=head1 TIPS

=over 4

=item *

You can create a project, then save the code as a Perl Module with a F<.pm> extension.
This will create a composite mega widget, with the same name as your project, but with
any non-alphanumeric characters switched to underscores. For example, C<Project 1.5> will
be changed to C<Project_1_5>. You can then B<use> this in a larger program as a regular
widget.

For example, if you dumped your module into F<myMod.pm>, and your project was called
C<Project 1.5>, then you would do this in your main code:

    use myMod;
    my $project = $parent->Project_1_5->pack;

Note also that the mega widget will F<Advertise()> every widget in your project.
So, if your project had a canvas called Canvas1, you can access it like this:

    my $cv = $project->Subwidget('Canvas1');

=item *

ZooZ automatically defines a hash called I<%ZWIDGETS> that holds the project's
widgets. This allows the user to access any widget inside of a callback via
I<$ZWIDGETS{WidgetName}> where B<WidgetName> is the name of the widget.

=item *

You can click on the row and column numbers to configure their properties.

=item *

If you want a row or column to take up more space than it currently does,
then increase its greediness. Remember that widgets are confined to the
space of the grids they occupy.

=back

=head1 BUGS

You tell me! If you think you found a bug, or you want to discuss anything
ZooZ-related, then please drop me a note at I<aqumsieh@cpan.org>.

=head1 ACKNOWLEDGEMENTS

I'm indebted to everyone on comp.lang.perl.tk for constructive comments and
bug reports. Many people also emailed me with bugs and suggestions. It is

=head1 AUTHOR

Ala Qumsieh, faraco <skelic3@gmail.com>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2004-2005, 2018 by Ala Qumsieh, faraco.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
