#!perl -T

use Test::More tests => 6;
use Archive::Har();
use JSON();

my $har = Archive::Har->new();

my $fiddler_string = <<'_FIDDLER2_RESULTS_';
﻿{"log":{"creator":{"comment":"http://www.fiddler2.com", "version":"4.6.0.2", "name":"Fiddler"}, "entries":[{"startedDateTime":"2015-09-05T17:11:08.5888671+10:00", "response":{"headersSize":306, "httpVersion":"HTTP/1.1", "content":{"compression":0, "size":89156, "comment":"Body length exceeded fiddler.importexport.HTTPArchiveJSON.MaxTextBodyLength, so body was omitted.", "mimeType":"text/html"}, "status":200, "bodySize":89156, "statusText":"OK", "headers":[{"name":"Date", "value":"Sat, 05 Sep 2015 07:11:10 GMT"}, {"name":"Server", "value":"Plack/Starman (Perl)"}, {"name":"Cache-Control", "value":"max-age=699"}, {"name":"Content-Length", "value":"89156"}, {"name":"Content-Type", "value":"text/html"}, {"name":"Expires", "value":"Sat, 05 Sep 2015 07:22:50 GMT"}, {"name":"Last-Modified", "value":"Sat, 05 Sep 2015 07:11:10 GMT"}, {"name":"Keep-Alive", "value":"timeout=5, max=100"}, {"name":"Connection", "value":"Keep-Alive"}], "cookies":[], "redirectURL":""}, "timings":{"send":0, "receive":1000, "wait":375, "dns":649, "ssl":0, "blocked":-1, "connect":319}, "request":{"headersSize":281, "httpVersion":"HTTP/1.1", "url":"http://search.cpan.org/recent", "cookies":[], "bodySize":0, "headers":[{"name":"Accept", "value":"text/html, application/xhtml+xml, */*"}, {"name":"Accept-Language", "value":"en-AU"}, {"name":"User-Agent", "value":"Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko"}, {"name":"Accept-Encoding", "value":"gzip, deflate"}, {"name":"Host", "value":"search.cpan.org"}, {"name":"DNT", "value":"1"}, {"name":"Connection", "value":"Keep-Alive"}], "postData":{"text":"", "mimeType":""}, "method":"GET", "queryString":[]}, "cache":{}, "connection":"ClientPort:49425;EgressPort:49428", "time":2343, "serverIPAddress":"194.106.223.155"}, {"startedDateTime":"2015-09-05T17:11:10.9326171+10:00", "response":{"headersSize":534, "httpVersion":"HTTP/1.1", "content":{"compression":4217, "size":6015, "comment":"Body length exceeded fiddler.importexport.HTTPArchiveJSON.MaxTextBodyLength, so body was omitted.", "mimeType":"text/css"}, "status":200, "bodySize":1798, "statusText":"OK", "headers":[{"name":"Date", "value":"Sat, 05 Sep 2015 07:11:12 GMT"}, {"name":"Content-Type", "value":"text/css"}, {"name":"Transfer-Encoding", "value":"chunked"}, {"name":"Connection", "value":"keep-alive"}, {"name":"Last-Modified", "value":"Thu, 27 Mar 2014 18:31:20 GMT"}, {"name":"ETag", "value":"W/\"f6754c-177f-4f59aca9e8e00\""}, {"name":"Cache-Control", "value":"max-age=86400"}, {"name":"Expires", "value":"Sun, 06 Sep 2015 01:28:51 GMT"}, {"name":"X-Proxy", "value":"proxy1"}, {"name":"Via", "value":"1.1 st.pimg.net"}, {"name":"Vary", "value":"Accept-Encoding"}, {"name":"X-Varnish", "value":"1477381054"}, {"name":"Age", "value":"0"}, {"name":"Via", "value":"1.1 varnish"}, {"name":"X-Served-By", "value":"varnish2"}, {"name":"X-Cache", "value":"MISS"}, {"name":"X-Cache-Hits", "value":"0"}, {"name":"X-Proxy", "value":"proxy2"}, {"name":"Server", "value":"NetDNA-cache/2.2"}, {"name":"X-Cache", "value":"HIT"}, {"name":"Content-Encoding", "value":"gzip"}], "cookies":[], "redirectURL":""}, "timings":{"send":0, "receive":0, "wait":203, "dns":428, "ssl":0, "blocked":-1, "connect":174}, "request":{"headersSize":299, "httpVersion":"HTTP/1.1", "url":"http://st.pimg.net/tucs/style.css?3", "cookies":[], "bodySize":0, "headers":[{"name":"Accept", "value":"text/css, */*"}, {"name":"Referer", "value":"http://search.cpan.org/recent"}, {"name":"Accept-Language", "value":"en-AU"}, {"name":"User-Agent", "value":"Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko"}, {"name":"Accept-Encoding", "value":"gzip, deflate"}, {"name":"Connection", "value":"Keep-Alive"}, {"name":"DNT", "value":"1"}, {"name":"Host", "value":"st.pimg.net"}], "postData":{"text":"", "mimeType":""}, "method":"GET", "queryString":[{"name":null, "value":"3"}]}, "cache":{}, "connection":"ClientPort:49425;EgressPort:49447", "time":805, "serverIPAddress":"108.161.187.23"}, {"startedDateTime":"2015-09-05T17:11:10.9638671+10:00", "response":{"headersSize":450, "httpVersion":"HTTP/1.1", "content":{"compression":47569, "size":72174, "comment":"Body length exceeded fiddler.importexport.HTTPArchiveJSON.MaxTextBodyLength, so body was omitted.", "mimeType":"text/javascript; charset=UTF-8"}, "status":200, "bodySize":24605, "statusText":"OK", "headers":[{"name":"Vary", "value":"Accept-Encoding"}, {"name":"Content-Encoding", "value":"gzip"}, {"name":"Content-Type", "value":"text/javascript; charset=UTF-8"}, {"name":"Last-Modified", "value":"Mon, 02 Apr 2012 18:24:28 GMT"}, {"name":"Date", "value":"Mon, 31 Aug 2015 04:31:54 GMT"}, {"name":"Expires", "value":"Tue, 30 Aug 2016 04:31:54 GMT"}, {"name":"Access-Control-Allow-Origin", "value":"*"}, {"name":"Timing-Allow-Origin", "value":"*"}, {"name":"X-Content-Type-Options", "value":"nosniff"}, {"name":"Server", "value":"sffe"}, {"name":"Content-Length", "value":"24605"}, {"name":"X-XSS-Protection", "value":"1; mode=block"}, {"name":"Cache-Control", "value":"public, max-age=31536000"}, {"name":"Age", "value":"441557"}], "cookies":[], "redirectURL":""}, "timings":{"send":0, "receive":0, "wait":109, "dns":32, "ssl":0, "blocked":-1, "connect":25}, "request":{"headersSize":355, "httpVersion":"HTTP/1.1", "url":"http://ajax.googleapis.com/ajax/libs/jquery/1.4.2/jquery.min.js", "cookies":[], "bodySize":0, "headers":[{"name":"Accept", "value":"application/javascript, */*;q=0.8"}, {"name":"Referer", "value":"http://search.cpan.org/recent"}, {"name":"Accept-Language", "value":"en-AU"}, {"name":"User-Agent", "value":"Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko"}, {"name":"Accept-Encoding", "value":"gzip, deflate"}, {"name":"Connection", "value":"Keep-Alive"}, {"name":"DNT", "value":"1"}, {"name":"Host", "value":"ajax.googleapis.com"}], "postData":{"text":"", "mimeType":""}, "method":"GET", "queryString":[]}, "cache":{}, "connection":"ClientPort:49429;EgressPort:49441", "time":166, "serverIPAddress":"216.58.220.138"}, {"startedDateTime":"2015-09-05T17:11:10.9638671+10:00", "response":{"headersSize":517, "httpVersion":"HTTP/1.1", "content":{"compression":-13, "size":4305, "comment":"Body length exceeded fiddler.importexport.HTTPArchiveJSON.MaxTextBodyLength, so body was omitted.", "mimeType":"text/x-javascript"}, "status":200, "bodySize":4318, "statusText":"OK", "headers":[{"name":"Date", "value":"Sat, 05 Sep 2015 07:11:12 GMT"}, {"name":"Content-Type", "value":"text/x-javascript"}, {"name":"Transfer-Encoding", "value":"chunked"}, {"name":"Connection", "value":"keep-alive"}, {"name":"Last-Modified", "value":"Thu, 24 Mar 2011 01:21:32 GMT"}, {"name":"ETag", "value":"\"f6760b-10d1-49f304c2b5f00\""}, {"name":"Cache-Control", "value":"max-age=86400"}, {"name":"Expires", "value":"Sun, 06 Sep 2015 01:30:06 GMT"}, {"name":"X-Proxy", "value":"proxy1"}, {"name":"Via", "value":"1.1 st.pimg.net"}, {"name":"Vary", "value":"Accept-Encoding"}, {"name":"X-Varnish", "value":"1477381480"}, {"name":"Age", "value":"0"}, {"name":"Via", "value":"1.1 varnish"}, {"name":"X-Served-By", "value":"varnish2"}, {"name":"X-Cache", "value":"MISS"}, {"name":"X-Cache-Hits", "value":"0"}, {"name":"X-Proxy", "value":"proxy2"}, {"name":"Server", "value":"NetDNA-cache/2.2"}, {"name":"X-Cache", "value":"HIT"}], "cookies":[], "redirectURL":""}, "timings":{"send":0, "receive":0, "wait":188, "dns":672, "ssl":0, "blocked":-1, "connect":179}, "request":{"headersSize":325, "httpVersion":"HTTP/1.1", "url":"http://st.pimg.net/tucs/js/sh_perl.min.js", "cookies":[], "bodySize":0, "headers":[{"name":"Accept", "value":"application/javascript, */*;q=0.8"}, {"name":"Referer", "value":"http://search.cpan.org/recent"}, {"name":"Accept-Language", "value":"en-AU"}, {"name":"User-Agent", "value":"Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko"}, {"name":"Accept-Encoding", "value":"gzip, deflate"}, {"name":"Connection", "value":"Keep-Alive"}, {"name":"DNT", "value":"1"}, {"name":"Host", "value":"st.pimg.net"}], "postData":{"text":"", "mimeType":""}, "method":"GET", "queryString":[]}, "cache":{}, "connection":"ClientPort:49432;EgressPort:49451", "time":1039, "serverIPAddress":"108.161.187.23"}, {"startedDateTime":"2015-09-05T17:11:10.9638671+10:00", "response":{"headersSize":516, "httpVersion":"HTTP/1.1", "content":{"compression":-12, "size":3418, "comment":"Body length exceeded fiddler.importexport.HTTPArchiveJSON.MaxTextBodyLength, so body was omitted.", "mimeType":"text/x-javascript"}, "status":200, "bodySize":3430, "statusText":"OK", "headers":[{"name":"Date", "value":"Sat, 05 Sep 2015 07:11:12 GMT"}, {"name":"Content-Type", "value":"text/x-javascript"}, {"name":"Transfer-Encoding", "value":"chunked"}, {"name":"Connection", "value":"keep-alive"}, {"name":"Last-Modified", "value":"Thu, 24 Mar 2011 01:21:32 GMT"}, {"name":"ETag", "value":"\"f67609-d5a-49f304c2b5f00\""}, {"name":"Cache-Control", "value":"max-age=86400"}, {"name":"Expires", "value":"Sun, 06 Sep 2015 01:28:51 GMT"}, {"name":"X-Proxy", "value":"proxy1"}, {"name":"Via", "value":"1.1 st.pimg.net"}, {"name":"Vary", "value":"Accept-Encoding"}, {"name":"X-Varnish", "value":"1477381059"}, {"name":"Age", "value":"0"}, {"name":"Via", "value":"1.1 varnish"}, {"name":"X-Served-By", "value":"varnish2"}, {"name":"X-Cache", "value":"MISS"}, {"name":"X-Cache-Hits", "value":"0"}, {"name":"X-Proxy", "value":"proxy2"}, {"name":"Server", "value":"NetDNA-cache/2.2"}, {"name":"X-Cache", "value":"HIT"}], "cookies":[], "redirectURL":""}, "timings":{"send":0, "receive":16, "wait":188, "dns":403, "ssl":0, "blocked":-1, "connect":174}, "request":{"headersSize":332, "httpVersion":"HTTP/1.1", "url":"http://st.pimg.net/tucs/js/jquery.styleswitch.js", "cookies":[], "bodySize":0, "headers":[{"name":"Accept", "value":"application/javascript, */*;q=0.8"}, {"name":"Referer", "value":"http://search.cpan.org/recent"}, {"name":"Accept-Language", "value":"en-AU"}, {"name":"User-Agent", "value":"Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko"}, {"name":"Accept-Encoding", "value":"gzip, deflate"}, {"name":"Connection", "value":"Keep-Alive"}, {"name":"DNT", "value":"1"}, {"name":"Host", "value":"st.pimg.net"}], "postData":{"text":"", "mimeType":""}, "method":"GET", "queryString":[]}, "cache":{}, "connection":"ClientPort:49433;EgressPort:49448", "time":781, "serverIPAddress":"108.161.187.23"}, {"startedDateTime":"2015-09-05T17:11:10.9638671+10:00", "response":{"headersSize":532, "httpVersion":"HTTP/1.1", "content":{"compression":-20, "size":92, "comment":"Body length exceeded fiddler.importexport.HTTPArchiveJSON.MaxTextBodyLength, so body was omitted.", "mimeType":"text/css"}, "status":200, "bodySize":112, "statusText":"OK", "headers":[{"name":"Date", "value":"Sat, 05 Sep 2015 07:11:12 GMT"}, {"name":"Content-Type", "value":"text/css"}, {"name":"Transfer-Encoding", "value":"chunked"}, {"name":"Connection", "value":"keep-alive"}, {"name":"Last-Modified", "value":"Tue, 07 Apr 2009 13:25:11 GMT"}, {"name":"ETag", "value":"W/\"f67571-5c-466f6f1c43bc0\""}, {"name":"Cache-Control", "value":"max-age=86400"}, {"name":"Expires", "value":"Sun, 06 Sep 2015 01:30:06 GMT"}, {"name":"X-Proxy", "value":"proxy1"}, {"name":"Via", "value":"1.1 st.pimg.net"}, {"name":"Vary", "value":"Accept-Encoding"}, {"name":"X-Varnish", "value":"1477381485"}, {"name":"Age", "value":"0"}, {"name":"Via", "value":"1.1 varnish"}, {"name":"X-Served-By", "value":"varnish2"}, {"name":"X-Cache", "value":"MISS"}, {"name":"X-Cache-Hits", "value":"0"}, {"name":"X-Proxy", "value":"proxy2"}, {"name":"Server", "value":"NetDNA-cache/2.2"}, {"name":"X-Cache", "value":"HIT"}, {"name":"Content-Encoding", "value":"gzip"}], "cookies":[], "redirectURL":""}, "timings":{"send":0, "receive":0, "wait":172, "dns":79, "ssl":0, "blocked":-1, "connect":175}, "request":{"headersSize":297, "httpVersion":"HTTP/1.1", "url":"http://st.pimg.net/tucs/print.css", "cookies":[], "bodySize":0, "headers":[{"name":"Accept", "value":"text/css, */*"}, {"name":"Referer", "value":"http://search.cpan.org/recent"}, {"name":"Accept-Language", "value":"en-AU"}, {"name":"User-Agent", "value":"Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko"}, {"name":"Accept-Encoding", "value":"gzip, deflate"}, {"name":"Connection", "value":"Keep-Alive"}, {"name":"DNT", "value":"1"}, {"name":"Host", "value":"st.pimg.net"}], "postData":{"text":"", "mimeType":""}, "method":"GET", "queryString":[]}, "cache":{}, "connection":"ClientPort:49434;EgressPort:49443", "time":426, "serverIPAddress":"108.161.187.23"}, {"startedDateTime":"2015-09-05T17:11:10.9638671+10:00", "response":{"headersSize":502, "httpVersion":"HTTP/1.1", "content":{"encoding":"base64", "compression":0, "size":5160, "text":"iVBORw0KGgoAAAANSUhEUgAAAQgAAABNCAMAAABtygqmAAADAFBMVEW//88CAgIGBgYKCgoODg4SEhIWFhYaGhoeHh4iIiImJiYqKiouLi4yMjI2NjY6Ojo+Pj5CQkJGRkZKSkpOTk5SUlJWVlZaWlpeXl5iYmJmZmZqampubm5ycnJ2dnZ6enp+fn6CgoKGhoaKioqOjo6SkpKWlpaampqenp6ioqKmpqaqqqqurq6ysrK2tra6urq+vr7CwsLGxsbKysrOzs7S0tLW1tba2tre3t7i4uLm5ubq6uru7u7y8vL29vb6+vr+/v4AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACqShimAAAAAXRSTlMAQObYZgAAAAlwSFlzAAALEwAACxMBAJqcGAAAEMFJREFUeNrtXId2IruyRVLn3NBkkw2YDB3Iwf//Va9KMDO26QDvjO+7b+ZoLQ8Yq7ulXWlXlZhc7r92vJ+Lxir373h/H1Ji/YvD+yVSCfH+ehwu74cqEcX5vxpxWBJBKHYWf7tCXAKXEKen/uW2cdlHbUJZu85Y9/A3A3GMpgojlaZACH0DJNZ/KQy5IPAokToWY0QoTXK+Vj3/jXZxCjavAqHFrkgJMQebc5nSwenvw+Gw8+cWIVrXYIQI1cVxBHi8/XU4nE/r1bZKGGnWCSXM7Idbl9DS36cQx3C1nKiAwFgGhWDV1WUiUDL+P9fT3Gm/iYLVYuWHm/33iwXi5iyIXEqEYZGIhNjD7XuBEGP/8B0C//f71aP/1vFcU1NlgYqSopmuV+oMVzyw32MSvU2mk2UQRut1FAaL+Ww2my9Xh8Px8gwO/mIVvFJKigOwDkHs+Mc30IsnPETdnmRNWb1NpwEsdAMino4nowwU5k1HhjBOYMDC6PUNI1RQ7XKrN4++XtBXJYGoAJiqKpLIcD6TZMutDqKHoThGwWwzFSiT3wwGCuEN1xeLMPsJVfSInZG7n2qSLAmCKKuqxETYTursflHEnTNFswulSqXiuZYmsSsoBIyWvcZ4+6jDpwANEnRNUwAYjp5cnD2oEJtpGGzzCqHNHl4pN1eHEbwOnlBjixI7I0E57zfhq4pipaQ736WY0mnsQAhnitsY7Q4/pHHezrslW4JNwmZl1o+7cD9mBKHwhuBStsFb3YX7UJGIldVj+hCt/KFMqDnUgEiIhfF65xFZuhyeAkIoB9nBaaIjEtVtmrJtqqjYaj1u8aMqQAGiFuLN9qhTVIPuTcLHbRNcHeiW4GQn1Mf1crmOfKAQ5K1CJMK07nL/JhKqPVOnMlGVqpvsiSXQd5Kmqu9LHZYuNrbxynJaFFHmYrxLupS4+fR+fbJuiJBPA0PMQuIcBoG/2nYIo/aUOyN3Hm4cNEXziUhgoiMTKtkTW2jhUcqEKegMs6bJmJ46jEhSgh3W0Iuw7kdBt9BrCKSSnjmdNxChw3AiQayY2+hntGb0/gYpB7gM9fECjQ0KC9g1Mye+gbjllLA8EohMjCjVp3VkIvnxf2tQ3MNHIHLrssBASlI79Z6RH/h+tC7A0+s9WKPAStPNuw3yLdYosWaPBg6HcGdOX7MmzsAy9EQgDlMGiyhk8Jd1jcgJULVR+KT36TO/wKOHleLyTjvQh2UUDgXQgDGGG9Huhrsx2rHVNSViTJ/xEYCE9JoJBCXKNpHfyhBT9MyH9qmcoOhtEAahX0JKE1ZGk/zrDYdl5C8OgQNa3WmBT2GkOt6cLbiMEbmvi8R+kGVrPLhjpMoIujOMZ0kS3yKewgNRX5cTIlSbC/+zRuR2LqcfrcTbRUG4WoOLqIBheGMF40y+s750GYYvEFzHgoD9GBIYd3mgImI/daIPd5Z2CQ6rKcKCGw8Qe09bPwHE6YXh6pJc+QkwWOzn6zAvSMTpl8EwZLk8O+xccBU68ha7ZhNFfYiWQfQteVeypKWSbZ8mA7ECjkCk6IHHNZRngMhNZATCiX/seR2EwXqy33hgEtpgiISNud31+wA4iQOOGYBxX8wHUy+IGu25QzidSW2UBQjEPoGE43LLj+DeU8NngNgaeGc9Fogz8MlwEW7CIgMc2o08boLVFtsdOAyhMIeYAYpeaJtELD/mLGu5uY4RmxEnhWwHLBGIqQTLVZePJAXT8vYZICCoIS86xvqluR8sQ39XgClmpyDiTMF73W0HIng8sT0DU0EkGjplzQdMg5JSLjdELgH0Pp9MQMJkICqYJxQfckn7JKgTgCiis/TistBTuApXq+MK47/TwkALixC7q/fAZjzxGkyK6GpFw1PYAxU7BzUil3uFiyF0ECfR0CMhCQhfu6cAKRWbp4Ao46eN2IAdQMgIFzBBzLdtnu8z2Rlt37uwlZIrEHswgM2B95KLVJSn2UAw7pTrkAgj+hU/iQyJSUA0MHOU/mG3MR6ISwWZdzfWMIJovvHzIINCC3SAm4HWDdYH0HE1XIKhlEavsoCaLtk6scJMHyHyFvq5DpdIEDtqzwJxsdBb6/t/BkSLl3K+bvns4acxe9gsVkGwmxmgCfkGOkfCvX37ddeHX2APA4EotXFDRYOhpiWRfJTpLK9twsML3o6RJCS2EMlic421got1c98BxL4AK3LvI+5pFe4X6wUIn5QaFlcmMAJITMpDi1EZKNQZbMZqV9E0IPkyNcZqhywgCredFjH+SJQ2k4CIT7pG3KYq3wLEUoWP+3dPvexW4WK3MAGl4ovLK2ICZ4WlTh5+qWGiFTrgPJB5MxCupEOW3TpnAJH/Ido8uRbJOk8B0eQlyfq3ANEFJb2nYJdDuFpu5gbgUH4BfRAx4UPZv3TAVsT81ZTmEFddE/8CBi874NG7Gczyp1YvbbybFH/FVkkAwiNoU+3vAGINbl94jYmci2Cz0kENvJaM+2S80CfW2hr82/7BVEKNOI5zTa6pbKhEHacD4fxUGR8mA3okrrC4UwGIODPTsbFE+t8AxLGLvv9yT63BQ8xAH1ixrfDSJgiCCqwBGawo93+tcWkQydMpKixhEiBhzlKB+FD0HiOxopSJ9zX7fRIQjAPx9vuBuAxMoIp3DOyyXYXR1CCC7EFQkAlvHTBi9MvACJVPAplAWC9bCBUojWxIpBClAWF9YLBDEa1DJcadFu21BCBwFcI3AHFeKpBD3hH3yynyt2OQM6vXJcrrWuAjiN4rgoE4X/LGkUSMApadQWWo7rIU/gtAmB+315PQ3IR7LeIaEecjrkF3/LuB2PXAvTXuqheX980qHAENZJU6WjFsEDml2fVgGaWv6rOdQj5WxlQIiZWmieQlBQh9+7mIRHj+Yiy/FtxBUw7xQMBSBr8TiMvp2IaoaA1i0s4A4qYGUR44Ah4H4Y0xanVsEGDtnnkd+gJRK9hswYqLpgqkeUoG4nPhucV1QibO549PEGiVWI3gJtr6XUBEk/Gk5ylUdHpxBfHNZjMEPykXqyqSBwic4CsrbRu0uBmb2PaIYBQoVwki6zpR3hKB+Fo0QueLplf0v6Znyi7WRyDev4tQXV5B3SXNaI7i+wLhcQCBTW1UMSxSTqNYo6kyonXimeOpB8bvgnUIoLmyCXFxkgSEGt2l1bwKSkqf9g2cTYvTCJUDUfhdGrHzlxAdk5oYx6gFTtsolxlPu9FXio22AWY0TOKN5zpjLmSj3DpkXSJulACE8tW01hXOSynxPt4cjxucEggVgP4tSdd9N6enEKbWa9emMl6ivdQZkY1FSiZRocSxhdt0U4nPvwAI+S7zjvJ4Eejox/6dB4wjfguItbT4TwAR9TSZaK08wd4/+iaqNgtAE4zU7u3BZaKjMc61qaRR0jjHAiHdlyp9Cy8CZ9v+ZR1F4KBxjxlwYkeG/wEgTuhA7KbBDxDgfKp1XICkmFFs2OSpZuk3FVKBYbVjgRBjaraBgrsDbtU/fSgWxQLhc2pJne8ozNxFAEoKmGbx0ycgYrfngF9vbbPuHuSJUjB5EIUsXSNyLwYIKsQVl4CnM6zx/+rLeuCZY9NSTDaAxq6+G4j3JmiBV7Rv6gCaUG7pApH7D7Q3lxaTPFlknH0pjOjD+zScstgq21zjHVUi/WDvJYEZsVXIGmY1jLxcvheI4ytESrdisqtCYAOhpYiwpYda/0DC1LJ4PcgkAhJf+SLWI2h8TjbR0U8AMZulm0ZuJCLPJXb0vUCAXWhmXWVXfYAH1hvwj/Uot19IVCvQq8fEEwNucAcESajwTrAGJwFZv2pMLakeFzncXoXWtwLRx6Ji0aLXuhxwqmpZISS/OT76hBmhegGya2QG2OKsRXdAJLX6JngVHlrhOtGkJOEcWQctA+zO/0Ygtiokmbp2wwH4QK0JAcDbPPGIOaWGo9yIGLCD8h0Qido1QeSwwYpqBIqYAERkc3LJKrvvA2IpAd29nbaDNWnlMihr8blnjETBtBjWJvAWRN59CZ8pKXT7durPBDV6IUkakauJPB0mk2y/NV7974DYmHzx18BJzGYRuNHTttgn1NN+ngBVPmkwGl2Kv+nI17po6fAODNJMmBWWsWYu/vAmaSNfSnhQlo9oCLezPSBSs2VAOPsRAQ/hqFG0LMu2HcfN571iqVKt1eovjVa70x30+2+jt9FkPlv4a/+FMM/iKoXp0f6raaSdpcVCDRY/i5cppVqinHXeWyNG5jE2LaFt0uR1hRQgAu9KJmFUqvYtNz7u5oN63tB13bgNTbv+omn8na7IyvWtppu2A/gJbkFiWIeTB5/SE2xTpRZVelfrkF/rlJlpSsdjdH6TjsSCJrDoF05POyl0agvZHVYo5XwbfFJx+b6fDpqeaWi6YVmm9XGYpmlfX0zTMEx4Y7mWYZq6DMRIz0uo5eLr55Vi6ziVz51avIVEFEi3U75fW+MxSSbW7D3tbmWaYIdVLu3U9v2BP0Os1yHrllp1SDKoIMggcVAArgWwbdyuiagY199/AoQ6omDTHvsX8CN8lb6VekaJI9FW+JEBuIuRS0VCwhqfPUphvCtZTXCWJZrU9/7iu+WCjIQXSzJYchfY1V4YBHpBEEWG/0gAj6KqaBLazUZUE72k7Pm+x73/1/bDGdBlGY8/twAFCZ+e+o3rF1yRIBK1l5wDVYib8EeXn6p7yfAwE1sUeJuTV1nIjWyzn+zi5/j1Ca9bUCry001VH884qlrtzqsfdOwQZTx+1xKv907PMLsKuWa6blIfpSuRcoIPMfmVlax8JeqU8y94SBaHDFmUJPKzywLDQenVU5FrcfvXb3zIboF3zU5xB8rXKoCb+a3ZU1PiNzfTp02t2zc0qPcW86yoTJKbxToXcuGhOlcBT57zIYiCKMuyJIkwpOsQRbARtBM+kD1hSxA4WLGoXMUQJwtfzjjaemtqlLFmL+hZ8mqI5HoujTqNxecswG9gZYQlhOpA5PVH+SHKXORtPkLoF5NADbhuX/w5wJsCRLB68yUP918mObA5dzQPfBWgjkdSjMxpq6KCeS7iIZteYzCbzler2aBZdRVcqCDH5yOnDjIceu34ns+ZGnHvFJIHwiPKxTw/WmUnZQFlJoHvbe0zufG+AVzfeEBcyxf9xwrQarlUrusGa1a8mGTxEvk9mUdfRozeaO5npSwufQYIfojEwmwLGVmczHfBW/XqfIXqZLmKzpk6YT/E6I+TmvVj8x/dOJPc2ObK1FVVpsqGIusycB3ZqC/Tl+Iy9iEkZKsEAGGAuPHEuVK+N75ZXtUEVRdVXaWKoBq1jAroqSE82Ly4nPZht1lxDRXjOfzoluOWWuMwTh3O5/V4Eu126/1+s9tGUbicLA+/0TR4+LyW6KhgmDFuYDscR1G03+c2h81msRxn1+OHneeSvcMm8IPlfLaMDv+ojHfHQlHKD5sHr/rzd4qtUcP/HSs45v4rxitKl0KEvDEHHPztzTXGKQV+eUjXiDL5k74jPcM2NRMkZBDKbSB9iGGYnIFeaZ5uQYq8zP1RoyV8DI48y+BEEwCBBAN+VMToyqxuhFPVTfXxr/P8vxkD4wcMH3k1xmv+CgwKkOC44MBXw5GIu8z9cWM5n45e2/VKyXVsU1MkSbgZBvtsHzxkABMXMWX8w/9PpvNxt4nCxXw6fhu89qqVYsG1dFUSv1KZsp/748flcnmHcQFSwl+P23XgL2fjYf/1pVb2HFOVBT34nmf/D8SlZs2VUbJtAAAAAElFTkSuQmCC", "mimeType":"image/png"}, "status":200, "bodySize":5160, "statusText":"OK", "headers":[{"name":"Date", "value":"Sat, 05 Sep 2015 07:11:12 GMT"}, {"name":"Content-Type", "value":"image/png"}, {"name":"Content-Length", "value":"5160"}, {"name":"Connection", "value":"keep-alive"}, {"name":"Last-Modified", "value":"Fri, 24 Oct 2008 02:49:08 GMT"}, {"name":"ETag", "value":"\"f675e6-1428-459f6d3423100\""}, {"name":"Cache-Control", "value":"max-age=86400"}, {"name":"Expires", "value":"Sun, 06 Sep 2015 01:30:06 GMT"}, {"name":"X-Proxy", "value":"proxy1"}, {"name":"Via", "value":"1.1 st.pimg.net"}, {"name":"X-Varnish", "value":"1477381481"}, {"name":"Age", "value":"0"}, {"name":"Via", "value":"1.1 varnish"}, {"name":"X-Served-By", "value":"varnish2"}, {"name":"X-Cache", "value":"MISS"}, {"name":"X-Cache-Hits", "value":"0"}, {"name":"X-Proxy", "value":"proxy2"}, {"name":"Server", "value":"NetDNA-cache/2.2"}, {"name":"X-Cache", "value":"HIT"}, {"name":"Accept-Ranges", "value":"bytes"}], "cookies":[], "redirectURL":""}, "timings":{"send":0, "receive":0, "wait":719, "dns":79, "ssl":0, "blocked":-1, "connect":184}, "request":{"headersSize":344, "httpVersion":"HTTP/1.1", "url":"http://st.pimg.net/tucs/img/cpan_banner.png", "cookies":[], "bodySize":0, "headers":[{"name":"Accept", "value":"image/png, image/svg+xml, image/*;q=0.8, */*;q=0.5"}, {"name":"Referer", "value":"http://search.cpan.org/recent"}, {"name":"Accept-Language", "value":"en-AU"}, {"name":"User-Agent", "value":"Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko"}, {"name":"Accept-Encoding", "value":"gzip, deflate"}, {"name":"Connection", "value":"Keep-Alive"}, {"name":"DNT", "value":"1"}, {"name":"Host", "value":"st.pimg.net"}], "postData":{"text":"", "mimeType":""}, "method":"GET", "queryString":[]}, "cache":{}, "connection":"ClientPort:49435;EgressPort:49445", "time":982, "serverIPAddress":"108.161.187.23"}, {"startedDateTime":"2015-09-05T17:11:10.9638671+10:00", "response":{"headersSize":517, "httpVersion":"HTTP/1.1", "content":{"compression":-13, "size":5305, "comment":"Body length exceeded fiddler.importexport.HTTPArchiveJSON.MaxTextBodyLength, so body was omitted.", "mimeType":"text/x-javascript"}, "status":200, "bodySize":5318, "statusText":"OK", "headers":[{"name":"Date", "value":"Sat, 05 Sep 2015 07:11:12 GMT"}, {"name":"Content-Type", "value":"text/x-javascript"}, {"name":"Transfer-Encoding", "value":"chunked"}, {"name":"Connection", "value":"keep-alive"}, {"name":"Last-Modified", "value":"Thu, 24 Mar 2011 01:21:32 GMT"}, {"name":"ETag", "value":"\"f6760a-14b9-49f304c2b5f00\""}, {"name":"Cache-Control", "value":"max-age=86400"}, {"name":"Expires", "value":"Sun, 06 Sep 2015 01:28:51 GMT"}, {"name":"X-Proxy", "value":"proxy1"}, {"name":"Via", "value":"1.1 st.pimg.net"}, {"name":"Vary", "value":"Accept-Encoding"}, {"name":"X-Varnish", "value":"1477381057"}, {"name":"Age", "value":"0"}, {"name":"Via", "value":"1.1 varnish"}, {"name":"X-Served-By", "value":"varnish2"}, {"name":"X-Cache", "value":"MISS"}, {"name":"X-Cache-Hits", "value":"0"}, {"name":"X-Proxy", "value":"proxy2"}, {"name":"Server", "value":"NetDNA-cache/2.2"}, {"name":"X-Cache", "value":"HIT"}], "cookies":[], "redirectURL":""}, "timings":{"send":0, "receive":0, "wait":188, "dns":665, "ssl":0, "blocked":-1, "connect":174}, "request":{"headersSize":325, "httpVersion":"HTTP/1.1", "url":"http://st.pimg.net/tucs/js/sh_main.min.js", "cookies":[], "bodySize":0, "headers":[{"name":"Accept", "value":"application/javascript, */*;q=0.8"}, {"name":"Referer", "value":"http://search.cpan.org/recent"}, {"name":"Accept-Language", "value":"en-AU"}, {"name":"User-Agent", "value":"Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko"}, {"name":"Accept-Encoding", "value":"gzip, deflate"}, {"name":"Connection", "value":"Keep-Alive"}, {"name":"DNT", "value":"1"}, {"name":"Host", "value":"st.pimg.net"}], "postData":{"text":"", "mimeType":""}, "method":"GET", "queryString":[]}, "cache":{}, "connection":"ClientPort:49431;EgressPort:49453", "time":1027, "serverIPAddress":"108.161.187.23"}, {"startedDateTime":"2015-09-05T17:11:10.9638671+10:00", "response":{"headersSize":516, "httpVersion":"HTTP/1.1", "content":{"compression":-12, "size":3713, "comment":"Body length exceeded fiddler.importexport.HTTPArchiveJSON.MaxTextBodyLength, so body was omitted.", "mimeType":"text/x-javascript"}, "status":200, "bodySize":3725, "statusText":"OK", "headers":[{"name":"Date", "value":"Sat, 05 Sep 2015 07:11:12 GMT"}, {"name":"Content-Type", "value":"text/x-javascript"}, {"name":"Transfer-Encoding", "value":"chunked"}, {"name":"Connection", "value":"keep-alive"}, {"name":"Last-Modified", "value":"Thu, 24 Mar 2011 01:21:32 GMT"}, {"name":"ETag", "value":"\"f67608-e81-49f304c2b5f00\""}, {"name":"Cache-Control", "value":"max-age=86400"}, {"name":"Expires", "value":"Sun, 06 Sep 2015 01:30:06 GMT"}, {"name":"X-Proxy", "value":"proxy1"}, {"name":"Via", "value":"1.1 st.pimg.net"}, {"name":"Vary", "value":"Accept-Encoding"}, {"name":"X-Varnish", "value":"1477381479"}, {"name":"Age", "value":"0"}, {"name":"Via", "value":"1.1 varnish"}, {"name":"X-Served-By", "value":"varnish2"}, {"name":"X-Cache", "value":"MISS"}, {"name":"X-Cache-Hits", "value":"0"}, {"name":"X-Proxy", "value":"proxy2"}, {"name":"Server", "value":"NetDNA-cache/2.2"}, {"name":"X-Cache", "value":"HIT"}], "cookies":[], "redirectURL":""}, "timings":{"send":0, "receive":0, "wait":203, "dns":397, "ssl":0, "blocked":-1, "connect":180}, "request":{"headersSize":327, "httpVersion":"HTTP/1.1", "url":"http://st.pimg.net/tucs/js/jquery.cookie.js", "cookies":[], "bodySize":0, "headers":[{"name":"Accept", "value":"application/javascript, */*;q=0.8"}, {"name":"Referer", "value":"http://search.cpan.org/recent"}, {"name":"Accept-Language", "value":"en-AU"}, {"name":"User-Agent", "value":"Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko"}, {"name":"Accept-Encoding", "value":"gzip, deflate"}, {"name":"Connection", "value":"Keep-Alive"}, {"name":"DNT", "value":"1"}, {"name":"Host", "value":"st.pimg.net"}], "postData":{"text":"", "mimeType":""}, "method":"GET", "queryString":[]}, "cache":{}, "connection":"ClientPort:49430;EgressPort:49450", "time":780, "serverIPAddress":"108.161.187.23"}, {"startedDateTime":"2015-09-05T17:11:10.9638671+10:00", "response":{"headersSize":500, "httpVersion":"HTTP/1.1", "content":{"encoding":"base64", "compression":0, "size":586, "text":"R0lGODlhUAAPAOYAAP///8pSAmqZC0klDf9mAPaxgwtNr7JHAJE6AExrBXWfj//BmABm/gUIB/yORHF3YImOedbX/svLy6enpzpKBEBYTysxL6J7YLe4uNWacWOBsf7t4tva2fLSvP9NAIE7DJPItGItCgoKbNjr72ZmZlRzaOt5LIS2pMxtLuFbAS4yALOOdIeCgwFf666cyHc4EJaHq+3s65CayAAA//djAOf49jR967WkzqXXxgEByicaC/2pcU85KbPk06OQuMeHWc6qkjhEQNpnGmSIeod6mzMA/9K4p/ri0f9yFVdPY2Wy/6mGkTMzzAoKnQwMPa9mNZmZ/+9gAJ1LFQFX2GlddEwhA//28LXJ53Of4pnM/2kzEPJtFPpqC+i8nqqq/zMAzPb29jFsxPCXXPr071CA19uARRQZGLyupXJycv6DMCYmJE5nX4+w4nQvAb6hjfP//v/59f/8+v/9/EdCTvdsD5hhO2YzzP3//8Ow3P1oBHZqh6rj/8Dw3/f3///+/ndSNywAAAAAUAAPAEAHr4ATgoOEhYaHiImKi4yDAASQj4+QlJOVlAQAEJucEJqdnpufoKSlpqQAgpaYrK2so6exsrOlqROrrrmYsLS9vqiqusK7v8XGnsGRHpmRr668oqjRx722uMPP1Nqyto3e3+DhhQDk5ebn6Onq6+zt7snYutDb9Mi3leS7+ZH7kajz5Opxg1dOn0Fi0kB9midQFMFmmfoVRNip3DRPDBvauxaPosZt1tyJHEmyZLoJgQAAOw==", "mimeType":"image/gif"}, "status":200, "bodySize":586, "statusText":"OK", "headers":[{"name":"Date", "value":"Sat, 05 Sep 2015 07:11:12 GMT"}, {"name":"Content-Type", "value":"image/gif"}, {"name":"Content-Length", "value":"586"}, {"name":"Connection", "value":"keep-alive"}, {"name":"Last-Modified", "value":"Fri, 24 Oct 2008 02:49:08 GMT"}, {"name":"ETag", "value":"\"f675f1-24a-459f6d3423100\""}, {"name":"Cache-Control", "value":"max-age=86400"}, {"name":"Expires", "value":"Sat, 05 Sep 2015 13:39:39 GMT"}, {"name":"X-Proxy", "value":"proxy2"}, {"name":"Via", "value":"1.1 st.pimg.net"}, {"name":"X-Varnish", "value":"1477121609"}, {"name":"Age", "value":"0"}, {"name":"Via", "value":"1.1 varnish"}, {"name":"X-Served-By", "value":"varnish2"}, {"name":"X-Cache", "value":"MISS"}, {"name":"X-Cache-Hits", "value":"0"}, {"name":"X-Proxy", "value":"proxy2"}, {"name":"Server", "value":"NetDNA-cache/2.2"}, {"name":"X-Cache", "value":"HIT"}, {"name":"Accept-Ranges", "value":"bytes"}], "cookies":[], "redirectURL":""}, "timings":{"send":0, "receive":0, "wait":188, "dns":664, "ssl":0, "blocked":-1, "connect":175}, "request":{"headersSize":339, "httpVersion":"HTTP/1.1", "url":"http://st.pimg.net/tucs/img/rss-10.gif", "cookies":[], "bodySize":0, "headers":[{"name":"Accept", "value":"image/png, image/svg+xml, image/*;q=0.8, */*;q=0.5"}, {"name":"Referer", "value":"http://search.cpan.org/recent"}, {"name":"Accept-Language", "value":"en-AU"}, {"name":"User-Agent", "value":"Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko"}, {"name":"Accept-Encoding", "value":"gzip, deflate"}, {"name":"Connection", "value":"Keep-Alive"}, {"name":"DNT", "value":"1"}, {"name":"Host", "value":"st.pimg.net"}], "postData":{"text":"", "mimeType":""}, "method":"GET", "queryString":[]}, "cache":{}, "connection":"ClientPort:49436;EgressPort:49452", "time":1027, "serverIPAddress":"108.161.187.23"}, {"startedDateTime":"2015-09-05T17:11:10.9638671+10:00", "response":{"headersSize":513, "httpVersion":"HTTP/1.1", "content":{"encoding":"base64", "compression":0, "size":487, "text":"iVBORw0KGgoAAAANSUhEUgAAABgAAAAVCAMAAABrN94UAAAA0lBMVEX////////29vvw8Pbc3PDT0+vU1NrQ0OXMzMzDw8jAwNa6uuS3t+K1tdW1tbutrd6srM+srKykpNukpMyhocecnNeZmcyZmZmMjNGPj4+FhcB4eLB1dYJoaMJxcXloaLJsbHliYr9nZ3VaWr1ZWbZWVqdSUq1OTrhMTKo/P7E+Ppo7O5Y2Nqw6OoszM60yMqMsLKkzM2YwMHssLJ4qKnUjI6MmJoEpKVoiIooXF44dHV8YGHITE40QEIQQEGQJCWwBAX0AAHIAAGYAAFkAAFIAAD7a0KKBAAAAAXRSTlMAQObYZgAAAAlwSFlzAAALEgAACxIB0t1+/AAAAAd0SU1FB9IEGA0cFul0tWsAAACbSURBVHicY2CgPlDTUVfEJi4vISrEwy+EKeEgzMjIyMTNjyGhay8ClGFE0aNhaqCnZ2xhLQ2WEYWLa9moKMrKKiqqqIJMYxSSgJvuwIgCRJWhEk7OqBIsmlAJQ1cuKGAHibPqa8PMMndxBgIXFzuQBLulGZp7rYxYQOK21mjiJkbMWMUZwOLCmOJAJ7g4OTpiigOd4OyEVZwKAAATFhDUwxPvlwAAAABJRU5ErkJggg==", "mimeType":"image/png"}, "status":200, "bodySize":487, "statusText":"OK", "headers":[{"name":"Date", "value":"Sat, 05 Sep 2015 07:11:12 GMT"}, {"name":"Content-Type", "value":"image/png"}, {"name":"Content-Length", "value":"487"}, {"name":"Connection", "value":"keep-alive"}, {"name":"Last-Modified", "value":"Fri, 24 Oct 2008 02:49:08 GMT"}, {"name":"ETag", "value":"\"f675f0-1e7-459f6d3423100\""}, {"name":"Cache-Control", "value":"max-age=86400"}, {"name":"Expires", "value":"Sat, 05 Sep 2015 12:05:39 GMT"}, {"name":"X-Proxy", "value":"proxy1"}, {"name":"Via", "value":"1.1 st.pimg.net"}, {"name":"X-Varnish", "value":"1477121608 1477086497"}, {"name":"Age", "value":"5640"}, {"name":"Via", "value":"1.1 varnish"}, {"name":"X-Served-By", "value":"varnish2"}, {"name":"X-Cache", "value":"HIT"}, {"name":"X-Cache-Hits", "value":"2"}, {"name":"X-Proxy", "value":"proxy2"}, {"name":"Server", "value":"NetDNA-cache/2.2"}, {"name":"X-Cache", "value":"HIT"}, {"name":"Accept-Ranges", "value":"bytes"}], "cookies":[], "redirectURL":""}, "timings":{"send":0, "receive":0, "wait":188, "dns":394, "ssl":0, "blocked":-1, "connect":173}, "request":{"headersSize":338, "httpVersion":"HTTP/1.1", "url":"http://st.pimg.net/tucs/img/right.png", "cookies":[], "bodySize":0, "headers":[{"name":"Accept", "value":"image/png, image/svg+xml, image/*;q=0.8, */*;q=0.5"}, {"name":"Referer", "value":"http://search.cpan.org/recent"}, {"name":"Accept-Language", "value":"en-AU"}, {"name":"User-Agent", "value":"Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko"}, {"name":"Accept-Encoding", "value":"gzip, deflate"}, {"name":"Connection", "value":"Keep-Alive"}, {"name":"DNT", "value":"1"}, {"name":"Host", "value":"st.pimg.net"}], "postData":{"text":"", "mimeType":""}, "method":"GET", "queryString":[]}, "cache":{}, "connection":"ClientPort:49438;EgressPort:49449", "time":755, "serverIPAddress":"108.161.187.23"}, {"startedDateTime":"2015-09-05T17:11:10.9794921+10:00", "response":{"headersSize":508, "httpVersion":"HTTP/1.1", "content":{"encoding":"base64", "compression":0, "size":1884, "text":"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", "mimeType":"image/gif"}, "status":200, "bodySize":1884, "statusText":"OK", "headers":[{"name":"Date", "value":"Sat, 05 Sep 2015 07:11:12 GMT"}, {"name":"Content-Type", "value":"image/gif"}, {"name":"Content-Length", "value":"1884"}, {"name":"Connection", "value":"keep-alive"}, {"name":"Last-Modified", "value":"Fri, 24 Oct 2008 02:49:08 GMT"}, {"name":"ETag", "value":"\"f675e0-75c-459f6d3423100\""}, {"name":"Cache-Control", "value":"max-age=86400"}, {"name":"Expires", "value":"Sat, 05 Sep 2015 21:04:49 GMT"}, {"name":"X-Proxy", "value":"proxy1"}, {"name":"Via", "value":"1.1 st.pimg.net"}, {"name":"X-Varnish", "value":"310264874 310257723"}, {"name":"Age", "value":"28373"}, {"name":"Via", "value":"1.1 varnish"}, {"name":"X-Served-By", "value":"x19"}, {"name":"X-Cache", "value":"HIT"}, {"name":"X-Cache-Hits", "value":"3"}, {"name":"X-Proxy", "value":"proxy2"}, {"name":"Server", "value":"NetDNA-cache/2.2"}, {"name":"X-Cache", "value":"HIT"}, {"name":"Accept-Ranges", "value":"bytes"}], "cookies":[], "redirectURL":""}, "timings":{"send":0, "receive":0, "wait":188, "dns":74, "ssl":0, "blocked":-1, "connect":185}, "request":{"headersSize":342, "httpVersion":"HTTP/1.1", "url":"http://st.pimg.net/tucs/img/DC-LOGO-S.gif", "cookies":[], "bodySize":0, "headers":[{"name":"Accept", "value":"image/png, image/svg+xml, image/*;q=0.8, */*;q=0.5"}, {"name":"Referer", "value":"http://search.cpan.org/recent"}, {"name":"Accept-Language", "value":"en-AU"}, {"name":"User-Agent", "value":"Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko"}, {"name":"Accept-Encoding", "value":"gzip, deflate"}, {"name":"Connection", "value":"Keep-Alive"}, {"name":"DNT", "value":"1"}, {"name":"Host", "value":"st.pimg.net"}], "postData":{"text":"", "mimeType":""}, "method":"GET", "queryString":[]}, "cache":{}, "connection":"ClientPort:49439;EgressPort:49444", "time":447, "serverIPAddress":"108.161.187.23"}, {"startedDateTime":"2015-09-05T17:11:10.9794921+10:00", "response":{"headersSize":514, "httpVersion":"HTTP/1.1", "content":{"encoding":"base64", "compression":0, "size":488, "text":"iVBORw0KGgoAAAANSUhEUgAAABgAAAAVCAMAAABrN94UAAAA0lBMVEX////////29vvw8Pbc3PDT0+vU1NrQ0OXMzMzDw8jAwNa6uuS3t+K1tdW1tbutrd6srM+srKykpNukpMyhocecnNeZmcyZmZmMjNGPj4+FhcB4eLB1dYJoaMJxcXloaLJsbHliYr9nZ3VaWr1ZWbZWVqdSUq1OTrhMTKo/P7E+Ppo7O5Y2Nqw6OoszM60yMqMsLKkzM2YwMHssLJ4qKnUjI6MmJoEpKVoiIooXF44dHV8YGHITE40QEIQQEGQJCWwBAX0AAHIAAGYAAFkAAFIAAD7a0KKBAAAAAXRSTlMAQObYZgAAAAlwSFlzAAALEgAACxIB0t1+/AAAAAd0SU1FB9IEGA0bFEg7QoAAAACcSURBVHicY2CgDVBU11HDIizEzyMkKiGPIc7PzcTIyCjsgKkeKMwoYq+LJi4KFpe2tjDW0zMw1YCLSwiBxIVVVRQVZWUVVWy0oOLKoowowAFmkyYLqoSzE1RCW58VxGfnggJXQ5gdZpbsIAk7FxdnIHAxR7jK2hYkw2JkheE/iAyzkQkWGWGwDGZYWTs6OrkgrEWRcXI2xyJOKQAAs3IQ1LNDjswAAAAASUVORK5CYII=", "mimeType":"image/png"}, "status":200, "bodySize":488, "statusText":"OK", "headers":[{"name":"Date", "value":"Sat, 05 Sep 2015 07:11:12 GMT"}, {"name":"Content-Type", "value":"image/png"}, {"name":"Content-Length", "value":"488"}, {"name":"Connection", "value":"keep-alive"}, {"name":"Last-Modified", "value":"Fri, 24 Oct 2008 02:49:08 GMT"}, {"name":"ETag", "value":"\"f675ec-1e8-459f6d3423100\""}, {"name":"Cache-Control", "value":"max-age=86400"}, {"name":"Expires", "value":"Sat, 05 Sep 2015 15:58:38 GMT"}, {"name":"X-Proxy", "value":"proxy1"}, {"name":"Via", "value":"1.1 st.pimg.net"}, {"name":"X-Varnish", "value":"1477372678 1477175368"}, {"name":"Age", "value":"32926"}, {"name":"Via", "value":"1.1 varnish"}, {"name":"X-Served-By", "value":"varnish2"}, {"name":"X-Cache", "value":"HIT"}, {"name":"X-Cache-Hits", "value":"1"}, {"name":"X-Proxy", "value":"proxy2"}, {"name":"Server", "value":"NetDNA-cache/2.2"}, {"name":"X-Cache", "value":"HIT"}, {"name":"Accept-Ranges", "value":"bytes"}], "cookies":[], "redirectURL":""}, "timings":{"send":0, "receive":0, "wait":188, "dns":661, "ssl":0, "blocked":-1, "connect":177}, "request":{"headersSize":337, "httpVersion":"HTTP/1.1", "url":"http://st.pimg.net/tucs/img/left.png", "cookies":[], "bodySize":0, "headers":[{"name":"Accept", "value":"image/png, image/svg+xml, image/*;q=0.8, */*;q=0.5"}, {"name":"Referer", "value":"http://search.cpan.org/recent"}, {"name":"Accept-Language", "value":"en-AU"}, {"name":"User-Agent", "value":"Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko"}, {"name":"Accept-Encoding", "value":"gzip, deflate"}, {"name":"Connection", "value":"Keep-Alive"}, {"name":"DNT", "value":"1"}, {"name":"Host", "value":"st.pimg.net"}], "postData":{"text":"", "mimeType":""}, "method":"GET", "queryString":[]}, "cache":{}, "connection":"ClientPort:49437;EgressPort:49454", "time":1026, "serverIPAddress":"108.161.187.23"}, {"startedDateTime":"2015-09-05T17:11:10.9794921+10:00", "response":{"headersSize":186, "httpVersion":"HTTP/1.0", "content":{"encoding":"base64", "compression":0, "size":692, "text":"VGhpcyBpcyBhIENPTk5FQ1QgdHVubmVsLCB0aHJvdWdoIHdoaWNoIGVuY3J5cHRlZCBIVFRQUyB0cmFmZmljIGZsb3dzLgpUbyB2aWV3IHRoZSBlbmNyeXB0ZWQgc2Vzc2lvbnMgaW5zaWRlIHRoaXMgdHVubmVsLCBlbmFibGUgdGhlIFRvb2xzID4gRmlkZGxlciBPcHRpb25zID4gSFRUUFMgPiBEZWNyeXB0IEhUVFBTIHRyYWZmaWMgb3B0aW9uLgoKQSBTU0x2My1jb21wYXRpYmxlIFNlcnZlckhlbGxvIGhhbmRzaGFrZSB3YXMgZm91bmQuIEZpZGRsZXIgZXh0cmFjdGVkIHRoZSBwYXJhbWV0ZXJzIGJlbG93LgoKVmVyc2lvbjogMy4zIChUTFMvMS4yKQpTZXNzaW9uSUQ6CTkwIDA5IDAwIDAwIDY1IDM3IDM2IDUwIDA5IDU1IEE4IDBCIDIyIEMwIDM5IEExIEJEIEJFIDNBIDIwIEE1IDhDIDFGIENBIDE5IDYzIDNGIDQzIEI0IEM0IEM3IDU5ClJhbmRvbToJCTU1IEVBIDk1IDkwIDJBIDlFIDI2IDBDIEY5IEM3IEY0IEYzIDkzIDM0IEU3IDVGIDJGIENBIDBEIENGIDMxIDE0IEFDIDNCIDM2IDBDIDdCIDE1IDg5IDczIEYyIEUzCkNpcGhlcjoJCVRMU19SU0FfV0lUSF9BRVNfMTI4X0NCQ19TSEEyNTYgWzB4MDAzQ10KQ29tcHJlc3Npb25TdWl0ZToJTk9fQ09NUFJFU1NJT04gWzB4MDBdCkV4dGVuc2lvbnM6CgkJc3RhdHVzX3JlcXVlc3QgKE9DU1Atc3RhcGxpbmcpCWVtcHR5CgkJcmVuZWdvdGlhdGlvbl9pbmZvCTAwCgo=", "mimeType":""}, "status":200, "bodySize":692, "statusText":"Connection Established", "headers":[{"name":"FiddlerGateway", "value":"Direct"}, {"name":"StartTime", "value":"17:11:11.245"}, {"name":"Connection", "value":"close"}, {"name":"EndTime", "value":"17:11:12.010"}, {"name":"ClientToServerBytes", "value":"1299"}, {"name":"ServerToClientBytes", "value":"5978"}], "cookies":[], "redirectURL":""}, "timings":{"send":0, "receive":63577069872011, "wait":0, "dns":14, "ssl":0, "blocked":-1, "connect":249}, "request":{"headersSize":168, "httpVersion":"HTTP/1.0", "url":"http://urs.microsoft.com:443", "cookies":[], "bodySize":1500, "headers":[{"name":"User-Agent", "value":"VCSoapClient"}, {"name":"Host", "value":"urs.microsoft.com:443"}, {"name":"Content-Length", "value":"0"}, {"name":"DNT", "value":"1"}, {"name":"Connection", "value":"Keep-Alive"}, {"name":"Pragma", "value":"no-cache"}], "postData":{"text":"A SSLv3-compatible ClientHello handshake was found. Fiddler extracted the parameters below.\n\nVersion: 3.3 (TLS/1.2)\nRandom: 55 EA 95 8F C7 B1 05 1B 33 5A D3 5B 58 2D 72 13 78 AA CC 1D D4 97 6C F2 C5 74 C2 BF CB D9 1C B6\n\"Time\": 3/05/2046 11:25:41 PM\nSessionID: empty\nExtensions: \n\trenegotiation_info\t00\n\tserver_name\turs.microsoft.com\n\tstatus_request\tOCSP - Implicit Responder\n\telliptic_curves\tsecp256r1 [0x17], secp384r1 [0x18]\n\tec_point_formats\tuncompressed [0x0]\n\tsignature_algs\tsha256_rsa, sha384_rsa, sha1_rsa, sha256_ecdsa, sha384_ecdsa, sha1_ecdsa, sha1_dsa\nCiphers: \n\t[003C]\tTLS_RSA_WITH_AES_128_CBC_SHA256\r\n\t[002F]\tTLS_RSA_AES_128_SHA\r\n\t[003D]\tTLS_RSA_WITH_AES_256_CBC_SHA256\r\n\t[0035]\tTLS_RSA_AES_256_SHA\r\n\t[0005]\tSSL_RSA_WITH_RC4_128_SHA\r\n\t[000A]\tSSL_RSA_WITH_3DES_EDE_SHA\r\n\t[C027]\tTLS_ECDHE_RSA_WITH_AES_128_CBC_SHA256\r\n\t[C013]\tTLS1_CK_ECDHE_RSA_WITH_AES_128_CBC_SHA\r\n\t[C014]\tTLS1_CK_ECDHE_RSA_WITH_AES_256_CBC_SHA\r\n\t[C02B]\tTLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256\r\n\t[C023]\tTLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA256\r\n\t[C02C]\tTLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384\r\n\t[C024]\tTLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA384\r\n\t[C009]\tTLS1_CK_ECDHE_ECDSA_WITH_AES_128_CBC_SHA\r\n\t[C00A]\tTLS1_CK_ECDHE_ECDSA_WITH_AES_256_CBC_SHA\r\n\t[0040]\tTLS_DHE_DSS_WITH_AES_128_CBC_SHA256\r\n\t[0032]\tTLS_DHE_DSS_WITH_AES_128_SHA\r\n\t[006A]\tTLS_DHE_DSS_WITH_AES_256_CBC_SHA256\r\n\t[0038]\tTLS_DHE_DSS_WITH_AES_256_SHA\r\n\t[0013]\tSSL_DHE_DSS_WITH_3DES_EDE_SHA\r\n\t[0004]\tSSL_RSA_WITH_RC4_128_MD5\r\n\nCompression: \n\t[00]\tNO_COMPRESSION\r\n\n\n", "mimeType":""}, "method":"CONNECT", "queryString":[]}, "cache":{}, "connection":"ClientPort:49440;EgressPort:49442", "time":263, "serverIPAddress":"207.46.15.254"}, {"startedDateTime":"2015-09-05T17:11:11.1357421+10:00", "response":{"headersSize":382, "httpVersion":"HTTP/1.1", "content":{"compression":1982, "size":3528, "comment":"Body length exceeded fiddler.importexport.HTTPArchiveJSON.MaxTextBodyLength, so body was omitted.", "mimeType":"text/javascript; charset=utf-8"}, "status":200, "bodySize":1546, "statusText":"OK", "headers":[{"name":"Date", "value":"Sat, 05 Sep 2015 07:09:10 GMT"}, {"name":"Content-Type", "value":"text/javascript; charset=utf-8"}, {"name":"Last-Modified", "value":"Sun, 27 Jul 2014 19:52:31 GMT"}, {"name":"x-lang", "value":"es"}, {"name":"Content-Encoding", "value":"gzip"}, {"name":"X-Varnish", "value":"75830430 75705561"}, {"name":"Age", "value":"122"}, {"name":"Via", "value":"1.1 varnish-v4"}, {"name":"X-Varnish-Language", "value":"en"}, {"name":"X-Served-By", "value":"ntplax11.ntppool.net"}, {"name":"X-Cache", "value":"HIT"}, {"name":"X-Cache-Hits", "value":"12"}, {"name":"Content-Length", "value":"1546"}, {"name":"Accept-Ranges", "value":"bytes"}], "cookies":[], "redirectURL":""}, "timings":{"send":0, "receive":0, "wait":219, "dns":81, "ssl":0, "blocked":-1, "connect":222}, "request":{"headersSize":348, "httpVersion":"HTTP/1.1", "url":"http://ipv4.v6test.develooper.com/js/v1/v6test.js", "cookies":[], "bodySize":0, "headers":[{"name":"Accept", "value":"application/javascript, */*;q=0.8"}, {"name":"Referer", "value":"http://search.cpan.org/recent"}, {"name":"Accept-Language", "value":"en-AU"}, {"name":"User-Agent", "value":"Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko"}, {"name":"Accept-Encoding", "value":"gzip, deflate"}, {"name":"Connection", "value":"Keep-Alive"}, {"name":"DNT", "value":"1"}, {"name":"Host", "value":"ipv4.v6test.develooper.com"}], "postData":{"text":"", "mimeType":""}, "method":"GET", "queryString":[]}, "cache":{}, "connection":"ClientPort:49429;EgressPort:49446", "time":522, "serverIPAddress":"207.171.3.4"}, {"startedDateTime":"2015-09-05T17:11:12.0107421+10:00", "response":{"headersSize":342, "httpVersion":"HTTP/1.1", "content":{"compression":24998, "size":41100, "comment":"Body length exceeded fiddler.importexport.HTTPArchiveJSON.MaxTextBodyLength, so body was omitted.", "mimeType":"text/javascript"}, "status":200, "bodySize":16102, "statusText":"OK", "headers":[{"name":"Date", "value":"Sat, 05 Sep 2015 06:29:17 GMT"}, {"name":"Expires", "value":"Sat, 05 Sep 2015 08:29:17 GMT"}, {"name":"Last-Modified", "value":"Thu, 06 Aug 2015 18:26:56 GMT"}, {"name":"X-Content-Type-Options", "value":"nosniff"}, {"name":"Content-Type", "value":"text/javascript"}, {"name":"Vary", "value":"Accept-Encoding"}, {"name":"Content-Encoding", "value":"gzip"}, {"name":"Server", "value":"Golfe2"}, {"name":"Content-Length", "value":"16102"}, {"name":"Age", "value":"2515"}, {"name":"Cache-Control", "value":"public, max-age=7200"}], "cookies":[], "redirectURL":""}, "timings":{"send":0, "receive":0, "wait":62, "dns":11, "ssl":0, "blocked":-1, "connect":31}, "request":{"headersSize":334, "httpVersion":"HTTP/1.1", "url":"http://www.google-analytics.com/ga.js", "cookies":[], "bodySize":0, "headers":[{"name":"Accept", "value":"application/javascript, */*;q=0.8"}, {"name":"Referer", "value":"http://search.cpan.org/recent"}, {"name":"Accept-Language", "value":"en-AU"}, {"name":"User-Agent", "value":"Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko"}, {"name":"Accept-Encoding", "value":"gzip, deflate"}, {"name":"Connection", "value":"Keep-Alive"}, {"name":"DNT", "value":"1"}, {"name":"Host", "value":"www.google-analytics.com"}], "postData":{"text":"", "mimeType":""}, "method":"GET", "queryString":[]}, "cache":{}, "connection":"ClientPort:49432;EgressPort:49455", "time":104, "serverIPAddress":"203.42.93.24"}, {"startedDateTime":"2015-09-05T17:11:12.1826171+10:00", "response":{"headersSize":340, "httpVersion":"HTTP/1.1", "content":{"encoding":"base64", "compression":0, "size":35, "text":"R0lGODlhAQABAID/AP///wAAACwAAAAAAQABAAACAkQBADs=", "mimeType":"image/gif"}, "status":200, "bodySize":35, "statusText":"OK", "headers":[{"name":"Access-Control-Allow-Origin", "value":"*"}, {"name":"Date", "value":"Sat, 05 Sep 2015 07:11:12 GMT"}, {"name":"Pragma", "value":"no-cache"}, {"name":"Expires", "value":"Fri, 01 Jan 1990 00:00:00 GMT"}, {"name":"Cache-Control", "value":"no-cache, no-store, must-revalidate"}, {"name":"Last-Modified", "value":"Sun, 17 May 1998 03:00:00 GMT"}, {"name":"X-Content-Type-Options", "value":"nosniff"}, {"name":"Content-Type", "value":"image/gif"}, {"name":"Server", "value":"Golfe2"}, {"name":"Content-Length", "value":"35"}], "cookies":[], "redirectURL":""}, "timings":{"send":0, "receive":0, "wait":156, "dns":0, "ssl":0, "blocked":-1, "connect":0}, "request":{"headersSize":866, "httpVersion":"HTTP/1.1", "url":"http://www.google-analytics.com/r/__utm.gif?utmwv=5.6.6&utms=1&utmn=1146587467&utmhn=search.cpan.org&utmcs=windows-1252&utmsr=1152x864&utmvp=1135x770&utmsc=24-bit&utmul=en-au&utmje=1&utmfl=-&utmdt=The%20CPAN%20Search%20Site%20-%20search.cpan.org&utmhid=351578373&utmr=-&utmp=%2Frecent&utmht=1441437072174&utmac=UA-3528438-1&utmcc=__utma%3D143795127.1603094418.1441437072.1441437072.1441437072.1%3B%2B__utmz%3D143795127.1441437072.1.1.utmcsr%3D(direct)%7Cutmccn%3D(direct)%7Cutmcmd%3D(none)%3B&utmjid=1066932398&utmredir=1&utmu=qAAAAAAAAAAAAAAAAAAAAAAE~", "cookies":[], "bodySize":0, "headers":[{"name":"Accept", "value":"image/png, image/svg+xml, image/*;q=0.8, */*;q=0.5"}, {"name":"Referer", "value":"http://search.cpan.org/recent"}, {"name":"Accept-Language", "value":"en-AU"}, {"name":"User-Agent", "value":"Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko"}, {"name":"Accept-Encoding", "value":"gzip, deflate"}, {"name":"Connection", "value":"Keep-Alive"}, {"name":"DNT", "value":"1"}, {"name":"Host", "value":"www.google-analytics.com"}], "postData":{"text":"", "mimeType":""}, "method":"GET", "queryString":[{"name":"utmwv", "value":"5.6.6"}, {"name":"utms", "value":"1"}, {"name":"utmn", "value":"1146587467"}, {"name":"utmhn", "value":"search.cpan.org"}, {"name":"utmcs", "value":"windows-1252"}, {"name":"utmsr", "value":"1152x864"}, {"name":"utmvp", "value":"1135x770"}, {"name":"utmsc", "value":"24-bit"}, {"name":"utmul", "value":"en-au"}, {"name":"utmje", "value":"1"}, {"name":"utmfl", "value":"-"}, {"name":"utmdt", "value":"The CPAN Search Site - search.cpan.org"}, {"name":"utmhid", "value":"351578373"}, {"name":"utmr", "value":"-"}, {"name":"utmp", "value":"/recent"}, {"name":"utmht", "value":"1441437072174"}, {"name":"utmac", "value":"UA-3528438-1"}, {"name":"utmcc", "value":"__utma=143795127.1603094418.1441437072.1441437072.1441437072.1;+__utmz=143795127.1441437072.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none);"}, {"name":"utmjid", "value":"1066932398"}, {"name":"utmredir", "value":"1"}, {"name":"utmu", "value":"qAAAAAAAAAAAAAAAAAAAAAAE~"}]}, "cache":{}, "connection":"ClientPort:49432;EgressPort:49455", "time":156, "serverIPAddress":"203.42.93.24"}, {"startedDateTime":"2015-09-05T17:11:12.2138671+10:00", "response":{"headersSize":320, "httpVersion":"HTTP/1.1", "content":{"encoding":"base64", "compression":0, "size":43, "text":"R0lGODlhAQABAIAAAAAAAAAAACH5BAEAAAAALAAAAAABAAEAAAICRAEAOw==", "mimeType":"image/gif"}, "status":200, "bodySize":43, "statusText":"OK", "headers":[{"name":"Date", "value":"Sat, 05 Sep 2015 07:10:32 GMT"}, {"name":"Content-Length", "value":"43"}, {"name":"Content-Type", "value":"image/gif"}, {"name":"Last-Modified", "value":"Mon, 19 Oct 2009 05:32:03 GMT"}, {"name":"X-Varnish", "value":"24629584 24653007"}, {"name":"Age", "value":"40"}, {"name":"Via", "value":"1.1 varnish-v4"}, {"name":"X-Varnish-Language", "value":"en"}, {"name":"X-Served-By", "value":"ntplax8.ntppool.net"}, {"name":"X-Cache", "value":"HIT"}, {"name":"X-Cache-Hits", "value":"8"}, {"name":"Accept-Ranges", "value":"bytes"}], "cookies":[], "redirectURL":""}, "timings":{"send":0, "receive":0, "wait":219, "dns":0, "ssl":0, "blocked":-1, "connect":0}, "request":{"headersSize":357, "httpVersion":"HTTP/1.1", "url":"http://ipv4.v6test.develooper.com/i/t.gif", "cookies":[], "bodySize":0, "headers":[{"name":"Accept", "value":"image/png, image/svg+xml, image/*;q=0.8, */*;q=0.5"}, {"name":"Referer", "value":"http://search.cpan.org/recent"}, {"name":"Accept-Language", "value":"en-AU"}, {"name":"User-Agent", "value":"Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko"}, {"name":"Accept-Encoding", "value":"gzip, deflate"}, {"name":"Connection", "value":"Keep-Alive"}, {"name":"DNT", "value":"1"}, {"name":"Host", "value":"ipv4.v6test.develooper.com"}], "postData":{"text":"", "mimeType":""}, "method":"GET", "queryString":[]}, "cache":{}, "connection":"ClientPort:49431;EgressPort:49446", "time":219, "serverIPAddress":"207.171.3.4"}, {"startedDateTime":"2015-09-05T17:11:12.2138671+10:00", "response":{"headersSize":209, "httpVersion":"HTTP/1.1", "content":{"compression":0, "size":512, "comment":"Body length exceeded fiddler.importexport.HTTPArchiveJSON.MaxTextBodyLength, so body was omitted.", "mimeType":"text/html; charset=UTF-8"}, "status":502, "bodySize":512, "statusText":"Fiddler - DNS Lookup Failed", "headers":[{"name":"Date", "value":"Sat, 05 Sep 2015 07:11:12 GMT"}, {"name":"Content-Type", "value":"text/html; charset=UTF-8"}, {"name":"Connection", "value":"close"}, {"name":"Cache-Control", "value":"no-cache, must-revalidate"}, {"name":"Timestamp", "value":"17:11:12.323"}], "cookies":[], "redirectURL":""}, "timings":{"send":0, "receive":0, "wait":0, "dns":90, "ssl":0, "blocked":-1, "connect":0}, "request":{"headersSize":363, "httpVersion":"HTTP/1.1", "url":"http://ipv6.v6test.develooper.com/i/t.gif", "cookies":[], "bodySize":0, "headers":[{"name":"Accept", "value":"image/png, image/svg+xml, image/*;q=0.8, */*;q=0.5"}, {"name":"Referer", "value":"http://search.cpan.org/recent"}, {"name":"Accept-Language", "value":"en-AU"}, {"name":"User-Agent", "value":"Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko"}, {"name":"Accept-Encoding", "value":"gzip, deflate"}, {"name":"Proxy-Connection", "value":"Keep-Alive"}, {"name":"DNT", "value":"1"}, {"name":"Host", "value":"ipv6.v6test.develooper.com"}], "postData":{"text":"", "mimeType":""}, "method":"GET", "queryString":[]}, "cache":{}, "connection":"ClientPort:49436", "time":90}, {"startedDateTime":"2015-09-05T17:11:12.2138671+10:00", "response":{"headersSize":320, "httpVersion":"HTTP/1.1", "content":{"encoding":"base64", "compression":0, "size":43, "text":"R0lGODlhAQABAIAAAAAAAAAAACH5BAEAAAAALAAAAAABAAEAAAICRAEAOw==", "mimeType":"image/gif"}, "status":200, "bodySize":43, "statusText":"OK", "headers":[{"name":"Date", "value":"Sat, 05 Sep 2015 07:10:32 GMT"}, {"name":"Content-Length", "value":"43"}, {"name":"Content-Type", "value":"image/gif"}, {"name":"Last-Modified", "value":"Mon, 19 Oct 2009 05:32:03 GMT"}, {"name":"X-Varnish", "value":"24629586 22871686"}, {"name":"Age", "value":"40"}, {"name":"Via", "value":"1.1 varnish-v4"}, {"name":"X-Varnish-Language", "value":"en"}, {"name":"X-Served-By", "value":"ntplax8.ntppool.net"}, {"name":"X-Cache", "value":"HIT"}, {"name":"X-Cache-Hits", "value":"8"}, {"name":"Accept-Ranges", "value":"bytes"}], "cookies":[], "redirectURL":""}, "timings":{"send":0, "receive":0, "wait":219, "dns":86, "ssl":0, "blocked":-1, "connect":222}, "request":{"headersSize":359, "httpVersion":"HTTP/1.1", "url":"http://ipv64.v6test.develooper.com/i/t.gif", "cookies":[], "bodySize":0, "headers":[{"name":"Accept", "value":"image/png, image/svg+xml, image/*;q=0.8, */*;q=0.5"}, {"name":"Referer", "value":"http://search.cpan.org/recent"}, {"name":"Accept-Language", "value":"en-AU"}, {"name":"User-Agent", "value":"Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko"}, {"name":"Accept-Encoding", "value":"gzip, deflate"}, {"name":"Connection", "value":"Keep-Alive"}, {"name":"DNT", "value":"1"}, {"name":"Host", "value":"ipv64.v6test.develooper.com"}], "postData":{"text":"", "mimeType":""}, "method":"GET", "queryString":[]}, "cache":{}, "connection":"ClientPort:49437;EgressPort:49457", "time":527, "serverIPAddress":"207.171.3.4"}, {"startedDateTime":"2015-09-05T17:11:12.2451171+10:00", "response":{"headersSize":376, "httpVersion":"HTTP/1.1", "content":{"encoding":"base64", "compression":0, "size":318, "text":"AAABAAEAEBAAAAAAAAAoAQAAFgAAACgAAAAQAAAAIAAAAAEABAAAAAAAwAAAAAAAAAAAAAAAAAAAAAAAAAD///8AewAAAAB7AAB7ewAAAAB7AHsAewAAe3sAvb29AHt7ewD/AAAAAP8AAP//AAAAAP8A/wD/AAD//wAAAAAA///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////w/////////////////////zNs/L/vGObX6/D22wAA+ukAAvjDYWz8A3Rl+AJDb/ACciDgAVzQ4AMRAOYPv+YnHwACB/8ABof/MoDj/zHg", "mimeType":"image/x-icon"}, "status":200, "bodySize":318, "statusText":"OK", "headers":[{"name":"Date", "value":"Sat, 05 Sep 2015 07:11:13 GMT"}, {"name":"Server", "value":"Apache/2.4.6 (Red Hat Enterprise Linux)"}, {"name":"Last-Modified", "value":"Fri, 24 Oct 2008 02:49:08 GMT"}, {"name":"ETag", "value":"\"13e-459f6d3423100\""}, {"name":"Accept-Ranges", "value":"bytes"}, {"name":"Content-Length", "value":"318"}, {"name":"Cache-Control", "value":"max-age=86400"}, {"name":"Expires", "value":"Sun, 06 Sep 2015 07:11:13 GMT"}, {"name":"Keep-Alive", "value":"timeout=5, max=99"}, {"name":"Connection", "value":"Keep-Alive"}, {"name":"Content-Type", "value":"image/x-icon"}], "cookies":[], "redirectURL":""}, "timings":{"send":0, "receive":0, "wait":328, "dns":0, "ssl":0, "blocked":-1, "connect":0}, "request":{"headersSize":228, "httpVersion":"HTTP/1.1", "url":"http://search.cpan.org/favicon.ico", "cookies":[], "bodySize":0, "headers":[{"name":"Accept", "value":"*/*"}, {"name":"Accept-Encoding", "value":"gzip, deflate"}, {"name":"User-Agent", "value":"Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko"}, {"name":"Host", "value":"search.cpan.org"}, {"name":"DNT", "value":"1"}, {"name":"Connection", "value":"Keep-Alive"}], "postData":{"text":"", "mimeType":""}, "method":"GET", "queryString":[]}, "cache":{}, "connection":"ClientPort:49456;EgressPort:49428", "time":328, "serverIPAddress":"194.106.223.155"}, {"startedDateTime":"2015-09-05T17:11:12.4482421+10:00", "response":{"headersSize":364, "httpVersion":"HTTP/1.1", "content":{"compression":-33, "size":43, "comment":"Body length exceeded fiddler.importexport.HTTPArchiveJSON.MaxTextBodyLength, so body was omitted.", "mimeType":"text/javascipt"}, "status":200, "bodySize":76, "statusText":"OK", "headers":[{"name":"Cache-Control", "value":"private, no-cache, no-store, must-revalidate"}, {"name":"Content-Type", "value":"text/javascipt"}, {"name":"Date", "value":"Sat, 05 Sep 2015 07:11:13 GMT"}, {"name":"Content-Encoding", "value":"gzip"}, {"name":"X-Varnish", "value":"75705882"}, {"name":"Age", "value":"0"}, {"name":"Via", "value":"1.1 varnish-v4"}, {"name":"X-Varnish-Language", "value":"en"}, {"name":"X-Served-By", "value":"ntplax11.ntppool.net"}, {"name":"X-Cache", "value":"MISS"}, {"name":"X-Cache-Hits", "value":"0"}, {"name":"Transfer-Encoding", "value":"chunked"}, {"name":"Accept-Ranges", "value":"bytes"}], "cookies":[], "redirectURL":""}, "timings":{"send":0, "receive":0, "wait":219, "dns":0, "ssl":0, "blocked":-1, "connect":0}, "request":{"headersSize":365, "httpVersion":"HTTP/1.1", "url":"http://ipv4.v6test.develooper.com/c/ip?callback=jsonp1441437071752", "cookies":[], "bodySize":0, "headers":[{"name":"Accept", "value":"application/javascript, */*;q=0.8"}, {"name":"Referer", "value":"http://search.cpan.org/recent"}, {"name":"Accept-Language", "value":"en-AU"}, {"name":"User-Agent", "value":"Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko"}, {"name":"Accept-Encoding", "value":"gzip, deflate"}, {"name":"Connection", "value":"Keep-Alive"}, {"name":"DNT", "value":"1"}, {"name":"Host", "value":"ipv4.v6test.develooper.com"}], "postData":{"text":"", "mimeType":""}, "method":"GET", "queryString":[{"name":"callback", "value":"jsonp1441437071752"}]}, "cache":{}, "connection":"ClientPort:49431;EgressPort:49446", "time":219, "serverIPAddress":"207.171.3.4"}, {"startedDateTime":"2015-09-05T17:11:12.7451171+10:00", "response":{"headersSize":364, "httpVersion":"HTTP/1.1", "content":{"compression":-33, "size":43, "comment":"Body length exceeded fiddler.importexport.HTTPArchiveJSON.MaxTextBodyLength, so body was omitted.", "mimeType":"text/javascipt"}, "status":200, "bodySize":76, "statusText":"OK", "headers":[{"name":"Cache-Control", "value":"private, no-cache, no-store, must-revalidate"}, {"name":"Content-Type", "value":"text/javascipt"}, {"name":"Date", "value":"Sat, 05 Sep 2015 07:11:13 GMT"}, {"name":"Content-Encoding", "value":"gzip"}, {"name":"X-Varnish", "value":"75830442"}, {"name":"Age", "value":"0"}, {"name":"Via", "value":"1.1 varnish-v4"}, {"name":"X-Varnish-Language", "value":"en"}, {"name":"X-Served-By", "value":"ntplax11.ntppool.net"}, {"name":"X-Cache", "value":"MISS"}, {"name":"X-Cache-Hits", "value":"0"}, {"name":"Transfer-Encoding", "value":"chunked"}, {"name":"Accept-Ranges", "value":"bytes"}], "cookies":[], "redirectURL":""}, "timings":{"send":0, "receive":0, "wait":219, "dns":0, "ssl":0, "blocked":-1, "connect":0}, "request":{"headersSize":367, "httpVersion":"HTTP/1.1", "url":"http://ipv64.v6test.develooper.com/c/ip?callback=jsonp1441437071753", "cookies":[], "bodySize":0, "headers":[{"name":"Accept", "value":"application/javascript, */*;q=0.8"}, {"name":"Referer", "value":"http://search.cpan.org/recent"}, {"name":"Accept-Language", "value":"en-AU"}, {"name":"User-Agent", "value":"Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko"}, {"name":"Accept-Encoding", "value":"gzip, deflate"}, {"name":"Connection", "value":"Keep-Alive"}, {"name":"DNT", "value":"1"}, {"name":"Host", "value":"ipv64.v6test.develooper.com"}], "postData":{"text":"", "mimeType":""}, "method":"GET", "queryString":[{"name":"callback", "value":"jsonp1441437071753"}]}, "cache":{}, "connection":"ClientPort:49437;EgressPort:49457", "time":219, "serverIPAddress":"207.171.3.4"}, {"startedDateTime":"2015-09-05T17:11:15.4169921+10:00", "response":{"headersSize":127, "httpVersion":"HTTP/1.1", "content":{"encoding":"base64", "compression":0, "size":0, "text":"", "mimeType":""}, "status":204, "bodySize":0, "statusText":"No Content", "headers":[{"name":"Cache-Control", "value":"private, no-cache, no-store, must-revalidate"}, {"name":"Date", "value":"Sat, 05 Sep 2015 07:11:16 GMT"}], "cookies":[], "redirectURL":""}, "timings":{"send":0, "receive":0, "wait":219, "dns":357, "ssl":0, "blocked":-1, "connect":221}, "request":{"headersSize":412, "httpVersion":"HTTP/1.1", "url":"http://40ed1ef9-fc6c-4e26-b9c8-7cc2399736b1.mapper.ntppool.org/none", "cookies":[], "bodySize":0, "headers":[{"name":"Accept", "value":"image/png, image/svg+xml, image/*;q=0.8, */*;q=0.5"}, {"name":"Referer", "value":"http://search.cpan.org/recent"}, {"name":"Accept-Language", "value":"en-AU"}, {"name":"User-Agent", "value":"Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko"}, {"name":"Accept-Encoding", "value":"gzip, deflate"}, {"name":"Connection", "value":"Keep-Alive"}, {"name":"DNT", "value":"1"}, {"name":"Host", "value":"40ed1ef9-fc6c-4e26-b9c8-7cc2399736b1.mapper.ntppool.org"}], "postData":{"text":"", "mimeType":""}, "method":"GET", "queryString":[]}, "cache":{}, "connection":"ClientPort:49437;EgressPort:49458", "time":797, "serverIPAddress":"207.171.3.22"}, {"startedDateTime":"2015-09-05T17:11:16.2294921+10:00", "response":{"headersSize":341, "httpVersion":"HTTP/1.1", "content":{"text":"", "compression":0, "size":0, "mimeType":"text/javascipt"}, "status":204, "bodySize":0, "statusText":"No Content", "headers":[{"name":"Cache-Control", "value":"private, no-cache, no-store, must-revalidate"}, {"name":"Content-Type", "value":"text/javascipt"}, {"name":"Date", "value":"Sat, 05 Sep 2015 07:11:17 GMT"}, {"name":"Content-Encoding", "value":"gzip"}, {"name":"X-Varnish", "value":"75830464"}, {"name":"Age", "value":"0"}, {"name":"Via", "value":"1.1 varnish-v4"}, {"name":"X-Varnish-Language", "value":"en"}, {"name":"X-Served-By", "value":"ntplax11.ntppool.net"}, {"name":"X-Cache", "value":"MISS"}, {"name":"X-Cache-Hits", "value":"0"}, {"name":"Content-Length", "value":"0"}], "cookies":[], "redirectURL":""}, "timings":{"send":0, "receive":0, "wait":219, "dns":0, "ssl":0, "blocked":-1, "connect":0}, "request":{"headersSize":539, "httpVersion":"HTTP/1.1", "url":"http://ipv4.v6test.develooper.com/c/json?callback=jsonp1441437071754&version=1.25&ipv4=218&ipv4_ip=124.188.236.5&ipv6=error&ipv64=531&ipv64_ip=124.188.236.5&v6uq=4212dd41-c9a7-49ee-9925-c43aa6dc5640&site=7A0D89A6-2B82-11DF-B9DA-F61CBD13F020", "cookies":[], "bodySize":0, "headers":[{"name":"Accept", "value":"application/javascript, */*;q=0.8"}, {"name":"Referer", "value":"http://search.cpan.org/recent"}, {"name":"Accept-Language", "value":"en-AU"}, {"name":"User-Agent", "value":"Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko"}, {"name":"Accept-Encoding", "value":"gzip, deflate"}, {"name":"Connection", "value":"Keep-Alive"}, {"name":"DNT", "value":"1"}, {"name":"Host", "value":"ipv4.v6test.develooper.com"}], "postData":{"text":"", "mimeType":""}, "method":"GET", "queryString":[{"name":"callback", "value":"jsonp1441437071754"}, {"name":"version", "value":"1.25"}, {"name":"ipv4", "value":"218"}, {"name":"ipv4_ip", "value":"124.188.236.5"}, {"name":"ipv6", "value":"error"}, {"name":"ipv64", "value":"531"}, {"name":"ipv64_ip", "value":"124.188.236.5"}, {"name":"v6uq", "value":"4212dd41-c9a7-49ee-9925-c43aa6dc5640"}, {"name":"site", "value":"7A0D89A6-2B82-11DF-B9DA-F61CBD13F020"}]}, "cache":{}, "connection":"ClientPort:49437;EgressPort:49446", "time":219, "serverIPAddress":"207.171.3.4"}, {"startedDateTime":"2015-09-05T17:11:23.3544921+10:00", "response":{"headersSize":191, "httpVersion":"HTTP/1.1", "content":{"compression":0, "size":8471, "comment":"Body length exceeded fiddler.importexport.HTTPArchiveJSON.MaxTextBodyLength, so body was omitted.", "mimeType":"text/html"}, "status":200, "bodySize":8471, "statusText":"OK", "headers":[{"name":"Date", "value":"Sat, 05 Sep 2015 07:11:24 GMT"}, {"name":"Server", "value":"Plack/Starman (Perl)"}, {"name":"Content-Length", "value":"8471"}, {"name":"Content-Type", "value":"text/html"}, {"name":"Keep-Alive", "value":"timeout=5, max=100"}, {"name":"Connection", "value":"Keep-Alive"}], "cookies":[], "redirectURL":""}, "timings":{"send":0, "receive":859, "wait":0, "dns":0, "ssl":0, "blocked":-1, "connect":312}, "request":{"headersSize":566, "httpVersion":"HTTP/1.1", "url":"http://search.cpan.org/search?query=Archive%3A%3AHar&mode=all", "cookies":[{"name":"__utma", "value":"143795127.1603094418.1441437072.1441437072.1441437072.1"}, {"name":"__utmb", "value":"143795127.1.10.1441437072"}, {"name":"__utmc", "value":"143795127"}, {"name":"__utmz", "value":"143795127.1441437072.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none)"}, {"name":"__utmt", "value":"1"}], "bodySize":0, "headers":[{"name":"Accept", "value":"text/html, application/xhtml+xml, */*"}, {"name":"Referer", "value":"http://search.cpan.org/recent"}, {"name":"Accept-Language", "value":"en-AU"}, {"name":"User-Agent", "value":"Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko"}, {"name":"Accept-Encoding", "value":"gzip, deflate"}, {"name":"Connection", "value":"Keep-Alive"}, {"name":"DNT", "value":"1"}, {"name":"Host", "value":"search.cpan.org"}, {"name":"Cookie", "value":"__utma=143795127.1603094418.1441437072.1441437072.1441437072.1; __utmb=143795127.1.10.1441437072; __utmc=143795127; __utmz=143795127.1441437072.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); __utmt=1"}], "postData":{"text":"", "mimeType":""}, "method":"GET", "queryString":[{"name":"query", "value":"Archive::Har"}, {"name":"mode", "value":"all"}]}, "cache":{}, "connection":"ClientPort:49434;EgressPort:49459", "time":1171, "serverIPAddress":"194.106.223.155"}, {"startedDateTime":"2015-09-05T17:11:24.3076171+10:00", "response":{"headersSize":374, "httpVersion":"HTTP/1.1", "content":{"encoding":"base64", "compression":0, "size":35, "text":"R0lGODlhAQABAID/AP///wAAACwAAAAAAQABAAACAkQBADs=", "mimeType":"image/gif"}, "status":200, "bodySize":35, "statusText":"OK", "headers":[{"name":"Pragma", "value":"no-cache"}, {"name":"Expires", "value":"Mon, 07 Aug 1995 23:30:00 GMT"}, {"name":"Access-Control-Allow-Origin", "value":"*"}, {"name":"Last-Modified", "value":"Sun, 17 May 1998 03:00:00 GMT"}, {"name":"X-Content-Type-Options", "value":"nosniff"}, {"name":"Content-Type", "value":"image/gif"}, {"name":"Date", "value":"Tue, 01 Sep 2015 16:33:14 GMT"}, {"name":"Server", "value":"Golfe2"}, {"name":"Content-Length", "value":"35"}, {"name":"Age", "value":"311891"}, {"name":"Cache-Control", "value":"private, no-cache, no-cache=Set-Cookie, proxy-revalidate"}], "cookies":[], "redirectURL":""}, "timings":{"send":0, "receive":0, "wait":31, "dns":0, "ssl":0, "blocked":-1, "connect":0}, "request":{"headersSize":923, "httpVersion":"HTTP/1.1", "url":"http://www.google-analytics.com/__utm.gif?utmwv=5.6.6&utms=2&utmn=628767026&utmhn=search.cpan.org&utmcs=windows-1252&utmsr=1152x864&utmvp=1135x770&utmsc=24-bit&utmul=en-au&utmje=1&utmfl=-&utmdt=The%20CPAN%20Search%20Site%20-%20search.cpan.org&utmhid=2134397309&utmr=0&utmp=%2Fsearch%3Fquery%3DArchive%25253A%25253AHar%26mode%3Dall&utmht=1441437084303&utmac=UA-3528438-1&utmcc=__utma%3D143795127.1603094418.1441437072.1441437072.1441437072.1%3B%2B__utmz%3D143795127.1441437072.1.1.utmcsr%3D(direct)%7Cutmccn%3D(direct)%7Cutmcmd%3D(none)%3B&utmjid=&utmu=qAAAAAAAAAAAAAAAAAAAAAAE~", "cookies":[], "bodySize":0, "headers":[{"name":"Accept", "value":"image/png, image/svg+xml, image/*;q=0.8, */*;q=0.5"}, {"name":"Referer", "value":"http://search.cpan.org/search?query=Archive%3A%3AHar&mode=all"}, {"name":"Accept-Language", "value":"en-AU"}, {"name":"User-Agent", "value":"Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko"}, {"name":"Accept-Encoding", "value":"gzip, deflate"}, {"name":"Connection", "value":"Keep-Alive"}, {"name":"DNT", "value":"1"}, {"name":"Host", "value":"www.google-analytics.com"}], "postData":{"text":"", "mimeType":""}, "method":"GET", "queryString":[{"name":"utmwv", "value":"5.6.6"}, {"name":"utms", "value":"2"}, {"name":"utmn", "value":"628767026"}, {"name":"utmhn", "value":"search.cpan.org"}, {"name":"utmcs", "value":"windows-1252"}, {"name":"utmsr", "value":"1152x864"}, {"name":"utmvp", "value":"1135x770"}, {"name":"utmsc", "value":"24-bit"}, {"name":"utmul", "value":"en-au"}, {"name":"utmje", "value":"1"}, {"name":"utmfl", "value":"-"}, {"name":"utmdt", "value":"The CPAN Search Site - search.cpan.org"}, {"name":"utmhid", "value":"2134397309"}, {"name":"utmr", "value":"0"}, {"name":"utmp", "value":"/search?query=Archive%253A%253AHar&mode=all"}, {"name":"utmht", "value":"1441437084303"}, {"name":"utmac", "value":"UA-3528438-1"}, {"name":"utmcc", "value":"__utma=143795127.1603094418.1441437072.1441437072.1441437072.1;+__utmz=143795127.1441437072.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none);"}, {"name":"utmjid", "value":""}, {"name":"utmu", "value":"qAAAAAAAAAAAAAAAAAAAAAAE~"}]}, "cache":{}, "connection":"ClientPort:49439;EgressPort:49455", "time":31, "serverIPAddress":"203.42.93.24"}, {"startedDateTime":"2015-09-05T17:11:24.3076171+10:00", "response":{"headersSize":209, "httpVersion":"HTTP/1.1", "content":{"compression":0, "size":512, "comment":"Body length exceeded fiddler.importexport.HTTPArchiveJSON.MaxTextBodyLength, so body was omitted.", "mimeType":"text/html; charset=UTF-8"}, "status":502, "bodySize":512, "statusText":"Fiddler - DNS Lookup Failed", "headers":[{"name":"Date", "value":"Sat, 05 Sep 2015 07:11:24 GMT"}, {"name":"Content-Type", "value":"text/html; charset=UTF-8"}, {"name":"Connection", "value":"close"}, {"name":"Cache-Control", "value":"no-cache, must-revalidate"}, {"name":"Timestamp", "value":"17:11:24.323"}], "cookies":[], "redirectURL":""}, "timings":{"send":0, "receive":0, "wait":0, "dns":0, "ssl":0, "blocked":-1, "connect":0}, "request":{"headersSize":395, "httpVersion":"HTTP/1.1", "url":"http://ipv6.v6test.develooper.com/i/t.gif", "cookies":[], "bodySize":0, "headers":[{"name":"Accept", "value":"image/png, image/svg+xml, image/*;q=0.8, */*;q=0.5"}, {"name":"Referer", "value":"http://search.cpan.org/search?query=Archive%3A%3AHar&mode=all"}, {"name":"Accept-Language", "value":"en-AU"}, {"name":"User-Agent", "value":"Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko"}, {"name":"Accept-Encoding", "value":"gzip, deflate"}, {"name":"Proxy-Connection", "value":"Keep-Alive"}, {"name":"DNT", "value":"1"}, {"name":"Host", "value":"ipv6.v6test.develooper.com"}], "postData":{"text":"", "mimeType":""}, "method":"GET", "queryString":[]}, "cache":{}, "connection":"ClientPort:49429", "time":0}, {"startedDateTime":"2015-09-05T17:11:24.3232421+10:00", "response":{"headersSize":364, "httpVersion":"HTTP/1.1", "content":{"compression":-33, "size":43, "comment":"Body length exceeded fiddler.importexport.HTTPArchiveJSON.MaxTextBodyLength, so body was omitted.", "mimeType":"text/javascipt"}, "status":200, "bodySize":76, "statusText":"OK", "headers":[{"name":"Cache-Control", "value":"private, no-cache, no-store, must-revalidate"}, {"name":"Content-Type", "value":"text/javascipt"}, {"name":"Date", "value":"Sat, 05 Sep 2015 07:11:25 GMT"}, {"name":"Content-Encoding", "value":"gzip"}, {"name":"X-Varnish", "value":"75830496"}, {"name":"Age", "value":"0"}, {"name":"Via", "value":"1.1 varnish-v4"}, {"name":"X-Varnish-Language", "value":"en"}, {"name":"X-Served-By", "value":"ntplax11.ntppool.net"}, {"name":"X-Cache", "value":"MISS"}, {"name":"X-Cache-Hits", "value":"0"}, {"name":"Transfer-Encoding", "value":"chunked"}, {"name":"Accept-Ranges", "value":"bytes"}], "cookies":[], "redirectURL":""}, "timings":{"send":0, "receive":0, "wait":219, "dns":0, "ssl":0, "blocked":-1, "connect":0}, "request":{"headersSize":397, "httpVersion":"HTTP/1.1", "url":"http://ipv4.v6test.develooper.com/c/ip?callback=jsonp1441437084263", "cookies":[], "bodySize":0, "headers":[{"name":"Accept", "value":"application/javascript, */*;q=0.8"}, {"name":"Referer", "value":"http://search.cpan.org/search?query=Archive%3A%3AHar&mode=all"}, {"name":"Accept-Language", "value":"en-AU"}, {"name":"User-Agent", "value":"Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko"}, {"name":"Accept-Encoding", "value":"gzip, deflate"}, {"name":"Connection", "value":"Keep-Alive"}, {"name":"DNT", "value":"1"}, {"name":"Host", "value":"ipv4.v6test.develooper.com"}], "postData":{"text":"", "mimeType":""}, "method":"GET", "queryString":[{"name":"callback", "value":"jsonp1441437084263"}]}, "cache":{}, "connection":"ClientPort:49438;EgressPort:49446", "time":219, "serverIPAddress":"207.171.3.4"}, {"startedDateTime":"2015-09-05T17:11:24.3232421+10:00", "response":{"headersSize":364, "httpVersion":"HTTP/1.1", "content":{"compression":-33, "size":43, "comment":"Body length exceeded fiddler.importexport.HTTPArchiveJSON.MaxTextBodyLength, so body was omitted.", "mimeType":"text/javascipt"}, "status":200, "bodySize":76, "statusText":"OK", "headers":[{"name":"Cache-Control", "value":"private, no-cache, no-store, must-revalidate"}, {"name":"Content-Type", "value":"text/javascipt"}, {"name":"Date", "value":"Sat, 05 Sep 2015 07:11:25 GMT"}, {"name":"Content-Encoding", "value":"gzip"}, {"name":"X-Varnish", "value":"75705936"}, {"name":"Age", "value":"0"}, {"name":"Via", "value":"1.1 varnish-v4"}, {"name":"X-Varnish-Language", "value":"en"}, {"name":"X-Served-By", "value":"ntplax11.ntppool.net"}, {"name":"X-Cache", "value":"MISS"}, {"name":"X-Cache-Hits", "value":"0"}, {"name":"Transfer-Encoding", "value":"chunked"}, {"name":"Accept-Ranges", "value":"bytes"}], "cookies":[], "redirectURL":""}, "timings":{"send":0, "receive":0, "wait":219, "dns":0, "ssl":0, "blocked":-1, "connect":0}, "request":{"headersSize":399, "httpVersion":"HTTP/1.1", "url":"http://ipv64.v6test.develooper.com/c/ip?callback=jsonp1441437084264", "cookies":[], "bodySize":0, "headers":[{"name":"Accept", "value":"application/javascript, */*;q=0.8"}, {"name":"Referer", "value":"http://search.cpan.org/search?query=Archive%3A%3AHar&mode=all"}, {"name":"Accept-Language", "value":"en-AU"}, {"name":"User-Agent", "value":"Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko"}, {"name":"Accept-Encoding", "value":"gzip, deflate"}, {"name":"Connection", "value":"Keep-Alive"}, {"name":"DNT", "value":"1"}, {"name":"Host", "value":"ipv64.v6test.develooper.com"}], "postData":{"text":"", "mimeType":""}, "method":"GET", "queryString":[{"name":"callback", "value":"jsonp1441437084264"}]}, "cache":{}, "connection":"ClientPort:49433;EgressPort:49457", "time":219, "serverIPAddress":"207.171.3.4"}, {"startedDateTime":"2015-09-05T17:11:27.5263671+10:00", "response":{"headersSize":127, "httpVersion":"HTTP/1.1", "content":{"encoding":"base64", "compression":0, "size":0, "text":"", "mimeType":""}, "status":204, "bodySize":0, "statusText":"No Content", "headers":[{"name":"Cache-Control", "value":"private, no-cache, no-store, must-revalidate"}, {"name":"Date", "value":"Sat, 05 Sep 2015 07:11:28 GMT"}], "cookies":[], "redirectURL":""}, "timings":{"send":0, "receive":0, "wait":203, "dns":190, "ssl":0, "blocked":-1, "connect":192}, "request":{"headersSize":444, "httpVersion":"HTTP/1.1", "url":"http://dcad2f49-e46e-4f87-bec2-f60d95793f9d.mapper.ntppool.org/none", "cookies":[], "bodySize":0, "headers":[{"name":"Accept", "value":"image/png, image/svg+xml, image/*;q=0.8, */*;q=0.5"}, {"name":"Referer", "value":"http://search.cpan.org/search?query=Archive%3A%3AHar&mode=all"}, {"name":"Accept-Language", "value":"en-AU"}, {"name":"User-Agent", "value":"Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko"}, {"name":"Accept-Encoding", "value":"gzip, deflate"}, {"name":"Connection", "value":"Keep-Alive"}, {"name":"DNT", "value":"1"}, {"name":"Host", "value":"dcad2f49-e46e-4f87-bec2-f60d95793f9d.mapper.ntppool.org"}], "postData":{"text":"", "mimeType":""}, "method":"GET", "queryString":[]}, "cache":{}, "connection":"ClientPort:49433;EgressPort:49460", "time":585, "serverIPAddress":"207.171.7.83"}, {"startedDateTime":"2015-09-05T17:11:28.3388671+10:00", "response":{"headersSize":341, "httpVersion":"HTTP/1.1", "content":{"text":"", "compression":0, "size":0, "mimeType":"text/javascipt"}, "status":204, "bodySize":0, "statusText":"No Content", "headers":[{"name":"Cache-Control", "value":"private, no-cache, no-store, must-revalidate"}, {"name":"Content-Type", "value":"text/javascipt"}, {"name":"Date", "value":"Sat, 05 Sep 2015 07:11:29 GMT"}, {"name":"Content-Encoding", "value":"gzip"}, {"name":"X-Varnish", "value":"75705952"}, {"name":"Age", "value":"0"}, {"name":"Via", "value":"1.1 varnish-v4"}, {"name":"X-Varnish-Language", "value":"en"}, {"name":"X-Served-By", "value":"ntplax11.ntppool.net"}, {"name":"X-Cache", "value":"MISS"}, {"name":"X-Cache-Hits", "value":"0"}, {"name":"Content-Length", "value":"0"}], "cookies":[], "redirectURL":""}, "timings":{"send":0, "receive":0, "wait":219, "dns":0, "ssl":0, "blocked":-1, "connect":0}, "request":{"headersSize":567, "httpVersion":"HTTP/1.1", "url":"http://ipv4.v6test.develooper.com/c/json?callback=jsonp1441437084265&version=1.25&ipv4=1&ipv4_ip=124.188.236.5&ipv6=error&ipv64=2&ipv64_ip=124.188.236.5&v6uq=6e2cbe7a-d2bd-486e-adf9-e69557967d9e&site=7A0D89A6-2B82-11DF-B9DA-F61CBD13F020", "cookies":[], "bodySize":0, "headers":[{"name":"Accept", "value":"application/javascript, */*;q=0.8"}, {"name":"Referer", "value":"http://search.cpan.org/search?query=Archive%3A%3AHar&mode=all"}, {"name":"Accept-Language", "value":"en-AU"}, {"name":"User-Agent", "value":"Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko"}, {"name":"Accept-Encoding", "value":"gzip, deflate"}, {"name":"Connection", "value":"Keep-Alive"}, {"name":"DNT", "value":"1"}, {"name":"Host", "value":"ipv4.v6test.develooper.com"}], "postData":{"text":"", "mimeType":""}, "method":"GET", "queryString":[{"name":"callback", "value":"jsonp1441437084265"}, {"name":"version", "value":"1.25"}, {"name":"ipv4", "value":"1"}, {"name":"ipv4_ip", "value":"124.188.236.5"}, {"name":"ipv6", "value":"error"}, {"name":"ipv64", "value":"2"}, {"name":"ipv64_ip", "value":"124.188.236.5"}, {"name":"v6uq", "value":"6e2cbe7a-d2bd-486e-adf9-e69557967d9e"}, {"name":"site", "value":"7A0D89A6-2B82-11DF-B9DA-F61CBD13F020"}]}, "cache":{}, "connection":"ClientPort:49433;EgressPort:49446", "time":219, "serverIPAddress":"207.171.3.4"}], "comment":"exported @ 5/09/2015 5:12:42 PM", "version":"1.2", "pages":[]}}
_FIDDLER2_RESULTS_
ok($har->string($fiddler_string), "Successfully read Fiddler har archive for http://search.cpan.org/recent");
ok($har->version() eq '1.2', "INPUT: Fiddler produces a version 1.2 http archive");
ok($har->creator()->name() eq 'Fiddler', "INPUT: Fiddler's creator name is 'Fiddler'");
ok($har->creator()->version() eq '4.6.0.2', "INPUT: Fiddler's creator version is '4.6.0.2'");
ok($har->creator()->comment() eq 'http://www.fiddler2.com', "INPUT: Fiddler's creator comment is 'http://www.fiddler2.com'");
my $fiddler_ref = $har->hashref();
ok(!exists $fiddler_ref->{log}->{entries}->[0]->{request}->{postData}, "Empty postData entry stripped from Fiddler output");
