/*
 * Decompiled with CFR 0.152.
 */
package org.gagravarr.tika;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.tika.exception.TikaException;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.AbstractParser;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.sax.XHTMLContentHandler;
import org.gagravarr.ogg.OggFile;
import org.gagravarr.ogg.OggPacket;
import org.gagravarr.ogg.OggPacketReader;
import org.gagravarr.ogg.OggStreamIdentifier;
import org.gagravarr.tika.OggDetector;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OggParser
extends AbstractParser {
    private static final long serialVersionUID = -5686095376587813226L;
    protected static final MediaType OGG_GENERAL = OggDetector.OGG_GENERAL;
    protected static final MediaType OGG_AUDIO = OggDetector.OGG_AUDIO;
    protected static final MediaType OGG_VIDEO = OggDetector.OGG_VIDEO;
    protected static final MediaType KATE = MediaType.parse(OggStreamIdentifier.KATE.mimetype);
    protected static final MediaType DAALA_VIDEO = MediaType.parse(OggStreamIdentifier.DAALA_VIDEO.mimetype);
    protected static final MediaType DIRAC_VIDEO = MediaType.parse(OggStreamIdentifier.DIRAC_VIDEO.mimetype);
    protected static final MediaType OGM_VIDEO = MediaType.parse(OggStreamIdentifier.OGM_VIDEO.mimetype);
    protected static final MediaType OGG_UVS = MediaType.parse(OggStreamIdentifier.OGG_UVS.mimetype);
    protected static final MediaType OGG_YUV = MediaType.parse(OggStreamIdentifier.OGG_YUV.mimetype);
    protected static final MediaType OGG_RGB = MediaType.parse(OggStreamIdentifier.OGG_RGB.mimetype);
    protected static final MediaType OGG_PCM = MediaType.parse(OggStreamIdentifier.OGG_PCM.mimetype);
    private static List<MediaType> TYPES = Arrays.asList(OGG_GENERAL, OGG_AUDIO, OGG_VIDEO, DAALA_VIDEO, DIRAC_VIDEO, OGM_VIDEO, OGG_UVS, OGG_YUV, OGG_RGB, OGG_PCM, KATE);

    @Override
    public Set<MediaType> getSupportedTypes(ParseContext context) {
        return new HashSet<MediaType>(TYPES);
    }

    @Override
    public void parse(InputStream stream, ContentHandler handler, Metadata metadata, ParseContext context) throws IOException, TikaException, SAXException {
        String key;
        OggPacket p;
        OggFile ogg = new OggFile(stream);
        HashMap<OggStreamIdentifier.OggStreamType, Integer> streams = new HashMap<OggStreamIdentifier.OggStreamType, Integer>();
        HashMap<OggStreamIdentifier.OggStreamType.Kind, Integer> streamKinds = new HashMap<OggStreamIdentifier.OggStreamType.Kind, Integer>();
        ArrayList<Integer> sids = new ArrayList<Integer>();
        int totalStreams = 0;
        XHTMLContentHandler xhtml = new XHTMLContentHandler(handler, metadata);
        xhtml.startDocument();
        OggPacketReader r = ogg.getPacketReader();
        while ((p = r.getNextPacket()) != null) {
            if (!p.isBeginningOfStream()) continue;
            ++totalStreams;
            sids.add(p.getSid());
            OggStreamIdentifier.OggStreamType type = OggStreamIdentifier.identifyType(p);
            Integer prevValue = (Integer)streams.get(type);
            if (prevValue == null) {
                prevValue = 0;
            }
            streams.put(type, prevValue + 1);
            prevValue = (Integer)streamKinds.get((Object)type.kind);
            if (prevValue == null) {
                prevValue = 0;
            }
            streamKinds.put(type.kind, prevValue + 1);
        }
        metadata.add("streams-total", Integer.toString(totalStreams));
        for (OggStreamIdentifier.OggStreamType type : streams.keySet()) {
            key = type.mimetype.substring(type.mimetype.indexOf(47) + 1);
            if (key.startsWith("x-")) {
                key = key.substring(2);
            }
            if (type == OggStreamIdentifier.UNKNOWN) {
                key = "unknown";
            }
            metadata.add("streams-" + key, Integer.toString((Integer)streams.get(type)));
        }
        for (OggStreamIdentifier.OggStreamType.Kind kind : streamKinds.keySet()) {
            key = kind.name().toLowerCase();
            metadata.add("streams-" + key, Integer.toString((Integer)streamKinds.get((Object)kind)));
        }
        xhtml.endDocument();
        ogg.close();
    }
}

