/*
 * Decompiled with CFR 0.152.
 */
package com.drew.metadata;

import com.drew.lang.Rational;
import com.drew.lang.annotations.NotNull;
import com.drew.lang.annotations.Nullable;
import com.drew.lang.annotations.SuppressWarnings;
import com.drew.metadata.MetadataException;
import com.drew.metadata.StringValue;
import com.drew.metadata.Tag;
import com.drew.metadata.TagDescriptor;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Array;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class Directory {
    private static final String _floatFormatPattern = "0.###";
    @NotNull
    protected final Map<Integer, Object> _tagMap = new HashMap<Integer, Object>();
    @NotNull
    protected final Collection<Tag> _definedTagList = new ArrayList<Tag>();
    @NotNull
    private final Collection<String> _errorList = new ArrayList<String>(4);
    protected TagDescriptor _descriptor;
    @Nullable
    private Directory _parent;

    @NotNull
    public abstract String getName();

    @NotNull
    protected abstract HashMap<Integer, String> getTagNameMap();

    protected Directory() {
    }

    public boolean isEmpty() {
        return this._errorList.isEmpty() && this._definedTagList.isEmpty();
    }

    public boolean containsTag(int tagType) {
        return this._tagMap.containsKey(tagType);
    }

    @NotNull
    public Collection<Tag> getTags() {
        return Collections.unmodifiableCollection(this._definedTagList);
    }

    public int getTagCount() {
        return this._definedTagList.size();
    }

    public void setDescriptor(@NotNull TagDescriptor descriptor) {
        if (descriptor == null) {
            throw new NullPointerException("cannot set a null descriptor");
        }
        this._descriptor = descriptor;
    }

    public void addError(@NotNull String message) {
        this._errorList.add(message);
    }

    public boolean hasErrors() {
        return this._errorList.size() > 0;
    }

    @NotNull
    public Iterable<String> getErrors() {
        return Collections.unmodifiableCollection(this._errorList);
    }

    public int getErrorCount() {
        return this._errorList.size();
    }

    @Nullable
    public Directory getParent() {
        return this._parent;
    }

    public void setParent(@NotNull Directory parent) {
        this._parent = parent;
    }

    public void setInt(int tagType, int value) {
        this.setObject(tagType, value);
    }

    public void setIntArray(int tagType, @NotNull int[] ints) {
        this.setObjectArray(tagType, ints);
    }

    public void setFloat(int tagType, float value) {
        this.setObject(tagType, Float.valueOf(value));
    }

    public void setFloatArray(int tagType, @NotNull float[] floats) {
        this.setObjectArray(tagType, floats);
    }

    public void setDouble(int tagType, double value) {
        this.setObject(tagType, value);
    }

    public void setDoubleArray(int tagType, @NotNull double[] doubles) {
        this.setObjectArray(tagType, doubles);
    }

    public void setStringValue(int tagType, @NotNull StringValue value) {
        if (value == null) {
            throw new NullPointerException("cannot set a null StringValue");
        }
        this.setObject(tagType, value);
    }

    public void setString(int tagType, @NotNull String value) {
        if (value == null) {
            throw new NullPointerException("cannot set a null String");
        }
        this.setObject(tagType, value);
    }

    public void setStringArray(int tagType, @NotNull String[] strings) {
        this.setObjectArray(tagType, strings);
    }

    public void setStringValueArray(int tagType, @NotNull StringValue[] strings) {
        this.setObjectArray(tagType, strings);
    }

    public void setBoolean(int tagType, boolean value) {
        this.setObject(tagType, value);
    }

    public void setLong(int tagType, long value) {
        this.setObject(tagType, value);
    }

    public void setDate(int tagType, @NotNull Date value) {
        this.setObject(tagType, value);
    }

    public void setRational(int tagType, @NotNull Rational rational) {
        this.setObject(tagType, rational);
    }

    public void setRationalArray(int tagType, @NotNull Rational[] rationals) {
        this.setObjectArray(tagType, rationals);
    }

    public void setByteArray(int tagType, @NotNull byte[] bytes) {
        this.setObjectArray(tagType, bytes);
    }

    public void setObject(int tagType, @NotNull Object value) {
        if (value == null) {
            throw new NullPointerException("cannot set a null object");
        }
        if (!this._tagMap.containsKey(tagType)) {
            this._definedTagList.add(new Tag(tagType, this));
        }
        this._tagMap.put(tagType, value);
    }

    public void setObjectArray(int tagType, @NotNull Object array) {
        this.setObject(tagType, array);
    }

    public int getInt(int tagType) throws MetadataException {
        Integer integer = this.getInteger(tagType);
        if (integer != null) {
            return integer;
        }
        Object o = this.getObject(tagType);
        if (o == null) {
            throw new MetadataException("Tag '" + this.getTagName(tagType) + "' has not been set -- check using containsTag() first");
        }
        throw new MetadataException("Tag '" + tagType + "' cannot be converted to int.  It is of type '" + o.getClass() + "'.");
    }

    @Nullable
    public Integer getInteger(int tagType) {
        short[] shorts;
        Object o = this.getObject(tagType);
        if (o == null) {
            return null;
        }
        if (o instanceof Number) {
            return ((Number)o).intValue();
        }
        if (o instanceof String || o instanceof StringValue) {
            try {
                return Integer.parseInt(o.toString());
            }
            catch (NumberFormatException nfe) {
                String s = o.toString();
                byte[] bytes = s.getBytes();
                long val = 0L;
                for (byte aByte : bytes) {
                    val <<= 8;
                    val += (long)(aByte & 0xFF);
                }
                return (int)val;
            }
        }
        if (o instanceof Rational[]) {
            Rational[] rationals = (Rational[])o;
            if (rationals.length == 1) {
                return rationals[0].intValue();
            }
        } else if (o instanceof byte[]) {
            byte[] bytes = (byte[])o;
            if (bytes.length == 1) {
                return bytes[0];
            }
        } else if (o instanceof int[]) {
            int[] ints = (int[])o;
            if (ints.length == 1) {
                return ints[0];
            }
        } else if (o instanceof short[] && (shorts = (short[])o).length == 1) {
            return shorts[0];
        }
        return null;
    }

    @Nullable
    public String[] getStringArray(int tagType) {
        Object o = this.getObject(tagType);
        if (o == null) {
            return null;
        }
        if (o instanceof String[]) {
            return (String[])o;
        }
        if (o instanceof String) {
            return new String[]{(String)o};
        }
        if (o instanceof StringValue) {
            return new String[]{o.toString()};
        }
        if (o instanceof StringValue[]) {
            StringValue[] stringValues = (StringValue[])o;
            String[] strings = new String[stringValues.length];
            for (int i = 0; i < strings.length; ++i) {
                strings[i] = stringValues[i].toString();
            }
            return strings;
        }
        if (o instanceof int[]) {
            int[] ints = (int[])o;
            String[] strings = new String[ints.length];
            for (int i = 0; i < strings.length; ++i) {
                strings[i] = Integer.toString(ints[i]);
            }
            return strings;
        }
        if (o instanceof byte[]) {
            byte[] bytes = (byte[])o;
            String[] strings = new String[bytes.length];
            for (int i = 0; i < strings.length; ++i) {
                strings[i] = Byte.toString(bytes[i]);
            }
            return strings;
        }
        if (o instanceof Rational[]) {
            Rational[] rationals = (Rational[])o;
            String[] strings = new String[rationals.length];
            for (int i = 0; i < strings.length; ++i) {
                strings[i] = rationals[i].toSimpleString(false);
            }
            return strings;
        }
        return null;
    }

    @Nullable
    public StringValue[] getStringValueArray(int tagType) {
        Object o = this.getObject(tagType);
        if (o == null) {
            return null;
        }
        if (o instanceof StringValue[]) {
            return (StringValue[])o;
        }
        if (o instanceof StringValue) {
            return new StringValue[]{(StringValue)o};
        }
        return null;
    }

    @Nullable
    public int[] getIntArray(int tagType) {
        Object o = this.getObject(tagType);
        if (o == null) {
            return null;
        }
        if (o instanceof int[]) {
            return (int[])o;
        }
        if (o instanceof Rational[]) {
            Rational[] rationals = (Rational[])o;
            int[] ints = new int[rationals.length];
            for (int i = 0; i < ints.length; ++i) {
                ints[i] = rationals[i].intValue();
            }
            return ints;
        }
        if (o instanceof short[]) {
            short[] shorts = (short[])o;
            int[] ints = new int[shorts.length];
            for (int i = 0; i < shorts.length; ++i) {
                ints[i] = shorts[i];
            }
            return ints;
        }
        if (o instanceof byte[]) {
            byte[] bytes = (byte[])o;
            int[] ints = new int[bytes.length];
            for (int i = 0; i < bytes.length; ++i) {
                ints[i] = bytes[i];
            }
            return ints;
        }
        if (o instanceof CharSequence) {
            CharSequence str = (CharSequence)o;
            int[] ints = new int[str.length()];
            for (int i = 0; i < str.length(); ++i) {
                ints[i] = str.charAt(i);
            }
            return ints;
        }
        if (o instanceof Integer) {
            return new int[]{(Integer)o};
        }
        return null;
    }

    @Nullable
    public byte[] getByteArray(int tagType) {
        Object o = this.getObject(tagType);
        if (o == null) {
            return null;
        }
        if (o instanceof StringValue) {
            return ((StringValue)o).getBytes();
        }
        if (o instanceof Rational[]) {
            Rational[] rationals = (Rational[])o;
            byte[] bytes = new byte[rationals.length];
            for (int i = 0; i < bytes.length; ++i) {
                bytes[i] = rationals[i].byteValue();
            }
            return bytes;
        }
        if (o instanceof byte[]) {
            return (byte[])o;
        }
        if (o instanceof int[]) {
            int[] ints = (int[])o;
            byte[] bytes = new byte[ints.length];
            for (int i = 0; i < ints.length; ++i) {
                bytes[i] = (byte)ints[i];
            }
            return bytes;
        }
        if (o instanceof short[]) {
            short[] shorts = (short[])o;
            byte[] bytes = new byte[shorts.length];
            for (int i = 0; i < shorts.length; ++i) {
                bytes[i] = (byte)shorts[i];
            }
            return bytes;
        }
        if (o instanceof CharSequence) {
            CharSequence str = (CharSequence)o;
            byte[] bytes = new byte[str.length()];
            for (int i = 0; i < str.length(); ++i) {
                bytes[i] = (byte)str.charAt(i);
            }
            return bytes;
        }
        if (o instanceof Integer) {
            return new byte[]{((Integer)o).byteValue()};
        }
        return null;
    }

    public double getDouble(int tagType) throws MetadataException {
        Double value = this.getDoubleObject(tagType);
        if (value != null) {
            return value;
        }
        Object o = this.getObject(tagType);
        if (o == null) {
            throw new MetadataException("Tag '" + this.getTagName(tagType) + "' has not been set -- check using containsTag() first");
        }
        throw new MetadataException("Tag '" + tagType + "' cannot be converted to a double.  It is of type '" + o.getClass() + "'.");
    }

    @Nullable
    public Double getDoubleObject(int tagType) {
        Object o = this.getObject(tagType);
        if (o == null) {
            return null;
        }
        if (o instanceof String || o instanceof StringValue) {
            try {
                return Double.parseDouble(o.toString());
            }
            catch (NumberFormatException nfe) {
                return null;
            }
        }
        if (o instanceof Number) {
            return ((Number)o).doubleValue();
        }
        return null;
    }

    public float getFloat(int tagType) throws MetadataException {
        Float value = this.getFloatObject(tagType);
        if (value != null) {
            return value.floatValue();
        }
        Object o = this.getObject(tagType);
        if (o == null) {
            throw new MetadataException("Tag '" + this.getTagName(tagType) + "' has not been set -- check using containsTag() first");
        }
        throw new MetadataException("Tag '" + tagType + "' cannot be converted to a float.  It is of type '" + o.getClass() + "'.");
    }

    @Nullable
    public Float getFloatObject(int tagType) {
        Object o = this.getObject(tagType);
        if (o == null) {
            return null;
        }
        if (o instanceof String || o instanceof StringValue) {
            try {
                return Float.valueOf(Float.parseFloat(o.toString()));
            }
            catch (NumberFormatException nfe) {
                return null;
            }
        }
        if (o instanceof Number) {
            return Float.valueOf(((Number)o).floatValue());
        }
        return null;
    }

    public long getLong(int tagType) throws MetadataException {
        Long value = this.getLongObject(tagType);
        if (value != null) {
            return value;
        }
        Object o = this.getObject(tagType);
        if (o == null) {
            throw new MetadataException("Tag '" + this.getTagName(tagType) + "' has not been set -- check using containsTag() first");
        }
        throw new MetadataException("Tag '" + tagType + "' cannot be converted to a long.  It is of type '" + o.getClass() + "'.");
    }

    @Nullable
    public Long getLongObject(int tagType) {
        Object o = this.getObject(tagType);
        if (o == null) {
            return null;
        }
        if (o instanceof String || o instanceof StringValue) {
            try {
                return Long.parseLong(o.toString());
            }
            catch (NumberFormatException nfe) {
                return null;
            }
        }
        if (o instanceof Number) {
            return ((Number)o).longValue();
        }
        return null;
    }

    public boolean getBoolean(int tagType) throws MetadataException {
        Boolean value = this.getBooleanObject(tagType);
        if (value != null) {
            return value;
        }
        Object o = this.getObject(tagType);
        if (o == null) {
            throw new MetadataException("Tag '" + this.getTagName(tagType) + "' has not been set -- check using containsTag() first");
        }
        throw new MetadataException("Tag '" + tagType + "' cannot be converted to a boolean.  It is of type '" + o.getClass() + "'.");
    }

    @Nullable
    @SuppressWarnings(value="NP_BOOLEAN_RETURN_NULL", justification="keep API interface consistent")
    public Boolean getBooleanObject(int tagType) {
        Object o = this.getObject(tagType);
        if (o == null) {
            return null;
        }
        if (o instanceof Boolean) {
            return (Boolean)o;
        }
        if (o instanceof String || o instanceof StringValue) {
            try {
                return Boolean.getBoolean(o.toString());
            }
            catch (NumberFormatException nfe) {
                return null;
            }
        }
        if (o instanceof Number) {
            return ((Number)o).doubleValue() != 0.0;
        }
        return null;
    }

    @Nullable
    public Date getDate(int tagType) {
        return this.getDate(tagType, null, null);
    }

    @Nullable
    public Date getDate(int tagType, @Nullable TimeZone timeZone) {
        return this.getDate(tagType, null, timeZone);
    }

    @Nullable
    public Date getDate(int tagType, @Nullable String subsecond, @Nullable TimeZone timeZone) {
        Object o = this.getObject(tagType);
        if (o instanceof Date) {
            return (Date)o;
        }
        Date date = null;
        if (o instanceof String || o instanceof StringValue) {
            Pattern timeZonePattern;
            Matcher timeZoneMatcher;
            String[] datePatterns = new String[]{"yyyy:MM:dd HH:mm:ss", "yyyy:MM:dd HH:mm", "yyyy-MM-dd HH:mm:ss", "yyyy-MM-dd HH:mm", "yyyy.MM.dd HH:mm:ss", "yyyy.MM.dd HH:mm", "yyyy-MM-dd'T'HH:mm:ss", "yyyy-MM-dd'T'HH:mm", "yyyy-MM-dd", "yyyy-MM", "yyyyMMdd", "yyyy"};
            String dateString = o.toString();
            Pattern subsecondPattern = Pattern.compile("(\\d\\d:\\d\\d:\\d\\d)(\\.\\d+)");
            Matcher subsecondMatcher = subsecondPattern.matcher(dateString);
            if (subsecondMatcher.find()) {
                subsecond = subsecondMatcher.group(2).substring(1);
                dateString = subsecondMatcher.replaceAll("$1");
            }
            if ((timeZoneMatcher = (timeZonePattern = Pattern.compile("(Z|[+-]\\d\\d:\\d\\d)$")).matcher(dateString)).find()) {
                timeZone = TimeZone.getTimeZone("GMT" + timeZoneMatcher.group().replaceAll("Z", ""));
                dateString = timeZoneMatcher.replaceAll("");
            }
            for (String datePattern : datePatterns) {
                try {
                    SimpleDateFormat parser = new SimpleDateFormat(datePattern);
                    if (timeZone != null) {
                        parser.setTimeZone(timeZone);
                    } else {
                        parser.setTimeZone(TimeZone.getTimeZone("GMT"));
                    }
                    date = parser.parse(dateString);
                    break;
                }
                catch (ParseException ex) {
                }
            }
        }
        if (date == null) {
            return null;
        }
        if (subsecond == null) {
            return date;
        }
        try {
            int millisecond = (int)(Double.parseDouble("." + subsecond) * 1000.0);
            if (millisecond >= 0 && millisecond < 1000) {
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(date);
                calendar.set(14, millisecond);
                return calendar.getTime();
            }
            return date;
        }
        catch (NumberFormatException e) {
            return date;
        }
    }

    @Nullable
    public Rational getRational(int tagType) {
        Object o = this.getObject(tagType);
        if (o == null) {
            return null;
        }
        if (o instanceof Rational) {
            return (Rational)o;
        }
        if (o instanceof Integer) {
            return new Rational(((Integer)o).intValue(), 1L);
        }
        if (o instanceof Long) {
            return new Rational((Long)o, 1L);
        }
        return null;
    }

    @Nullable
    public Rational[] getRationalArray(int tagType) {
        Object o = this.getObject(tagType);
        if (o == null) {
            return null;
        }
        if (o instanceof Rational[]) {
            return (Rational[])o;
        }
        return null;
    }

    @Nullable
    public String getString(int tagType) {
        Object o = this.getObject(tagType);
        if (o == null) {
            return null;
        }
        if (o instanceof Rational) {
            return ((Rational)o).toSimpleString(true);
        }
        if (o.getClass().isArray()) {
            int arrayLength = Array.getLength(o);
            Class<?> componentType = o.getClass().getComponentType();
            StringBuilder string = new StringBuilder();
            if (Object.class.isAssignableFrom(componentType)) {
                for (int i = 0; i < arrayLength; ++i) {
                    if (i != 0) {
                        string.append(' ');
                    }
                    string.append(Array.get(o, i).toString());
                }
            } else if (componentType.getName().equals("int")) {
                for (int i = 0; i < arrayLength; ++i) {
                    if (i != 0) {
                        string.append(' ');
                    }
                    string.append(Array.getInt(o, i));
                }
            } else if (componentType.getName().equals("short")) {
                for (int i = 0; i < arrayLength; ++i) {
                    if (i != 0) {
                        string.append(' ');
                    }
                    string.append(Array.getShort(o, i));
                }
            } else if (componentType.getName().equals("long")) {
                for (int i = 0; i < arrayLength; ++i) {
                    if (i != 0) {
                        string.append(' ');
                    }
                    string.append(Array.getLong(o, i));
                }
            } else if (componentType.getName().equals("float")) {
                for (int i = 0; i < arrayLength; ++i) {
                    if (i != 0) {
                        string.append(' ');
                    }
                    string.append(new DecimalFormat(_floatFormatPattern).format(Array.getFloat(o, i)));
                }
            } else if (componentType.getName().equals("double")) {
                for (int i = 0; i < arrayLength; ++i) {
                    if (i != 0) {
                        string.append(' ');
                    }
                    string.append(new DecimalFormat(_floatFormatPattern).format(Array.getDouble(o, i)));
                }
            } else if (componentType.getName().equals("byte")) {
                for (int i = 0; i < arrayLength; ++i) {
                    if (i != 0) {
                        string.append(' ');
                    }
                    string.append(Array.getByte(o, i) & 0xFF);
                }
            } else {
                this.addError("Unexpected array component type: " + componentType.getName());
            }
            return string.toString();
        }
        if (o instanceof Double) {
            return new DecimalFormat(_floatFormatPattern).format((Double)o);
        }
        if (o instanceof Float) {
            return new DecimalFormat(_floatFormatPattern).format(((Float)o).floatValue());
        }
        return o.toString();
    }

    @Nullable
    public String getString(int tagType, String charset) {
        byte[] bytes = this.getByteArray(tagType);
        if (bytes == null) {
            return null;
        }
        try {
            return new String(bytes, charset);
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }

    @Nullable
    public StringValue getStringValue(int tagType) {
        Object o = this.getObject(tagType);
        if (o instanceof StringValue) {
            return (StringValue)o;
        }
        return null;
    }

    @Nullable
    public Object getObject(int tagType) {
        return this._tagMap.get(tagType);
    }

    @NotNull
    public String getTagName(int tagType) {
        HashMap<Integer, String> nameMap = this.getTagNameMap();
        if (!nameMap.containsKey(tagType)) {
            String hex = Integer.toHexString(tagType);
            while (hex.length() < 4) {
                hex = "0" + hex;
            }
            return "Unknown tag (0x" + hex + ")";
        }
        return nameMap.get(tagType);
    }

    public boolean hasTagName(int tagType) {
        return this.getTagNameMap().containsKey(tagType);
    }

    @Nullable
    public String getDescription(int tagType) {
        assert (this._descriptor != null);
        return this._descriptor.getDescription(tagType);
    }

    public String toString() {
        return String.format("%s Directory (%d %s)", this.getName(), this._tagMap.size(), this._tagMap.size() == 1 ? "tag" : "tags");
    }
}

