/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.javaocr.ocrPlugins.mseOCR;

import java.util.logging.Logger;
import net.sourceforge.javaocr.scanner.PixelImage;

public class TrainingImage
extends PixelImage {
    public static final float ASPECT_RATIO_TOLERANCE = 0.3f;
    public static final float TOP_WHITE_SPACE_FRACTION_TOLERANCE = 0.3f;
    public static final float BOTTOM_WHITE_SPACE_FRACTION_TOLERANCE = 0.3f;
    public final float topWhiteSpaceFraction;
    public final float bottomWhiteSpaceFraction;
    private int myMaxX;
    private int myMaxY;
    private static final Logger LOG = Logger.getLogger(TrainingImage.class.getName());

    public TrainingImage(int[] pixels, int width, int height, int topWhiteSpacePixels, int bottomWhiteSpacePixels) {
        super(pixels, width, height);
        int rowHeight = topWhiteSpacePixels + height + bottomWhiteSpacePixels;
        this.topWhiteSpaceFraction = (float)topWhiteSpacePixels / (float)rowHeight;
        this.bottomWhiteSpaceFraction = (float)bottomWhiteSpacePixels / (float)rowHeight;
        this.myMaxX = width - 1;
        this.myMaxY = height - 1;
    }

    public double calcMSE(int[] theirPixels, int w, int h, int x1, int y1, int x2, int y2) {
        int theirXRange = Math.max(x2 - x1 - 1, 1);
        int theirYRange = Math.max(y2 - y1 - 1, 1);
        int theirNPix = (theirXRange + 1) * (theirYRange + 1);
        boolean firstCompare = true;
        long minError = Long.MAX_VALUE;
        long totalError = 0L;
        int theirY = y1;
        int yScan = 0;
        while (theirY < y2) {
            int theirIdx = theirY * w + x1;
            int myY = yScan * this.myMaxY / theirYRange;
            int myLineIdx = myY * this.width;
            int theirX = x1;
            int xScan = 0;
            while (theirX < x2) {
                int myX = xScan * this.myMaxX / theirXRange;
                long thisError = myX < 0 || myX > this.myMaxX || myY < 0 || myY > this.myMaxY ? (long)(theirPixels[theirIdx] - 255) : (long)(theirPixels[theirIdx] - this.pixels[myLineIdx + myX]);
                totalError += thisError * thisError;
                ++theirX;
                ++theirIdx;
                ++xScan;
            }
            ++theirY;
            ++yScan;
        }
        if (firstCompare || totalError < minError) {
            minError = totalError;
        }
        firstCompare = false;
        return Math.sqrt(minError) / (double)theirNPix;
    }
}

