/*
 * Decompiled with CFR 0.152.
 */
package opennlp.maxent.io;

import java.io.BufferedWriter;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.zip.GZIPOutputStream;
import opennlp.maxent.GISModel;
import opennlp.maxent.io.BinaryGISModelWriter;
import opennlp.maxent.io.GISModelWriter;
import opennlp.maxent.io.PlainTextGISModelWriter;

public class SuffixSensitiveGISModelWriter
extends GISModelWriter {
    private final GISModelWriter suffixAppropriateWriter;

    public SuffixSensitiveGISModelWriter(GISModel model, File f) throws IOException {
        super(model);
        FilterOutputStream output;
        String filename = f.getName();
        if (filename.endsWith(".gz")) {
            output = new GZIPOutputStream(new FileOutputStream(f));
            filename = filename.substring(0, filename.length() - 3);
        } else {
            output = new DataOutputStream(new FileOutputStream(f));
        }
        this.suffixAppropriateWriter = filename.endsWith(".bin") ? new BinaryGISModelWriter(model, new DataOutputStream(output)) : new PlainTextGISModelWriter(model, new BufferedWriter(new OutputStreamWriter(output)));
    }

    protected void close() throws IOException {
        this.suffixAppropriateWriter.close();
    }

    protected void writeDouble(double d) throws IOException {
        this.suffixAppropriateWriter.writeDouble(d);
    }

    protected void writeInt(int i) throws IOException {
        this.suffixAppropriateWriter.writeInt(i);
    }

    protected void writeUTF(String s) throws IOException {
        this.suffixAppropriateWriter.writeUTF(s);
    }
}

