#
# Patch given file with DATA hunks and print to STDOUT.
#
#
# Patching types in gen_uuid.c.
#
use strict;
use warnings;
use Text::Patch 'patch';

my $in = $ARGV[0];

my ($txt, $patch);
{
    local $/;
    open my $fh, '<', $in or die "open: $in: $!";
    $txt   = <$fh>;
    $patch = <DATA>;
}

#print $txt;
#print $patch;
#exit;

my $out = patch( $txt, $patch, STYLE => 'Unified' );

print $out;
exit 0;

__END__
--- usrc/uuid/gen_uuid.c	2023-11-29 23:03:41.792859158 -0500
+++ usrcP/uuid/gen_uuid.c	2023-12-03 04:47:40.747608198 -0500
@@ -300,19 +300,19 @@
 /* Assume that the gettimeofday() has microsecond granularity */
 #define MAX_ADJUSTMENT 10
 
-static int get_clock(uint32_t *clock_high, uint32_t *clock_low,
-		     uint16_t *ret_clock_seq, int *num)
+static int get_clock(myuint32_t *clock_high, myuint32_t *clock_low,
+		     myuint16_t *ret_clock_seq, int *num)
 {
 	THREAD_LOCAL int		adjustment = 0;
 	THREAD_LOCAL struct timeval	last = {0, 0};
 	THREAD_LOCAL int		state_fd = -2;
 	THREAD_LOCAL FILE		*state_f;
-	THREAD_LOCAL uint16_t		clock_seq;
+	THREAD_LOCAL myuint16_t		clock_seq;
 	struct timeval 			tv;
 #ifndef _WIN32
 	struct flock			fl;
 #endif
-	uint64_t			clock_reg;
+	myuint64_t			clock_reg;
 	mode_t				save_umask;
 	int				len;
 
@@ -386,8 +386,8 @@
 	}
 
 	clock_reg = tv.tv_usec*10 + adjustment;
-	clock_reg += ((uint64_t) tv.tv_sec)*10000000;
-	clock_reg += (((uint64_t) 0x01B21DD2) << 32) + 0x13814000;
+	clock_reg += ((myuint64_t) tv.tv_sec)*10000000;
+	clock_reg += (((myuint64_t) 0x01B21DD2) << 32) + 0x13814000;
 
 	if (num && (*num > 1)) {
 		adjustment += *num - 1;
@@ -495,7 +495,7 @@
 	int op_len;
 	int s;
 	ssize_t ret;
-	int32_t reply_len = 0, expected = 16;
+	myint32_t reply_len = 0, expected = 16;
 	struct sockaddr_un srv_addr;
 	struct stat st;
 	pid_t pid;
@@ -574,7 +574,7 @@
 	static unsigned char node_id[6];
 	static int has_init = 0;
 	struct uuid uu;
-	uint32_t	clock_mid;
+	myuint32_t	clock_mid;
 
 	if (!has_init) {
 		if (get_node_id(node_id) <= 0) {
@@ -590,7 +590,7 @@
 	}
 	get_clock(&clock_mid, &uu.time_low, &uu.clock_seq, num);
 	uu.clock_seq |= 0x8000;
-	uu.time_mid = (uint16_t) clock_mid;
+	uu.time_mid = (myuint16_t) clock_mid;
 	uu.time_hi_and_version = ((clock_mid >> 16) & 0x0FFF) | 0x1000;
 	memcpy(uu.node, node_id, 6);
 	uuid_pack(&uu, out);
