# Generated by default/object.tt
package Paws::Batch::ResourceRequirement;
  use Moose;
  has Type => (is => 'ro', isa => 'Str', request_name => 'type', traits => ['NameInRequest'], required => 1);
  has Value => (is => 'ro', isa => 'Str', request_name => 'value', traits => ['NameInRequest'], required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::Batch::ResourceRequirement

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Batch::ResourceRequirement object:

  $service_obj->Method(Att1 => { Type => $value, ..., Value => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Batch::ResourceRequirement object:

  $result = $service_obj->Method(...);
  $result->Att1->Type

=head1 DESCRIPTION

The type and amount of a resource to assign to a container. The
supported resources include C<GPU>, C<MEMORY>, and C<VCPU>.

=head1 ATTRIBUTES


=head2 B<REQUIRED> Type => Str

The type of resource to assign to a container. The supported resources
include C<GPU>, C<MEMORY>, and C<VCPU>.


=head2 B<REQUIRED> Value => Str

The quantity of the specified resource to reserve for the container.
The values vary based on the C<type> specified.

=over

=item type="GPU"

The number of physical GPUs to reserve for the container. The number of
GPUs reserved for all containers in a job shouldn't exceed the number
of available GPUs on the compute resource that the job is launched on.

GPUs are not available for jobs running on Fargate resources.

=item type="MEMORY"

The memory hard limit (in MiB) present to the container. This parameter
is supported for jobs running on EC2 resources. If your container
attempts to exceed the memory specified, the container is terminated.
This parameter maps to C<Memory> in the Create a container
(https://docs.docker.com/engine/api/v1.23/#create-a-container) section
of the Docker Remote API (https://docs.docker.com/engine/api/v1.23/)
and the C<--memory> option to docker run
(https://docs.docker.com/engine/reference/run/). You must specify at
least 4 MiB of memory for a job. This is required but can be specified
in several places for multi-node parallel (MNP) jobs. It must be
specified for each node at least once. This parameter maps to C<Memory>
in the Create a container
(https://docs.docker.com/engine/api/v1.23/#create-a-container) section
of the Docker Remote API (https://docs.docker.com/engine/api/v1.23/)
and the C<--memory> option to docker run
(https://docs.docker.com/engine/reference/run/).

If you're trying to maximize your resource utilization by providing
your jobs as much memory as possible for a particular instance type,
see Memory Management
(https://docs.aws.amazon.com/batch/latest/userguide/memory-management.html)
in the I<AWS Batch User Guide>.

For jobs running on Fargate resources, then C<value> is the hard limit
(in MiB), and must match one of the supported values and the C<VCPU>
values must be one of the values supported for that memory value.

=over

=item value = 512

C<VCPU> = 0.25

=item value = 1024

C<VCPU> = 0.25 or 0.5

=item value = 2048

C<VCPU> = 0.25, 0.5, or 1

=item value = 3072

C<VCPU> = 0.5, or 1

=item value = 4096

C<VCPU> = 0.5, 1, or 2

=item value = 5120, 6144, or 7168

C<VCPU> = 1 or 2

=item value = 8192

C<VCPU> = 1, 2, or 4

=item value = 9216, 10240, 11264, 12288, 13312, 14336, 15360, or 16384

C<VCPU> = 2 or 4

=item value = 17408, 18432, 19456, 20480, 21504, 22528, 23552, 24576,
25600, 26624, 27648, 28672, 29696, or 30720

C<VCPU> = 4

=back

=item type="VCPU"

The number of vCPUs reserved for the container. This parameter maps to
C<CpuShares> in the Create a container
(https://docs.docker.com/engine/api/v1.23/#create-a-container) section
of the Docker Remote API (https://docs.docker.com/engine/api/v1.23/)
and the C<--cpu-shares> option to docker run
(https://docs.docker.com/engine/reference/run/). Each vCPU is
equivalent to 1,024 CPU shares. For EC2 resources, you must specify at
least one vCPU. This is required but can be specified in several
places; it must be specified for each node at least once.

For jobs running on Fargate resources, then C<value> must match one of
the supported values and the C<MEMORY> values must be one of the values
supported for that VCPU value. The supported values are 0.25, 0.5, 1,
2, and 4

=over

=item value = 0.25

C<MEMORY> = 512, 1024, or 2048

=item value = 0.5

C<MEMORY> = 1024, 2048, 3072, or 4096

=item value = 1

C<MEMORY> = 2048, 3072, 4096, 5120, 6144, 7168, or 8192

=item value = 2

C<MEMORY> = 4096, 5120, 6144, 7168, 8192, 9216, 10240, 11264, 12288,
13312, 14336, 15360, or 16384

=item value = 4

C<MEMORY> = 8192, 9216, 10240, 11264, 12288, 13312, 14336, 15360,
16384, 17408, 18432, 19456, 20480, 21504, 22528, 23552, 24576, 25600,
26624, 27648, 28672, 29696, or 30720

=back

=back




=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Batch>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

