/*
 * Decompiled with CFR 0.152.
 */
package org.couchbase.mock.memcached.protocol;

import java.nio.ByteBuffer;
import org.couchbase.mock.memcached.Item;
import org.couchbase.mock.memcached.protocol.BinaryCommand;
import org.couchbase.mock.memcached.protocol.BinaryResponse;
import org.couchbase.mock.memcached.protocol.ErrorCode;

public class BinaryGetResponse
extends BinaryResponse {
    public BinaryGetResponse(BinaryCommand command, ErrorCode error) {
        super(command, error);
    }

    public BinaryGetResponse(BinaryCommand command, Item item) {
        super(BinaryGetResponse.create(command, item));
    }

    private static ByteBuffer create(BinaryCommand command, Item item) {
        int keySize;
        switch (command.getComCode()) {
            case GETK: 
            case GETKQ: 
            case GET_REPLICA: {
                keySize = command.getKey().length();
                break;
            }
            default: {
                keySize = 0;
            }
        }
        ByteBuffer message = BinaryResponse.create(command, ErrorCode.SUCCESS, 4, keySize, item.getValue().length, item.getCas());
        message.putInt(item.getFlags());
        if (keySize > 0) {
            message.put(command.getKey().getBytes());
        }
        message.put(item.getValue());
        message.rewind();
        return message;
    }
}

