# Before `make install' is performed this script should be runnable with
# `make test'. After `make install' it should work as `perl test.pl'

#	get_host.t
#
######################### We start with some black magic to print on failure.
# Change 1..1 below to 1..last_test_to_print .
# (It may become useful if the test is moved to ./t subdirectory.)

BEGIN {
	$| = 1; print "1..25\n"; 
	*Net::DNS::ToolKit::Utilities::question = \&question;
}
END {print "not ok 1\n" unless $loaded;}

#use diagnostics;
use Net::DNS::Dig qw(
	AF_INET
	AF_INET6
);
use Net::DNS::Codes qw(:all);
use Net::DNS::ToolKit qw(
	getflags
	putflags
	put1char
	inet_ntoa
	inet_aton
);
use Net::DNS::ToolKit::RR;
#use Net::DNS::ToolKit::Debug qw(
#	print_buf
#);
use Net::DNS::ToolKit::Utilities qw(
	revIP
);

$loaded = 1;
print "ok 1\n";
######################### End of black magic.

# Insert your test code below (better if it prints "ok 13"
# (correspondingly "not ok 13") depending on the success of chunk 13
# of the test code):

$test = 2;

sub ok {
  print "ok $test\n";
  ++$test;
}

#require './recurse2txt';

*get_host = \&Net::DNS::Dig::_get_host;

# input:	data pointer
# returns:	pointer to query buffer
#
sub makebuf {
  my $dp = shift;
  my @data = split("\n",$$dp);
  my $off = 0;
  my $buffer = '';
  foreach (@data) {
    $_ =~ /0x.{2}\s+(\d+)/;
    $off = put1char(\$buffer,$off,$1);
  }
  return \$buffer;
}

my $aques1 = q
| 0	:  0011_0011  0x33   51  3  
  1	:  1011_0010  0xB2  178    
  2	:  0000_0001  0x01    1    
  3	:  0000_0000  0x00    0    
  4	:  0000_0000  0x00    0    
  5	:  0000_0001  0x01    1    
  6	:  0000_0000  0x00    0    
  7	:  0000_0000  0x00    0    
  8	:  0000_0000  0x00    0    
  9	:  0000_0000  0x00    0    
  10	:  0000_0000  0x00    0    
  11	:  0000_0000  0x00    0    
  12	:  0000_0100  0x04    4    
  13	:  0110_0001  0x61   97  a  
  14	:  0111_0010  0x72  114  r  
  15	:  0111_0000  0x70  112  p  
  16	:  0110_0001  0x61   97  a  
  17	:  0000_0011  0x03    3    
  18	:  0110_0011  0x63   99  c  
  19	:  0110_1111  0x6F  111  o  
  20	:  0110_1101  0x6D  109  m  
  21	:  0000_0000  0x00    0    
  22	:  0000_0000  0x00    0    
  23	:  0000_0001  0x01    1    
  24	:  0000_0000  0x00    0    
  25	:  0000_0001  0x01    1    |;

my $aans1 = q
| 0	:  0011_0011  0x33   51  3  
  1	:  1011_0010  0xB2  178    
  2	:  1000_0001  0x81  129    
  3	:  1000_0000  0x80  128    
  4	:  0000_0000  0x00    0    
  5	:  0000_0001  0x01    1    
  6	:  0000_0000  0x00    0    
  7	:  0000_0001  0x01    1    
  8	:  0000_0000  0x00    0    
  9	:  0000_1000  0x08    8    
  10	:  0000_0000  0x00    0    
  11	:  0000_1000  0x08    8    
  12	:  0000_0100  0x04    4    
  13	:  0110_0001  0x61   97  a  
  14	:  0111_0010  0x72  114  r  
  15	:  0111_0000  0x70  112  p  
  16	:  0110_0001  0x61   97  a  
  17	:  0000_0011  0x03    3    
  18	:  0110_0011  0x63   99  c  
  19	:  0110_1111  0x6F  111  o  
  20	:  0110_1101  0x6D  109  m  
  21	:  0000_0000  0x00    0    
  22	:  0000_0000  0x00    0    
  23	:  0000_0001  0x01    1    
  24	:  0000_0000  0x00    0    
  25	:  0000_0001  0x01    1    
  26	:  1100_0000  0xC0  192    
  27	:  0000_1100  0x0C   12    
  28	:  0000_0000  0x00    0    
  29	:  0000_0001  0x01    1    
  30	:  0000_0000  0x00    0    
  31	:  0000_0001  0x01    1    
  32	:  0000_0000  0x00    0    
  33	:  0000_0000  0x00    0    
  34	:  0000_0000  0x00    0    
  35	:  0010_1010  0x2A   42  *  
  36	:  0000_0000  0x00    0    
  37	:  0000_0100  0x04    4    
  38	:  1010_1110  0xAE  174    
  39	:  1000_1000  0x88  136    
  40	:  0110_1000  0x68  104  h  
  41	:  1110_1010  0xEA  234    
  42	:  1100_0000  0xC0  192    
  43	:  0000_1100  0x0C   12    
  44	:  0000_0000  0x00    0    
  45	:  0000_0010  0x02    2    
  46	:  0000_0000  0x00    0    
  47	:  0000_0001  0x01    1    
  48	:  0000_0000  0x00    0    
  49	:  0000_0001  0x01    1    
  50	:  0101_0001  0x51   81  Q  
  51	:  0110_1110  0x6E  110  n  
  52	:  0000_0000  0x00    0    
  53	:  0001_0100  0x14   20    
  54	:  0000_0101  0x05    5    
  55	:  0111_0000  0x70  112  p  
  56	:  0110_0100  0x64  100  d  
  57	:  0110_1110  0x6E  110  n  
  58	:  0111_0011  0x73  115  s  
  59	:  0011_0100  0x34   52  4  
  60	:  0000_1000  0x08    8    
  61	:  0111_0101  0x75  117  u  
  62	:  0110_1100  0x6C  108  l  
  63	:  0111_0100  0x74  116  t  
  64	:  0111_0010  0x72  114  r  
  65	:  0110_0001  0x61   97  a  
  66	:  0110_0100  0x64  100  d  
  67	:  0110_1110  0x6E  110  n  
  68	:  0111_0011  0x73  115  s  
  69	:  0000_0011  0x03    3    
  70	:  0110_1111  0x6F  111  o  
  71	:  0111_0010  0x72  114  r  
  72	:  0110_0111  0x67  103  g  
  73	:  0000_0000  0x00    0    
  74	:  1100_0000  0xC0  192    
  75	:  0000_1100  0x0C   12    
  76	:  0000_0000  0x00    0    
  77	:  0000_0010  0x02    2    
  78	:  0000_0000  0x00    0    
  79	:  0000_0001  0x01    1    
  80	:  0000_0000  0x00    0    
  81	:  0000_0001  0x01    1    
  82	:  0101_0001  0x51   81  Q  
  83	:  0110_1110  0x6E  110  n  
  84	:  0000_0000  0x00    0    
  85	:  0001_0100  0x14   20    
  86	:  0000_0101  0x05    5    
  87	:  0111_0000  0x70  112  p  
  88	:  0110_0100  0x64  100  d  
  89	:  0110_1110  0x6E  110  n  
  90	:  0111_0011  0x73  115  s  
  91	:  0011_0001  0x31   49  1  
  92	:  0000_1000  0x08    8    
  93	:  0111_0101  0x75  117  u  
  94	:  0110_1100  0x6C  108  l  
  95	:  0111_0100  0x74  116  t  
  96	:  0111_0010  0x72  114  r  
  97	:  0110_0001  0x61   97  a  
  98	:  0110_0100  0x64  100  d  
  99	:  0110_1110  0x6E  110  n  
  100	:  0111_0011  0x73  115  s  
  101	:  0000_0011  0x03    3    
  102	:  0110_1110  0x6E  110  n  
  103	:  0110_0101  0x65  101  e  
  104	:  0111_0100  0x74  116  t  
  105	:  0000_0000  0x00    0    
  106	:  1100_0000  0xC0  192    
  107	:  0000_1100  0x0C   12    
  108	:  0000_0000  0x00    0    
  109	:  0000_0010  0x02    2    
  110	:  0000_0000  0x00    0    
  111	:  0000_0001  0x01    1    
  112	:  0000_0000  0x00    0    
  113	:  0000_0001  0x01    1    
  114	:  0101_0001  0x51   81  Q  
  115	:  0110_1110  0x6E  110  n  
  116	:  0000_0000  0x00    0    
  117	:  0000_1000  0x08    8    
  118	:  0000_0101  0x05    5    
  119	:  0111_0101  0x75  117  u  
  120	:  0110_0100  0x64  100  d  
  121	:  0110_1110  0x6E  110  n  
  122	:  0111_0011  0x73  115  s  
  123	:  0011_0010  0x32   50  2  
  124	:  1100_0000  0xC0  192    
  125	:  0101_1100  0x5C   92  \  
  126	:  1100_0000  0xC0  192    
  127	:  0000_1100  0x0C   12    
  128	:  0000_0000  0x00    0    
  129	:  0000_0010  0x02    2    
  130	:  0000_0000  0x00    0    
  131	:  0000_0001  0x01    1    
  132	:  0000_0000  0x00    0    
  133	:  0000_0001  0x01    1    
  134	:  0101_0001  0x51   81  Q  
  135	:  0110_1110  0x6E  110  n  
  136	:  0000_0000  0x00    0    
  137	:  0000_1000  0x08    8    
  138	:  0000_0101  0x05    5    
  139	:  0111_0000  0x70  112  p  
  140	:  0110_0100  0x64  100  d  
  141	:  0110_1110  0x6E  110  n  
  142	:  0111_0011  0x73  115  s  
  143	:  0011_0010  0x32   50  2  
  144	:  1100_0000  0xC0  192    
  145	:  0101_1100  0x5C   92  \  
  146	:  1100_0000  0xC0  192    
  147	:  0000_1100  0x0C   12    
  148	:  0000_0000  0x00    0    
  149	:  0000_0010  0x02    2    
  150	:  0000_0000  0x00    0    
  151	:  0000_0001  0x01    1    
  152	:  0000_0000  0x00    0    
  153	:  0000_0001  0x01    1    
  154	:  0101_0001  0x51   81  Q  
  155	:  0110_1110  0x6E  110  n  
  156	:  0000_0000  0x00    0    
  157	:  0000_1000  0x08    8    
  158	:  0000_0101  0x05    5    
  159	:  0111_0101  0x75  117  u  
  160	:  0110_0100  0x64  100  d  
  161	:  0110_1110  0x6E  110  n  
  162	:  0111_0011  0x73  115  s  
  163	:  0011_0001  0x31   49  1  
  164	:  1100_0000  0xC0  192    
  165	:  0101_1100  0x5C   92  \  
  166	:  1100_0000  0xC0  192    
  167	:  0000_1100  0x0C   12    
  168	:  0000_0000  0x00    0    
  169	:  0000_0010  0x02    2    
  170	:  0000_0000  0x00    0    
  171	:  0000_0001  0x01    1    
  172	:  0000_0000  0x00    0    
  173	:  0000_0001  0x01    1    
  174	:  0101_0001  0x51   81  Q  
  175	:  0110_1110  0x6E  110  n  
  176	:  0000_0000  0x00    0    
  177	:  0001_0110  0x16   22    
  178	:  0000_0101  0x05    5    
  179	:  0111_0000  0x70  112  p  
  180	:  0110_0100  0x64  100  d  
  181	:  0110_1110  0x6E  110  n  
  182	:  0111_0011  0x73  115  s  
  183	:  0011_0110  0x36   54  6  
  184	:  0000_1000  0x08    8    
  185	:  0111_0101  0x75  117  u  
  186	:  0110_1100  0x6C  108  l  
  187	:  0111_0100  0x74  116  t  
  188	:  0111_0010  0x72  114  r  
  189	:  0110_0001  0x61   97  a  
  190	:  0110_0100  0x64  100  d  
  191	:  0110_1110  0x6E  110  n  
  192	:  0111_0011  0x73  115  s  
  193	:  0000_0010  0x02    2    
  194	:  0110_0011  0x63   99  c  
  195	:  0110_1111  0x6F  111  o  
  196	:  0000_0010  0x02    2    
  197	:  0111_0101  0x75  117  u  
  198	:  0110_1011  0x6B  107  k  
  199	:  0000_0000  0x00    0    
  200	:  1100_0000  0xC0  192    
  201	:  0000_1100  0x0C   12    
  202	:  0000_0000  0x00    0    
  203	:  0000_0010  0x02    2    
  204	:  0000_0000  0x00    0    
  205	:  0000_0001  0x01    1    
  206	:  0000_0000  0x00    0    
  207	:  0000_0001  0x01    1    
  208	:  0101_0001  0x51   81  Q  
  209	:  0110_1110  0x6E  110  n  
  210	:  0000_0000  0x00    0    
  211	:  0000_1000  0x08    8    
  212	:  0000_0101  0x05    5    
  213	:  0111_0000  0x70  112  p  
  214	:  0110_0100  0x64  100  d  
  215	:  0110_1110  0x6E  110  n  
  216	:  0111_0011  0x73  115  s  
  217	:  0011_0011  0x33   51  3  
  218	:  1100_0000  0xC0  192    
  219	:  0011_1100  0x3C   60  <  
  220	:  1100_0000  0xC0  192    
  221	:  0000_1100  0x0C   12    
  222	:  0000_0000  0x00    0    
  223	:  0000_0010  0x02    2    
  224	:  0000_0000  0x00    0    
  225	:  0000_0001  0x01    1    
  226	:  0000_0000  0x00    0    
  227	:  0000_0001  0x01    1    
  228	:  0101_0001  0x51   81  Q  
  229	:  0110_1110  0x6E  110  n  
  230	:  0000_0000  0x00    0    
  231	:  0001_0101  0x15   21    
  232	:  0000_0101  0x05    5    
  233	:  0111_0000  0x70  112  p  
  234	:  0110_0100  0x64  100  d  
  235	:  0110_1110  0x6E  110  n  
  236	:  0111_0011  0x73  115  s  
  237	:  0011_0101  0x35   53  5  
  238	:  0000_1000  0x08    8    
  239	:  0111_0101  0x75  117  u  
  240	:  0110_1100  0x6C  108  l  
  241	:  0111_0100  0x74  116  t  
  242	:  0111_0010  0x72  114  r  
  243	:  0110_0001  0x61   97  a  
  244	:  0110_0100  0x64  100  d  
  245	:  0110_1110  0x6E  110  n  
  246	:  0111_0011  0x73  115  s  
  247	:  0000_0100  0x04    4    
  248	:  0110_1001  0x69  105  i  
  249	:  0110_1110  0x6E  110  n  
  250	:  0110_0110  0x66  102  f  
  251	:  0110_1111  0x6F  111  o  
  252	:  0000_0000  0x00    0    
  253	:  1100_0000  0xC0  192    
  254	:  0101_0110  0x56   86  V  
  255	:  0000_0000  0x00    0    
  256	:  0000_0001  0x01    1    
  257	:  0000_0000  0x00    0    
  258	:  0000_0001  0x01    1    
  259	:  0000_0000  0x00    0    
  260	:  0000_0000  0x00    0    
  261	:  0000_0100  0x04    4    
  262	:  1110_1010  0xEA  234    
  263	:  0000_0000  0x00    0    
  264	:  0000_0100  0x04    4    
  265	:  1100_1100  0xCC  204    
  266	:  0100_1010  0x4A   74  J  
  267	:  0110_1100  0x6C  108  l  
  268	:  0000_0001  0x01    1    
  269	:  1100_0000  0xC0  192    
  270	:  1000_1010  0x8A  138    
  271	:  0000_0000  0x00    0    
  272	:  0000_0001  0x01    1    
  273	:  0000_0000  0x00    0    
  274	:  0000_0001  0x01    1    
  275	:  0000_0000  0x00    0    
  276	:  0000_0000  0x00    0    
  277	:  0000_0100  0x04    4    
  278	:  1110_1010  0xEA  234    
  279	:  0000_0000  0x00    0    
  280	:  0000_0100  0x04    4    
  281	:  1100_1100  0xCC  204    
  282	:  0100_1010  0x4A   74  J  
  283	:  0110_1101  0x6D  109  m  
  284	:  0000_0001  0x01    1    
  285	:  1100_0000  0xC0  192    
  286	:  1101_0100  0xD4  212    
  287	:  0000_0000  0x00    0    
  288	:  0000_0001  0x01    1    
  289	:  0000_0000  0x00    0    
  290	:  0000_0001  0x01    1    
  291	:  0000_0000  0x00    0    
  292	:  0000_0000  0x00    0    
  293	:  1110_1110  0xEE  238    
  294	:  0010_0011  0x23   35  #  
  295	:  0000_0000  0x00    0    
  296	:  0000_0100  0x04    4    
  297	:  1100_0111  0xC7  199    
  298	:  0000_0111  0x07    7    
  299	:  0100_0100  0x44   68  D  
  300	:  0000_0001  0x01    1    
  301	:  1100_0000  0xC0  192    
  302	:  0011_0110  0x36   54  6  
  303	:  0000_0000  0x00    0    
  304	:  0000_0001  0x01    1    
  305	:  0000_0000  0x00    0    
  306	:  0000_0001  0x01    1    
  307	:  0000_0000  0x00    0    
  308	:  0000_0001  0x01    1    
  309	:  0010_0010  0x22   34  "  
  310	:  0110_1010  0x6A  106  j  
  311	:  0000_0000  0x00    0    
  312	:  0000_0100  0x04    4    
  313	:  1100_0111  0xC7  199    
  314	:  0000_0111  0x07    7    
  315	:  0100_0101  0x45   69  E  
  316	:  0000_0001  0x01    1    
  317	:  1100_0000  0xC0  192    
  318	:  1110_1000  0xE8  232    
  319	:  0000_0000  0x00    0    
  320	:  0000_0001  0x01    1    
  321	:  0000_0000  0x00    0    
  322	:  0000_0001  0x01    1    
  323	:  0000_0000  0x00    0    
  324	:  0000_0000  0x00    0    
  325	:  1110_1110  0xEE  238    
  326	:  0010_0011  0x23   35  #  
  327	:  0000_0000  0x00    0    
  328	:  0000_0100  0x04    4    
  329	:  1100_1100  0xCC  204    
  330	:  0100_1010  0x4A   74  J  
  331	:  0111_0010  0x72  114  r  
  332	:  0000_0001  0x01    1    
  333	:  1100_0000  0xC0  192    
  334	:  1011_0010  0xB2  178    
  335	:  0000_0000  0x00    0    
  336	:  0000_0001  0x01    1    
  337	:  0000_0000  0x00    0    
  338	:  0000_0001  0x01    1    
  339	:  0000_0000  0x00    0    
  340	:  0000_0000  0x00    0    
  341	:  1110_1110  0xEE  238    
  342	:  0010_0011  0x23   35  #  
  343	:  0000_0000  0x00    0    
  344	:  0000_0100  0x04    4    
  345	:  1100_1100  0xCC  204    
  346	:  0100_1010  0x4A   74  J  
  347	:  0111_0011  0x73  115  s  
  348	:  0000_0001  0x01    1    
  349	:  1100_0000  0xC0  192    
  350	:  1001_1110  0x9E  158    
  351	:  0000_0000  0x00    0    
  352	:  0000_0001  0x01    1    
  353	:  0000_0000  0x00    0    
  354	:  0000_0001  0x01    1    
  355	:  0000_0000  0x00    0    
  356	:  0000_0000  0x00    0    
  357	:  1101_1110  0xDE  222    
  358	:  0000_1010  0x0A   10    
  359	:  0000_0000  0x00    0    
  360	:  0000_0100  0x04    4    
  361	:  1100_1100  0xCC  204    
  362	:  0100_0101  0x45   69  E  
  363	:  1110_1010  0xEA  234    
  364	:  0000_0001  0x01    1    
  365	:  1100_0000  0xC0  192    
  366	:  0111_0110  0x76  118  v  
  367	:  0000_0000  0x00    0    
  368	:  0000_0001  0x01    1    
  369	:  0000_0000  0x00    0    
  370	:  0000_0001  0x01    1    
  371	:  0000_0000  0x00    0    
  372	:  0000_0000  0x00    0    
  373	:  1101_1110  0xDE  222    
  374	:  0000_1010  0x0A   10    
  375	:  0000_0000  0x00    0    
  376	:  0000_0100  0x04    4    
  377	:  1100_1100  0xCC  204    
  378	:  0100_1010  0x4A   74  J  
  379	:  0110_0101  0x65  101  e  
  380	:  0000_0001  0x01    1    |;

# ; <<>> dig.pl 1.10 <<>> -d arpa.com
# ;;
# ;; Got answer.
# ;; ->>HEADER<<- opcode: QUERY, status: NOERROR, id: 13234
# ;; flags: qr rd ra; QUERY: 1, ANSWER: 1, AUTHORITY: 8, ADDITIONAL: 8
# 
# ;; QUESTION SECTION:
# ;arpa.com.			IN	A
# 
# ;; ANSWER SECTION:
# arpa.com.		42	IN	A	174.136.104.234 
# 
# ;; AUTHORITY SECTION:
# arpa.com.		86382	IN	NS	pdns4.ultradns.org. 
# arpa.com.		86382	IN	NS	pdns1.ultradns.net. 
# arpa.com.		86382	IN	NS	udns2.ultradns.net. 
# arpa.com.		86382	IN	NS	pdns2.ultradns.net. 
# arpa.com.		86382	IN	NS	udns1.ultradns.net. 
# arpa.com.		86382	IN	NS	pdns6.ultradns.co.uk. 
# arpa.com.		86382	IN	NS	pdns3.ultradns.org. 
# arpa.com.		86382	IN	NS	pdns5.ultradns.info. 
# 
# ;; ADDITIONAL SECTION:
# pdns1.ultradns.net.	1258	IN	A	204.74.108.1 
# pdns2.ultradns.net.	1258	IN	A	204.74.109.1 
# pdns3.ultradns.org.	60963	IN	A	199.7.68.1 
# pdns4.ultradns.org.	74346	IN	A	199.7.69.1 
# pdns5.ultradns.info.	60963	IN	A	204.74.114.1 
# pdns6.ultradns.co.uk.	60963	IN	A	204.74.115.1 
# udns1.ultradns.net.	56842	IN	A	204.69.234.1 
# udns2.ultradns.net.	56842	IN	A	204.74.101.1 
# 
# ;; Query time: 61 ms
# ;; SERVER: 192.168.1.171# 53(192.168.1.171)
# ;; WHEN: Sun Oct  2 15:12:41 2011
# ;; MSG SIZE rcvd: 381 -- XFR size: 18 records
#
 
my $pques1 = q
| 0	:  0011_0011  0x33   51  3  
  1	:  1110_0100  0xE4  228    
  2	:  0000_0001  0x01    1    
  3	:  0000_0000  0x00    0    
  4	:  0000_0000  0x00    0    
  5	:  0000_0001  0x01    1    
  6	:  0000_0000  0x00    0    
  7	:  0000_0000  0x00    0    
  8	:  0000_0000  0x00    0    
  9	:  0000_0000  0x00    0    
  10	:  0000_0000  0x00    0    
  11	:  0000_0000  0x00    0    
  12	:  0000_0011  0x03    3    
  13	:  0011_0010  0x32   50  2  
  14	:  0011_0011  0x33   51  3  
  15	:  0011_0100  0x34   52  4  
  16	:  0000_0011  0x03    3    
  17	:  0011_0001  0x31   49  1  
  18	:  0011_0000  0x30   48  0  
  19	:  0011_0100  0x34   52  4  
  20	:  0000_0011  0x03    3    
  21	:  0011_0001  0x31   49  1  
  22	:  0011_0011  0x33   51  3  
  23	:  0011_0110  0x36   54  6  
  24	:  0000_0011  0x03    3    
  25	:  0011_0001  0x31   49  1  
  26	:  0011_0111  0x37   55  7  
  27	:  0011_0100  0x34   52  4  
  28	:  0000_0111  0x07    7    
  29	:  0110_1001  0x69  105  i  
  30	:  0110_1110  0x6E  110  n  
  31	:  0010_1101  0x2D   45  -  
  32	:  0110_0001  0x61   97  a  
  33	:  0110_0100  0x64  100  d  
  34	:  0110_0100  0x64  100  d  
  35	:  0111_0010  0x72  114  r  
  36	:  0000_0100  0x04    4    
  37	:  0110_0001  0x61   97  a  
  38	:  0111_0010  0x72  114  r  
  39	:  0111_0000  0x70  112  p  
  40	:  0110_0001  0x61   97  a  
  41	:  0000_0000  0x00    0    
  42	:  0000_0000  0x00    0    
  43	:  0000_1100  0x0C   12    
  44	:  0000_0000  0x00    0    
  45	:  0000_0001  0x01    1    |;

my $pans1 = q
| 0	:  0011_0011  0x33   51  3  
  1	:  1110_0100  0xE4  228    
  2	:  1000_0001  0x81  129    
  3	:  1000_0000  0x80  128    
  4	:  0000_0000  0x00    0    
  5	:  0000_0001  0x01    1    
  6	:  0000_0000  0x00    0    
  7	:  0000_0001  0x01    1    
  8	:  0000_0000  0x00    0    
  9	:  0000_0010  0x02    2    
  10	:  0000_0000  0x00    0    
  11	:  0000_0010  0x02    2    
  12	:  0000_0011  0x03    3    
  13	:  0011_0010  0x32   50  2  
  14	:  0011_0011  0x33   51  3  
  15	:  0011_0100  0x34   52  4  
  16	:  0000_0011  0x03    3    
  17	:  0011_0001  0x31   49  1  
  18	:  0011_0000  0x30   48  0  
  19	:  0011_0100  0x34   52  4  
  20	:  0000_0011  0x03    3    
  21	:  0011_0001  0x31   49  1  
  22	:  0011_0011  0x33   51  3  
  23	:  0011_0110  0x36   54  6  
  24	:  0000_0011  0x03    3    
  25	:  0011_0001  0x31   49  1  
  26	:  0011_0111  0x37   55  7  
  27	:  0011_0100  0x34   52  4  
  28	:  0000_0111  0x07    7    
  29	:  0110_1001  0x69  105  i  
  30	:  0110_1110  0x6E  110  n  
  31	:  0010_1101  0x2D   45  -  
  32	:  0110_0001  0x61   97  a  
  33	:  0110_0100  0x64  100  d  
  34	:  0110_0100  0x64  100  d  
  35	:  0111_0010  0x72  114  r  
  36	:  0000_0100  0x04    4    
  37	:  0110_0001  0x61   97  a  
  38	:  0111_0010  0x72  114  r  
  39	:  0111_0000  0x70  112  p  
  40	:  0110_0001  0x61   97  a  
  41	:  0000_0000  0x00    0    
  42	:  0000_0000  0x00    0    
  43	:  0000_1100  0x0C   12    
  44	:  0000_0000  0x00    0    
  45	:  0000_0001  0x01    1    
  46	:  1100_0000  0xC0  192    
  47	:  0000_1100  0x0C   12    
  48	:  0000_0000  0x00    0    
  49	:  0000_1100  0x0C   12    
  50	:  0000_0000  0x00    0    
  51	:  0000_0001  0x01    1    
  52	:  0000_0000  0x00    0    
  53	:  0000_0000  0x00    0    
  54	:  0000_1101  0x0D   13    
  55	:  1110_1010  0xEA  234    
  56	:  0000_0000  0x00    0    
  57	:  0000_1100  0x0C   12    
  58	:  0000_0001  0x01    1    
  59	:  0110_0001  0x61   97  a  
  60	:  0000_0100  0x04    4    
  61	:  0110_0001  0x61   97  a  
  62	:  0111_0010  0x72  114  r  
  63	:  0111_0000  0x70  112  p  
  64	:  0110_0001  0x61   97  a  
  65	:  0000_0011  0x03    3    
  66	:  0110_0011  0x63   99  c  
  67	:  0110_1111  0x6F  111  o  
  68	:  0110_1101  0x6D  109  m  
  69	:  0000_0000  0x00    0    
  70	:  1100_0000  0xC0  192    
  71	:  0001_0000  0x10   16    
  72	:  0000_0000  0x00    0    
  73	:  0000_0010  0x02    2    
  74	:  0000_0000  0x00    0    
  75	:  0000_0001  0x01    1    
  76	:  0000_0000  0x00    0    
  77	:  0000_0000  0x00    0    
  78	:  0000_1101  0x0D   13    
  79	:  1110_1010  0xEA  234    
  80	:  0000_0000  0x00    0    
  81	:  0001_0010  0x12   18    
  82	:  0000_0011  0x03    3    
  83	:  0110_1110  0x6E  110  n  
  84	:  0111_0011  0x73  115  s  
  85	:  0011_0010  0x32   50  2  
  86	:  0000_1011  0x0B   11    
  87	:  0110_0001  0x61   97  a  
  88	:  0111_0010  0x72  114  r  
  89	:  0111_0000  0x70  112  p  
  90	:  0110_1110  0x6E  110  n  
  91	:  0110_0101  0x65  101  e  
  92	:  0111_0100  0x74  116  t  
  93	:  0111_0111  0x77  119  w  
  94	:  0110_1111  0x6F  111  o  
  95	:  0111_0010  0x72  114  r  
  96	:  0110_1011  0x6B  107  k  
  97	:  0111_0011  0x73  115  s  
  98	:  1100_0000  0xC0  192    
  99	:  0100_0001  0x41   65  A  
  100	:  1100_0000  0xC0  192    
  101	:  0001_0000  0x10   16    
  102	:  0000_0000  0x00    0    
  103	:  0000_0010  0x02    2    
  104	:  0000_0000  0x00    0    
  105	:  0000_0001  0x01    1    
  106	:  0000_0000  0x00    0    
  107	:  0000_0000  0x00    0    
  108	:  0000_1101  0x0D   13    
  109	:  1110_1010  0xEA  234    
  110	:  0000_0000  0x00    0    
  111	:  0000_0110  0x06    6    
  112	:  0000_0011  0x03    3    
  113	:  0110_1110  0x6E  110  n  
  114	:  0111_0011  0x73  115  s  
  115	:  0011_0001  0x31   49  1  
  116	:  1100_0000  0xC0  192    
  117	:  0101_0110  0x56   86  V  
  118	:  1100_0000  0xC0  192    
  119	:  0111_0000  0x70  112  p  
  120	:  0000_0000  0x00    0    
  121	:  0000_0001  0x01    1    
  122	:  0000_0000  0x00    0    
  123	:  0000_0001  0x01    1    
  124	:  0000_0000  0x00    0    
  125	:  0000_0000  0x00    0    
  126	:  0000_0001  0x01    1    
  127	:  0000_0110  0x06    6    
  128	:  0000_0000  0x00    0    
  129	:  0000_0100  0x04    4    
  130	:  1101_0000  0xD0  208    
  131	:  0100_1111  0x4F   79  O  
  132	:  0101_1000  0x58   88  X  
  133	:  0000_0111  0x07    7    
  134	:  1100_0000  0xC0  192    
  135	:  0101_0010  0x52   82  R  
  136	:  0000_0000  0x00    0    
  137	:  0000_0001  0x01    1    
  138	:  0000_0000  0x00    0    
  139	:  0000_0001  0x01    1    
  140	:  0000_0000  0x00    0    
  141	:  0000_0000  0x00    0    
  142	:  0000_0001  0x01    1    
  143	:  0000_0110  0x06    6    
  144	:  0000_0000  0x00    0    
  145	:  0000_0100  0x04    4    
  146	:  1101_0000  0xD0  208    
  147	:  0100_1111  0x4F   79  O  
  148	:  0101_1001  0x59   89  Y  
  149	:  0000_1001  0x09    9    |;

my $zans1 = q		# answer count set to zero
| 0	:  0011_0011  0x33   51  3  
  1	:  1110_0100  0xE4  228    
  2	:  1000_0001  0x81  129    
  3	:  1000_0000  0x80  128    
  4	:  0000_0000  0x00    0    
  5	:  0000_0001  0x01    1    
  6	:  0000_0000  0x00    0    
  7	:  0000_0000  0x00    0    
  8	:  0000_0000  0x00    0    
  9	:  0000_0010  0x02    2    
  10	:  0000_0000  0x00    0    
  11	:  0000_0010  0x02    2    
  12	:  0000_0011  0x03    3    
  13	:  0011_0010  0x32   50  2  
  14	:  0011_0011  0x33   51  3  
  15	:  0011_0100  0x34   52  4  
  16	:  0000_0011  0x03    3    
  17	:  0011_0001  0x31   49  1  
  18	:  0011_0000  0x30   48  0  
  19	:  0011_0100  0x34   52  4  
  20	:  0000_0011  0x03    3    
  21	:  0011_0001  0x31   49  1  
  22	:  0011_0011  0x33   51  3  
  23	:  0011_0110  0x36   54  6  
  24	:  0000_0011  0x03    3    
  25	:  0011_0001  0x31   49  1  
  26	:  0011_0111  0x37   55  7  
  27	:  0011_0100  0x34   52  4  
  28	:  0000_0111  0x07    7    
  29	:  0110_1001  0x69  105  i  
  30	:  0110_1110  0x6E  110  n  
  31	:  0010_1101  0x2D   45  -  
  32	:  0110_0001  0x61   97  a  
  33	:  0110_0100  0x64  100  d  
  34	:  0110_0100  0x64  100  d  
  35	:  0111_0010  0x72  114  r  
  36	:  0000_0100  0x04    4    
  37	:  0110_0001  0x61   97  a  
  38	:  0111_0010  0x72  114  r  
  39	:  0111_0000  0x70  112  p  
  40	:  0110_0001  0x61   97  a  
  41	:  0000_0000  0x00    0    
  42	:  0000_0000  0x00    0    
  43	:  0000_1100  0x0C   12    
  44	:  0000_0000  0x00    0    
  45	:  0000_0001  0x01    1    
  46	:  1100_0000  0xC0  192    
  47	:  0000_1100  0x0C   12    
  48	:  0000_0000  0x00    0    
  49	:  0000_1100  0x0C   12    
  50	:  0000_0000  0x00    0    
  51	:  0000_0001  0x01    1    
  52	:  0000_0000  0x00    0    
  53	:  0000_0000  0x00    0    
  54	:  0000_1101  0x0D   13    
  55	:  1110_1010  0xEA  234    
  56	:  0000_0000  0x00    0    
  57	:  0000_1100  0x0C   12    
  58	:  0000_0001  0x01    1    
  59	:  0110_0001  0x61   97  a  
  60	:  0000_0100  0x04    4    
  61	:  0110_0001  0x61   97  a  
  62	:  0111_0010  0x72  114  r  
  63	:  0111_0000  0x70  112  p  
  64	:  0110_0001  0x61   97  a  
  65	:  0000_0011  0x03    3    
  66	:  0110_0011  0x63   99  c  
  67	:  0110_1111  0x6F  111  o  
  68	:  0110_1101  0x6D  109  m  
  69	:  0000_0000  0x00    0    
  70	:  1100_0000  0xC0  192    
  71	:  0001_0000  0x10   16    
  72	:  0000_0000  0x00    0    
  73	:  0000_0010  0x02    2    
  74	:  0000_0000  0x00    0    
  75	:  0000_0001  0x01    1    
  76	:  0000_0000  0x00    0    
  77	:  0000_0000  0x00    0    
  78	:  0000_1101  0x0D   13    
  79	:  1110_1010  0xEA  234    
  80	:  0000_0000  0x00    0    
  81	:  0001_0010  0x12   18    
  82	:  0000_0011  0x03    3    
  83	:  0110_1110  0x6E  110  n  
  84	:  0111_0011  0x73  115  s  
  85	:  0011_0010  0x32   50  2  
  86	:  0000_1011  0x0B   11    
  87	:  0110_0001  0x61   97  a  
  88	:  0111_0010  0x72  114  r  
  89	:  0111_0000  0x70  112  p  
  90	:  0110_1110  0x6E  110  n  
  91	:  0110_0101  0x65  101  e  
  92	:  0111_0100  0x74  116  t  
  93	:  0111_0111  0x77  119  w  
  94	:  0110_1111  0x6F  111  o  
  95	:  0111_0010  0x72  114  r  
  96	:  0110_1011  0x6B  107  k  
  97	:  0111_0011  0x73  115  s  
  98	:  1100_0000  0xC0  192    
  99	:  0100_0001  0x41   65  A  
  100	:  1100_0000  0xC0  192    
  101	:  0001_0000  0x10   16    
  102	:  0000_0000  0x00    0    
  103	:  0000_0010  0x02    2    
  104	:  0000_0000  0x00    0    
  105	:  0000_0001  0x01    1    
  106	:  0000_0000  0x00    0    
  107	:  0000_0000  0x00    0    
  108	:  0000_1101  0x0D   13    
  109	:  1110_1010  0xEA  234    
  110	:  0000_0000  0x00    0    
  111	:  0000_0110  0x06    6    
  112	:  0000_0011  0x03    3    
  113	:  0110_1110  0x6E  110  n  
  114	:  0111_0011  0x73  115  s  
  115	:  0011_0001  0x31   49  1  
  116	:  1100_0000  0xC0  192    
  117	:  0101_0110  0x56   86  V  
  118	:  1100_0000  0xC0  192    
  119	:  0111_0000  0x70  112  p  
  120	:  0000_0000  0x00    0    
  121	:  0000_0001  0x01    1    
  122	:  0000_0000  0x00    0    
  123	:  0000_0001  0x01    1    
  124	:  0000_0000  0x00    0    
  125	:  0000_0000  0x00    0    
  126	:  0000_0001  0x01    1    
  127	:  0000_0110  0x06    6    
  128	:  0000_0000  0x00    0    
  129	:  0000_0100  0x04    4    
  130	:  1101_0000  0xD0  208    
  131	:  0100_1111  0x4F   79  O  
  132	:  0101_1000  0x58   88  X  
  133	:  0000_0111  0x07    7    
  134	:  1100_0000  0xC0  192    
  135	:  0101_0010  0x52   82  R  
  136	:  0000_0000  0x00    0    
  137	:  0000_0001  0x01    1    
  138	:  0000_0000  0x00    0    
  139	:  0000_0001  0x01    1    
  140	:  0000_0000  0x00    0    
  141	:  0000_0000  0x00    0    
  142	:  0000_0001  0x01    1    
  143	:  0000_0110  0x06    6    
  144	:  0000_0000  0x00    0    
  145	:  0000_0100  0x04    4    
  146	:  1101_0000  0xD0  208    
  147	:  0100_1111  0x4F   79  O  
  148	:  0101_1001  0x59   89  Y  
  149	:  0000_1001  0x09    9    |;

# ; <<>> dig.pl 1.10 <<>> -t ptr -d 234.104.136.174.in-addr.arpa
# ;;
# ;; Got answer.
# ;; ->>HEADER<<- opcode: QUERY, status: NOERROR, id: 13284
# ;; flags: qr rd ra; QUERY: 1, ANSWER: 1, AUTHORITY: 2, ADDITIONAL: 2
# 
# ;; QUESTION SECTION:
# ;234.104.136.174.in-addr.arpa.		IN	PTR
# 
# ;; ANSWER SECTION:
# 234.104.136.174.in-addr.arpa.	3562	IN	PTR	a.arpa.com. 
# 
# ;; AUTHORITY SECTION:
# 104.136.174.in-addr.arpa.	3562	IN	NS	ns2.arpnetworks.com. 
# 104.136.174.in-addr.arpa.	3562	IN	NS	ns1.arpnetworks.com. 
# 
# ;; ADDITIONAL SECTION:
# ns1.arpnetworks.com.	262	IN	A	208.79.88.7 
# ns2.arpnetworks.com.	262	IN	A	208.79.89.9 
# 
# ;; Query time: 44 ms
# ;; SERVER: 192.168.1.171# 53(192.168.1.171)
# ;; WHEN: Sun Oct  2 15:26:21 2011
# ;; MSG SIZE rcvd: 150 -- XFR size: 6 records
# 

my $naans1 = makebuf(\$aans1);
my $npans1 = makebuf(\$pans1);
my $nzans1 = makebuf(\$zans1);

my %answers = (
	'bad-name.com'	=> undef,		# 0
	'arpa.com'	=> $naans1,	# 1	A record for arpa.com
	'in-addr.arpa'	=> $npans1,	# 2	PTR record for 234.104.136.174.in-addr.arpa
	'no-name.com'	=> $nzans1,	# 3	zero answer count
);

# dummy question builder for testing, does nothing
my $qn;
sub question {
  $qn = $_[0];
  return undef;
}

# dummy query responder for testing

sub _query {
  my($here,$bp,$ns) = @_;
  return $answers{$ns};
}

*set_NS = \&Net::DNS::Dig::_set_NS;

my $self = { AddrType => &AF_INET };
bless $self;	# needs to point to "this" test package

## test 2	check empty array return from get_host
$! = 0;
set_NS('bad-name.com');
print "unknown buffer pointer returned by _get_host\nnot "
	if get_host($self,'dummy',T_A);
&ok;

## test 3	check that error code is 3
my $err = $! -0;
print "did not return error code 3, got: $err\nnot "
	unless $! == 3;
&ok;

## test 4	check empty array return from get_host for zero anscount
set_NS(qw( bad-name.com no-name.com ));
$! = 0;
print "unknown buffer return from _get_host\nnot "
	if get_host($self,'myname',T_A);
&ok;

## test 5	check error code is 4
$err = $! - 0;
print "did not return error code 4, got: $err\nnot "
	unless $! == 4;
&ok;

## test 6	check A record request
set_NS(qw( bad-name.com arpa.com ) );

my($name,$aliases,$addrtype,$length,@addrs) = get_host($self,'arpa.com',T_A);
my $got = @addrs;
print "got: $got responses, expected 1\nnot "
	if $got != 1;
&ok;

## test 7	check A record value
my $exp = '174.136.104.234';
if ($got == 1) {
  $got = inet_ntoa($addrs[0]);
  print "got: $got, exp: $exp\nnot "
	unless $got eq $exp;
  &ok;
} else {
  print "ok $test	# skipped, previous test failed\n";
  $test++;
}

## test 8	check PTR record value
$self = { AddrType => &AF_INET, NetAddr => $addrs[0] };	# address from test 6
bless $self;    # needs to point to "this" test package
set_NS(qw( bad-name.com in-addr.arpa ));
# NOTE: name field contains netaddr from 174.136.104.234 above
$exp = revIP(inet_ntoa($addrs[0])) .'.in-addr.arpa';		# temporary storage
($name,$aliases,$addrtype,$length,@addrs) = get_host($self,$exp,T_PTR);
$got = @addrs;
print "got: $got responses, expected 1\nnot "
	if $got != 1;
&ok;

#$self->{SERVER} = inet_aton('127.1');
#my $obj = Net::DNS::Dig::to_text($self);
#print Dumper($obj);



## test 9	check for in-addr.arpa name conversion
$exp = '234.104.136.174.in-addr.arpa';
print "got: $qn, exp: $exp\nnot "
	unless $qn eq $exp;
&ok;


## test 10	check ptr record name value
$exp = 'a.arpa.com';
if ($got == 1) {
  $got = $name;
  print "got: $got, exp: $exp\nnot "
	unless $got eq $exp;
  &ok;
} else {
  print "ok $test	# skipped, previous test failed\n";
  $test++;
}

## test 11	check ptr record netaddr value
$exp = '174.136.104.234';
$got = inet_ntoa($addrs[0]);
if ($got) {
  print "got: $got, exp: $exp\nnot "
	unless $got eq $exp;
} else {
  print "not a netaddr\nnot ";
}
&ok;

## test 12	ans = 0, AA = 0 rcode = NXDOMAIN
set_NS(qw( bad-name.com no-name.com ));
my $flags = getflags($nzans1);
$flags |= &NXDOMAIN;
putflags($nzans1,$flags);
$! = 0;
print "unknown buffer return from _get_host\nnot "
	if get_host($self,'myname',T_A);
&ok;

## test 13	check error code is 4
$err = $! - 0;
print "did not return error code 4, got: $err\nnot "
	unless $! == 2;
&ok;

## test 14	ans = 0, AA = 1 rcode = NXDOMAIN
$flags = getflags($nzans1);
$flags |= &AA;
putflags($nzans1,$flags);
$! = 0;
print "unknown buffer return from _get_host\nnot "
	if get_host($self,'myname',T_A);
&ok;

## test 15	validate AA bit
print "failed to set AA\nnot "
	unless $self->{HEADER}->{AA};
&ok;


## test 16	check error code is 1
$err = $! - 0;
print "did not return error code 1, got: $err\nnot "
	unless $! == 1;
&ok;

## test 17	ans = 0, AA = 0 rcode = NOERROR
$flags = getflags($nzans1);
$flags &= &RCODE_MASK;
$flags ^= &AA;
putflags($nzans1,$flags);
$! = 0;
print "unknown buffer return from _get_host\nnot "
	if get_host($self,'myname',T_A);
&ok;

## test 18	validate AA bit
print "failed to clear AA\nnot "
	if $self->{HEADER}->{AA};
&ok;

## test 19	check error code is 4
$err = $! - 0;
print "did not return error code 4, got: $err\nnot "
	unless $! == 4;
&ok;

## test 20	ans = 0, AA = 1 rcode = NOERROR
$flags = getflags($nzans1);
$flags |= &AA;
putflags($nzans1,$flags);
$! = 0;
print "unknown buffer return from _get_host\nnot "
	if get_host($self,'myname',T_A);
&ok;

## test 21	check error code is 1
$err = $! - 0;
print "did not return error code 1, got: $err\nnot "
	unless $! == 1;
&ok;

## test 22	ans = 0, AA = 1 rcode = SERVFAIL
$flags = getflags($nzans1);
$flags |= &SERVFAIL;
putflags($nzans1,$flags);
$! = 0;
print "unknown buffer return from _get_host\nnot "
	if get_host($self,'myname',T_A);
&ok;

## test 23	check error code is 2
$err = $! - 0;
print "did not return error code 2, got: $err\nnot "
	unless $! == 2;
&ok;

## test 24	ans = 0, AA = 1 rcode = NOTIMP
$flags = getflags($nzans1);
$flags &= &RCODE_MASK;
$flags |= &NOTIMP;
putflags($nzans1,$flags);
$! = 0;
print "unknown buffer return from _get_host\nnot "
	if get_host($self,'myname',T_A);
&ok;

## test 25	check error code is 3
$err = $! - 0;
print "did not return error code 3, got: $err\nnot "
	unless $! == 3;
&ok;

