#!/usr/bin/perl

use Test;
use Math::Business::ParabolicSAR;
use Data::Dumper;

my $sar = recommended Math::Business::ParabolicSAR;
my $ohlc = [
  ["34.6400", "35.0000", "34.2100", "34.7400"],
  ["34.6900", "35.1400", "34.3800", "34.7900"],
  ["35.2900", "35.7900", "35.0800", "35.5200"],
  ["35.9000", "36.0600", "35.7500", "36.0600"],
  ["36.1300", "36.7200", "36.0500", "36.5800"],
  ["36.4100", "36.6400", "36.2600", "36.6100"],
  ["36.3500", 37, 37,               "35.9700"],
  ["36.1000", 37, 37,               "36.1200"],
  ["35.9000", "35.9900", "35.5200", "35.6000"],
  ["35.7900", "35.9600", "35.0000", "35.2200"],
  ["35.2200", "35.6500", "34.8600", "35.3700"],
  ["35.1900", "35.2000", "34.0900", "34.3800"],
];

plan tests => int @$ohlc;

for my $row (@$ohlc) {
    my $v = eval { $sar->insert( $row ) };
    ok($@, "");
}
