#!perl
use strict;
use warnings;

use Math::Int64 qw( hex_to_uint64 );
use Math::Int64::native_if_available;
use Test::More;

BEGIN {
    use_ok(
        'Digest::xxHash64', qw( xxhash64 xxhash64_hex xxhash32 xxhash32_hex)
    );
}

my @tests = (
    [ sub { goto &xxhash32 }, 'xxhash32' ],
    [ sub { goto &xxhash32_hex }, 'xxhash32_hex' ],
    [ sub { goto &xxhash64 }, 'xxhash64' ],
    [ sub { goto &xxhash64_hex }, 'xxhash64_hex' ],
);

my @cases = (
    {
        input => "\0\0\0\0",
        seed => 0,
        results => [
            0x08d6d969,
            '08d6d969',
            hex_to_uint64('3aefa6fd5cf2deb4'),
            '3aefa6fd5cf2deb4',
        ],
    },
    {
        input => join('', 'a' .. 'z'),
        seed => 0,
        results => [
            0x63a14d5f,
            '63a14d5f',
            hex_to_uint64( "cfe1f278fa89835c" ),
            "cfe1f278fa89835c",
        ],
    },
);

for my $case ( @cases ) {
    for my $i ( 0 .. $#tests ) {
        my $test = $tests[$i][0];
        my $label = $tests[$i][1];
        my $input = $case->{input};
        my $seed = $case->{seed};

        is(
            $test->($input, $seed),
            $case->{results}[$i],
            "$label( $input, $seed) ",
        );
    }
}

# Taken from Digest::xxHash

my $input1 = join '',
    map chr(hex),
    qw(
        b8 1e 85 eb 51 b8 9e 3f b8 1e 85 eb 51 b8 9e 3f
        b8 1e 85 eb 51 b8 9e 3f b8 1e 85 eb 51 b8 9e 3f
        b8 1e 85 eb 51 b8 9e 3f 00 00 00 00 00 00 00 00
        50 c3 00 00 00 00 00 00 20 13 08 12 65 e3 6a c0
    )
;

my $input2 = join '',
    map chr(hex),
    qw(
        d7 a3 70 3d 0a 57 21 40 9a 99 99 99 99 99 21 40
        a4 70 3d 0a d7 23 21 40 14 ae 47 e1 7a 94 21 40
        14 ae 47 e1 7a 94 21 40 00 00 00 00 00 00 00 00
        d8 3c 09 00 00 00 00 00 20 13 08 13 a9 f1 e2 2a
    )
;

ok(
    xxhash32($input1, 0x5262) == xxhash32($input2, 0x5262),
    "Known collision",
);

done_testing;

