#!/usr/bin/perl

use strict;
use lib 't/lib';

use Test::More;
use Test::Deep qw(cmp_deeply);
use XML::TreePP;

use FusionInventory::Agent::SNMP::Mock;
use FusionInventory::Agent::Task::NetDiscovery::Dictionary;
use FusionInventory::Agent::Tools::Hardware;

my %tests = (
    'alcatel/unknown.1.walk' => [
        {
            MANUFACTURER => 'Alcatel-Lucent',
            TYPE         => 'NETWORKING',
            DESCRIPTION  => 'Alcatel-Lucent 6.4.4.342.R01 GA, April 18, 2011.',
            SNMPHOSTNAME => 'CB-C005-127-os6400',
            MAC          => 'e8:e7:32:2b:c1:e2',
        },
        {
            MANUFACTURER => 'Alcatel-Lucent',
            TYPE         => 'NETWORKING',
            DESCRIPTION  => 'Alcatel-Lucent 6.4.4.342.R01 GA, April 18, 2011.',
            SNMPHOSTNAME => 'CB-C005-127-os6400',
            MAC          => 'e8:e7:32:2b:c1:e2',
            MODELSNMP    => 'Networking2189',
            FIRMWARE     => undef,
            SERIAL       => 'M4682816',
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Alcatel-Lucent',
                TYPE         => 'NETWORKING',
                MODEL        => 'OS6400-P24',
                COMMENTS     => 'Alcatel-Lucent 6.4.4.342.R01 GA, April 18, 2011.',
                CONTACT      => 'Alcatel-Lucent, http://alcatel-lucent.com/wps/portal/enterprise',
                NAME         => 'CB-C005-127-os6400',
                LOCATION     => 'Unknown',
                SERIAL       => 'M4682816',
                IPS          => {
                    IP => [
                        '127.0.0.1',
                        '192.168.1.127',
                    ],
                },
                MAC          => 'e8:e7:32:2b:c1:e2',
                UPTIME       => '(1442631100) 166 days, 23:18:31.00',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1001',
                        IFNAME           => '1/1',
                        IFDESCR          => 'Alcatel-Lucent 1/1',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '9216',
                        MAC              => 'e8:e7:32:2b:c1:e4',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(7100) 0:01:11.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1002',
                        IFNAME           => '1/2',
                        IFDESCR          => 'Alcatel-Lucent 1/2',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '9216',
                        MAC              => 'e8:e7:32:2b:c1:e5',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(7100) 0:01:11.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1003',
                        IFNAME           => '1/3',
                        IFDESCR          => 'Alcatel-Lucent 1/3',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '9216',
                        MAC              => 'e8:e7:32:2b:c1:e6',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(7100) 0:01:11.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1004',
                        IFNAME           => '1/4',
                        IFDESCR          => 'Alcatel-Lucent 1/4',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '9216',
                        MAC              => 'e8:e7:32:2b:c1:e7',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(7100) 0:01:11.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1005',
                        IFNAME           => '1/5',
                        IFDESCR          => 'Alcatel-Lucent 1/5',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '9216',
                        MAC              => 'e8:e7:32:2b:c1:e8',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(7100) 0:01:11.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1006',
                        IFNAME           => '1/6',
                        IFDESCR          => 'Alcatel-Lucent 1/6',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '9216',
                        MAC              => 'e8:e7:32:2b:c1:e9',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(7100) 0:01:11.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1007',
                        IFNAME           => '1/7',
                        IFDESCR          => 'Alcatel-Lucent 1/7',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '9216',
                        MAC              => 'e8:e7:32:2b:c1:ea',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(7100) 0:01:11.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1008',
                        IFNAME           => '1/8',
                        IFDESCR          => 'Alcatel-Lucent 1/8',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '9216',
                        MAC              => 'e8:e7:32:2b:c1:eb',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(7100) 0:01:11.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1009',
                        IFNAME           => '1/9',
                        IFDESCR          => 'Alcatel-Lucent 1/9',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '9216',
                        MAC              => 'e8:e7:32:2b:c1:ec',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(7100) 0:01:11.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1010',
                        IFNAME           => '1/10',
                        IFDESCR          => 'Alcatel-Lucent 1/10',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '9216',
                        MAC              => 'e8:e7:32:2b:c1:ed',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(7100) 0:01:11.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1011',
                        IFNAME           => '1/11',
                        IFDESCR          => 'Alcatel-Lucent 1/11',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '9216',
                        MAC              => 'e8:e7:32:2b:c1:ee',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(7100) 0:01:11.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1012',
                        IFNAME           => '1/12',
                        IFDESCR          => 'Alcatel-Lucent 1/12',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '9216',
                        MAC              => 'e8:e7:32:2b:c1:ef',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(7100) 0:01:11.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1013',
                        IFNAME           => '1/13',
                        IFDESCR          => 'Alcatel-Lucent 1/13',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '9216',
                        MAC              => 'e8:e7:32:2b:c1:f0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(7100) 0:01:11.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1014',
                        IFNAME           => '1/14',
                        IFDESCR          => 'Alcatel-Lucent 1/14',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '9216',
                        MAC              => 'e8:e7:32:2b:c1:f1',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(7100) 0:01:11.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1015',
                        IFNAME           => '1/15',
                        IFDESCR          => 'Alcatel-Lucent 1/15',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '9216',
                        MAC              => 'e8:e7:32:2b:c1:f2',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(7100) 0:01:11.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1016',
                        IFNAME           => '1/16',
                        IFDESCR          => 'Alcatel-Lucent 1/16',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '9216',
                        MAC              => 'e8:e7:32:2b:c1:f3',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(7100) 0:01:11.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1017',
                        IFNAME           => '1/17',
                        IFDESCR          => 'Alcatel-Lucent 1/17',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '9216',
                        MAC              => 'e8:e7:32:2b:c1:f4',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(7100) 0:01:11.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1018',
                        IFNAME           => '1/18',
                        IFDESCR          => 'Alcatel-Lucent 1/18',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '9216',
                        MAC              => 'e8:e7:32:2b:c1:f5',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(7100) 0:01:11.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1019',
                        IFNAME           => '1/19',
                        IFDESCR          => 'Alcatel-Lucent 1/19',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '9216',
                        MAC              => 'e8:e7:32:2b:c1:f6',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(7100) 0:01:11.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1020',
                        IFNAME           => '1/20',
                        IFDESCR          => 'Alcatel-Lucent 1/20',
                        IFALIAS          => 'wifi-RDC-ascenseur-203',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '9216',
                        MAC              => 'e8:e7:32:2b:c1:f7',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1009388000) 116 days, 19:51:20.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '2695194882',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1462639524',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '00:16:6f:47:52:f9',
                                    '00:25:4b:71:76:ec',
                                    '10:93:e9:0f:d7:cc',
                                    'c4:85:08:3c:04:b0',
                                    '14:10:9f:d1:9a:db',
                                    'd8:24:bd:e8:79:20',
                                    'f0:b4:79:15:a4:03',
                                    '28:94:0f:d6:bd:94',
                                    '4c:0f:6e:fe:e9:78',
                                    '54:26:96:09:33:a4',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '1021',
                        IFNAME           => '1/21',
                        IFDESCR          => 'Alcatel-Lucent 1/21',
                        IFALIAS          => 'wifi-c005-espaceOne-205',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '9216',
                        MAC              => 'e8:e7:32:2b:c1:f8',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1441734300) 166 days, 20:49:03.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '2824635082',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '464602515',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '98:0c:82:c9:d4:70',
                                    'd8:24:bd:b4:92:c0',
                                    '28:94:0f:c1:1c:3b',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '1022',
                        IFNAME           => '1/22',
                        IFDESCR          => 'Alcatel-Lucent 1/22',
                        IFALIAS          => 'wifi-rdc-acceuil-47',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '9216',
                        MAC              => 'e8:e7:32:2b:c1:f9',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(492727000) 57 days, 0:41:10.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1952393561',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '211370716',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '0c:ee:e6:b0:86:7a',
                                    '7c:d1:c3:f7:d7:c3',
                                    '98:b8:e3:66:fd:2c',
                                    'd8:24:bd:b4:92:b0',
                                    'dc:85:de:69:44:24',
                                    '28:94:0f:c1:1d:89',
                                    '28:cf:da:48:1f:4b',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '1023',
                        IFNAME           => '1/23',
                        IFDESCR          => 'Alcatel-Lucent 1/23',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '9216',
                        MAC              => 'e8:e7:32:2b:c1:fa',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(7100) 0:01:11.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1024',
                        IFNAME           => '1/24',
                        IFDESCR          => 'Alcatel-Lucent 1/24',
                        IFALIAS          => 'CB-C005-202',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '9216',
                        MAC              => 'e8:e7:32:2b:c1:fb',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(128821500) 14 days, 21:50:15.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '826699557',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3448622558',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '00:00:5e:00:01:02',
                                    '00:0b:5f:cc:d8:80',
                                    '00:0b:5f:cc:d8:81',
                                    '00:80:9f:af:b1:10',
                                    '00:80:9f:af:b1:11',
                                    '00:80:9f:af:b1:15',
                                    '00:80:9f:af:b1:1b',
                                    '00:80:9f:af:b1:2e',
                                    '00:80:9f:af:b1:32',
                                    '00:80:9f:b3:aa:8d',
                                    '00:80:9f:b3:aa:8e',
                                    '00:80:9f:b3:aa:8f',
                                    '00:80:9f:b3:aa:93',
                                    '00:80:9f:b3:aa:95',
                                    '00:80:9f:b3:aa:96',
                                    '00:80:9f:b3:aa:99',
                                    '00:80:9f:b3:aa:9c',
                                    '00:80:9f:b3:aa:9d',
                                    '00:80:9f:b3:aa:a1',
                                    '00:80:9f:b3:aa:a2',
                                    '00:80:9f:b3:aa:a6',
                                    '00:80:9f:b3:aa:a8',
                                    '00:80:9f:b3:ad:51',
                                    '00:80:9f:b3:ad:5c',
                                    '00:80:9f:ba:8b:d2',
                                    '00:80:9f:ba:8d:90',
                                    '00:80:9f:ba:8d:91',
                                    '00:80:9f:ba:8d:d4',
                                    '00:80:9f:ba:8d:d5',
                                    '00:0d:bc:bd:66:d8',
                                    '00:88:65:a9:b5:e3',
                                    '00:13:5f:fa:ed:70',
                                    '00:13:5f:fa:ed:f0',
                                    '00:13:5f:fa:ed:20',
                                    '00:13:5f:fa:ee:90',
                                    '00:13:5f:fa:ee:f0',
                                    '00:13:5f:fa:ee:20',
                                    '00:13:5f:fa:ee:50',
                                    '00:13:5f:fa:ef:90',
                                    '00:13:5f:fa:f0:80',
                                    '00:13:5f:fa:f1:90',
                                    '00:13:5f:fa:f1:a0',
                                    '00:13:5f:fa:f1:30',
                                    '00:13:5f:fa:f2:00',
                                    '00:13:5f:fa:f2:a0',
                                    '00:13:5f:fa:f2:50',
                                    '00:13:5f:fa:f3:20',
                                    '00:13:5f:fa:f4:80',
                                    '00:13:5f:fa:f4:d0',
                                    '00:13:5f:fa:f5:70',
                                    '00:13:5f:fa:f6:c0',
                                    '00:13:5f:fa:f7:20',
                                    '00:13:5f:fa:f8:50',
                                    '00:13:5f:fa:f9:a0',
                                    '00:13:5f:fa:f9:b0',
                                    '00:13:5f:fa:f9:e0',
                                    '00:13:5f:fa:fa:50',
                                    '00:13:5f:fa:fa:60',
                                    '00:13:5f:fa:fb:80',
                                    '00:13:5f:fa:fb:b0',
                                    '00:13:5f:fa:fb:60',
                                    '00:13:5f:fa:fc:80',
                                    '00:13:5f:fa:fc:d0',
                                    '00:14:6a:d6:b1:76',
                                    '00:14:6a:d6:b1:94',
                                    '00:14:6a:d6:b1:aa',
                                    '00:14:6a:d6:b1:b6',
                                    '00:14:6a:d6:b1:b8',
                                    '00:14:6a:d6:b1:c4',
                                    '00:14:6a:d6:b1:ce',
                                    '00:14:6a:d6:b1:d8',
                                    '00:14:6a:d6:b1:e8',
                                    '00:14:6a:d6:b1:28',
                                    '00:14:6a:d6:b1:32',
                                    '00:14:6a:d6:b1:42',
                                    '00:14:6a:d6:b1:48',
                                    '00:14:6a:d6:b1:4e',
                                    '00:14:6a:d6:b1:56',
                                    '00:14:6a:d6:b1:62',
                                    '00:14:6a:d6:b2:68',
                                    '00:14:6a:d6:b2:8e',
                                    '00:14:6a:d6:b2:b8',
                                    '00:14:6a:d6:b2:ba',
                                    '00:14:6a:d6:b2:c0',
                                    '00:14:6a:d6:b2:14',
                                    '00:14:6a:d6:b2:ce',
                                    '00:14:6a:d6:b2:d0',
                                    '00:14:6a:d6:b2:f0',
                                    '00:14:6a:d6:b2:f4',
                                    '00:14:6a:d6:b2:fa',
                                    '00:14:6a:d6:b2:1e',
                                    '00:14:6a:d6:b2:32',
                                    '00:14:6a:d6:b2:5c',
                                    '00:14:6a:d6:b3:14',
                                    '00:14:6a:d6:b3:1e',
                                    '00:d0:95:17:51:a3',
                                    '00:d0:95:3e:96:83',
                                    '00:15:af:b4:88:3a',
                                    '00:15:f2:d5:b3:f6',
                                    '00:16:d4:50:f1:ff',
                                    '00:16:ea:28:ef:7c',
                                    '00:17:c4:65:e1:cb',
                                    '00:17:c4:ae:c8:b8',
                                    '00:18:de:e1:43:bf',
                                    '00:f4:b9:53:b7:a2',
                                    '00:19:d1:92:0c:4c',
                                    '00:1b:77:df:5d:e1',
                                    '00:1b:77:49:52:59',
                                    '00:1b:a9:a2:a8:8e',
                                    '00:1b:b1:a0:48:b8',
                                    '00:1b:b1:a6:13:a2',
                                    '00:1b:b1:4a:51:47',
                                    '00:1b:b1:4c:10:34',
                                    '00:1b:63:cb:45:98',
                                    '00:1c:b3:bc:b5:f0',
                                    '00:1c:b3:c4:7e:68',
                                    '00:1c:bf:b3:31:73',
                                    '00:1c:c0:d8:8d:7f',
                                    '00:1e:64:0a:41:ae',
                                    '00:1e:64:35:1c:38',
                                    '00:1e:64:3c:e3:80',
                                    '00:1e:65:eb:75:c0',
                                    '00:1e:65:2c:6c:aa',
                                    '00:1e:c2:ae:f4:c5',
                                    '00:1e:c2:c4:92:49',
                                    '00:1e:4c:13:ce:44',
                                    '00:1e:52:6f:aa:33',
                                    '00:1e:52:c8:8f:81',
                                    '00:1f:3c:a5:cc:ef',
                                    '00:1f:3c:e1:9a:87',
                                    '00:1f:5b:c1:0e:17',
                                    '00:1f:5b:d7:41:1f',
                                    '00:20:a6:49:7e:d7',
                                    '00:20:a6:49:7e:da',
                                    '00:20:a6:49:7e:f8',
                                    '00:20:a6:49:7e:fb',
                                    '00:20:a6:49:7f:04',
                                    '00:20:a6:49:7f:07',
                                    '00:21:00:30:65:1c',
                                    '00:21:6a:0f:10:68',
                                    '00:21:6a:b6:86:96',
                                    '00:21:6b:c7:95:50',
                                    '00:21:6b:31:e5:88',
                                    '00:21:e9:db:c8:5c',
                                    '00:21:5d:ac:05:c0',
                                    '00:21:5d:08:76:58',
                                    '00:22:fa:31:cd:40',
                                    '00:22:fb:60:9a:40',
                                    '00:22:41:86:60:d7',
                                    '00:22:41:f6:e1:0f',
                                    '00:22:41:28:17:55',
                                    '00:22:43:70:ac:5f',
                                    '00:22:43:25:f8:02',
                                    '00:22:4d:47:f6:65',
                                    '00:22:5f:36:13:a2',
                                    '00:23:6c:7a:2d:67',
                                    '00:23:6c:82:7a:e6',
                                    '00:23:6c:85:b9:61',
                                    '00:23:6c:89:6f:5e',
                                    '00:23:6c:8a:00:b0',
                                    '00:23:6c:8a:56:09',
                                    '00:23:6c:8b:88:6c',
                                    '00:23:6c:8b:1c:a2',
                                    '00:23:6c:94:c6:40',
                                    '00:23:6c:99:48:86',
                                    '00:23:6c:09:bb:50',
                                    '00:23:12:0d:33:dc',
                                    '00:23:12:02:dc:d6',
                                    '00:23:12:57:99:6e',
                                    '00:23:14:1b:a7:d0',
                                    '00:23:14:3e:a1:2c',
                                    '00:23:14:56:47:d8',
                                    '00:23:4d:4f:93:97',
                                    '00:23:4e:d7:2a:75',
                                    '00:23:08:a4:e8:ec',
                                    '00:24:be:b6:4c:20',
                                    '00:24:d6:0a:d1:94',
                                    '00:24:d6:98:03:5a',
                                    '00:24:d6:06:e2:64',
                                    '00:25:00:37:19:e8',
                                    '00:25:00:3d:c4:72',
                                    '00:25:00:3f:7c:c5',
                                    '00:25:00:3f:1d:f0',
                                    '00:25:00:46:71:2c',
                                    '00:25:00:4f:12:88',
                                    '00:25:d3:79:55:24',
                                    '00:25:d3:87:4f:af',
                                    '00:25:d3:d4:3e:20',
                                    '00:25:d3:d4:52:d1',
                                    '00:25:d3:3f:65:6b',
                                    '00:25:d3:45:a2:e3',
                                    '00:25:d3:45:a7:ec',
                                    '00:25:d3:5f:26:09',
                                    '00:25:4b:85:a6:4f',
                                    '00:25:4b:8f:61:cb',
                                    '00:25:4b:92:ca:a1',
                                    '00:26:82:73:62:85',
                                    '00:26:82:86:b0:c7',
                                    '00:26:82:a0:97:b6',
                                    '00:26:b0:be:84:a0',
                                    '00:26:b0:f1:25:3e',
                                    '00:26:b0:1f:07:4f',
                                    '00:26:b6:66:e9:d5',
                                    '00:26:b6:84:64:ab',
                                    '00:26:b6:97:d1:99',
                                    '00:26:b6:c3:a6:c5',
                                    '00:26:bb:10:3a:02',
                                    '00:26:bb:15:dd:9f',
                                    '00:26:bb:18:80:63',
                                    '00:26:bb:18:b3:2b',
                                    '00:26:bb:1b:ad:65',
                                    '00:26:bb:03:a5:36',
                                    '00:26:c7:a7:38:9a',
                                    '00:26:c7:b2:ed:f0',
                                    '00:26:c7:c1:70:1e',
                                    '00:26:4d:43:92:01',
                                    '00:26:4d:59:b3:5c',
                                    '00:26:08:e6:73:9a',
                                    '00:26:08:e6:9d:2d',
                                    '00:26:08:e7:21:bf',
                                    '00:26:08:e7:24:c3',
                                    '00:26:08:e7:38:0b',
                                    '00:26:08:ec:e3:96',
                                    '00:26:08:f5:87:fb',
                                    '00:26:08:f7:ba:9e',
                                    '00:26:08:f7:21:3f',
                                    '00:26:5e:f7:45:0e',
                                    '00:26:5e:37:43:99',
                                    '00:27:10:f2:a3:18',
                                    '00:27:10:42:50:14',
                                    '00:07:e9:06:a6:be',
                                    '00:08:ca:9c:cd:84',
                                    '00:08:ca:9e:57:e1',
                                    '00:08:ca:e6:b3:26',
                                    '00:08:ca:e7:2f:6b',
                                    '00:08:ca:21:42:9d',
                                    '00:08:ca:43:cf:1b',
                                    '00:08:ca:46:9b:a1',
                                    '00:50:56:b7:2c:4e',
                                    '00:09:3d:00:73:29',
                                    '00:09:43:08:ea:d8',
                                    '64:a3:cb:bf:57:f0',
                                    '64:b9:e8:1a:cc:0d',
                                    '64:b9:e8:08:75:6d',
                                    '68:96:7b:30:09:60',
                                    '68:a3:c4:85:93:fc',
                                    '68:a3:c4:db:f2:5e',
                                    '68:a3:c4:dd:e6:21',
                                    '68:a3:c4:e2:5e:03',
                                    '68:a3:c4:25:2f:4d',
                                    '68:a3:c4:32:76:c6',
                                    '68:a3:c4:37:e4:6a',
                                    '68:a8:6d:0c:e4:12',
                                    '68:a8:6d:10:ea:2e',
                                    '68:a8:6d:25:c9:0c',
                                    '68:a8:6d:04:a4:5e',
                                    '68:a8:6d:2a:55:cc',
                                    '68:a8:6d:37:c5:d8',
                                    '68:a8:6d:37:37:f2',
                                    '68:a8:6d:42:20:3c',
                                    '68:a8:6d:42:5e:84',
                                    '68:a8:6d:45:c1:1e',
                                    '68:a8:6d:45:1f:2a',
                                    '68:a8:6d:4a:f8:a0',
                                    '68:a8:6d:56:12:22',
                                    '68:09:27:f1:c9:b9',
                                    '70:d4:f2:a1:27:d7',
                                    '70:de:e2:88:51:43',
                                    '70:f1:a1:89:2a:2b',
                                    '70:f1:a1:da:a6:9e',
                                    '70:f1:a1:16:56:86',
                                    '70:f1:a1:ed:42:b7',
                                    '70:f3:95:b5:4c:e4',
                                    '70:f3:95:36:76:93',
                                    '70:1a:04:ef:cd:f4',
                                    '70:1a:04:34:27:90',
                                    '70:1a:04:36:f0:b2',
                                    '70:56:81:88:75:19',
                                    '70:56:81:89:b9:17',
                                    '70:56:81:8d:ca:91',
                                    '70:56:81:8f:79:69',
                                    '70:56:81:92:9e:31',
                                    '70:56:81:9c:a2:85',
                                    '70:56:81:9c:e7:d9',
                                    '70:56:81:9c:ef:ef',
                                    '70:56:81:9d:15:39',
                                    '70:56:81:aa:68:11',
                                    '70:56:81:aa:bf:85',
                                    '70:56:81:ac:22:8b',
                                    '70:56:81:ac:33:81',
                                    '70:56:81:b6:2e:8d',
                                    '70:56:81:b8:55:93',
                                    '74:de:2b:69:96:ff',
                                    '74:de:2b:9d:1c:45',
                                    '74:de:2b:c4:ea:49',
                                    '74:de:2b:17:35:b6',
                                    '74:de:2b:f3:5c:74',
                                    '74:de:2b:25:dd:18',
                                    '74:e2:f5:c0:bc:72',
                                    '74:e2:f5:04:09:4e',
                                    '74:e5:43:a4:1a:43',
                                    '74:e5:43:a4:04:c6',
                                    '74:e5:43:11:63:e6',
                                    '74:e5:43:bb:6b:70',
                                    '74:e5:43:08:6c:20',
                                    '74:f0:6d:8b:d9:d9',
                                    '74:f0:6d:0e:09:1e',
                                    '74:f0:6d:22:ae:2e',
                                    '74:f0:6d:30:05:d2',
                                    '74:f0:6d:50:ce:ce',
                                    '74:f0:6d:53:3f:c2',
                                    '74:f0:6d:55:ad:68',
                                    '74:f0:6d:09:69:1b',
                                    '74:2f:68:8a:3a:33',
                                    '74:2f:68:8c:33:9f',
                                    '74:2f:68:a5:6f:d4',
                                    '74:2f:68:cc:b5:06',
                                    '74:2f:68:cd:75:49',
                                    '74:2f:68:30:de:80',
                                    '74:2f:68:31:5a:c5',
                                    '74:2f:68:32:a3:59',
                                    '74:2f:68:33:dd:f7',
                                    '74:2f:68:33:eb:50',
                                    '74:2f:68:4b:11:49',
                                    '0c:74:c2:0e:7a:9f',
                                    '0c:74:c2:90:f5:28',
                                    '0c:74:c2:4f:7c:34',
                                    '0c:77:1a:1f:d9:78',
                                    '0c:d2:92:03:0d:7c',
                                    '0c:d2:92:03:da:6d',
                                    '0c:ee:e6:bf:51:76',
                                    '0c:ee:e6:fe:4f:18',
                                    '0c:60:76:44:92:09',
                                    '0c:60:76:59:62:d0',
                                    '78:6c:1c:bd:e1:f4',
                                    '78:92:9c:29:8f:62',
                                    '78:92:9c:06:fd:a2',
                                    '78:ca:39:a4:e8:4d',
                                    '78:ca:39:ae:65:df',
                                    '78:ca:39:ae:9e:d0',
                                    '78:ca:39:b0:1f:f1',
                                    '78:ca:39:b1:19:54',
                                    '78:ca:39:b1:34:d9',
                                    '78:ca:39:b3:f3:79',
                                    '78:ca:39:b8:3d:cb',
                                    '78:ca:39:b8:5c:e1',
                                    '78:ca:39:b9:cc:16',
                                    '78:ca:39:b9:d0:d2',
                                    '78:ca:39:ba:57:d3',
                                    '78:ca:39:bb:24:e3',
                                    '78:ca:39:bc:d1:44',
                                    '78:ca:39:bd:55:20',
                                    '78:ca:39:be:3d:5b',
                                    '78:ca:39:34:b2:b6',
                                    '78:ca:39:40:f7:96',
                                    '78:dd:08:d4:b1:d2',
                                    '78:dd:08:e1:36:9d',
                                    '78:dd:08:f6:36:47',
                                    '78:e4:00:88:41:6d',
                                    '78:e4:00:91:82:d4',
                                    '78:e4:00:04:a9:7f',
                                    '7c:11:be:b2:42:08',
                                    '7c:c3:a1:0b:ad:eb',
                                    '7c:c5:37:92:85:85',
                                    '7c:c5:37:bf:34:60',
                                    '7c:c5:37:07:1b:a7',
                                    '7c:d1:c3:6c:be:9a',
                                    '7c:d1:c3:70:ef:8e',
                                    '7c:d1:c3:75:a7:84',
                                    '7c:d1:c3:83:52:6c',
                                    '7c:d1:c3:89:ae:f2',
                                    '7c:d1:c3:95:46:b6',
                                    '7c:d1:c3:98:70:e2',
                                    '7c:d1:c3:99:00:42',
                                    '7c:d1:c3:9a:80:60',
                                    '7c:d1:c3:9a:84:7a',
                                    '7c:d1:c3:9c:3f:24',
                                    '7c:d1:c3:eb:e0:cd',
                                    '7c:d1:c3:ec:1a:cb',
                                    '7c:d1:c3:ec:09:ff',
                                    '7c:d1:c3:f1:bc:35',
                                    '7c:d1:c3:f4:e7:89',
                                    '7c:d1:c3:f5:17:51',
                                    '7c:d1:c3:f6:dc:15',
                                    '7c:e9:d3:6d:8c:d2',
                                    '7c:61:93:f5:37:96',
                                    '80:60:07:78:5a:21',
                                    '80:60:07:dc:f3:c9',
                                    '84:00:d2:bc:d3:1a',
                                    '84:85:06:77:86:fc',
                                    '84:85:06:18:68:9e',
                                    '84:a6:c8:0d:d4:f5',
                                    '84:a6:c8:5d:b1:e1',
                                    '84:29:99:79:ad:8d',
                                    '84:29:99:54:32:c6',
                                    '84:4b:f5:c2:6e:59',
                                    '84:4b:f5:ca:b4:7d',
                                    '84:4b:f5:26:b7:86',
                                    '84:4b:f5:4c:34:8b',
                                    '84:4b:f5:54:9f:03',
                                    '88:9f:fa:69:d8:51',
                                    '88:9f:fa:03:fa:4c',
                                    '88:9f:fa:28:92:ae',
                                    '88:53:2e:b2:e0:6c',
                                    '8c:7b:9d:d5:c5:82',
                                    '8c:7b:9d:d5:e8:55',
                                    '8c:89:a5:3a:b8:84',
                                    '8c:89:a5:3a:ba:1a',
                                    '8c:a9:82:14:56:c6',
                                    '8c:2d:aa:76:59:6b',
                                    '8c:2d:aa:77:cf:91',
                                    '90:00:4e:91:ab:b3',
                                    '90:00:4e:61:24:43',
                                    '90:84:0d:78:95:d2',
                                    '90:84:0d:f5:53:4f',
                                    '90:a4:de:72:c0:91',
                                    '90:a4:de:c1:fe:0e',
                                    '90:fb:a6:9e:ed:cf',
                                    '90:27:e4:13:a6:10',
                                    '90:27:e4:eb:6f:dc',
                                    '90:27:e4:ed:4a:3a',
                                    '90:27:e4:f2:2d:90',
                                    '90:27:e4:f3:97:2f',
                                    '90:27:e4:f3:a8:87',
                                    '90:27:e4:f5:4d:6b',
                                    '90:27:e4:f7:31:30',
                                    '90:27:e4:fd:40:fc',
                                    '90:4c:e5:a2:55:e6',
                                    '90:4c:e5:a9:c2:e9',
                                    '94:db:c9:99:32:1c',
                                    '94:db:c9:a2:c4:2b',
                                    '94:db:c9:b1:db:01',
                                    '94:db:c9:e0:df:51',
                                    '94:39:e5:b0:54:4f',
                                    '94:39:e5:b5:6f:c5',
                                    '98:0c:82:b3:c2:39',
                                    '98:0c:82:cc:01:2c',
                                    '98:0c:82:5b:71:ff',
                                    '98:fe:94:3f:c8:94',
                                    '98:fe:94:41:65:d4',
                                    '98:fe:94:45:b6:8c',
                                    '98:fe:94:47:36:3e',
                                    '98:fe:94:4a:bf:8e',
                                    '98:03:d8:b7:d8:f9',
                                    '9c:b7:0d:7b:d3:67',
                                    '9c:b7:0d:7b:2f:a3',
                                    '9c:b7:0d:d2:c1:a9',
                                    '9c:b7:0d:1c:44:41',
                                    '9c:b7:0d:39:b9:7a',
                                    '9c:04:eb:66:46:67',
                                    '9c:4e:36:53:76:74',
                                    '9c:4e:36:58:d0:94',
                                    '10:93:e9:03:64:cc',
                                    '10:93:e9:04:e0:c6',
                                    '10:93:e9:5d:4a:43',
                                    '10:93:e9:5e:37:5e',
                                    '10:9a:dd:0c:43:62',
                                    '10:9a:dd:a5:32:33',
                                    '10:9a:dd:b2:fb:61',
                                    '10:9a:dd:c2:42:39',
                                    '10:bf:48:d0:57:57',
                                    '10:40:f3:7b:bc:78',
                                    '10:40:f3:80:06:34',
                                    '10:40:f3:86:39:6e',
                                    '10:40:f3:8d:83:0c',
                                    '10:40:f3:8d:85:32',
                                    '10:40:f3:8f:16:90',
                                    '10:40:f3:99:50:8e',
                                    '10:40:f3:9c:35:ac',
                                    '10:40:f3:a5:45:30',
                                    '10:40:f3:a7:95:8e',
                                    '10:40:f3:a7:42:56',
                                    '10:40:f3:ef:ba:be',
                                    'a4:d1:d2:82:1a:a7',
                                    'a4:d1:d2:ac:32:1b',
                                    'a4:d1:d2:35:43:be',
                                    'a4:d1:d2:45:1b:fe',
                                    'a8:26:d9:e9:d6:63',
                                    'ac:72:89:4e:76:4a',
                                    'ac:81:12:8c:a2:10',
                                    'ac:81:12:24:67:35',
                                    'ac:81:12:2f:8b:b4',
                                    'ac:81:12:47:d1:a5',
                                    'b0:65:bd:01:f6:c9',
                                    'b0:65:bd:6b:7b:a9',
                                    'b0:65:bd:60:12:7d',
                                    'b0:65:bd:60:60:17',
                                    '12:41:9b:00:62:fa',
                                    'b4:74:9f:7c:55:ec',
                                    'b4:14:89:38:2d:93',
                                    'b4:f0:ab:b1:4a:7f',
                                    'b8:8d:12:0c:3f:3a',
                                    'b8:8d:12:0d:49:64',
                                    'b8:8d:12:0e:52:86',
                                    'b8:8d:12:10:9f:4e',
                                    'b8:8d:12:10:4b:3a',
                                    'b8:8d:12:12:f6:e8',
                                    'b8:8d:12:16:e3:7c',
                                    'b8:8d:12:1a:e9:6a',
                                    'b8:8d:12:1b:dc:1a',
                                    'b8:8d:12:1c:58:a6',
                                    'b8:8d:12:1e:21:1e',
                                    'b8:8d:12:20:04:78',
                                    'b8:8d:12:22:fc:e2',
                                    'b8:8d:12:2b:08:6c',
                                    'b8:8d:12:2e:c4:c0',
                                    'b8:8d:12:05:12:56',
                                    'b8:8d:12:34:99:32',
                                    'b8:8d:12:34:b1:84',
                                    'b8:8d:12:34:f5:a2',
                                    'b8:8d:12:38:fa:6a',
                                    'b8:8d:12:39:d7:e4',
                                    'b8:8d:12:39:f9:e4',
                                    'b8:8d:12:06:d5:74',
                                    'b8:8d:12:40:21:ae',
                                    'b8:8d:12:07:fc:32',
                                    'b8:ac:6f:94:57:ed',
                                    'b8:c7:5d:3c:d9:ab',
                                    'b8:f6:b1:a7:f2:7c',
                                    'b8:f6:b1:11:0f:0d',
                                    'b8:ff:61:b1:90:d6',
                                    'b8:03:05:2c:68:02',
                                    'bc:3b:af:6d:10:85',
                                    'bc:52:b7:25:17:c9',
                                    'c0:9f:42:52:9a:5e',
                                    'c0:cb:38:01:35:18',
                                    'c0:18:85:6f:2c:56',
                                    'c0:18:85:79:24:e7',
                                    'c0:f8:da:a7:e9:fe',
                                    'c4:64:13:11:23:b9',
                                    'c4:64:13:11:24:d6',
                                    'c4:85:08:69:9c:18',
                                    'c4:85:08:6a:0b:c6',
                                    'c4:85:08:22:d6:93',
                                    'c4:85:08:22:ff:74',
                                    'c4:85:08:24:b8:c3',
                                    'c4:85:08:34:39:74',
                                    'c4:85:08:37:c7:38',
                                    'c4:85:08:41:97:e5',
                                    'c4:85:08:56:d8:d5',
                                    'c4:85:08:57:0c:c4',
                                    'c4:17:fe:b5:48:8a',
                                    'c4:17:fe:55:91:75',
                                    'c4:17:fe:5c:24:68',
                                    'c4:2c:03:00:e7:8c',
                                    'c4:46:19:15:9f:88',
                                    'c4:46:19:5f:74:ef',
                                    '14:74:11:9e:33:49',
                                    '14:8f:c6:8e:63:34',
                                    '14:8f:c6:94:84:b8',
                                    '14:8f:c6:59:d7:ce',
                                    '14:8f:c6:5b:80:fe',
                                    '14:10:9f:ce:46:57',
                                    '14:10:9f:e9:a3:d0',
                                    '14:10:9f:f1:0e:a2',
                                    '14:10:9f:f1:99:a6',
                                    '14:10:9f:f1:9b:5a',
                                    '14:5a:05:a0:f0:a7',
                                    'c8:bc:c8:bc:e7:28',
                                    'c8:bc:c8:cc:8e:85',
                                    'c8:bc:c8:cc:9a:b6',
                                    'c8:bc:c8:ce:3e:88',
                                    'c8:bc:c8:d5:ff:25',
                                    'c8:bc:c8:d7:28:04',
                                    'c8:bc:c8:d9:92:35',
                                    'c8:bc:c8:dd:b7:01',
                                    'c8:bc:c8:dd:e5:56',
                                    'c8:bc:c8:ea:0c:60',
                                    'c8:f7:33:20:a6:89',
                                    'c8:60:00:0d:8f:8b',
                                    'c8:60:00:47:19:6b',
                                    'cc:af:78:73:a6:a0',
                                    'cc:af:78:15:18:89',
                                    'cc:af:78:2a:02:7c',
                                    'cc:af:78:4d:78:ba',
                                    'cc:08:e0:a2:23:90',
                                    'cc:52:af:5e:b7:67',
                                    'd0:c1:b1:82:2b:7f',
                                    'd0:df:9a:71:d8:2d',
                                    'd0:df:9a:81:09:37',
                                    'd0:df:9a:94:72:96',
                                    'd0:df:9a:e3:3d:ee',
                                    'd0:df:9a:21:f2:97',
                                    'd0:df:9a:04:4e:4a',
                                    'd0:df:9a:42:70:90',
                                    'd0:23:db:e4:a7:32',
                                    'd0:51:62:64:b5:68',
                                    'd4:9a:20:65:3a:98',
                                    'd4:9a:20:66:3f:0d',
                                    'd4:9a:20:66:51:4d',
                                    'd4:9a:20:6b:0e:e8',
                                    'd4:9a:20:6e:1c:23',
                                    'd4:9a:20:71:d6:db',
                                    'd4:9a:20:71:2d:a5',
                                    'd4:9a:20:72:b8:1e',
                                    'd4:9a:20:72:ba:28',
                                    'd4:9a:20:72:d6:83',
                                    'd4:9a:20:72:e4:7e',
                                    'd4:9a:20:5d:08:9b',
                                    'd8:9e:3f:7d:07:a6',
                                    'd8:a2:5e:8c:88:79',
                                    'd8:a2:5e:8e:ff:28',
                                    'd8:a2:5e:8e:48:c4',
                                    'd8:a2:5e:91:9e:e5',
                                    'd8:a2:5e:91:a1:34',
                                    'd8:a2:5e:91:36:12',
                                    'd8:a2:5e:96:f9:8a',
                                    'd8:a2:5e:97:f7:91',
                                    'd8:a2:5e:98:14:b1',
                                    'd8:a2:5e:13:00:f2',
                                    'd8:24:bd:d4:d3:10',
                                    'd8:24:bd:d4:e0:80',
                                    'd8:24:bd:e8:75:f0',
                                    'd8:24:bd:e8:5d:70',
                                    'd8:30:62:81:6e:9f',
                                    'dc:85:de:13:b1:7a',
                                    'dc:85:de:15:d1:21',
                                    'e0:b9:a5:80:12:73',
                                    'e0:b9:a5:83:1b:d5',
                                    'e0:b9:a5:9d:00:f8',
                                    'e0:b9:a5:ae:01:43',
                                    'e0:b9:a5:c5:e8:12',
                                    'e0:b9:a5:cc:81:0d',
                                    'e0:b9:ba:87:f0:31',
                                    'e0:b9:ba:d5:47:ba',
                                    'e0:b9:ba:2b:eb:f0',
                                    'e0:c9:7a:e1:1e:2e',
                                    'e0:ca:94:77:e2:76',
                                    'e0:ca:94:8d:3e:05',
                                    'e0:ca:94:1d:15:ae',
                                    'e0:ca:94:24:ec:6f',
                                    'e0:ca:94:5e:be:1a',
                                    'e0:f8:47:12:76:ea',
                                    'e0:f8:47:13:02:b4',
                                    'e0:f8:47:17:b6:38',
                                    'e0:f8:47:1a:4d:48',
                                    'e0:f8:47:1b:f9:00',
                                    'e0:f8:47:2b:8b:44',
                                    'e0:f8:47:35:7b:f6',
                                    'e0:f8:47:39:8f:2c',
                                    'e0:f8:47:39:e3:0e',
                                    'e0:f8:47:43:cc:74',
                                    'e0:2a:82:58:df:fe',
                                    'e0:06:e6:6a:6c:0e',
                                    'e0:06:e6:93:5b:21',
                                    'e0:06:e6:96:d4:a1',
                                    'e0:06:e6:11:70:b7',
                                    'e0:06:e6:41:d7:d7',
                                    'e0:06:e6:4c:eb:9f',
                                    'e4:ce:8f:0f:1c:64',
                                    'e4:ce:8f:0f:04:58',
                                    'e4:ce:8f:16:fc:00',
                                    'e4:ce:8f:35:bb:f2',
                                    'e4:ce:8f:36:00:ee',
                                    'e4:ce:8f:47:8e:fc',
                                    'e4:ce:8f:4a:bd:8e',
                                    'e4:ce:8f:4b:21:16',
                                    'e4:ce:8f:50:71:0c',
                                    'e4:d5:3d:4c:d7:f7',
                                    'e8:e7:32:27:23:5f',
                                    'e8:e7:32:27:31:02',
                                    'e8:e7:32:27:38:30',
                                    'e8:e7:32:27:63:a0',
                                    'e8:e7:32:27:63:f4',
                                    'e8:e7:32:2a:e0:9e',
                                    'e8:e7:32:2a:e0:b6',
                                    'e8:e7:32:2a:e8:a4',
                                    'e8:e7:32:2a:e8:bc',
                                    'e8:e7:32:2b:cc:e7',
                                    'e8:e7:32:4b:78:f8',
                                    'e8:e7:32:4b:79:13',
                                    'e8:e7:32:4b:7b:b4',
                                    'e8:e7:32:4b:86:db',
                                    'e8:e7:32:4b:8a:cc',
                                    'e8:e7:32:4b:9b:d8',
                                    'e8:e7:32:5c:be:b8',
                                    'e8:e7:32:5c:be:d3',
                                    'e8:03:9a:8b:6d:12',
                                    'e8:39:df:6c:b3:07',
                                    'e8:39:df:84:76:cc',
                                    'e8:39:df:3f:05:c5',
                                    'e8:06:88:64:16:09',
                                    'e8:3e:b6:88:c2:8b',
                                    'e8:3e:b6:40:a8:27',
                                    'ec:55:f9:6f:ed:de',
                                    '18:a9:05:e3:0c:f5',
                                    '18:e2:c2:96:78:48',
                                    '18:20:32:bd:67:77',
                                    '18:34:51:17:ff:78',
                                    '18:3d:a2:51:82:40',
                                    'f0:7b:cb:01:a5:2c',
                                    'f0:7b:cb:18:ce:2a',
                                    'f0:b4:79:13:51:14',
                                    'f0:b4:79:14:aa:e7',
                                    'f0:b4:79:14:af:78',
                                    'f0:b4:79:14:b2:c6',
                                    'f0:b4:79:14:d5:04',
                                    'f0:b4:79:15:40:f2',
                                    'f0:b4:79:15:4a:4d',
                                    'f0:b4:79:16:d5:1c',
                                    'f0:b4:79:18:e4:4f',
                                    'f0:b4:79:19:71:e2',
                                    'f0:b4:79:1b:e1:d5',
                                    'f0:b4:79:1b:e4:5b',
                                    'f0:b4:79:1c:00:c4',
                                    'f0:b4:79:1c:12:90',
                                    'f0:b4:79:1c:4f:99',
                                    'f0:b4:79:1f:5b:76',
                                    'f0:cb:a1:c5:24:f0',
                                    'f0:cb:a1:ca:da:f7',
                                    'f0:dc:e2:6b:35:48',
                                    'f8:1e:df:d9:9f:79',
                                    'f8:1e:df:e2:ab:87',
                                    'f8:1e:df:e4:86:b6',
                                    'f8:1e:df:e9:69:37',
                                    'f8:1e:df:e9:ee:30',
                                    'f8:1e:df:eb:11:47',
                                    'f8:1e:df:f2:77:95',
                                    'f8:1e:df:f2:63:c8',
                                    'f8:1e:df:32:a2:50',
                                    '1c:69:a5:51:15:8c',
                                    '1c:4b:d6:6f:78:90',
                                    '1c:4b:d6:80:6c:00',
                                    '1c:4b:d6:f2:d2:b8',
                                    '1c:4b:d6:1f:d4:05',
                                    '1c:62:b8:5f:8d:00',
                                    '20:68:9d:bb:fd:17',
                                    '20:68:9d:e9:5c:58',
                                    '20:7c:8f:6b:79:0f',
                                    '20:c9:d0:7c:fc:3d',
                                    '20:c9:d0:80:c8:f5',
                                    '20:c9:d0:c3:10:f9',
                                    '20:c9:d0:c9:25:37',
                                    '20:c9:d0:d0:42:e9',
                                    '20:c9:d0:d1:45:05',
                                    '20:c9:d0:d1:56:0d',
                                    '20:c9:d0:d2:05:39',
                                    '20:c9:d0:d4:c8:ad',
                                    '20:c9:d0:d6:75:03',
                                    '20:c9:d0:da:82:61',
                                    '20:c9:d0:da:b2:81',
                                    '20:c9:d0:dd:d1:fb',
                                    '20:c9:d0:e0:83:db',
                                    '20:c9:d0:e4:2f:85',
                                    '20:c9:d0:44:8c:cb',
                                    '20:54:76:90:5c:5d',
                                    '24:77:03:e2:30:74',
                                    '24:ec:99:23:1c:c6',
                                    '24:ec:99:4c:24:8a',
                                    '04:0c:ce:d3:ed:18',
                                    '04:0c:ce:d5:9f:a8',
                                    '04:0c:ce:d5:19:da',
                                    '04:0c:ce:d5:1c:4e',
                                    '04:0c:ce:dc:82:50',
                                    '04:0c:ce:dc:c3:40',
                                    '04:0c:ce:de:70:90',
                                    '04:0c:ce:e4:62:42',
                                    '04:0c:ce:20:b9:aa',
                                    '04:1e:64:73:d2:b3',
                                    '04:1e:64:f8:5a:bd',
                                    '04:1e:64:3b:91:24',
                                    '04:1e:64:45:98:da',
                                    '04:54:53:91:f4:d7',
                                    '28:6a:ba:7b:5d:d0',
                                    '28:6a:ba:27:d2:3c',
                                    '28:6a:ba:3d:18:a8',
                                    '28:6a:ba:4b:95:ec',
                                    '28:94:0f:c1:1d:90',
                                    '28:94:0f:d6:bd:81',
                                    '28:94:0f:d6:bd:02',
                                    '28:cf:da:d6:81:fc',
                                    '28:cf:da:df:c4:50',
                                    '28:cf:da:e0:f1:1e',
                                    '28:cf:da:e7:68:26',
                                    '28:cf:da:e7:16:84',
                                    '28:cf:da:e8:6e:6c',
                                    '28:cf:da:e8:f6:c6',
                                    '28:cf:da:ec:03:d2',
                                    '28:cf:da:ed:96:88',
                                    '28:37:37:24:94:1a',
                                    '28:37:37:4d:96:f5',
                                    '2c:81:58:fd:18:17',
                                    '30:85:a9:e4:08:89',
                                    '30:39:26:e5:84:84',
                                    '34:bb:1f:35:b7:11',
                                    '34:c0:59:2c:97:52',
                                    '34:15:9e:8d:d4:71',
                                    '34:15:9e:91:f8:f0',
                                    '34:15:9e:94:10:71',
                                    '34:15:9e:95:e1:1a',
                                    '34:15:9e:e8:39:4f',
                                    '34:51:c9:4c:71:d1',
                                    '38:59:f9:44:5f:b2',
                                    '3c:07:54:23:60:58',
                                    '40:6c:8f:1d:c0:7f',
                                    '40:6c:8f:42:b0:90',
                                    '44:6d:57:0d:03:2a',
                                    '44:6d:57:87:be:af',
                                    '44:6d:57:03:11:09',
                                    '44:2a:60:6b:d6:60',
                                    '44:2a:60:94:f3:1d',
                                    '44:2a:60:f2:f1:10',
                                    '44:4c:0c:dd:2a:b9',
                                    '48:5d:60:10:5a:39',
                                    '48:5d:60:b0:8c:ac',
                                    '48:5d:60:be:de:0e',
                                    '48:5d:60:bf:18:a1',
                                    '48:5d:60:f5:96:80',
                                    '48:5d:60:25:da:ce',
                                    '48:5d:60:39:91:49',
                                    '48:5d:60:5a:24:f8',
                                    '4c:0f:6e:01:4d:9f',
                                    '4c:0f:6e:12:a1:fc',
                                    '4c:0f:6e:e1:0d:bf',
                                    '4c:0f:6e:fa:2b:fd',
                                    '4c:b1:99:cc:85:9f',
                                    '4c:bc:a5:ad:bf:6c',
                                    '4c:ed:de:65:5e:8e',
                                    '4c:ed:de:67:ad:2a',
                                    '08:ed:b9:72:6b:33',
                                    '08:ed:b9:f8:65:d1',
                                    '08:ed:b9:f8:57:07',
                                    '08:ed:b9:04:94:12',
                                    '08:ed:b9:34:c2:f4',
                                    '08:ed:b9:06:23:a2',
                                    '08:3e:8e:b2:99:ed',
                                    '08:3e:8e:b2:c5:e1',
                                    '08:3e:8e:cd:23:b3',
                                    '50:cc:f8:21:c2:58',
                                    '50:ea:d6:e3:1b:0f',
                                    '50:46:5d:29:77:c3',
                                    '54:04:a6:96:01:e1',
                                    '54:04:a6:07:54:9d',
                                    '58:94:6b:6b:c2:fc',
                                    '58:94:6b:d2:d4:e4',
                                    '58:b0:35:66:11:6e',
                                    '58:b0:35:6c:f7:e4',
                                    '58:b0:35:6d:02:35',
                                    '58:b0:35:75:f3:93',
                                    '58:b0:35:7e:cf:d3',
                                    '58:b0:35:80:a8:93',
                                    '58:b0:35:fc:6b:30',
                                    '58:b0:35:5c:95:64',
                                    '58:1f:aa:c8:62:d9',
                                    '58:55:ca:f5:64:a9',
                                    '58:55:ca:f6:86:6f',
                                    '58:55:ca:f6:ef:83',
                                    '58:55:ca:f8:15:4d',
                                    '58:55:ca:f8:5b:39',
                                    '5c:0a:5b:69:1d:c7',
                                    '5c:96:9d:70:20:c7',
                                    '5c:96:9d:76:2a:7f',
                                    '5c:96:9d:7a:9c:fb',
                                    '5c:96:9d:7c:71:c9',
                                    '5c:96:9d:7c:5a:15',
                                    '5c:96:9d:7d:1b:63',
                                    '5c:96:9d:8a:96:2f',
                                    '5c:96:9d:8b:05:db',
                                    '5c:96:9d:dd:d0:4d',
                                    '5c:59:48:66:e8:90',
                                    '5c:59:48:8f:1f:80',
                                    '60:c5:47:0a:cb:34',
                                    '60:c5:47:72:76:c3',
                                    '60:c5:47:79:34:85',
                                    '60:c5:47:8c:75:e0',
                                    '60:c5:47:96:70:32',
                                    '60:c5:47:96:c3:26',
                                    '60:c5:47:97:25:8a',
                                    '60:c5:47:04:7f:c0',
                                    '60:c5:47:04:81:d8',
                                    '60:c5:47:07:6d:90',
                                    '60:d8:19:65:c4:df',
                                    '60:d8:19:08:a2:92',
                                    '60:33:4b:01:c7:d8',
                                    '60:33:4b:01:dd:f5',
                                    '60:33:4b:23:73:cf',
                                    '60:33:4b:23:62:e2',
                                    '60:33:4b:26:86:b9',
                                    '60:33:4b:26:8b:b7',
                                    '60:33:4b:26:bc:8f',
                                    '60:45:bd:24:de:76',
                                    '00:08:ca:e7:7e:29',
                                    '78:dd:08:c6:9c:ce',
                                    'b8:ff:61:50:40:16',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '1025',
                        IFNAME           => ' Stacking Port 1/StackA',
                        IFDESCR          => 'Alcatel-Lucent Stacking Port 1/StackA',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3300) 0:00:33.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1026',
                        IFNAME           => ' Stacking Port 1/StackB',
                        IFDESCR          => 'Alcatel-Lucent Stacking Port 1/StackB',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3300) 0:00:33.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '13600001',
                        IFNAME           => 'admin',
                        IFDESCR          => 'admin',
                        IFTYPE           => '136',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IP               => '192.168.1.127',
                        MAC              => 'e8:e7:32:2b:c1:e2',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(57238810) 6 days, 14:59:48.10',
                        IFINOCTETS       => '173601851',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '205881648',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '13600154',
                        IFNAME           => 'Loopback',
                        IFDESCR          => 'Loopback',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '32768',
                        IP               => '127.0.0.1',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(511) 0:00:05.11',
                        IFINOCTETS       => '1305305095',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1305406678',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Alcatel-Lucent',
                TYPE         => 'NETWORKING',
                MODEL        => 'OS6400-P24',
                COMMENTS     => 'Alcatel-Lucent 6.4.4.342.R01 GA, April 18, 2011.',
                CONTACT      => 'Alcatel-Lucent, http://alcatel-lucent.com/wps/portal/enterprise',
                NAME         => 'CB-C005-127-os6400',
                LOCATION     => 'Unknown',
                SERIAL       => 'M4682816',
                FIRMWARE     => 'Alcatel-Lucent 6.4.4.342.R01 GA, April 18, 2011.',
                IPS          => {
                    IP => [
                        '127.0.0.1',
                        '192.168.1.127',
                    ],
                },
                MAC          => 'e8:e7:32:2b:c1:e2',
                UPTIME       => '(1442631100) 166 days, 23:18:31.00',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1001',
                        IFNAME           => '1/1',
                        IFDESCR          => 'Alcatel-Lucent 1/1',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '9216',
                        MAC              => 'e8:e7:32:2b:c1:e4',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(7100) 0:01:11.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1002',
                        IFNAME           => '1/2',
                        IFDESCR          => 'Alcatel-Lucent 1/2',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '9216',
                        MAC              => 'e8:e7:32:2b:c1:e5',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(7100) 0:01:11.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1003',
                        IFNAME           => '1/3',
                        IFDESCR          => 'Alcatel-Lucent 1/3',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '9216',
                        MAC              => 'e8:e7:32:2b:c1:e6',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(7100) 0:01:11.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1004',
                        IFNAME           => '1/4',
                        IFDESCR          => 'Alcatel-Lucent 1/4',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '9216',
                        MAC              => 'e8:e7:32:2b:c1:e7',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(7100) 0:01:11.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1005',
                        IFNAME           => '1/5',
                        IFDESCR          => 'Alcatel-Lucent 1/5',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '9216',
                        MAC              => 'e8:e7:32:2b:c1:e8',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(7100) 0:01:11.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1006',
                        IFNAME           => '1/6',
                        IFDESCR          => 'Alcatel-Lucent 1/6',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '9216',
                        MAC              => 'e8:e7:32:2b:c1:e9',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(7100) 0:01:11.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1007',
                        IFNAME           => '1/7',
                        IFDESCR          => 'Alcatel-Lucent 1/7',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '9216',
                        MAC              => 'e8:e7:32:2b:c1:ea',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(7100) 0:01:11.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1008',
                        IFNAME           => '1/8',
                        IFDESCR          => 'Alcatel-Lucent 1/8',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '9216',
                        MAC              => 'e8:e7:32:2b:c1:eb',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(7100) 0:01:11.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1009',
                        IFNAME           => '1/9',
                        IFDESCR          => 'Alcatel-Lucent 1/9',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '9216',
                        MAC              => 'e8:e7:32:2b:c1:ec',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(7100) 0:01:11.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1010',
                        IFNAME           => '1/10',
                        IFDESCR          => 'Alcatel-Lucent 1/10',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '9216',
                        MAC              => 'e8:e7:32:2b:c1:ed',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(7100) 0:01:11.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1011',
                        IFNAME           => '1/11',
                        IFDESCR          => 'Alcatel-Lucent 1/11',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '9216',
                        MAC              => 'e8:e7:32:2b:c1:ee',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(7100) 0:01:11.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1012',
                        IFNAME           => '1/12',
                        IFDESCR          => 'Alcatel-Lucent 1/12',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '9216',
                        MAC              => 'e8:e7:32:2b:c1:ef',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(7100) 0:01:11.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1013',
                        IFNAME           => '1/13',
                        IFDESCR          => 'Alcatel-Lucent 1/13',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '9216',
                        MAC              => 'e8:e7:32:2b:c1:f0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(7100) 0:01:11.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1014',
                        IFNAME           => '1/14',
                        IFDESCR          => 'Alcatel-Lucent 1/14',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '9216',
                        MAC              => 'e8:e7:32:2b:c1:f1',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(7100) 0:01:11.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1015',
                        IFNAME           => '1/15',
                        IFDESCR          => 'Alcatel-Lucent 1/15',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '9216',
                        MAC              => 'e8:e7:32:2b:c1:f2',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(7100) 0:01:11.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1016',
                        IFNAME           => '1/16',
                        IFDESCR          => 'Alcatel-Lucent 1/16',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '9216',
                        MAC              => 'e8:e7:32:2b:c1:f3',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(7100) 0:01:11.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1017',
                        IFNAME           => '1/17',
                        IFDESCR          => 'Alcatel-Lucent 1/17',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '9216',
                        MAC              => 'e8:e7:32:2b:c1:f4',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(7100) 0:01:11.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1018',
                        IFNAME           => '1/18',
                        IFDESCR          => 'Alcatel-Lucent 1/18',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '9216',
                        MAC              => 'e8:e7:32:2b:c1:f5',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(7100) 0:01:11.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1019',
                        IFNAME           => '1/19',
                        IFDESCR          => 'Alcatel-Lucent 1/19',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '9216',
                        MAC              => 'e8:e7:32:2b:c1:f6',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(7100) 0:01:11.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1020',
                        IFNAME           => '1/20',
                        IFDESCR          => 'Alcatel-Lucent 1/20',
                        IFALIAS          => 'wifi-RDC-ascenseur-203',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '9216',
                        MAC              => 'e8:e7:32:2b:c1:f7',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1009388000) 116 days, 19:51:20.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '2695194882',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1462639524',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '00:16:6f:47:52:f9',
                                    '00:25:4b:71:76:ec',
                                    '10:93:e9:0f:d7:cc',
                                    'c4:85:08:3c:04:b0',
                                    '14:10:9f:d1:9a:db',
                                    'd8:24:bd:e8:79:20',
                                    'f0:b4:79:15:a4:03',
                                    '28:94:0f:d6:bd:94',
                                    '4c:0f:6e:fe:e9:78',
                                    '54:26:96:09:33:a4',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '1021',
                        IFNAME           => '1/21',
                        IFDESCR          => 'Alcatel-Lucent 1/21',
                        IFALIAS          => 'wifi-c005-espaceOne-205',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '9216',
                        MAC              => 'e8:e7:32:2b:c1:f8',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1441734300) 166 days, 20:49:03.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '2824635082',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '464602515',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '98:0c:82:c9:d4:70',
                                    'd8:24:bd:b4:92:c0',
                                    '28:94:0f:c1:1c:3b',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '1022',
                        IFNAME           => '1/22',
                        IFDESCR          => 'Alcatel-Lucent 1/22',
                        IFALIAS          => 'wifi-rdc-acceuil-47',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '9216',
                        MAC              => 'e8:e7:32:2b:c1:f9',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(492727000) 57 days, 0:41:10.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1952393561',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '211370716',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '0c:ee:e6:b0:86:7a',
                                    '7c:d1:c3:f7:d7:c3',
                                    '98:b8:e3:66:fd:2c',
                                    'd8:24:bd:b4:92:b0',
                                    'dc:85:de:69:44:24',
                                    '28:94:0f:c1:1d:89',
                                    '28:cf:da:48:1f:4b',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '1023',
                        IFNAME           => '1/23',
                        IFDESCR          => 'Alcatel-Lucent 1/23',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '9216',
                        MAC              => 'e8:e7:32:2b:c1:fa',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(7100) 0:01:11.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1024',
                        IFNAME           => '1/24',
                        IFDESCR          => 'Alcatel-Lucent 1/24',
                        IFALIAS          => 'CB-C005-202',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '9216',
                        MAC              => 'e8:e7:32:2b:c1:fb',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(128821500) 14 days, 21:50:15.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '826699557',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3448622558',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '00:00:5e:00:01:02',
                                    '00:0b:5f:cc:d8:80',
                                    '00:0b:5f:cc:d8:81',
                                    '00:80:9f:af:b1:10',
                                    '00:80:9f:af:b1:11',
                                    '00:80:9f:af:b1:15',
                                    '00:80:9f:af:b1:1b',
                                    '00:80:9f:af:b1:2e',
                                    '00:80:9f:af:b1:32',
                                    '00:80:9f:b3:aa:8d',
                                    '00:80:9f:b3:aa:8e',
                                    '00:80:9f:b3:aa:8f',
                                    '00:80:9f:b3:aa:93',
                                    '00:80:9f:b3:aa:95',
                                    '00:80:9f:b3:aa:96',
                                    '00:80:9f:b3:aa:99',
                                    '00:80:9f:b3:aa:9c',
                                    '00:80:9f:b3:aa:9d',
                                    '00:80:9f:b3:aa:a1',
                                    '00:80:9f:b3:aa:a2',
                                    '00:80:9f:b3:aa:a6',
                                    '00:80:9f:b3:aa:a8',
                                    '00:80:9f:b3:ad:51',
                                    '00:80:9f:b3:ad:5c',
                                    '00:80:9f:ba:8b:d2',
                                    '00:80:9f:ba:8d:90',
                                    '00:80:9f:ba:8d:91',
                                    '00:80:9f:ba:8d:d4',
                                    '00:80:9f:ba:8d:d5',
                                    '00:0d:bc:bd:66:d8',
                                    '00:88:65:a9:b5:e3',
                                    '00:13:5f:fa:ed:70',
                                    '00:13:5f:fa:ed:f0',
                                    '00:13:5f:fa:ed:20',
                                    '00:13:5f:fa:ee:90',
                                    '00:13:5f:fa:ee:f0',
                                    '00:13:5f:fa:ee:20',
                                    '00:13:5f:fa:ee:50',
                                    '00:13:5f:fa:ef:90',
                                    '00:13:5f:fa:f0:80',
                                    '00:13:5f:fa:f1:90',
                                    '00:13:5f:fa:f1:a0',
                                    '00:13:5f:fa:f1:30',
                                    '00:13:5f:fa:f2:00',
                                    '00:13:5f:fa:f2:a0',
                                    '00:13:5f:fa:f2:50',
                                    '00:13:5f:fa:f3:20',
                                    '00:13:5f:fa:f4:80',
                                    '00:13:5f:fa:f4:d0',
                                    '00:13:5f:fa:f5:70',
                                    '00:13:5f:fa:f6:c0',
                                    '00:13:5f:fa:f7:20',
                                    '00:13:5f:fa:f8:50',
                                    '00:13:5f:fa:f9:a0',
                                    '00:13:5f:fa:f9:b0',
                                    '00:13:5f:fa:f9:e0',
                                    '00:13:5f:fa:fa:50',
                                    '00:13:5f:fa:fa:60',
                                    '00:13:5f:fa:fb:80',
                                    '00:13:5f:fa:fb:b0',
                                    '00:13:5f:fa:fb:60',
                                    '00:13:5f:fa:fc:80',
                                    '00:13:5f:fa:fc:d0',
                                    '00:14:6a:d6:b1:76',
                                    '00:14:6a:d6:b1:94',
                                    '00:14:6a:d6:b1:aa',
                                    '00:14:6a:d6:b1:b6',
                                    '00:14:6a:d6:b1:b8',
                                    '00:14:6a:d6:b1:c4',
                                    '00:14:6a:d6:b1:ce',
                                    '00:14:6a:d6:b1:d8',
                                    '00:14:6a:d6:b1:e8',
                                    '00:14:6a:d6:b1:28',
                                    '00:14:6a:d6:b1:32',
                                    '00:14:6a:d6:b1:42',
                                    '00:14:6a:d6:b1:48',
                                    '00:14:6a:d6:b1:4e',
                                    '00:14:6a:d6:b1:56',
                                    '00:14:6a:d6:b1:62',
                                    '00:14:6a:d6:b2:68',
                                    '00:14:6a:d6:b2:8e',
                                    '00:14:6a:d6:b2:b8',
                                    '00:14:6a:d6:b2:ba',
                                    '00:14:6a:d6:b2:c0',
                                    '00:14:6a:d6:b2:14',
                                    '00:14:6a:d6:b2:ce',
                                    '00:14:6a:d6:b2:d0',
                                    '00:14:6a:d6:b2:f0',
                                    '00:14:6a:d6:b2:f4',
                                    '00:14:6a:d6:b2:fa',
                                    '00:14:6a:d6:b2:1e',
                                    '00:14:6a:d6:b2:32',
                                    '00:14:6a:d6:b2:5c',
                                    '00:14:6a:d6:b3:14',
                                    '00:14:6a:d6:b3:1e',
                                    '00:d0:95:17:51:a3',
                                    '00:d0:95:3e:96:83',
                                    '00:15:af:b4:88:3a',
                                    '00:15:f2:d5:b3:f6',
                                    '00:16:d4:50:f1:ff',
                                    '00:16:ea:28:ef:7c',
                                    '00:17:c4:65:e1:cb',
                                    '00:17:c4:ae:c8:b8',
                                    '00:18:de:e1:43:bf',
                                    '00:f4:b9:53:b7:a2',
                                    '00:19:d1:92:0c:4c',
                                    '00:1b:77:df:5d:e1',
                                    '00:1b:77:49:52:59',
                                    '00:1b:a9:a2:a8:8e',
                                    '00:1b:b1:a0:48:b8',
                                    '00:1b:b1:a6:13:a2',
                                    '00:1b:b1:4a:51:47',
                                    '00:1b:b1:4c:10:34',
                                    '00:1b:63:cb:45:98',
                                    '00:1c:b3:bc:b5:f0',
                                    '00:1c:b3:c4:7e:68',
                                    '00:1c:bf:b3:31:73',
                                    '00:1c:c0:d8:8d:7f',
                                    '00:1e:64:0a:41:ae',
                                    '00:1e:64:35:1c:38',
                                    '00:1e:64:3c:e3:80',
                                    '00:1e:65:eb:75:c0',
                                    '00:1e:65:2c:6c:aa',
                                    '00:1e:c2:ae:f4:c5',
                                    '00:1e:c2:c4:92:49',
                                    '00:1e:4c:13:ce:44',
                                    '00:1e:52:6f:aa:33',
                                    '00:1e:52:c8:8f:81',
                                    '00:1f:3c:a5:cc:ef',
                                    '00:1f:3c:e1:9a:87',
                                    '00:1f:5b:c1:0e:17',
                                    '00:1f:5b:d7:41:1f',
                                    '00:20:a6:49:7e:d7',
                                    '00:20:a6:49:7e:da',
                                    '00:20:a6:49:7e:f8',
                                    '00:20:a6:49:7e:fb',
                                    '00:20:a6:49:7f:04',
                                    '00:20:a6:49:7f:07',
                                    '00:21:00:30:65:1c',
                                    '00:21:6a:0f:10:68',
                                    '00:21:6a:b6:86:96',
                                    '00:21:6b:c7:95:50',
                                    '00:21:6b:31:e5:88',
                                    '00:21:e9:db:c8:5c',
                                    '00:21:5d:ac:05:c0',
                                    '00:21:5d:08:76:58',
                                    '00:22:fa:31:cd:40',
                                    '00:22:fb:60:9a:40',
                                    '00:22:41:86:60:d7',
                                    '00:22:41:f6:e1:0f',
                                    '00:22:41:28:17:55',
                                    '00:22:43:70:ac:5f',
                                    '00:22:43:25:f8:02',
                                    '00:22:4d:47:f6:65',
                                    '00:22:5f:36:13:a2',
                                    '00:23:6c:7a:2d:67',
                                    '00:23:6c:82:7a:e6',
                                    '00:23:6c:85:b9:61',
                                    '00:23:6c:89:6f:5e',
                                    '00:23:6c:8a:00:b0',
                                    '00:23:6c:8a:56:09',
                                    '00:23:6c:8b:88:6c',
                                    '00:23:6c:8b:1c:a2',
                                    '00:23:6c:94:c6:40',
                                    '00:23:6c:99:48:86',
                                    '00:23:6c:09:bb:50',
                                    '00:23:12:0d:33:dc',
                                    '00:23:12:02:dc:d6',
                                    '00:23:12:57:99:6e',
                                    '00:23:14:1b:a7:d0',
                                    '00:23:14:3e:a1:2c',
                                    '00:23:14:56:47:d8',
                                    '00:23:4d:4f:93:97',
                                    '00:23:4e:d7:2a:75',
                                    '00:23:08:a4:e8:ec',
                                    '00:24:be:b6:4c:20',
                                    '00:24:d6:0a:d1:94',
                                    '00:24:d6:98:03:5a',
                                    '00:24:d6:06:e2:64',
                                    '00:25:00:37:19:e8',
                                    '00:25:00:3d:c4:72',
                                    '00:25:00:3f:7c:c5',
                                    '00:25:00:3f:1d:f0',
                                    '00:25:00:46:71:2c',
                                    '00:25:00:4f:12:88',
                                    '00:25:d3:79:55:24',
                                    '00:25:d3:87:4f:af',
                                    '00:25:d3:d4:3e:20',
                                    '00:25:d3:d4:52:d1',
                                    '00:25:d3:3f:65:6b',
                                    '00:25:d3:45:a2:e3',
                                    '00:25:d3:45:a7:ec',
                                    '00:25:d3:5f:26:09',
                                    '00:25:4b:85:a6:4f',
                                    '00:25:4b:8f:61:cb',
                                    '00:25:4b:92:ca:a1',
                                    '00:26:82:73:62:85',
                                    '00:26:82:86:b0:c7',
                                    '00:26:82:a0:97:b6',
                                    '00:26:b0:be:84:a0',
                                    '00:26:b0:f1:25:3e',
                                    '00:26:b0:1f:07:4f',
                                    '00:26:b6:66:e9:d5',
                                    '00:26:b6:84:64:ab',
                                    '00:26:b6:97:d1:99',
                                    '00:26:b6:c3:a6:c5',
                                    '00:26:bb:10:3a:02',
                                    '00:26:bb:15:dd:9f',
                                    '00:26:bb:18:80:63',
                                    '00:26:bb:18:b3:2b',
                                    '00:26:bb:1b:ad:65',
                                    '00:26:bb:03:a5:36',
                                    '00:26:c7:a7:38:9a',
                                    '00:26:c7:b2:ed:f0',
                                    '00:26:c7:c1:70:1e',
                                    '00:26:4d:43:92:01',
                                    '00:26:4d:59:b3:5c',
                                    '00:26:08:e6:73:9a',
                                    '00:26:08:e6:9d:2d',
                                    '00:26:08:e7:21:bf',
                                    '00:26:08:e7:24:c3',
                                    '00:26:08:e7:38:0b',
                                    '00:26:08:ec:e3:96',
                                    '00:26:08:f5:87:fb',
                                    '00:26:08:f7:ba:9e',
                                    '00:26:08:f7:21:3f',
                                    '00:26:5e:f7:45:0e',
                                    '00:26:5e:37:43:99',
                                    '00:27:10:f2:a3:18',
                                    '00:27:10:42:50:14',
                                    '00:07:e9:06:a6:be',
                                    '00:08:ca:9c:cd:84',
                                    '00:08:ca:9e:57:e1',
                                    '00:08:ca:e6:b3:26',
                                    '00:08:ca:e7:2f:6b',
                                    '00:08:ca:21:42:9d',
                                    '00:08:ca:43:cf:1b',
                                    '00:08:ca:46:9b:a1',
                                    '00:50:56:b7:2c:4e',
                                    '00:09:3d:00:73:29',
                                    '00:09:43:08:ea:d8',
                                    '64:a3:cb:bf:57:f0',
                                    '64:b9:e8:1a:cc:0d',
                                    '64:b9:e8:08:75:6d',
                                    '68:96:7b:30:09:60',
                                    '68:a3:c4:85:93:fc',
                                    '68:a3:c4:db:f2:5e',
                                    '68:a3:c4:dd:e6:21',
                                    '68:a3:c4:e2:5e:03',
                                    '68:a3:c4:25:2f:4d',
                                    '68:a3:c4:32:76:c6',
                                    '68:a3:c4:37:e4:6a',
                                    '68:a8:6d:0c:e4:12',
                                    '68:a8:6d:10:ea:2e',
                                    '68:a8:6d:25:c9:0c',
                                    '68:a8:6d:04:a4:5e',
                                    '68:a8:6d:2a:55:cc',
                                    '68:a8:6d:37:c5:d8',
                                    '68:a8:6d:37:37:f2',
                                    '68:a8:6d:42:20:3c',
                                    '68:a8:6d:42:5e:84',
                                    '68:a8:6d:45:c1:1e',
                                    '68:a8:6d:45:1f:2a',
                                    '68:a8:6d:4a:f8:a0',
                                    '68:a8:6d:56:12:22',
                                    '68:09:27:f1:c9:b9',
                                    '70:d4:f2:a1:27:d7',
                                    '70:de:e2:88:51:43',
                                    '70:f1:a1:89:2a:2b',
                                    '70:f1:a1:da:a6:9e',
                                    '70:f1:a1:16:56:86',
                                    '70:f1:a1:ed:42:b7',
                                    '70:f3:95:b5:4c:e4',
                                    '70:f3:95:36:76:93',
                                    '70:1a:04:ef:cd:f4',
                                    '70:1a:04:34:27:90',
                                    '70:1a:04:36:f0:b2',
                                    '70:56:81:88:75:19',
                                    '70:56:81:89:b9:17',
                                    '70:56:81:8d:ca:91',
                                    '70:56:81:8f:79:69',
                                    '70:56:81:92:9e:31',
                                    '70:56:81:9c:a2:85',
                                    '70:56:81:9c:e7:d9',
                                    '70:56:81:9c:ef:ef',
                                    '70:56:81:9d:15:39',
                                    '70:56:81:aa:68:11',
                                    '70:56:81:aa:bf:85',
                                    '70:56:81:ac:22:8b',
                                    '70:56:81:ac:33:81',
                                    '70:56:81:b6:2e:8d',
                                    '70:56:81:b8:55:93',
                                    '74:de:2b:69:96:ff',
                                    '74:de:2b:9d:1c:45',
                                    '74:de:2b:c4:ea:49',
                                    '74:de:2b:17:35:b6',
                                    '74:de:2b:f3:5c:74',
                                    '74:de:2b:25:dd:18',
                                    '74:e2:f5:c0:bc:72',
                                    '74:e2:f5:04:09:4e',
                                    '74:e5:43:a4:1a:43',
                                    '74:e5:43:a4:04:c6',
                                    '74:e5:43:11:63:e6',
                                    '74:e5:43:bb:6b:70',
                                    '74:e5:43:08:6c:20',
                                    '74:f0:6d:8b:d9:d9',
                                    '74:f0:6d:0e:09:1e',
                                    '74:f0:6d:22:ae:2e',
                                    '74:f0:6d:30:05:d2',
                                    '74:f0:6d:50:ce:ce',
                                    '74:f0:6d:53:3f:c2',
                                    '74:f0:6d:55:ad:68',
                                    '74:f0:6d:09:69:1b',
                                    '74:2f:68:8a:3a:33',
                                    '74:2f:68:8c:33:9f',
                                    '74:2f:68:a5:6f:d4',
                                    '74:2f:68:cc:b5:06',
                                    '74:2f:68:cd:75:49',
                                    '74:2f:68:30:de:80',
                                    '74:2f:68:31:5a:c5',
                                    '74:2f:68:32:a3:59',
                                    '74:2f:68:33:dd:f7',
                                    '74:2f:68:33:eb:50',
                                    '74:2f:68:4b:11:49',
                                    '0c:74:c2:0e:7a:9f',
                                    '0c:74:c2:90:f5:28',
                                    '0c:74:c2:4f:7c:34',
                                    '0c:77:1a:1f:d9:78',
                                    '0c:d2:92:03:0d:7c',
                                    '0c:d2:92:03:da:6d',
                                    '0c:ee:e6:bf:51:76',
                                    '0c:ee:e6:fe:4f:18',
                                    '0c:60:76:44:92:09',
                                    '0c:60:76:59:62:d0',
                                    '78:6c:1c:bd:e1:f4',
                                    '78:92:9c:29:8f:62',
                                    '78:92:9c:06:fd:a2',
                                    '78:ca:39:a4:e8:4d',
                                    '78:ca:39:ae:65:df',
                                    '78:ca:39:ae:9e:d0',
                                    '78:ca:39:b0:1f:f1',
                                    '78:ca:39:b1:19:54',
                                    '78:ca:39:b1:34:d9',
                                    '78:ca:39:b3:f3:79',
                                    '78:ca:39:b8:3d:cb',
                                    '78:ca:39:b8:5c:e1',
                                    '78:ca:39:b9:cc:16',
                                    '78:ca:39:b9:d0:d2',
                                    '78:ca:39:ba:57:d3',
                                    '78:ca:39:bb:24:e3',
                                    '78:ca:39:bc:d1:44',
                                    '78:ca:39:bd:55:20',
                                    '78:ca:39:be:3d:5b',
                                    '78:ca:39:34:b2:b6',
                                    '78:ca:39:40:f7:96',
                                    '78:dd:08:d4:b1:d2',
                                    '78:dd:08:e1:36:9d',
                                    '78:dd:08:f6:36:47',
                                    '78:e4:00:88:41:6d',
                                    '78:e4:00:91:82:d4',
                                    '78:e4:00:04:a9:7f',
                                    '7c:11:be:b2:42:08',
                                    '7c:c3:a1:0b:ad:eb',
                                    '7c:c5:37:92:85:85',
                                    '7c:c5:37:bf:34:60',
                                    '7c:c5:37:07:1b:a7',
                                    '7c:d1:c3:6c:be:9a',
                                    '7c:d1:c3:70:ef:8e',
                                    '7c:d1:c3:75:a7:84',
                                    '7c:d1:c3:83:52:6c',
                                    '7c:d1:c3:89:ae:f2',
                                    '7c:d1:c3:95:46:b6',
                                    '7c:d1:c3:98:70:e2',
                                    '7c:d1:c3:99:00:42',
                                    '7c:d1:c3:9a:80:60',
                                    '7c:d1:c3:9a:84:7a',
                                    '7c:d1:c3:9c:3f:24',
                                    '7c:d1:c3:eb:e0:cd',
                                    '7c:d1:c3:ec:1a:cb',
                                    '7c:d1:c3:ec:09:ff',
                                    '7c:d1:c3:f1:bc:35',
                                    '7c:d1:c3:f4:e7:89',
                                    '7c:d1:c3:f5:17:51',
                                    '7c:d1:c3:f6:dc:15',
                                    '7c:e9:d3:6d:8c:d2',
                                    '7c:61:93:f5:37:96',
                                    '80:60:07:78:5a:21',
                                    '80:60:07:dc:f3:c9',
                                    '84:00:d2:bc:d3:1a',
                                    '84:85:06:77:86:fc',
                                    '84:85:06:18:68:9e',
                                    '84:a6:c8:0d:d4:f5',
                                    '84:a6:c8:5d:b1:e1',
                                    '84:29:99:79:ad:8d',
                                    '84:29:99:54:32:c6',
                                    '84:4b:f5:c2:6e:59',
                                    '84:4b:f5:ca:b4:7d',
                                    '84:4b:f5:26:b7:86',
                                    '84:4b:f5:4c:34:8b',
                                    '84:4b:f5:54:9f:03',
                                    '88:9f:fa:69:d8:51',
                                    '88:9f:fa:03:fa:4c',
                                    '88:9f:fa:28:92:ae',
                                    '88:53:2e:b2:e0:6c',
                                    '8c:7b:9d:d5:c5:82',
                                    '8c:7b:9d:d5:e8:55',
                                    '8c:89:a5:3a:b8:84',
                                    '8c:89:a5:3a:ba:1a',
                                    '8c:a9:82:14:56:c6',
                                    '8c:2d:aa:76:59:6b',
                                    '8c:2d:aa:77:cf:91',
                                    '90:00:4e:91:ab:b3',
                                    '90:00:4e:61:24:43',
                                    '90:84:0d:78:95:d2',
                                    '90:84:0d:f5:53:4f',
                                    '90:a4:de:72:c0:91',
                                    '90:a4:de:c1:fe:0e',
                                    '90:fb:a6:9e:ed:cf',
                                    '90:27:e4:13:a6:10',
                                    '90:27:e4:eb:6f:dc',
                                    '90:27:e4:ed:4a:3a',
                                    '90:27:e4:f2:2d:90',
                                    '90:27:e4:f3:97:2f',
                                    '90:27:e4:f3:a8:87',
                                    '90:27:e4:f5:4d:6b',
                                    '90:27:e4:f7:31:30',
                                    '90:27:e4:fd:40:fc',
                                    '90:4c:e5:a2:55:e6',
                                    '90:4c:e5:a9:c2:e9',
                                    '94:db:c9:99:32:1c',
                                    '94:db:c9:a2:c4:2b',
                                    '94:db:c9:b1:db:01',
                                    '94:db:c9:e0:df:51',
                                    '94:39:e5:b0:54:4f',
                                    '94:39:e5:b5:6f:c5',
                                    '98:0c:82:b3:c2:39',
                                    '98:0c:82:cc:01:2c',
                                    '98:0c:82:5b:71:ff',
                                    '98:fe:94:3f:c8:94',
                                    '98:fe:94:41:65:d4',
                                    '98:fe:94:45:b6:8c',
                                    '98:fe:94:47:36:3e',
                                    '98:fe:94:4a:bf:8e',
                                    '98:03:d8:b7:d8:f9',
                                    '9c:b7:0d:7b:d3:67',
                                    '9c:b7:0d:7b:2f:a3',
                                    '9c:b7:0d:d2:c1:a9',
                                    '9c:b7:0d:1c:44:41',
                                    '9c:b7:0d:39:b9:7a',
                                    '9c:04:eb:66:46:67',
                                    '9c:4e:36:53:76:74',
                                    '9c:4e:36:58:d0:94',
                                    '10:93:e9:03:64:cc',
                                    '10:93:e9:04:e0:c6',
                                    '10:93:e9:5d:4a:43',
                                    '10:93:e9:5e:37:5e',
                                    '10:9a:dd:0c:43:62',
                                    '10:9a:dd:a5:32:33',
                                    '10:9a:dd:b2:fb:61',
                                    '10:9a:dd:c2:42:39',
                                    '10:bf:48:d0:57:57',
                                    '10:40:f3:7b:bc:78',
                                    '10:40:f3:80:06:34',
                                    '10:40:f3:86:39:6e',
                                    '10:40:f3:8d:83:0c',
                                    '10:40:f3:8d:85:32',
                                    '10:40:f3:8f:16:90',
                                    '10:40:f3:99:50:8e',
                                    '10:40:f3:9c:35:ac',
                                    '10:40:f3:a5:45:30',
                                    '10:40:f3:a7:95:8e',
                                    '10:40:f3:a7:42:56',
                                    '10:40:f3:ef:ba:be',
                                    'a4:d1:d2:82:1a:a7',
                                    'a4:d1:d2:ac:32:1b',
                                    'a4:d1:d2:35:43:be',
                                    'a4:d1:d2:45:1b:fe',
                                    'a8:26:d9:e9:d6:63',
                                    'ac:72:89:4e:76:4a',
                                    'ac:81:12:8c:a2:10',
                                    'ac:81:12:24:67:35',
                                    'ac:81:12:2f:8b:b4',
                                    'ac:81:12:47:d1:a5',
                                    'b0:65:bd:01:f6:c9',
                                    'b0:65:bd:6b:7b:a9',
                                    'b0:65:bd:60:12:7d',
                                    'b0:65:bd:60:60:17',
                                    '12:41:9b:00:62:fa',
                                    'b4:74:9f:7c:55:ec',
                                    'b4:14:89:38:2d:93',
                                    'b4:f0:ab:b1:4a:7f',
                                    'b8:8d:12:0c:3f:3a',
                                    'b8:8d:12:0d:49:64',
                                    'b8:8d:12:0e:52:86',
                                    'b8:8d:12:10:9f:4e',
                                    'b8:8d:12:10:4b:3a',
                                    'b8:8d:12:12:f6:e8',
                                    'b8:8d:12:16:e3:7c',
                                    'b8:8d:12:1a:e9:6a',
                                    'b8:8d:12:1b:dc:1a',
                                    'b8:8d:12:1c:58:a6',
                                    'b8:8d:12:1e:21:1e',
                                    'b8:8d:12:20:04:78',
                                    'b8:8d:12:22:fc:e2',
                                    'b8:8d:12:2b:08:6c',
                                    'b8:8d:12:2e:c4:c0',
                                    'b8:8d:12:05:12:56',
                                    'b8:8d:12:34:99:32',
                                    'b8:8d:12:34:b1:84',
                                    'b8:8d:12:34:f5:a2',
                                    'b8:8d:12:38:fa:6a',
                                    'b8:8d:12:39:d7:e4',
                                    'b8:8d:12:39:f9:e4',
                                    'b8:8d:12:06:d5:74',
                                    'b8:8d:12:40:21:ae',
                                    'b8:8d:12:07:fc:32',
                                    'b8:ac:6f:94:57:ed',
                                    'b8:c7:5d:3c:d9:ab',
                                    'b8:f6:b1:a7:f2:7c',
                                    'b8:f6:b1:11:0f:0d',
                                    'b8:ff:61:b1:90:d6',
                                    'b8:03:05:2c:68:02',
                                    'bc:3b:af:6d:10:85',
                                    'bc:52:b7:25:17:c9',
                                    'c0:9f:42:52:9a:5e',
                                    'c0:cb:38:01:35:18',
                                    'c0:18:85:6f:2c:56',
                                    'c0:18:85:79:24:e7',
                                    'c0:f8:da:a7:e9:fe',
                                    'c4:64:13:11:23:b9',
                                    'c4:64:13:11:24:d6',
                                    'c4:85:08:69:9c:18',
                                    'c4:85:08:6a:0b:c6',
                                    'c4:85:08:22:d6:93',
                                    'c4:85:08:22:ff:74',
                                    'c4:85:08:24:b8:c3',
                                    'c4:85:08:34:39:74',
                                    'c4:85:08:37:c7:38',
                                    'c4:85:08:41:97:e5',
                                    'c4:85:08:56:d8:d5',
                                    'c4:85:08:57:0c:c4',
                                    'c4:17:fe:b5:48:8a',
                                    'c4:17:fe:55:91:75',
                                    'c4:17:fe:5c:24:68',
                                    'c4:2c:03:00:e7:8c',
                                    'c4:46:19:15:9f:88',
                                    'c4:46:19:5f:74:ef',
                                    '14:74:11:9e:33:49',
                                    '14:8f:c6:8e:63:34',
                                    '14:8f:c6:94:84:b8',
                                    '14:8f:c6:59:d7:ce',
                                    '14:8f:c6:5b:80:fe',
                                    '14:10:9f:ce:46:57',
                                    '14:10:9f:e9:a3:d0',
                                    '14:10:9f:f1:0e:a2',
                                    '14:10:9f:f1:99:a6',
                                    '14:10:9f:f1:9b:5a',
                                    '14:5a:05:a0:f0:a7',
                                    'c8:bc:c8:bc:e7:28',
                                    'c8:bc:c8:cc:8e:85',
                                    'c8:bc:c8:cc:9a:b6',
                                    'c8:bc:c8:ce:3e:88',
                                    'c8:bc:c8:d5:ff:25',
                                    'c8:bc:c8:d7:28:04',
                                    'c8:bc:c8:d9:92:35',
                                    'c8:bc:c8:dd:b7:01',
                                    'c8:bc:c8:dd:e5:56',
                                    'c8:bc:c8:ea:0c:60',
                                    'c8:f7:33:20:a6:89',
                                    'c8:60:00:0d:8f:8b',
                                    'c8:60:00:47:19:6b',
                                    'cc:af:78:73:a6:a0',
                                    'cc:af:78:15:18:89',
                                    'cc:af:78:2a:02:7c',
                                    'cc:af:78:4d:78:ba',
                                    'cc:08:e0:a2:23:90',
                                    'cc:52:af:5e:b7:67',
                                    'd0:c1:b1:82:2b:7f',
                                    'd0:df:9a:71:d8:2d',
                                    'd0:df:9a:81:09:37',
                                    'd0:df:9a:94:72:96',
                                    'd0:df:9a:e3:3d:ee',
                                    'd0:df:9a:21:f2:97',
                                    'd0:df:9a:04:4e:4a',
                                    'd0:df:9a:42:70:90',
                                    'd0:23:db:e4:a7:32',
                                    'd0:51:62:64:b5:68',
                                    'd4:9a:20:65:3a:98',
                                    'd4:9a:20:66:3f:0d',
                                    'd4:9a:20:66:51:4d',
                                    'd4:9a:20:6b:0e:e8',
                                    'd4:9a:20:6e:1c:23',
                                    'd4:9a:20:71:d6:db',
                                    'd4:9a:20:71:2d:a5',
                                    'd4:9a:20:72:b8:1e',
                                    'd4:9a:20:72:ba:28',
                                    'd4:9a:20:72:d6:83',
                                    'd4:9a:20:72:e4:7e',
                                    'd4:9a:20:5d:08:9b',
                                    'd8:9e:3f:7d:07:a6',
                                    'd8:a2:5e:8c:88:79',
                                    'd8:a2:5e:8e:ff:28',
                                    'd8:a2:5e:8e:48:c4',
                                    'd8:a2:5e:91:9e:e5',
                                    'd8:a2:5e:91:a1:34',
                                    'd8:a2:5e:91:36:12',
                                    'd8:a2:5e:96:f9:8a',
                                    'd8:a2:5e:97:f7:91',
                                    'd8:a2:5e:98:14:b1',
                                    'd8:a2:5e:13:00:f2',
                                    'd8:24:bd:d4:d3:10',
                                    'd8:24:bd:d4:e0:80',
                                    'd8:24:bd:e8:75:f0',
                                    'd8:24:bd:e8:5d:70',
                                    'd8:30:62:81:6e:9f',
                                    'dc:85:de:13:b1:7a',
                                    'dc:85:de:15:d1:21',
                                    'e0:b9:a5:80:12:73',
                                    'e0:b9:a5:83:1b:d5',
                                    'e0:b9:a5:9d:00:f8',
                                    'e0:b9:a5:ae:01:43',
                                    'e0:b9:a5:c5:e8:12',
                                    'e0:b9:a5:cc:81:0d',
                                    'e0:b9:ba:87:f0:31',
                                    'e0:b9:ba:d5:47:ba',
                                    'e0:b9:ba:2b:eb:f0',
                                    'e0:c9:7a:e1:1e:2e',
                                    'e0:ca:94:77:e2:76',
                                    'e0:ca:94:8d:3e:05',
                                    'e0:ca:94:1d:15:ae',
                                    'e0:ca:94:24:ec:6f',
                                    'e0:ca:94:5e:be:1a',
                                    'e0:f8:47:12:76:ea',
                                    'e0:f8:47:13:02:b4',
                                    'e0:f8:47:17:b6:38',
                                    'e0:f8:47:1a:4d:48',
                                    'e0:f8:47:1b:f9:00',
                                    'e0:f8:47:2b:8b:44',
                                    'e0:f8:47:35:7b:f6',
                                    'e0:f8:47:39:8f:2c',
                                    'e0:f8:47:39:e3:0e',
                                    'e0:f8:47:43:cc:74',
                                    'e0:2a:82:58:df:fe',
                                    'e0:06:e6:6a:6c:0e',
                                    'e0:06:e6:93:5b:21',
                                    'e0:06:e6:96:d4:a1',
                                    'e0:06:e6:11:70:b7',
                                    'e0:06:e6:41:d7:d7',
                                    'e0:06:e6:4c:eb:9f',
                                    'e4:ce:8f:0f:1c:64',
                                    'e4:ce:8f:0f:04:58',
                                    'e4:ce:8f:16:fc:00',
                                    'e4:ce:8f:35:bb:f2',
                                    'e4:ce:8f:36:00:ee',
                                    'e4:ce:8f:47:8e:fc',
                                    'e4:ce:8f:4a:bd:8e',
                                    'e4:ce:8f:4b:21:16',
                                    'e4:ce:8f:50:71:0c',
                                    'e4:d5:3d:4c:d7:f7',
                                    'e8:e7:32:27:23:5f',
                                    'e8:e7:32:27:31:02',
                                    'e8:e7:32:27:38:30',
                                    'e8:e7:32:27:63:a0',
                                    'e8:e7:32:27:63:f4',
                                    'e8:e7:32:2a:e0:9e',
                                    'e8:e7:32:2a:e0:b6',
                                    'e8:e7:32:2a:e8:a4',
                                    'e8:e7:32:2a:e8:bc',
                                    'e8:e7:32:2b:cc:e7',
                                    'e8:e7:32:4b:78:f8',
                                    'e8:e7:32:4b:79:13',
                                    'e8:e7:32:4b:7b:b4',
                                    'e8:e7:32:4b:86:db',
                                    'e8:e7:32:4b:8a:cc',
                                    'e8:e7:32:4b:9b:d8',
                                    'e8:e7:32:5c:be:b8',
                                    'e8:e7:32:5c:be:d3',
                                    'e8:03:9a:8b:6d:12',
                                    'e8:39:df:6c:b3:07',
                                    'e8:39:df:84:76:cc',
                                    'e8:39:df:3f:05:c5',
                                    'e8:06:88:64:16:09',
                                    'e8:3e:b6:88:c2:8b',
                                    'e8:3e:b6:40:a8:27',
                                    'ec:55:f9:6f:ed:de',
                                    '18:a9:05:e3:0c:f5',
                                    '18:e2:c2:96:78:48',
                                    '18:20:32:bd:67:77',
                                    '18:34:51:17:ff:78',
                                    '18:3d:a2:51:82:40',
                                    'f0:7b:cb:01:a5:2c',
                                    'f0:7b:cb:18:ce:2a',
                                    'f0:b4:79:13:51:14',
                                    'f0:b4:79:14:aa:e7',
                                    'f0:b4:79:14:af:78',
                                    'f0:b4:79:14:b2:c6',
                                    'f0:b4:79:14:d5:04',
                                    'f0:b4:79:15:40:f2',
                                    'f0:b4:79:15:4a:4d',
                                    'f0:b4:79:16:d5:1c',
                                    'f0:b4:79:18:e4:4f',
                                    'f0:b4:79:19:71:e2',
                                    'f0:b4:79:1b:e1:d5',
                                    'f0:b4:79:1b:e4:5b',
                                    'f0:b4:79:1c:00:c4',
                                    'f0:b4:79:1c:12:90',
                                    'f0:b4:79:1c:4f:99',
                                    'f0:b4:79:1f:5b:76',
                                    'f0:cb:a1:c5:24:f0',
                                    'f0:cb:a1:ca:da:f7',
                                    'f0:dc:e2:6b:35:48',
                                    'f8:1e:df:d9:9f:79',
                                    'f8:1e:df:e2:ab:87',
                                    'f8:1e:df:e4:86:b6',
                                    'f8:1e:df:e9:69:37',
                                    'f8:1e:df:e9:ee:30',
                                    'f8:1e:df:eb:11:47',
                                    'f8:1e:df:f2:77:95',
                                    'f8:1e:df:f2:63:c8',
                                    'f8:1e:df:32:a2:50',
                                    '1c:69:a5:51:15:8c',
                                    '1c:4b:d6:6f:78:90',
                                    '1c:4b:d6:80:6c:00',
                                    '1c:4b:d6:f2:d2:b8',
                                    '1c:4b:d6:1f:d4:05',
                                    '1c:62:b8:5f:8d:00',
                                    '20:68:9d:bb:fd:17',
                                    '20:68:9d:e9:5c:58',
                                    '20:7c:8f:6b:79:0f',
                                    '20:c9:d0:7c:fc:3d',
                                    '20:c9:d0:80:c8:f5',
                                    '20:c9:d0:c3:10:f9',
                                    '20:c9:d0:c9:25:37',
                                    '20:c9:d0:d0:42:e9',
                                    '20:c9:d0:d1:45:05',
                                    '20:c9:d0:d1:56:0d',
                                    '20:c9:d0:d2:05:39',
                                    '20:c9:d0:d4:c8:ad',
                                    '20:c9:d0:d6:75:03',
                                    '20:c9:d0:da:82:61',
                                    '20:c9:d0:da:b2:81',
                                    '20:c9:d0:dd:d1:fb',
                                    '20:c9:d0:e0:83:db',
                                    '20:c9:d0:e4:2f:85',
                                    '20:c9:d0:44:8c:cb',
                                    '20:54:76:90:5c:5d',
                                    '24:77:03:e2:30:74',
                                    '24:ec:99:23:1c:c6',
                                    '24:ec:99:4c:24:8a',
                                    '04:0c:ce:d3:ed:18',
                                    '04:0c:ce:d5:9f:a8',
                                    '04:0c:ce:d5:19:da',
                                    '04:0c:ce:d5:1c:4e',
                                    '04:0c:ce:dc:82:50',
                                    '04:0c:ce:dc:c3:40',
                                    '04:0c:ce:de:70:90',
                                    '04:0c:ce:e4:62:42',
                                    '04:0c:ce:20:b9:aa',
                                    '04:1e:64:73:d2:b3',
                                    '04:1e:64:f8:5a:bd',
                                    '04:1e:64:3b:91:24',
                                    '04:1e:64:45:98:da',
                                    '04:54:53:91:f4:d7',
                                    '28:6a:ba:7b:5d:d0',
                                    '28:6a:ba:27:d2:3c',
                                    '28:6a:ba:3d:18:a8',
                                    '28:6a:ba:4b:95:ec',
                                    '28:94:0f:c1:1d:90',
                                    '28:94:0f:d6:bd:81',
                                    '28:94:0f:d6:bd:02',
                                    '28:cf:da:d6:81:fc',
                                    '28:cf:da:df:c4:50',
                                    '28:cf:da:e0:f1:1e',
                                    '28:cf:da:e7:68:26',
                                    '28:cf:da:e7:16:84',
                                    '28:cf:da:e8:6e:6c',
                                    '28:cf:da:e8:f6:c6',
                                    '28:cf:da:ec:03:d2',
                                    '28:cf:da:ed:96:88',
                                    '28:37:37:24:94:1a',
                                    '28:37:37:4d:96:f5',
                                    '2c:81:58:fd:18:17',
                                    '30:85:a9:e4:08:89',
                                    '30:39:26:e5:84:84',
                                    '34:bb:1f:35:b7:11',
                                    '34:c0:59:2c:97:52',
                                    '34:15:9e:8d:d4:71',
                                    '34:15:9e:91:f8:f0',
                                    '34:15:9e:94:10:71',
                                    '34:15:9e:95:e1:1a',
                                    '34:15:9e:e8:39:4f',
                                    '34:51:c9:4c:71:d1',
                                    '38:59:f9:44:5f:b2',
                                    '3c:07:54:23:60:58',
                                    '40:6c:8f:1d:c0:7f',
                                    '40:6c:8f:42:b0:90',
                                    '44:6d:57:0d:03:2a',
                                    '44:6d:57:87:be:af',
                                    '44:6d:57:03:11:09',
                                    '44:2a:60:6b:d6:60',
                                    '44:2a:60:94:f3:1d',
                                    '44:2a:60:f2:f1:10',
                                    '44:4c:0c:dd:2a:b9',
                                    '48:5d:60:10:5a:39',
                                    '48:5d:60:b0:8c:ac',
                                    '48:5d:60:be:de:0e',
                                    '48:5d:60:bf:18:a1',
                                    '48:5d:60:f5:96:80',
                                    '48:5d:60:25:da:ce',
                                    '48:5d:60:39:91:49',
                                    '48:5d:60:5a:24:f8',
                                    '4c:0f:6e:01:4d:9f',
                                    '4c:0f:6e:12:a1:fc',
                                    '4c:0f:6e:e1:0d:bf',
                                    '4c:0f:6e:fa:2b:fd',
                                    '4c:b1:99:cc:85:9f',
                                    '4c:bc:a5:ad:bf:6c',
                                    '4c:ed:de:65:5e:8e',
                                    '4c:ed:de:67:ad:2a',
                                    '08:ed:b9:72:6b:33',
                                    '08:ed:b9:f8:65:d1',
                                    '08:ed:b9:f8:57:07',
                                    '08:ed:b9:04:94:12',
                                    '08:ed:b9:34:c2:f4',
                                    '08:ed:b9:06:23:a2',
                                    '08:3e:8e:b2:99:ed',
                                    '08:3e:8e:b2:c5:e1',
                                    '08:3e:8e:cd:23:b3',
                                    '50:cc:f8:21:c2:58',
                                    '50:ea:d6:e3:1b:0f',
                                    '50:46:5d:29:77:c3',
                                    '54:04:a6:96:01:e1',
                                    '54:04:a6:07:54:9d',
                                    '58:94:6b:6b:c2:fc',
                                    '58:94:6b:d2:d4:e4',
                                    '58:b0:35:66:11:6e',
                                    '58:b0:35:6c:f7:e4',
                                    '58:b0:35:6d:02:35',
                                    '58:b0:35:75:f3:93',
                                    '58:b0:35:7e:cf:d3',
                                    '58:b0:35:80:a8:93',
                                    '58:b0:35:fc:6b:30',
                                    '58:b0:35:5c:95:64',
                                    '58:1f:aa:c8:62:d9',
                                    '58:55:ca:f5:64:a9',
                                    '58:55:ca:f6:86:6f',
                                    '58:55:ca:f6:ef:83',
                                    '58:55:ca:f8:15:4d',
                                    '58:55:ca:f8:5b:39',
                                    '5c:0a:5b:69:1d:c7',
                                    '5c:96:9d:70:20:c7',
                                    '5c:96:9d:76:2a:7f',
                                    '5c:96:9d:7a:9c:fb',
                                    '5c:96:9d:7c:71:c9',
                                    '5c:96:9d:7c:5a:15',
                                    '5c:96:9d:7d:1b:63',
                                    '5c:96:9d:8a:96:2f',
                                    '5c:96:9d:8b:05:db',
                                    '5c:96:9d:dd:d0:4d',
                                    '5c:59:48:66:e8:90',
                                    '5c:59:48:8f:1f:80',
                                    '60:c5:47:0a:cb:34',
                                    '60:c5:47:72:76:c3',
                                    '60:c5:47:79:34:85',
                                    '60:c5:47:8c:75:e0',
                                    '60:c5:47:96:70:32',
                                    '60:c5:47:96:c3:26',
                                    '60:c5:47:97:25:8a',
                                    '60:c5:47:04:7f:c0',
                                    '60:c5:47:04:81:d8',
                                    '60:c5:47:07:6d:90',
                                    '60:d8:19:65:c4:df',
                                    '60:d8:19:08:a2:92',
                                    '60:33:4b:01:c7:d8',
                                    '60:33:4b:01:dd:f5',
                                    '60:33:4b:23:73:cf',
                                    '60:33:4b:23:62:e2',
                                    '60:33:4b:26:86:b9',
                                    '60:33:4b:26:8b:b7',
                                    '60:33:4b:26:bc:8f',
                                    '60:45:bd:24:de:76',
                                    '00:08:ca:e7:7e:29',
                                    '78:dd:08:c6:9c:ce',
                                    'b8:ff:61:50:40:16',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '1025',
                        IFNAME           => ' Stacking Port 1/StackA',
                        IFDESCR          => 'Alcatel-Lucent Stacking Port 1/StackA',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3300) 0:00:33.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1026',
                        IFNAME           => ' Stacking Port 1/StackB',
                        IFDESCR          => 'Alcatel-Lucent Stacking Port 1/StackB',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3300) 0:00:33.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '13600001',
                        IFNAME           => 'admin',
                        IFDESCR          => 'admin',
                        IFTYPE           => '136',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IP               => '192.168.1.127',
                        MAC              => 'e8:e7:32:2b:c1:e2',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(57238810) 6 days, 14:59:48.10',
                        IFINOCTETS       => '173601851',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '205881648',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '13600154',
                        IFNAME           => 'Loopback',
                        IFDESCR          => 'Loopback',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '32768',
                        IP               => '127.0.0.1',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(511) 0:00:05.11',
                        IFINOCTETS       => '1305305095',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1305406678',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
    'alcatel/unknown.2.walk' => [
        {
            MANUFACTURER => 'Alcatel-Lucent',
            TYPE         => 'NETWORKING',
            DESCRIPTION  => 'Alcatel-Lucent 6.4.4.342.R01 GA, April 18, 2011.',
            SNMPHOSTNAME => 'CP-153-127',
            MAC          => 'e8:e7:32:2b:c1:e2',
        },
        {
            MANUFACTURER => 'Alcatel-Lucent',
            TYPE         => 'NETWORKING',
            DESCRIPTION  => 'Alcatel-Lucent 6.4.4.342.R01 GA, April 18, 2011.',
            SNMPHOSTNAME => 'CP-153-127',
            MAC          => 'e8:e7:32:2b:c1:e2',
            MODELSNMP    => 'Networking2189',
            FIRMWARE     => undef,
            SERIAL       => 'M4682816',
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Alcatel-Lucent',
                TYPE         => 'NETWORKING',
                MODEL        => 'OS6400-P24',
                COMMENTS     => 'Alcatel-Lucent 6.4.4.342.R01 GA, April 18, 2011.',
                CONTACT      => 'Alcatel-Lucent, http://alcatel-lucent.com/wps/portal/enterprise',
                NAME         => 'CP-153-127',
                LOCATION     => 'Unknown',
                SERIAL       => 'M4682816',
                MAC          => 'e8:e7:32:2b:c1:e2',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1001',
                        IFNAME           => '1/1',
                        IFDESCR          => 'Alcatel-Lucent 1/1',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '9216',
                        MAC              => 'e8:e7:32:2b:c1:e4',
                        IFLASTCHANGE     => '(163281300) 18 days, 21:33:33.00',
                        IFINOCTETS       => '11031705',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '135933304',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1002',
                        IFNAME           => '1/2',
                        IFDESCR          => 'Alcatel-Lucent 1/2',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '9216',
                        MAC              => 'e8:e7:32:2b:c1:e5',
                        IFLASTCHANGE     => '(7100) 0:01:11.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1003',
                        IFNAME           => '1/3',
                        IFDESCR          => 'Alcatel-Lucent 1/3',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '9216',
                        MAC              => 'e8:e7:32:2b:c1:e6',
                        IFLASTCHANGE     => '(7100) 0:01:11.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1004',
                        IFNAME           => '1/4',
                        IFDESCR          => 'Alcatel-Lucent 1/4',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '9216',
                        MAC              => 'e8:e7:32:2b:c1:e7',
                        IFLASTCHANGE     => '(7100) 0:01:11.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1005',
                        IFNAME           => '1/5',
                        IFDESCR          => 'Alcatel-Lucent 1/5',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '9216',
                        MAC              => 'e8:e7:32:2b:c1:e8',
                        IFLASTCHANGE     => '(7100) 0:01:11.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1006',
                        IFNAME           => '1/6',
                        IFDESCR          => 'Alcatel-Lucent 1/6',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '9216',
                        MAC              => 'e8:e7:32:2b:c1:e9',
                        IFLASTCHANGE     => '(7100) 0:01:11.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1007',
                        IFNAME           => '1/7',
                        IFDESCR          => 'Alcatel-Lucent 1/7',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '9216',
                        MAC              => 'e8:e7:32:2b:c1:ea',
                        IFLASTCHANGE     => '(7100) 0:01:11.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1008',
                        IFNAME           => '1/8',
                        IFDESCR          => 'Alcatel-Lucent 1/8',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '9216',
                        MAC              => 'e8:e7:32:2b:c1:eb',
                        IFLASTCHANGE     => '(133316300) 15 days, 10:19:23.00',
                        IFINOCTETS       => '68783504',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '167030715',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '00:80:9f:af:b1:09',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '1009',
                        IFNAME           => '1/9',
                        IFDESCR          => 'Alcatel-Lucent 1/9',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '9216',
                        MAC              => 'e8:e7:32:2b:c1:ec',
                        IFLASTCHANGE     => '(7100) 0:01:11.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1010',
                        IFNAME           => '1/10',
                        IFDESCR          => 'Alcatel-Lucent 1/10',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '9216',
                        MAC              => 'e8:e7:32:2b:c1:ed',
                        IFLASTCHANGE     => '(7100) 0:01:11.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1011',
                        IFNAME           => '1/11',
                        IFDESCR          => 'Alcatel-Lucent 1/11',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '9216',
                        MAC              => 'e8:e7:32:2b:c1:ee',
                        IFLASTCHANGE     => '(34170400) 3 days, 22:55:04.00',
                        IFINOCTETS       => '197055100',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '347793172',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '00:80:9f:af:b1:2e',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '1012',
                        IFNAME           => '1/12',
                        IFDESCR          => 'Alcatel-Lucent 1/12',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '9216',
                        MAC              => 'e8:e7:32:2b:c1:ef',
                        IFLASTCHANGE     => '(34163100) 3 days, 22:53:51.00',
                        IFINOCTETS       => '257499013',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '408235574',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '00:80:9f:af:b0:fe',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '1013',
                        IFNAME           => '1/13',
                        IFDESCR          => 'Alcatel-Lucent 1/13',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '9216',
                        MAC              => 'e8:e7:32:2b:c1:f0',
                        IFLASTCHANGE     => '(34193000) 3 days, 22:58:50.00',
                        IFINOCTETS       => '603370409',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '754298162',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '00:80:9f:af:b1:0c',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '1014',
                        IFNAME           => '1/14',
                        IFDESCR          => 'Alcatel-Lucent 1/14',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '9216',
                        MAC              => 'e8:e7:32:2b:c1:f1',
                        IFLASTCHANGE     => '(103428100) 11 days, 23:18:01.00',
                        IFINOCTETS       => '28001214',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '126345688',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '00:80:9f:af:b1:32',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '1015',
                        IFNAME           => '1/15',
                        IFDESCR          => 'Alcatel-Lucent 1/15',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '9216',
                        MAC              => 'e8:e7:32:2b:c1:f2',
                        IFLASTCHANGE     => '(7100) 0:01:11.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1016',
                        IFNAME           => '1/16',
                        IFDESCR          => 'Alcatel-Lucent 1/16',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '9216',
                        MAC              => 'e8:e7:32:2b:c1:f3',
                        IFLASTCHANGE     => '(7100) 0:01:11.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1017',
                        IFNAME           => '1/17',
                        IFDESCR          => 'Alcatel-Lucent 1/17',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '9216',
                        MAC              => 'e8:e7:32:2b:c1:f4',
                        IFLASTCHANGE     => '(7100) 0:01:11.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1018',
                        IFNAME           => '1/18',
                        IFDESCR          => 'Alcatel-Lucent 1/18',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '9216',
                        MAC              => 'e8:e7:32:2b:c1:f5',
                        IFLASTCHANGE     => '(7100) 0:01:11.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1019',
                        IFNAME           => '1/19',
                        IFDESCR          => 'Alcatel-Lucent 1/19',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '9216',
                        MAC              => 'e8:e7:32:2b:c1:f6',
                        IFLASTCHANGE     => '(7100) 0:01:11.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1020',
                        IFNAME           => '1/20',
                        IFDESCR          => 'Alcatel-Lucent 1/20',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '9216',
                        MAC              => 'e8:e7:32:2b:c1:f7',
                        IFLASTCHANGE     => '(7100) 0:01:11.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1021',
                        IFNAME           => '1/21',
                        IFDESCR          => 'Alcatel-Lucent 1/21',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '9216',
                        MAC              => 'e8:e7:32:2b:c1:f8',
                        IFLASTCHANGE     => '(7100) 0:01:11.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1022',
                        IFNAME           => '1/22',
                        IFDESCR          => 'Alcatel-Lucent 1/22',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '9216',
                        MAC              => 'e8:e7:32:2b:c1:f9',
                        IFLASTCHANGE     => '(7100) 0:01:11.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1023',
                        IFNAME           => '1/23',
                        IFDESCR          => 'Alcatel-Lucent 1/23',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '9216',
                        MAC              => 'e8:e7:32:2b:c1:fa',
                        IFLASTCHANGE     => '(7100) 0:01:11.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1024',
                        IFNAME           => '1/24',
                        IFDESCR          => 'Alcatel-Lucent 1/24',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '9216',
                        MAC              => 'e8:e7:32:2b:c1:fb',
                        IFLASTCHANGE     => '(11700) 0:01:57.00',
                        IFINOCTETS       => '2236854165',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1199596145',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '00:00:5e:00:01:02',
                                    '00:0b:5f:cc:d8:80',
                                    '00:80:9f:af:b0:f2',
                                    '00:80:9f:af:b0:f8',
                                    '00:80:9f:af:b1:01',
                                    '00:80:9f:af:b1:0a',
                                    '00:80:9f:af:b1:10',
                                    '00:80:9f:af:b1:13',
                                    '00:80:9f:af:b1:15',
                                    '00:80:9f:af:b1:16',
                                    '00:80:9f:af:b1:18',
                                    '00:80:9f:af:b1:1a',
                                    '00:80:9f:af:b1:1b',
                                    '00:80:9f:af:b1:1e',
                                    '00:80:9f:af:b1:21',
                                    '00:80:9f:af:b1:22',
                                    '00:80:9f:af:b1:24',
                                    '00:80:9f:af:b1:25',
                                    '00:80:9f:af:b1:2d',
                                    '00:80:9f:af:b1:2f',
                                    '00:80:9f:af:b1:3c',
                                    '00:80:9f:b3:aa:6c',
                                    '00:13:5f:fa:ee:20',
                                    '00:13:5f:fa:f1:90',
                                    '00:13:5f:fa:f1:30',
                                    '00:13:5f:fa:f2:a0',
                                    '00:13:5f:fa:f4:d0',
                                    '00:13:5f:fa:f5:70',
                                    '00:13:5f:fa:fa:60',
                                    '00:13:5f:fa:fb:b0',
                                    '00:14:6a:d6:b1:94',
                                    '00:14:6a:d6:b1:aa',
                                    '00:14:6a:d6:b1:b6',
                                    '00:14:6a:d6:b1:b8',
                                    '00:14:6a:d6:b1:ce',
                                    '00:14:6a:d6:b1:d8',
                                    '00:14:6a:d6:b1:e8',
                                    '00:14:6a:d6:b1:28',
                                    '00:14:6a:d6:b1:32',
                                    '00:14:6a:d6:b1:42',
                                    '00:14:6a:d6:b1:48',
                                    '00:14:6a:d6:b1:4e',
                                    '00:14:6a:d6:b1:56',
                                    '00:14:6a:d6:b1:5e',
                                    '00:14:6a:d6:b1:62',
                                    '00:14:6a:d6:b2:68',
                                    '00:14:6a:d6:b2:8e',
                                    '00:14:6a:d6:b2:b8',
                                    '00:14:6a:d6:b2:ba',
                                    '00:14:6a:d6:b2:c0',
                                    '00:14:6a:d6:b2:14',
                                    '00:14:6a:d6:b2:d0',
                                    '00:14:6a:d6:b2:f0',
                                    '00:14:6a:d6:b2:f4',
                                    '00:14:6a:d6:b2:fa',
                                    '00:14:6a:d6:b2:1e',
                                    '00:14:6a:d6:b2:32',
                                    '00:14:6a:d6:b3:14',
                                    '00:14:6a:d6:b3:1e',
                                    '00:19:d1:92:0c:4c',
                                    '00:1b:b1:f4:5e:10',
                                    '00:1b:53:fd:d5:84',
                                    '00:1b:54:d6:39:1a',
                                    '00:1c:c0:21:c6:a8',
                                    '00:1c:c4:49:5d:32',
                                    '00:1f:e2:12:56:70',
                                    '00:20:a6:49:7e:d7',
                                    '00:20:a6:49:7e:da',
                                    '00:20:a6:49:7e:f8',
                                    '00:20:a6:49:7e:fb',
                                    '00:20:a6:49:7f:04',
                                    '00:20:a6:49:7f:07',
                                    '00:21:59:92:fb:7f',
                                    '00:22:43:61:2e:f2',
                                    '00:23:7d:88:0c:11',
                                    '00:23:12:57:dc:52',
                                    '00:24:d2:72:a3:e2',
                                    '00:24:e8:d0:38:38',
                                    '00:24:2c:63:ff:08',
                                    '00:26:b6:15:21:25',
                                    '00:26:bb:1d:3c:1c',
                                    '00:09:3d:00:73:29',
                                    '00:09:3d:00:56:97',
                                    '64:20:0c:ce:8a:89',
                                    '68:a8:6d:23:eb:50',
                                    '74:e1:b6:8b:7e:ac',
                                    '74:2f:68:6f:d7:fc',
                                    '78:92:9c:78:d9:f6',
                                    '78:a3:e4:bf:cc:b2',
                                    '78:dd:08:cb:1a:ba',
                                    '7c:d1:c3:72:e3:ea',
                                    '7c:61:93:90:95:e3',
                                    '88:9f:fa:1a:9f:8c',
                                    '8c:89:a5:3a:b8:84',
                                    '10:9a:dd:a5:32:33',
                                    'b8:ac:6f:94:57:ed',
                                    'd0:df:9a:21:f6:11',
                                    'd4:87:d8:8e:2f:d5',
                                    'd8:30:62:60:12:7c',
                                    'e0:f8:47:41:b5:cc',
                                    'e8:e7:32:27:23:5e',
                                    'e8:e7:32:27:31:02',
                                    'e8:e7:32:27:38:30',
                                    'e8:e7:32:27:63:a0',
                                    'e8:e7:32:27:63:f4',
                                    'e8:e7:32:2a:e0:9e',
                                    'e8:e7:32:2a:e8:a4',
                                    'e8:e7:32:2b:cc:ce',
                                    'ec:85:2f:04:68:ca',
                                    'f8:1e:df:d6:b7:0f',
                                    '04:54:53:04:b3:76',
                                    '30:39:26:26:26:9a',
                                    '40:6c:8f:1d:c0:7f',
                                    '40:6c:8f:42:b0:90',
                                    '5c:ac:4c:1a:44:73',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '1025',
                        IFNAME           => ' Stacking Port 1/StackA',
                        IFDESCR          => 'Alcatel-Lucent Stacking Port 1/StackA',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '0',
                        IFLASTCHANGE     => '(3300) 0:00:33.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1026',
                        IFNAME           => ' Stacking Port 1/StackB',
                        IFDESCR          => 'Alcatel-Lucent Stacking Port 1/StackB',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '0',
                        IFLASTCHANGE     => '(3300) 0:00:33.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '13600001',
                        IFNAME           => 'admin',
                        IFDESCR          => 'admin',
                        IFTYPE           => '136',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => 'e8:e7:32:2b:c1:e2',
                        IFLASTCHANGE     => '(11801) 0:01:58.01',
                        IFINOCTETS       => '25252490',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '26159026',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '13600154',
                        IFNAME           => 'Loopback',
                        IFDESCR          => 'Loopback',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '32768',
                        IFLASTCHANGE     => '(511) 0:00:05.11',
                        IFINOCTETS       => '3686859309',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3686952587',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Alcatel-Lucent',
                TYPE         => 'NETWORKING',
                MODEL        => 'OS6400-P24',
                COMMENTS     => 'Alcatel-Lucent 6.4.4.342.R01 GA, April 18, 2011.',
                CONTACT      => 'Alcatel-Lucent, http://alcatel-lucent.com/wps/portal/enterprise',
                NAME         => 'CP-153-127',
                LOCATION     => 'Unknown',
                SERIAL       => 'M4682816',
                FIRMWARE     => 'Alcatel-Lucent 6.4.4.342.R01 GA, April 18, 2011.',
                MAC          => 'e8:e7:32:2b:c1:e2',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1001',
                        IFNAME           => '1/1',
                        IFDESCR          => 'Alcatel-Lucent 1/1',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '9216',
                        MAC              => 'e8:e7:32:2b:c1:e4',
                        IFLASTCHANGE     => '(163281300) 18 days, 21:33:33.00',
                        IFINOCTETS       => '11031705',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '135933304',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1002',
                        IFNAME           => '1/2',
                        IFDESCR          => 'Alcatel-Lucent 1/2',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '9216',
                        MAC              => 'e8:e7:32:2b:c1:e5',
                        IFLASTCHANGE     => '(7100) 0:01:11.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1003',
                        IFNAME           => '1/3',
                        IFDESCR          => 'Alcatel-Lucent 1/3',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '9216',
                        MAC              => 'e8:e7:32:2b:c1:e6',
                        IFLASTCHANGE     => '(7100) 0:01:11.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1004',
                        IFNAME           => '1/4',
                        IFDESCR          => 'Alcatel-Lucent 1/4',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '9216',
                        MAC              => 'e8:e7:32:2b:c1:e7',
                        IFLASTCHANGE     => '(7100) 0:01:11.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1005',
                        IFNAME           => '1/5',
                        IFDESCR          => 'Alcatel-Lucent 1/5',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '9216',
                        MAC              => 'e8:e7:32:2b:c1:e8',
                        IFLASTCHANGE     => '(7100) 0:01:11.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1006',
                        IFNAME           => '1/6',
                        IFDESCR          => 'Alcatel-Lucent 1/6',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '9216',
                        MAC              => 'e8:e7:32:2b:c1:e9',
                        IFLASTCHANGE     => '(7100) 0:01:11.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1007',
                        IFNAME           => '1/7',
                        IFDESCR          => 'Alcatel-Lucent 1/7',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '9216',
                        MAC              => 'e8:e7:32:2b:c1:ea',
                        IFLASTCHANGE     => '(7100) 0:01:11.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1008',
                        IFNAME           => '1/8',
                        IFDESCR          => 'Alcatel-Lucent 1/8',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '9216',
                        MAC              => 'e8:e7:32:2b:c1:eb',
                        IFLASTCHANGE     => '(133316300) 15 days, 10:19:23.00',
                        IFINOCTETS       => '68783504',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '167030715',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '00:80:9f:af:b1:09',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '1009',
                        IFNAME           => '1/9',
                        IFDESCR          => 'Alcatel-Lucent 1/9',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '9216',
                        MAC              => 'e8:e7:32:2b:c1:ec',
                        IFLASTCHANGE     => '(7100) 0:01:11.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1010',
                        IFNAME           => '1/10',
                        IFDESCR          => 'Alcatel-Lucent 1/10',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '9216',
                        MAC              => 'e8:e7:32:2b:c1:ed',
                        IFLASTCHANGE     => '(7100) 0:01:11.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1011',
                        IFNAME           => '1/11',
                        IFDESCR          => 'Alcatel-Lucent 1/11',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '9216',
                        MAC              => 'e8:e7:32:2b:c1:ee',
                        IFLASTCHANGE     => '(34170400) 3 days, 22:55:04.00',
                        IFINOCTETS       => '197055100',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '347793172',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '00:80:9f:af:b1:2e',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '1012',
                        IFNAME           => '1/12',
                        IFDESCR          => 'Alcatel-Lucent 1/12',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '9216',
                        MAC              => 'e8:e7:32:2b:c1:ef',
                        IFLASTCHANGE     => '(34163100) 3 days, 22:53:51.00',
                        IFINOCTETS       => '257499013',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '408235574',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '00:80:9f:af:b0:fe',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '1013',
                        IFNAME           => '1/13',
                        IFDESCR          => 'Alcatel-Lucent 1/13',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '9216',
                        MAC              => 'e8:e7:32:2b:c1:f0',
                        IFLASTCHANGE     => '(34193000) 3 days, 22:58:50.00',
                        IFINOCTETS       => '603370409',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '754298162',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '00:80:9f:af:b1:0c',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '1014',
                        IFNAME           => '1/14',
                        IFDESCR          => 'Alcatel-Lucent 1/14',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '9216',
                        MAC              => 'e8:e7:32:2b:c1:f1',
                        IFLASTCHANGE     => '(103428100) 11 days, 23:18:01.00',
                        IFINOCTETS       => '28001214',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '126345688',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '00:80:9f:af:b1:32',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '1015',
                        IFNAME           => '1/15',
                        IFDESCR          => 'Alcatel-Lucent 1/15',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '9216',
                        MAC              => 'e8:e7:32:2b:c1:f2',
                        IFLASTCHANGE     => '(7100) 0:01:11.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1016',
                        IFNAME           => '1/16',
                        IFDESCR          => 'Alcatel-Lucent 1/16',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '9216',
                        MAC              => 'e8:e7:32:2b:c1:f3',
                        IFLASTCHANGE     => '(7100) 0:01:11.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1017',
                        IFNAME           => '1/17',
                        IFDESCR          => 'Alcatel-Lucent 1/17',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '9216',
                        MAC              => 'e8:e7:32:2b:c1:f4',
                        IFLASTCHANGE     => '(7100) 0:01:11.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1018',
                        IFNAME           => '1/18',
                        IFDESCR          => 'Alcatel-Lucent 1/18',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '9216',
                        MAC              => 'e8:e7:32:2b:c1:f5',
                        IFLASTCHANGE     => '(7100) 0:01:11.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1019',
                        IFNAME           => '1/19',
                        IFDESCR          => 'Alcatel-Lucent 1/19',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '9216',
                        MAC              => 'e8:e7:32:2b:c1:f6',
                        IFLASTCHANGE     => '(7100) 0:01:11.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1020',
                        IFNAME           => '1/20',
                        IFDESCR          => 'Alcatel-Lucent 1/20',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '9216',
                        MAC              => 'e8:e7:32:2b:c1:f7',
                        IFLASTCHANGE     => '(7100) 0:01:11.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1021',
                        IFNAME           => '1/21',
                        IFDESCR          => 'Alcatel-Lucent 1/21',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '9216',
                        MAC              => 'e8:e7:32:2b:c1:f8',
                        IFLASTCHANGE     => '(7100) 0:01:11.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1022',
                        IFNAME           => '1/22',
                        IFDESCR          => 'Alcatel-Lucent 1/22',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '9216',
                        MAC              => 'e8:e7:32:2b:c1:f9',
                        IFLASTCHANGE     => '(7100) 0:01:11.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1023',
                        IFNAME           => '1/23',
                        IFDESCR          => 'Alcatel-Lucent 1/23',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '9216',
                        MAC              => 'e8:e7:32:2b:c1:fa',
                        IFLASTCHANGE     => '(7100) 0:01:11.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1024',
                        IFNAME           => '1/24',
                        IFDESCR          => 'Alcatel-Lucent 1/24',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '9216',
                        MAC              => 'e8:e7:32:2b:c1:fb',
                        IFLASTCHANGE     => '(11700) 0:01:57.00',
                        IFINOCTETS       => '2236854165',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1199596145',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '00:00:5e:00:01:02',
                                    '00:0b:5f:cc:d8:80',
                                    '00:80:9f:af:b0:f2',
                                    '00:80:9f:af:b0:f8',
                                    '00:80:9f:af:b1:01',
                                    '00:80:9f:af:b1:0a',
                                    '00:80:9f:af:b1:10',
                                    '00:80:9f:af:b1:13',
                                    '00:80:9f:af:b1:15',
                                    '00:80:9f:af:b1:16',
                                    '00:80:9f:af:b1:18',
                                    '00:80:9f:af:b1:1a',
                                    '00:80:9f:af:b1:1b',
                                    '00:80:9f:af:b1:1e',
                                    '00:80:9f:af:b1:21',
                                    '00:80:9f:af:b1:22',
                                    '00:80:9f:af:b1:24',
                                    '00:80:9f:af:b1:25',
                                    '00:80:9f:af:b1:2d',
                                    '00:80:9f:af:b1:2f',
                                    '00:80:9f:af:b1:3c',
                                    '00:80:9f:b3:aa:6c',
                                    '00:13:5f:fa:ee:20',
                                    '00:13:5f:fa:f1:90',
                                    '00:13:5f:fa:f1:30',
                                    '00:13:5f:fa:f2:a0',
                                    '00:13:5f:fa:f4:d0',
                                    '00:13:5f:fa:f5:70',
                                    '00:13:5f:fa:fa:60',
                                    '00:13:5f:fa:fb:b0',
                                    '00:14:6a:d6:b1:94',
                                    '00:14:6a:d6:b1:aa',
                                    '00:14:6a:d6:b1:b6',
                                    '00:14:6a:d6:b1:b8',
                                    '00:14:6a:d6:b1:ce',
                                    '00:14:6a:d6:b1:d8',
                                    '00:14:6a:d6:b1:e8',
                                    '00:14:6a:d6:b1:28',
                                    '00:14:6a:d6:b1:32',
                                    '00:14:6a:d6:b1:42',
                                    '00:14:6a:d6:b1:48',
                                    '00:14:6a:d6:b1:4e',
                                    '00:14:6a:d6:b1:56',
                                    '00:14:6a:d6:b1:5e',
                                    '00:14:6a:d6:b1:62',
                                    '00:14:6a:d6:b2:68',
                                    '00:14:6a:d6:b2:8e',
                                    '00:14:6a:d6:b2:b8',
                                    '00:14:6a:d6:b2:ba',
                                    '00:14:6a:d6:b2:c0',
                                    '00:14:6a:d6:b2:14',
                                    '00:14:6a:d6:b2:d0',
                                    '00:14:6a:d6:b2:f0',
                                    '00:14:6a:d6:b2:f4',
                                    '00:14:6a:d6:b2:fa',
                                    '00:14:6a:d6:b2:1e',
                                    '00:14:6a:d6:b2:32',
                                    '00:14:6a:d6:b3:14',
                                    '00:14:6a:d6:b3:1e',
                                    '00:19:d1:92:0c:4c',
                                    '00:1b:b1:f4:5e:10',
                                    '00:1b:53:fd:d5:84',
                                    '00:1b:54:d6:39:1a',
                                    '00:1c:c0:21:c6:a8',
                                    '00:1c:c4:49:5d:32',
                                    '00:1f:e2:12:56:70',
                                    '00:20:a6:49:7e:d7',
                                    '00:20:a6:49:7e:da',
                                    '00:20:a6:49:7e:f8',
                                    '00:20:a6:49:7e:fb',
                                    '00:20:a6:49:7f:04',
                                    '00:20:a6:49:7f:07',
                                    '00:21:59:92:fb:7f',
                                    '00:22:43:61:2e:f2',
                                    '00:23:7d:88:0c:11',
                                    '00:23:12:57:dc:52',
                                    '00:24:d2:72:a3:e2',
                                    '00:24:e8:d0:38:38',
                                    '00:24:2c:63:ff:08',
                                    '00:26:b6:15:21:25',
                                    '00:26:bb:1d:3c:1c',
                                    '00:09:3d:00:73:29',
                                    '00:09:3d:00:56:97',
                                    '64:20:0c:ce:8a:89',
                                    '68:a8:6d:23:eb:50',
                                    '74:e1:b6:8b:7e:ac',
                                    '74:2f:68:6f:d7:fc',
                                    '78:92:9c:78:d9:f6',
                                    '78:a3:e4:bf:cc:b2',
                                    '78:dd:08:cb:1a:ba',
                                    '7c:d1:c3:72:e3:ea',
                                    '7c:61:93:90:95:e3',
                                    '88:9f:fa:1a:9f:8c',
                                    '8c:89:a5:3a:b8:84',
                                    '10:9a:dd:a5:32:33',
                                    'b8:ac:6f:94:57:ed',
                                    'd0:df:9a:21:f6:11',
                                    'd4:87:d8:8e:2f:d5',
                                    'd8:30:62:60:12:7c',
                                    'e0:f8:47:41:b5:cc',
                                    'e8:e7:32:27:23:5e',
                                    'e8:e7:32:27:31:02',
                                    'e8:e7:32:27:38:30',
                                    'e8:e7:32:27:63:a0',
                                    'e8:e7:32:27:63:f4',
                                    'e8:e7:32:2a:e0:9e',
                                    'e8:e7:32:2a:e8:a4',
                                    'e8:e7:32:2b:cc:ce',
                                    'ec:85:2f:04:68:ca',
                                    'f8:1e:df:d6:b7:0f',
                                    '04:54:53:04:b3:76',
                                    '30:39:26:26:26:9a',
                                    '40:6c:8f:1d:c0:7f',
                                    '40:6c:8f:42:b0:90',
                                    '5c:ac:4c:1a:44:73',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '1025',
                        IFNAME           => ' Stacking Port 1/StackA',
                        IFDESCR          => 'Alcatel-Lucent Stacking Port 1/StackA',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '0',
                        IFLASTCHANGE     => '(3300) 0:00:33.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1026',
                        IFNAME           => ' Stacking Port 1/StackB',
                        IFDESCR          => 'Alcatel-Lucent Stacking Port 1/StackB',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '0',
                        IFLASTCHANGE     => '(3300) 0:00:33.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '13600001',
                        IFNAME           => 'admin',
                        IFDESCR          => 'admin',
                        IFTYPE           => '136',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => 'e8:e7:32:2b:c1:e2',
                        IFLASTCHANGE     => '(11801) 0:01:58.01',
                        IFINOCTETS       => '25252490',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '26159026',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '13600154',
                        IFNAME           => 'Loopback',
                        IFDESCR          => 'Loopback',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '32768',
                        IFLASTCHANGE     => '(511) 0:00:05.11',
                        IFINOCTETS       => '3686859309',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3686952587',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
);

plan skip_all => 'SNMP walks database required'
    if !$ENV{SNMPWALK_DATABASE};
plan tests => 4 * scalar keys %tests;

my ($dictionary, $index);
if ($ENV{SNMPMODELS_DICTIONARY}) {
    $dictionary = FusionInventory::Agent::Task::NetDiscovery::Dictionary->new(
        file => $ENV{SNMPMODELS_DICTIONARY}
    );
}
if ($ENV{SNMPMODELS_INDEX}) {
    $index = XML::TreePP->new()->parsefile($ENV{SNMPMODELS_INDEX});
}

foreach my $test (sort keys %tests) {
    my $snmp  = FusionInventory::Agent::SNMP::Mock->new(
        file => "$ENV{SNMPWALK_DATABASE}/$test"
    );

    # first test: discovery without dictionary
    my %device1 = getDeviceInfo(
        snmp    => $snmp,
        datadir => './share'
    );
    cmp_deeply(
        \%device1,
        $tests{$test}->[0],
        "$test: discovery, without dictionary"
    );

    # second test: discovery, with dictipnary
    SKIP: {
        skip "SNMP dictionary required, skipping", 1 unless $dictionary;

        my %device2 = getDeviceInfo(
            snmp       => $snmp,
            datadir    => './share',
            dictionary => $dictionary,
        );
        cmp_deeply(
            \%device2,
            $tests{$test}->[1],
            "$test: discovery, with dictionary"
        );
    };

    # third test: inventory without model
    my $device3 = getDeviceFullInfo(
        snmp    => $snmp,
        datadir => './share'
    );
    cmp_deeply(
        $device3,
        $tests{$test}->[2],
        "$test: inventory, without model"
    );

    # fourth test: inventory, with model
    SKIP: {
        my $model_id = $tests{$test}->[1]->{MODELSNMP};
        skip "SNMP models index required, skipping", 1 unless $index;
        skip "No model associated, skipping", 1 unless $model_id;
        my $model = loadModel($index->{$model_id});

        my $device4 = getDeviceFullInfo(
            snmp    => $snmp,
            datadir => './share',
            model   => $model
        );
        cmp_deeply(
            $device4,
            $tests{$test}->[3],
            "$test: inventory, with model"
        );
    };
}
