# Generated by default/object.tt
package Paws::StorageGateway::BandwidthRateLimitInterval;
  use Moose;
  has AverageDownloadRateLimitInBitsPerSec => (is => 'ro', isa => 'Int');
  has AverageUploadRateLimitInBitsPerSec => (is => 'ro', isa => 'Int');
  has DaysOfWeek => (is => 'ro', isa => 'ArrayRef[Int]', required => 1);
  has EndHourOfDay => (is => 'ro', isa => 'Int', required => 1);
  has EndMinuteOfHour => (is => 'ro', isa => 'Int', required => 1);
  has StartHourOfDay => (is => 'ro', isa => 'Int', required => 1);
  has StartMinuteOfHour => (is => 'ro', isa => 'Int', required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::StorageGateway::BandwidthRateLimitInterval

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::StorageGateway::BandwidthRateLimitInterval object:

  $service_obj->Method(Att1 => { AverageDownloadRateLimitInBitsPerSec => $value, ..., StartMinuteOfHour => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::StorageGateway::BandwidthRateLimitInterval object:

  $result = $service_obj->Method(...);
  $result->Att1->AverageDownloadRateLimitInBitsPerSec

=head1 DESCRIPTION

Describes a bandwidth rate limit interval for a gateway. A bandwidth
rate limit schedule consists of one or more bandwidth rate limit
intervals. A bandwidth rate limit interval defines a period of time on
one or more days of the week, during which bandwidth rate limits are
specified for uploading, downloading, or both.

=head1 ATTRIBUTES


=head2 AverageDownloadRateLimitInBitsPerSec => Int

The average download rate limit component of the bandwidth rate limit
interval, in bits per second. This field does not appear in the
response if the download rate limit is not set.


=head2 AverageUploadRateLimitInBitsPerSec => Int

The average upload rate limit component of the bandwidth rate limit
interval, in bits per second. This field does not appear in the
response if the upload rate limit is not set.


=head2 B<REQUIRED> DaysOfWeek => ArrayRef[Int]

The days of the week component of the bandwidth rate limit interval,
represented as ordinal numbers from 0 to 6, where 0 represents Sunday
and 6 represents Saturday.


=head2 B<REQUIRED> EndHourOfDay => Int

The hour of the day to end the bandwidth rate limit interval.


=head2 B<REQUIRED> EndMinuteOfHour => Int

The minute of the hour to end the bandwidth rate limit interval.

The bandwidth rate limit interval ends at the end of the minute. To end
an interval at the end of an hour, use the value C<59>.


=head2 B<REQUIRED> StartHourOfDay => Int

The hour of the day to start the bandwidth rate limit interval.


=head2 B<REQUIRED> StartMinuteOfHour => Int

The minute of the hour to start the bandwidth rate limit interval. The
interval begins at the start of that minute. To begin an interval
exactly at the start of the hour, use the value C<0>.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::StorageGateway>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

