# Generated by default/object.tt
package Paws::Honeycode::CreateRowData;
  use Moose;
  has BatchItemId => (is => 'ro', isa => 'Str', request_name => 'batchItemId', traits => ['NameInRequest'], required => 1);
  has CellsToCreate => (is => 'ro', isa => 'Paws::Honeycode::RowDataInput', request_name => 'cellsToCreate', traits => ['NameInRequest'], required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::Honeycode::CreateRowData

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Honeycode::CreateRowData object:

  $service_obj->Method(Att1 => { BatchItemId => $value, ..., CellsToCreate => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Honeycode::CreateRowData object:

  $result = $service_obj->Method(...);
  $result->Att1->BatchItemId

=head1 DESCRIPTION

Data needed to create a single row in a table as part of the
BatchCreateTableRows request.

=head1 ATTRIBUTES


=head2 B<REQUIRED> BatchItemId => Str

An external identifier that represents the single row that is being
created as part of the BatchCreateTableRows request. This can be any
string that you can use to identify the row in the request. The
BatchCreateTableRows API puts the batch item id in the results to allow
you to link data in the request to data in the results.


=head2 B<REQUIRED> CellsToCreate => L<Paws::Honeycode::RowDataInput>

A map representing the cells to create in the new row. The key is the
column id of the cell and the value is the CellInput object that
represents the data to set in that cell.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Honeycode>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

