# Generated by default/object.tt
package Paws::KinesisAnalyticsV2::MavenReference;
  use Moose;
  has ArtifactId => (is => 'ro', isa => 'Str', required => 1);
  has GroupId => (is => 'ro', isa => 'Str', required => 1);
  has Version => (is => 'ro', isa => 'Str', required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::KinesisAnalyticsV2::MavenReference

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::KinesisAnalyticsV2::MavenReference object:

  $service_obj->Method(Att1 => { ArtifactId => $value, ..., Version => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::KinesisAnalyticsV2::MavenReference object:

  $result = $service_obj->Method(...);
  $result->Att1->ArtifactId

=head1 DESCRIPTION

The information required to specify a Maven reference. You can use
Maven references to specify dependency JAR files.

=head1 ATTRIBUTES


=head2 B<REQUIRED> ArtifactId => Str

The artifact ID of the Maven reference.


=head2 B<REQUIRED> GroupId => Str

The group ID of the Maven reference.


=head2 B<REQUIRED> Version => Str

The version of the Maven reference.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::KinesisAnalyticsV2>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

