/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage;

import org.apache.sis.internal.simple.SimpleFormat;
import org.apache.sis.internal.storage.Resources;
import org.apache.sis.measure.Range;
import org.apache.sis.storage.DataStore;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.IllegalOpenParameterException;
import org.apache.sis.storage.ProbeResult;
import org.apache.sis.storage.StorageConnector;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.Version;
import org.opengis.metadata.distribution.Format;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterNotFoundException;
import org.opengis.parameter.ParameterValueGroup;

public abstract class DataStoreProvider {
    public static final String LOCATION = "location";

    protected DataStoreProvider() {
    }

    public abstract String getShortName();

    public Format getFormat() {
        return new SimpleFormat(this.getShortName());
    }

    public Range<Version> getSupportedVersions() {
        return null;
    }

    public abstract ParameterDescriptorGroup getOpenParameters();

    public abstract ProbeResult probeContent(StorageConnector var1) throws DataStoreException;

    public abstract DataStore open(StorageConnector var1) throws DataStoreException;

    public DataStore open(ParameterValueGroup parameterValueGroup) throws DataStoreException {
        Object var3_3;
        ArgumentChecks.ensureNonNull("parameter", parameterValueGroup);
        ParameterNotFoundException parameterNotFoundException = null;
        try {
            var3_3 = parameterValueGroup.parameter(LOCATION).getValue();
        }
        catch (ParameterNotFoundException parameterNotFoundException2) {
            var3_3 = null;
            parameterNotFoundException = parameterNotFoundException2;
        }
        if (var3_3 == null) {
            throw new IllegalOpenParameterException(Resources.format((short)27, this.getShortName(), LOCATION), parameterNotFoundException);
        }
        return this.open(new StorageConnector(var3_3));
    }
}

