# Generated by default/object.tt
package Paws::LexRuntime::ActiveContext;
  use Moose;
  has Name => (is => 'ro', isa => 'Str', request_name => 'name', traits => ['NameInRequest'], required => 1);
  has Parameters => (is => 'ro', isa => 'Paws::LexRuntime::ActiveContextParametersMap', request_name => 'parameters', traits => ['NameInRequest'], required => 1);
  has TimeToLive => (is => 'ro', isa => 'Paws::LexRuntime::ActiveContextTimeToLive', request_name => 'timeToLive', traits => ['NameInRequest'], required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::LexRuntime::ActiveContext

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::LexRuntime::ActiveContext object:

  $service_obj->Method(Att1 => { Name => $value, ..., TimeToLive => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::LexRuntime::ActiveContext object:

  $result = $service_obj->Method(...);
  $result->Att1->Name

=head1 DESCRIPTION

A context is a variable that contains information about the current
state of the conversation between a user and Amazon Lex. Context can be
set automatically by Amazon Lex when an intent is fulfilled, or it can
be set at runtime using the C<PutContent>, C<PutText>, or C<PutSession>
operation.

=head1 ATTRIBUTES


=head2 B<REQUIRED> Name => Str

The name of the context.


=head2 B<REQUIRED> Parameters => L<Paws::LexRuntime::ActiveContextParametersMap>

State variables for the current context. You can use these values as
default values for slots in subsequent events.


=head2 B<REQUIRED> TimeToLive => L<Paws::LexRuntime::ActiveContextTimeToLive>

The length of time or number of turns that a context remains active.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::LexRuntime>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

