/*
 * Decompiled with CFR 0.152.
 */
package com.github.junrar.io;

import com.github.junrar.io.IReadOnlyAccess;
import java.io.IOException;
import java.io.InputStream;

public class ReadOnlyAccessInputStream
extends InputStream {
    private IReadOnlyAccess file;
    private long curPos;
    private final long endPos;

    public ReadOnlyAccessInputStream(IReadOnlyAccess file, long startPos, long endPos) throws IOException {
        this.file = file;
        this.curPos = startPos;
        this.endPos = endPos;
        file.setPosition(this.curPos);
    }

    @Override
    public int read() throws IOException {
        if (this.curPos == this.endPos) {
            return -1;
        }
        int b = this.file.read();
        ++this.curPos;
        return b;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (len == 0) {
            return 0;
        }
        if (this.curPos == this.endPos) {
            return -1;
        }
        int bytesRead = this.file.read(b, off, (int)Math.min((long)len, this.endPos - this.curPos));
        this.curPos += (long)bytesRead;
        return bytesRead;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }
}

