/*
 * Decompiled with CFR 0.152.
 */
package com.drew.metadata.xmp;

import com.adobe.xmp.XMPException;
import com.adobe.xmp.XMPIterator;
import com.adobe.xmp.XMPMeta;
import com.adobe.xmp.XMPMetaFactory;
import com.adobe.xmp.properties.XMPPropertyInfo;
import com.drew.lang.BufferBoundsException;
import com.drew.lang.BufferReader;
import com.drew.lang.Rational;
import com.drew.lang.annotations.NotNull;
import com.drew.metadata.Metadata;
import com.drew.metadata.MetadataReader;
import com.drew.metadata.xmp.XmpDirectory;
import java.util.Calendar;

public class XmpReader
implements MetadataReader {
    private static final int FMT_STRING = 1;
    private static final int FMT_RATIONAL = 2;
    private static final int FMT_INT = 3;
    private static final int FMT_DOUBLE = 4;
    @NotNull
    private static final String SCHEMA_EXIF_SPECIFIC_PROPERTIES = "http://ns.adobe.com/exif/1.0/";
    @NotNull
    private static final String SCHEMA_EXIF_ADDITIONAL_PROPERTIES = "http://ns.adobe.com/exif/1.0/aux/";
    @NotNull
    private static final String SCHEMA_EXIF_TIFF_PROPERTIES = "http://ns.adobe.com/tiff/1.0/";
    @NotNull
    private static final String SCHEMA_DUBLIN_CORE_SPECIFIC_PROPERTIES = "http://purl.org/dc/elements/1.1/";

    public void extract(@NotNull BufferReader reader, @NotNull Metadata metadata) {
        String preamble;
        if (reader == null) {
            throw new NullPointerException("reader");
        }
        if (metadata == null) {
            throw new NullPointerException("metadata");
        }
        XmpDirectory directory = metadata.getOrCreateDirectory(XmpDirectory.class);
        if (reader.getLength() <= 30L) {
            directory.addError("Xmp data segment must contain at least 30 bytes");
            return;
        }
        try {
            preamble = reader.getString(0, 29);
        }
        catch (BufferBoundsException e) {
            directory.addError("Unable to read XMP preamble");
            return;
        }
        if (!"http://ns.adobe.com/xap/1.0/\u0000".equals(preamble)) {
            directory.addError("Xmp data segment doesn't begin with 'http://ns.adobe.com/xap/1.0/'");
            return;
        }
        try {
            byte[] xmpBuffer;
            try {
                xmpBuffer = reader.getBytes(29, (int)(reader.getLength() - 29L));
            }
            catch (BufferBoundsException e) {
                directory.addError("Unable to read XMP data");
                return;
            }
            XMPMeta xmpMeta = XMPMetaFactory.parseFromBuffer(xmpBuffer);
            directory.setXMPMeta(xmpMeta);
            this.processXmpTag(xmpMeta, directory, SCHEMA_EXIF_ADDITIONAL_PROPERTIES, "aux:LensInfo", 6, 1);
            this.processXmpTag(xmpMeta, directory, SCHEMA_EXIF_ADDITIONAL_PROPERTIES, "aux:Lens", 7, 1);
            this.processXmpTag(xmpMeta, directory, SCHEMA_EXIF_ADDITIONAL_PROPERTIES, "aux:SerialNumber", 8, 1);
            this.processXmpTag(xmpMeta, directory, SCHEMA_EXIF_ADDITIONAL_PROPERTIES, "aux:Firmware", 9, 1);
            this.processXmpTag(xmpMeta, directory, SCHEMA_EXIF_TIFF_PROPERTIES, "tiff:Make", 1, 1);
            this.processXmpTag(xmpMeta, directory, SCHEMA_EXIF_TIFF_PROPERTIES, "tiff:Model", 2, 1);
            this.processXmpTag(xmpMeta, directory, SCHEMA_EXIF_SPECIFIC_PROPERTIES, "exif:ExposureTime", 3, 1);
            this.processXmpTag(xmpMeta, directory, SCHEMA_EXIF_SPECIFIC_PROPERTIES, "exif:ExposureProgram", 12, 3);
            this.processXmpTag(xmpMeta, directory, SCHEMA_EXIF_SPECIFIC_PROPERTIES, "exif:ApertureValue", 11, 2);
            this.processXmpTag(xmpMeta, directory, SCHEMA_EXIF_SPECIFIC_PROPERTIES, "exif:FNumber", 5, 2);
            this.processXmpTag(xmpMeta, directory, SCHEMA_EXIF_SPECIFIC_PROPERTIES, "exif:FocalLength", 10, 2);
            this.processXmpTag(xmpMeta, directory, SCHEMA_EXIF_SPECIFIC_PROPERTIES, "exif:ShutterSpeedValue", 4, 2);
            this.processXmpDateTag(xmpMeta, directory, SCHEMA_EXIF_SPECIFIC_PROPERTIES, "exif:DateTimeOriginal", 13);
            this.processXmpDateTag(xmpMeta, directory, SCHEMA_EXIF_SPECIFIC_PROPERTIES, "exif:DateTimeDigitized", 14);
            XMPIterator iterator = xmpMeta.iterator();
            while (iterator.hasNext()) {
                XMPPropertyInfo propInfo = (XMPPropertyInfo)iterator.next();
                String path = propInfo.getPath();
                String value = propInfo.getValue();
                if (path == null || value == null) continue;
                directory.addProperty(path, value.toString());
            }
        }
        catch (XMPException e) {
            directory.addError("Error parsing XMP segment: " + e.getMessage());
        }
    }

    private void processXmpTag(@NotNull XMPMeta meta, @NotNull XmpDirectory directory, @NotNull String schemaNS, @NotNull String propName, int tagType, int formatCode) throws XMPException {
        String property = meta.getPropertyString(schemaNS, propName);
        if (property == null) {
            return;
        }
        switch (formatCode) {
            case 2: {
                String[] rationalParts = property.split("/", 2);
                if (rationalParts.length == 2) {
                    try {
                        Rational rational = new Rational((long)Float.parseFloat(rationalParts[0]), (long)Float.parseFloat(rationalParts[1]));
                        directory.setRational(tagType, rational);
                    }
                    catch (NumberFormatException ex) {
                        directory.addError(String.format("Unable to parse XMP property %s as a Rational.", propName));
                    }
                    break;
                }
                directory.addError("Error in rational format for tag " + tagType);
                break;
            }
            case 3: {
                try {
                    directory.setInt(tagType, Integer.valueOf(property));
                }
                catch (NumberFormatException ex) {
                    directory.addError(String.format("Unable to parse XMP property %s as an int.", propName));
                }
                break;
            }
            case 4: {
                try {
                    directory.setDouble(tagType, Double.valueOf(property));
                }
                catch (NumberFormatException ex) {
                    directory.addError(String.format("Unable to parse XMP property %s as an double.", propName));
                }
                break;
            }
            case 1: {
                directory.setString(tagType, property);
                break;
            }
            default: {
                directory.addError(String.format("Unknown format code %d for tag %d", formatCode, tagType));
            }
        }
    }

    void processXmpDateTag(@NotNull XMPMeta meta, @NotNull XmpDirectory directory, @NotNull String schemaNS, @NotNull String propName, int tagType) throws XMPException {
        Calendar cal = meta.getPropertyCalendar(schemaNS, propName);
        if (cal == null) {
            return;
        }
        directory.setDate(tagType, cal.getTime());
    }
}

