/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.SlashExpression;
import net.sf.saxon.expr.UnaryExpression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.sort.DocumentSorter;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.pattern.AnyNodeTest;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.HomogeneityCheckerIterator;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.TypeHierarchy;

public class HomogeneityChecker
extends UnaryExpression {
    public HomogeneityChecker(Expression base) {
        super(base);
    }

    public Expression typeCheck(ExpressionVisitor visitor, ExpressionVisitor.ContextItemType contextItemType) throws XPathException {
        ItemType type;
        if (this.getBaseExpression() instanceof HomogeneityChecker) {
            return visitor.typeCheck(this.getBaseExpression(), contextItemType);
        }
        Expression e = super.typeCheck(visitor, contextItemType);
        if (e != this) {
            return e;
        }
        TypeHierarchy th = visitor.getConfiguration().getTypeHierarchy();
        int rel = th.relationship(type = this.getBaseExpression().getItemType(th), AnyNodeTest.getInstance());
        if (rel == 4) {
            if (this.getBaseExpression() instanceof SlashExpression && ((SlashExpression)this.getBaseExpression()).getLeadingSteps() instanceof SlashExpression && (((SlashExpression)this.getBaseExpression()).getLeadingSteps().getSpecialProperties() & 0x20000) == 0) {
                DocumentSorter ds = new DocumentSorter(((SlashExpression)this.getBaseExpression()).getLeadingSteps());
                SlashExpression se = new SlashExpression(ds, ((SlashExpression)this.getBaseExpression()).getLastStep());
                ExpressionTool.copyLocationInfo(this, se);
                return se;
            }
            return this.getBaseExpression();
        }
        if (rel == 0 || rel == 2) {
            DocumentSorter ds = new DocumentSorter(this.getBaseExpression());
            ExpressionTool.copyLocationInfo(this, ds);
            return ds;
        }
        return this;
    }

    public Expression optimize(ExpressionVisitor visitor, ExpressionVisitor.ContextItemType contextItemType) throws XPathException {
        if (this.getBaseExpression() instanceof HomogeneityChecker) {
            return visitor.optimize(this.getBaseExpression(), contextItemType);
        }
        return super.optimize(visitor, contextItemType);
    }

    public Expression copy() {
        return new HomogeneityChecker(this.getBaseExpression().copy());
    }

    public SequenceIterator iterate(XPathContext context) throws XPathException {
        SequenceIterator<? extends Item> base = this.getBaseExpression().iterate(context);
        return new HomogeneityCheckerIterator(base, this);
    }

    public String getExpressionName() {
        return "homogeneityChecker";
    }
}

