use strict;
use warnings;

use Test::More tests => 4;

use Lingua::Ogmios;
use Lingua::Ogmios::Annotations::Token;
use Lingua::Ogmios::Annotations::LogProcessing;

warn "Log Processing\n";
my $logp = Lingua::Ogmios::Annotations::LogProcessing-> new(
    {'log_id' => 'log_processing1', 
     'software_name' => "testsoftware",
     'command_line' => "no comandline"
    });
ok(defined $logp  && ref $logp eq 'Lingua::Ogmios::Annotations::LogProcessing', 'LogProcessing->new works');
warn "Print LogProcessing content\n";
$logp->print;

warn "Token\n";
my $token = Lingua::Ogmios::Annotations::Token-> new(
    {'id' => "token1",
     'content' => "content",
     'type' => "alpha",
     'from' => 40,
     'to' => 50
    });
ok(defined $token  && ref $token eq 'Lingua::Ogmios::Annotations::Token', 'Token->new works');
warn "Print Token content\n";
$token->print;
warn "Print Token content as XML\n";
print STDERR $token->XMLout(['id', 'type', 'content', 'from', 'to']);

my $NLPPlatform = Lingua::Ogmios->new('rcfile' => 'etc/ogmios/nlpplatform-test.rc');


# $NLPPlatform->loadDocuments(['examples/FrenchText.xml']);
# ok(defined $NLPPlatform);

# $NLPPlatform->loadDocuments(['examples/InputDocument3.xml']);
# ok(defined $NLPPlatform);

$NLPPlatform->loadDocuments(['examples/pmid10788508-v3.xml']);

$NLPPlatform->tokenisation;

print STDERR $NLPPlatform->XMLout;

ok(defined $NLPPlatform);

warn "processing examples/pmid10788508-v4.xml\n";

$NLPPlatform->loadDocuments(['examples/pmid10788508-v4.xml']);

$NLPPlatform->tokenisation;

print STDERR $NLPPlatform->XMLout;

ok(defined $NLPPlatform);

