# Generated by default/object.tt
package Paws::CloudWatchEvents::ConnectionAuthResponseParameters;
  use Moose;
  has ApiKeyAuthParameters => (is => 'ro', isa => 'Paws::CloudWatchEvents::ConnectionApiKeyAuthResponseParameters');
  has BasicAuthParameters => (is => 'ro', isa => 'Paws::CloudWatchEvents::ConnectionBasicAuthResponseParameters');
  has InvocationHttpParameters => (is => 'ro', isa => 'Paws::CloudWatchEvents::ConnectionHttpParameters');
  has OAuthParameters => (is => 'ro', isa => 'Paws::CloudWatchEvents::ConnectionOAuthResponseParameters');

1;

### main pod documentation begin ###

=head1 NAME

Paws::CloudWatchEvents::ConnectionAuthResponseParameters

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::CloudWatchEvents::ConnectionAuthResponseParameters object:

  $service_obj->Method(Att1 => { ApiKeyAuthParameters => $value, ..., OAuthParameters => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::CloudWatchEvents::ConnectionAuthResponseParameters object:

  $result = $service_obj->Method(...);
  $result->Att1->ApiKeyAuthParameters

=head1 DESCRIPTION

Contains the authorization parameters to use for the connection.

=head1 ATTRIBUTES


=head2 ApiKeyAuthParameters => L<Paws::CloudWatchEvents::ConnectionApiKeyAuthResponseParameters>

The API Key parameters to use for authorization.


=head2 BasicAuthParameters => L<Paws::CloudWatchEvents::ConnectionBasicAuthResponseParameters>

The authorization parameters for Basic authorization.


=head2 InvocationHttpParameters => L<Paws::CloudWatchEvents::ConnectionHttpParameters>

Additional parameters for the connection that are passed through with
every invocation to the HTTP endpoint.


=head2 OAuthParameters => L<Paws::CloudWatchEvents::ConnectionOAuthResponseParameters>

The OAuth parameters to use for authorization.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::CloudWatchEvents>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

