package Google::Ads::AdWords::v201206::DynamicSearchAd;
use strict;
use warnings;


__PACKAGE__->_set_element_form_qualified(1);

sub get_xmlns { 'https://adwords.google.com/api/adwords/cm/v201206' };

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}


use base qw(Google::Ads::AdWords::v201206::Ad);
# Variety: sequence
use Class::Std::Fast::Storable constructor => 'none';
use base qw(SOAP::WSDL::XSD::Typelib::ComplexType);

Class::Std::initialize();

{ # BLOCK to scope variables

my %id_of :ATTR(:get<id>);
my %url_of :ATTR(:get<url>);
my %displayUrl_of :ATTR(:get<displayUrl>);
my %disapprovalReasons_of :ATTR(:get<disapprovalReasons>);
my %Ad__Type_of :ATTR(:get<Ad__Type>);
my %description1_of :ATTR(:get<description1>);
my %description2_of :ATTR(:get<description2>);

__PACKAGE__->_factory(
    [ qw(        id
        url
        displayUrl
        disapprovalReasons
        Ad__Type
        description1
        description2

    ) ],
    {
        'id' => \%id_of,
        'url' => \%url_of,
        'displayUrl' => \%displayUrl_of,
        'disapprovalReasons' => \%disapprovalReasons_of,
        'Ad__Type' => \%Ad__Type_of,
        'description1' => \%description1_of,
        'description2' => \%description2_of,
    },
    {
        'id' => 'SOAP::WSDL::XSD::Typelib::Builtin::long',
        'url' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'displayUrl' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'disapprovalReasons' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'Ad__Type' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'description1' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'description2' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
    },
    {

        'id' => 'id',
        'url' => 'url',
        'displayUrl' => 'displayUrl',
        'disapprovalReasons' => 'disapprovalReasons',
        'Ad__Type' => 'Ad.Type',
        'description1' => 'description1',
        'description2' => 'description2',
    }
);

} # end BLOCK







1;


=pod

=head1 NAME

Google::Ads::AdWords::v201206::DynamicSearchAd

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
DynamicSearchAd from the namespace https://adwords.google.com/api/adwords/cm/v201206.

Represents a dynamic search ad. This ad will have its headline and url autogenerated at serving time according to domain name specific information provided by DomainInfoExtension linked at the campaign level. Autogenerated fields: headline and url (url may be optionally specified for tracking purposes) Required fields: description1, description2, displayUrl The url field must contain at least one of the following placeholder tags: {unescapedlpurl}, {escapedlpurl} and {lpurlpath}. If no url is specified it will default to {unescapedlpurl}. When {unescapedlpurl} is used it must be in the beginning of the url field. When the ad is displayed it will be replaced with the full url of the ad landing page. Extra query parameters can be added to the end. E.g. "{unescapedlpurl}?lang=en" {escapedlpurl} is replaced with a URL encoded version of the full landing page url. This makes it suitable to be used as the value for a query parameter but cannot be in the beginning of the url field. E.g. "http://www.3rdpartytracker.com/?lp={escapedlpurl}". {lpurlpath} is replaced with the path and query part of the landing page url and can be used to add this to a different url. E.g. "http://www.mygoodbusiness.com/tracking/{lpurlpath}". There are also special rules that come into play depending on whether the destination url uses local click tracking or third party click tracking. See Helpcenter articles for more information. <span class="constraint AdxEnabled">This is disabled for AdX when it is contained within Operators: ADD, SET.</span> <span class="constraint Beta">This is a beta feature.</span> 




=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * description1


=item * description2




=back


=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():

 { # Google::Ads::AdWords::v201206::DynamicSearchAd
   description1 =>  $some_value, # string
   description2 =>  $some_value, # string
 },




=head1 AUTHOR

Generated by SOAP::WSDL

=cut

