package Google::Ads::AdWords::v201209::FailureResult;
use strict;
use warnings;


__PACKAGE__->_set_element_form_qualified(1);

sub get_xmlns { 'https://adwords.google.com/api/adwords/cm/v201209' };

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}


use base qw(Google::Ads::AdWords::v201209::OperationResult);
# Variety: sequence
use Class::Std::Fast::Storable constructor => 'none';
use base qw(Google::Ads::SOAP::Typelib::ComplexType);

Class::Std::initialize();

{ # BLOCK to scope variables

my %OperationResult__Type_of :ATTR(:get<OperationResult__Type>);
my %cause_of :ATTR(:get<cause>);

__PACKAGE__->_factory(
    [ qw(        OperationResult__Type
        cause

    ) ],
    {
        'OperationResult__Type' => \%OperationResult__Type_of,
        'cause' => \%cause_of,
    },
    {
        'OperationResult__Type' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'cause' => 'Google::Ads::AdWords::v201209::ApiException',
    },
    {

        'OperationResult__Type' => 'OperationResult.Type',
        'cause' => 'cause',
    }
);

} # end BLOCK







1;


=pod

=head1 NAME

Google::Ads::AdWords::v201209::FailureResult

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
FailureResult from the namespace https://adwords.google.com/api/adwords/cm/v201209.

Represents a failure result for an individual mutate operation. <p>Currently, operations are applied in transactional batches, so the corresponding operation for this result may not itself be faulty.</p> <p>The errors in the exception may contain {@code OGNL path}s that identify the faulty operations in the batch. Please see the subsequent {@link BatchFailureResult}s to determine the remaining operations that were also applied in the batch and their positions within the batch.</p> 




=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * cause




=back


=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():






=head1 AUTHOR

Generated by SOAP::WSDL

=cut

