# Generated by default/object.tt
package Paws::GuardDuty::PublicAccess;
  use Moose;
  has EffectivePermission => (is => 'ro', isa => 'Str', request_name => 'effectivePermission', traits => ['NameInRequest']);
  has PermissionConfiguration => (is => 'ro', isa => 'Paws::GuardDuty::PermissionConfiguration', request_name => 'permissionConfiguration', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::GuardDuty::PublicAccess

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::GuardDuty::PublicAccess object:

  $service_obj->Method(Att1 => { EffectivePermission => $value, ..., PermissionConfiguration => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::GuardDuty::PublicAccess object:

  $result = $service_obj->Method(...);
  $result->Att1->EffectivePermission

=head1 DESCRIPTION

Describes the public access policies that apply to the S3 bucket.

=head1 ATTRIBUTES


=head2 EffectivePermission => Str

Describes the effective permission on this bucket after factoring all
attached policies.


=head2 PermissionConfiguration => L<Paws::GuardDuty::PermissionConfiguration>

Contains information about how permissions are configured for the S3
bucket.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::GuardDuty>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

