# Generated by default/object.tt
package Paws::NetworkFirewall::FirewallPolicy;
  use Moose;
  has StatefulRuleGroupReferences => (is => 'ro', isa => 'ArrayRef[Paws::NetworkFirewall::StatefulRuleGroupReference]');
  has StatelessCustomActions => (is => 'ro', isa => 'ArrayRef[Paws::NetworkFirewall::CustomAction]');
  has StatelessDefaultActions => (is => 'ro', isa => 'ArrayRef[Str|Undef]', required => 1);
  has StatelessFragmentDefaultActions => (is => 'ro', isa => 'ArrayRef[Str|Undef]', required => 1);
  has StatelessRuleGroupReferences => (is => 'ro', isa => 'ArrayRef[Paws::NetworkFirewall::StatelessRuleGroupReference]');

1;

### main pod documentation begin ###

=head1 NAME

Paws::NetworkFirewall::FirewallPolicy

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::NetworkFirewall::FirewallPolicy object:

  $service_obj->Method(Att1 => { StatefulRuleGroupReferences => $value, ..., StatelessRuleGroupReferences => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::NetworkFirewall::FirewallPolicy object:

  $result = $service_obj->Method(...);
  $result->Att1->StatefulRuleGroupReferences

=head1 DESCRIPTION

The firewall policy defines the behavior of a firewall using a
collection of stateless and stateful rule groups and other settings.
You can use one firewall policy for multiple firewalls.

This, along with FirewallPolicyResponse, define the policy. You can
retrieve all objects for a firewall policy by calling
DescribeFirewallPolicy.

=head1 ATTRIBUTES


=head2 StatefulRuleGroupReferences => ArrayRef[L<Paws::NetworkFirewall::StatefulRuleGroupReference>]

References to the stateless rule groups that are used in the policy.
These define the inspection criteria in stateful rules.


=head2 StatelessCustomActions => ArrayRef[L<Paws::NetworkFirewall::CustomAction>]

The custom action definitions that are available for use in the
firewall policy's C<StatelessDefaultActions> setting. You name each
custom action that you define, and then you can use it by name in your
default actions specifications.


=head2 B<REQUIRED> StatelessDefaultActions => ArrayRef[Str|Undef]

The actions to take on a packet if it doesn't match any of the
stateless rules in the policy. If you want non-matching packets to be
forwarded for stateful inspection, specify C<aws:forward_to_sfe>.

You must specify one of the standard actions: C<aws:pass>, C<aws:drop>,
or C<aws:forward_to_sfe>. In addition, you can specify custom actions
that are compatible with your standard section choice.

For example, you could specify C<["aws:pass"]> or you could specify
C<["aws:pass", E<ldquo>customActionNameE<rdquo>]>. For information
about compatibility, see the custom action descriptions under
CustomAction.


=head2 B<REQUIRED> StatelessFragmentDefaultActions => ArrayRef[Str|Undef]

The actions to take on a fragmented UDP packet if it doesn't match any
of the stateless rules in the policy. Network Firewall only manages UDP
packet fragments and silently drops packet fragments for other
protocols. If you want non-matching fragmented UDP packets to be
forwarded for stateful inspection, specify C<aws:forward_to_sfe>.

You must specify one of the standard actions: C<aws:pass>, C<aws:drop>,
or C<aws:forward_to_sfe>. In addition, you can specify custom actions
that are compatible with your standard section choice.

For example, you could specify C<["aws:pass"]> or you could specify
C<["aws:pass", E<ldquo>customActionNameE<rdquo>]>. For information
about compatibility, see the custom action descriptions under
CustomAction.


=head2 StatelessRuleGroupReferences => ArrayRef[L<Paws::NetworkFirewall::StatelessRuleGroupReference>]

References to the stateless rule groups that are used in the policy.
These define the matching criteria in stateless rules.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::NetworkFirewall>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

