package Devel::PatchPerl::Hints;
$Devel::PatchPerl::Hints::VERSION = '2.12'; # TRIAL
#ABSTRACT: replacement 'hints' files

use strict;
use warnings;
use MIME::Base64 qw[decode_base64];
use File::Spec;

our @ISA            = qw[Exporter];
our @EXPORT_OK      = qw[hint_file hints];

my %hints = (
'bitrig' =>
'IyBoaW50cy9vcGVuYnNkLnNoCiMKIyBoaW50cyBmaWxlIGZvciBPcGVuQlNEOyBUb2RkIE1pbGxl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',
'cygwin' =>
'IyEgL2Jpbi9zaAojIGN5Z3dpbi5zaCAtIGhpbnRzIGZvciBidWlsZGluZyBwZXJsIHVzaW5nIHRo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==',
'darwin' =>
'IyMKIyBEYXJ3aW4gKE1hYyBPUykgaGludHMKIyBXaWxmcmVkbyBTYW5jaGV6IDx3c2FuY2hlekB3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',
'dragonfly' =>
'IyBoaW50cy9kcmFnb25mbHkuc2gKIwojIFRoaXMgZmlsZSBpcyBtb3N0bHkgY29waWVkIGZyb20g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',
'freebsd' =>
'IyBPcmlnaW5hbCBiYXNlZCBvbiBpbmZvIGZyb20KIyBDYXJsIE0uIEZvbmdoZWlzZXIgPGNtZkBp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',
'gnu' =>
'IyBoaW50cy9nbnUuc2gKIyBPcmlnaW5hbGx5IGNvbnRyaWJ1dGVkIGJ5OiAgTWFyayBLZXR0ZW5p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=',
'gnukfreebsd' =>
'IyEgL2Jpbi9zaAoKIyBTdXBwb3J0IGZvciBEZWJpYW4gR05VL2tGcmVlQlNEIChrZnJlZWJzZC1n
bnUpCiMgQSBwb3J0IG9mIHRoZSBEZWJpYW4gR05VIHN5c3RlbSB1c2luZyB0aGUgRnJlZUJTRCBr
ZXJuZWwuCgouIC4vaGludHMvbGludXguc2gKCg==',
'hpux' =>
'IyEvdXNyL2Jpbi9zaAoKIyMjIFNZU1RFTSBBUkNISVRFQ1RVUkUKCiMgRGV0ZXJtaW5lIHRoZSBh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',
'linux' =>
'IyBoaW50cy9saW51eC5zaAojIE9yaWdpbmFsIHZlcnNpb24gYnkgcnNhbmRlcnMKIyBBZGRpdGlv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',
'midnightbsd' =>
'dXNldmZvcms9J3RydWUnCmNhc2UgIiR1c2VteW1hbGxvYyIgaW4KICAgICIiKSB1c2VteW1hbGxv
Yz0nbicKICAgICAgICA7Owplc2FjCmxpYnN3YW50ZWQ9YGVjaG8gJGxpYnN3YW50ZWQgfCBzZWQg
J3MvIG1hbGxvYyAvIC8nYAoKb2JqZm9ybWF0PWAvdXNyL2Jpbi9vYmpmb3JtYXRgCmlmIFsgeCRv
Ympmb3JtYXQgPSB4YW91dCBdOyB0aGVuCiAgICBpZiBbIC1lIC91c3IvbGliL2FvdXQgXTsgdGhl
bgogICAgICAgIGxpYnB0aD0iL3Vzci9saWIvYW91dCAvdXNyL2xvY2FsL2xpYiAvdXNyL2xpYiIK
ICAgICAgICBnbGlicHRoPSIvdXNyL2xpYi9hb3V0IC91c3IvbG9jYWwvbGliIC91c3IvbGliIgog
ICAgZmkKICAgIGxkZGxmbGFncz0nLUJzaGFyZWFibGUnCmVsc2UKICAgIGxpYnB0aD0iL3Vzci9s
aWIgL3Vzci9sb2NhbC9saWIiCiAgICBnbGlicHRoPSIvdXNyL2xpYiAvdXNyL2xvY2FsL2xpYiIK
ICAgIGxkZmxhZ3M9Ii1XbCwtRSAiCiAgICBsZGRsZmxhZ3M9Ii1zaGFyZWQgIgpmaQpjY2NkbGZs
YWdzPSctRFBJQyAtZlBJQycKCmNjZmxhZ3M9IiR7Y2NmbGFnc30gLURIQVNfRlBTRVRNQVNLIC1E
SEFTX0ZMT0FUSU5HUE9JTlRfSCIKaWYgL3Vzci9iaW4vZmlsZSAtTCAvdXNyL2xpYi9saWJjLnNv
IHwgL3Vzci9iaW4vZ3JlcCAtdnEgIm5vdCBzdHJpcHBlZCIgOyB0aGVuCiAgICB1c2VubT1mYWxz
ZQpmaQoKc2lnbmFsX3Q9J3ZvaWQnCmRfdm9pZHNpZz0nZGVmaW5lJwoKIyBUaGlzIHNjcmlwdCBV
VS91c2V0aHJlYWRzLmNidSB3aWxsIGdldCAnY2FsbGVkLWJhY2snIGJ5IENvbmZpZ3VyZSAKIyBh
ZnRlciBpdCBoYXMgcHJvbXB0ZWQgdGhlIHVzZXIgZm9yIHdoZXRoZXIgdG8gdXNlIHRocmVhZHMu
CmNhdCA+IFVVL3VzZXRocmVhZHMuY2J1IDw8J0VPQ0JVJwpjYXNlICIkdXNldGhyZWFkcyIgaW4K
JGRlZmluZXx0cnVlfFt5WV0qKQoJbGRmbGFncz0iLXB0aHJlYWQgJGxkZmxhZ3MiCglzZXQgYGVj
aG8gWCAiJGxpYnN3YW50ZWQgInwgc2VkIC1lICdzLyBjIC8vJ2AKCXNoaWZ0CglsaWJzd2FudGVk
PSIkKiIKCSMgQ29uZmlndXJlIHdpbGwgcHJvYmFibHkgcGljayB0aGUgd3JvbmcgbGliYyB0byB1
c2UgZm9yIG5tIHNjYW4uCgkjIFRoZSBzYWZlc3QgcXVpY2stZml4IGlzIGp1c3QgdG8gbm90IHVz
ZSBubSBhdCBhbGwuLi4KCXVzZW5tPWZhbHNlCgogICAgICAgIHVuc2V0IGxjX3IKCgkjIEV2ZW4g
d2l0aCB0aGUgbWFsbG9jIG11dGV4ZXMgdGhlIFBlcmwgbWFsbG9jIGRvZXMgbm90CgkjIHNlZW0g
dG8gYmUgdGhyZWFkc2FmZSBpbiBNaWRuaWdodEJTRD8KCWNhc2UgIiR1c2VteW1hbGxvYyIgaW4K
CScnKSB1c2VteW1hbGxvYz1uIDs7Cgllc2FjCmVzYWMKRU9DQlUKCiMgbWFsbG9jIHdyYXAgd29y
a3MKY2FzZSAiJHVzZW1hbGxvY3dyYXAiIGluCicnKSB1c2VtYWxsb2N3cmFwPSdkZWZpbmUnIDs7
CmVzYWMK',
'netbsd' =>
'IyBoaW50cy9uZXRic2Quc2gKIwojIFBsZWFzZSBjaGVjayB3aXRoIHBhY2thZ2VzQG5ldGJzZC5v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',
'openbsd' =>
'IyBoaW50cy9vcGVuYnNkLnNoCiMKIyBoaW50cyBmaWxlIGZvciBPcGVuQlNEOyBUb2RkIE1pbGxl
ciA8bWlsbGVydEBvcGVuYnNkLm9yZz4KIyBFZGl0ZWQgdG8gYWxsb3cgQ29uZmlndXJlIGNvbW1h
bmQtbGluZSBvdmVycmlkZXMgYnkKIyAgQW5keSBEb3VnaGVydHkgPGRvdWdoZXJhQGxhZmF5ZXR0
ZS5lZHU+CiMKIyBUbyBidWlsZCB3aXRoIGRpc3RyaWJ1dGlvbiBwYXRocywgdXNlOgojCS4vQ29u
ZmlndXJlIC1kZXMgLURvcGVuYnNkX2Rpc3RyaWJ1dGlvbj1kZWZpbmVkCiMKCiMgT3BlbkJTRCBo
YXMgYSBiZXR0ZXIgbWFsbG9jIHRoYW4gcGVybC4uLgp0ZXN0ICIkdXNlbXltYWxsb2MiIHx8IHVz
ZW15bWFsbG9jPSduJwoKIyBtYWxsb2Mgd3JhcCB3b3JrcwpjYXNlICIkdXNlbWFsbG9jd3JhcCIg
aW4KJycpIHVzZW1hbGxvY3dyYXA9J2RlZmluZScgOzsKZXNhYwoKIyBDdXJyZW50bHksIHZmb3Jr
KDIpIGlzIG5vdCBhIHJlYWwgd2luIG92ZXIgZm9yaygyKS4KdXNldmZvcms9IiR1bmRlZiIKCiMg
SW4gT3BlbkJTRCA8IDMuMywgdGhlIHNldHJlP1t1Z11pZCgpIGFyZSBlbXVsYXRlZCB1c2luZyB0
aGUKIyBfUE9TSVhfU0FWRURfSURTIGZ1bmN0aW9uYWxpdHkgd2hpY2ggZG9lcyBub3QgaGF2ZSB0
aGUgc2FtZQojIHNlbWFudGljcyBhcyA0LjNCU0QuICBTdGFydGluZyB3aXRoIE9wZW5CU0QgMy4z
LCB0aGUgb3JpZ2luYWwKIyBzZW1hbnRpY3MgaGF2ZSBiZWVuIHJlc3RvcmVkLgpjYXNlICIkb3N2
ZXJzIiBpbgpbMC0yXS4qfDMuWzAtMl0pCglkX3NldHJlZ2lkPSR1bmRlZgoJZF9zZXRyZXVpZD0k
dW5kZWYKCWRfc2V0cmdpZD0kdW5kZWYKCWRfc2V0cnVpZD0kdW5kZWYKZXNhYwoKIwojIE5vdCBh
bGwgcGxhdGZvcm1zIHN1cHBvcnQgZHluYW1pYyBsb2FkaW5nLi4uCiMgRm9yIHRoZSBjYXNlIG9m
ICIkb3BlbmJzZF9kaXN0cmlidXRpb24iLCB0aGUgaGludHMgZmlsZQojIG5lZWRzIHRvIGtub3cg
d2hldGhlciB3ZSBhcmUgdXNpbmcgZHluYW1pYyBsb2FkaW5nIHNvIHRoYXQKIyBpdCBjYW4gc2V0
IHRoZSBsaWJwZXJsIG5hbWUgYXBwcm9wcmlhdGVseS4KIyBBbGxvdyBjb21tYW5kIGxpbmUgb3Zl
cnJpZGVzLgojCkFSQ0g9YGFyY2ggfCBzZWQgJ3MvXk9wZW5CU0QuLy8nYApjYXNlICIke0FSQ0h9
LSR7b3N2ZXJzfSIgaW4KYWxwaGEtMi5bMC04XXxtaXBzLTIuWzAtOF18cG93ZXJwYy0yLlswLTdd
fG04OGstWzItNF0uKnxtODhrLTUuWzAtMl18aHBwYS0zLlswLTVdfHZheC0qKQoJdGVzdCAteiAi
JHVzZWRsIiAmJiB1c2VkbD0kdW5kZWYKCTs7CiopCgl0ZXN0IC16ICIkdXNlZGwiICYmIHVzZWRs
PSRkZWZpbmUKCSMgV2UgdXNlIC1mUElDIGhlcmUgYmVjYXVzZSAtZnBpYyBpcyAqTk9UKiBlbm91
Z2ggZm9yIHNvbWUgb2YgdGhlCgkjIGV4dGVuc2lvbnMgbGlrZSBUayBvbiBzb21lIE9wZW5CU0Qg
cGxhdGZvcm1zIChpZTogc3BhcmMpCgljY2NkbGZsYWdzPSItRFBJQyAtZlBJQyAkY2NjZGxmbGFn
cyIKCWNhc2UgIiRvc3ZlcnMiIGluCglbMDFdLip8Mi5bMC03XXwyLlswLTddLiopCgkJbGRkbGZs
YWdzPSItQnNoYXJlYWJsZSAkbGRkbGZsYWdzIgoJCTs7CgkyLls4LTldfDMuMCkKCQlsZD0ke2Nj
Oi1jY30KCQlsZGRsZmxhZ3M9Ii1zaGFyZWQgLWZQSUMgJGxkZGxmbGFncyIKCQk7OwoJKikgIyBm
cm9tIDMuMSBvbndhcmRzCgkJbGQ9JHtjYzotY2N9CgkJbGRkbGZsYWdzPSItc2hhcmVkIC1mUElD
ICRsZGRsZmxhZ3MiCgkJbGlic3dhbnRlZD1gZWNobyAkbGlic3dhbnRlZCB8IHNlZCAncy8gZGwg
LyAvJ2AKCQk7OwoJZXNhYwoKCSMgV2UgbmVlZCB0byBmb3JjZSBsZCB0byBleHBvcnQgc3ltYm9s
cyBvbiBFTEYgcGxhdGZvcm1zLgoJIyBXaXRob3V0IHRoaXMsIGRsb3BlbigpIGlzIGNyaXBwbGVk
LgoJRUxGPWAke2NjOi1jY30gLWRNIC1FIC0gPC9kZXYvbnVsbCB8IGdyZXAgX19FTEZfX2AKCXRl
c3QgLW4gIiRFTEYiICYmIGxkZmxhZ3M9Ii1XbCwtRSAkbGRmbGFncyIKCTs7CmVzYWMKCiMKIyBU
d2Vha3MgZm9yIHZhcmlvdXMgdmVyc2lvbnMgb2YgT3BlbkJTRAojCmNhc2UgIiRvc3ZlcnMiIGlu
CjIuNSkKCSMgT3BlbkJTRCAyLjUgaGFzIGJyb2tlbiBvZGJtIHN1cHBvcnQKCWlfZGJtPSR1bmRl
ZgoJOzsKZXNhYwoKIyBPcGVuQlNEIGRvZXNuJ3QgbmVlZCBsaWJjcnlwdCBidXQgbWFueSBmb2xr
cyBrZWVwIGEgc3R1YiBsaWIKIyBhcm91bmQgZm9yIG9sZCBOZXRCU0QgYmluYXJpZXMuCmxpYnN3
YW50ZWQ9YGVjaG8gJGxpYnN3YW50ZWQgfCBzZWQgJ3MvIGNyeXB0IC8gLydgCgojIENvbmZpZ3Vy
ZSBjYW4ndCBmaWd1cmUgdGhpcyBvdXQgbm9uLWludGVyYWN0aXZlbHkKZF9zdWlkc2FmZT0kZGVm
aW5lCgojIGNjIGlzIGdjYyBzbyB3ZSBjYW4gZG8gYmV0dGVyIHRoYW4gLU8KIyBBbGxvdyBhIGNv
bW1hbmQtbGluZSBvdmVycmlkZSwgc3VjaCBhcyAtRG9wdGltaXplPS1nCmNhc2UgIiR7QVJDSH0t
JHtvc3ZlcnN9IiBpbgpocHBhLTMuM3xtODhrLTIuKnxtODhrLTMuWzAtM10pCiAgIHRlc3QgIiRv
cHRpbWl6ZSIgfHwgb3B0aW1pemU9Jy1PMCcKICAgOzsKbTg4ay0zLjQpCiAgIHRlc3QgIiRvcHRp
bWl6ZSIgfHwgb3B0aW1pemU9Jy1PMScKICAgOzsKKikKICAgdGVzdCAiJG9wdGltaXplIiB8fCBv
cHRpbWl6ZT0nLU8yJwogICA7Owplc2FjCgojIFRoaXMgc2NyaXB0IFVVL3VzZXRocmVhZHMuY2J1
IHdpbGwgZ2V0ICdjYWxsZWQtYmFjaycgYnkgQ29uZmlndXJlIAojIGFmdGVyIGl0IGhhcyBwcm9t
cHRlZCB0aGUgdXNlciBmb3Igd2hldGhlciB0byB1c2UgdGhyZWFkcy4KY2F0ID4gVVUvdXNldGhy
ZWFkcy5jYnUgPDwnRU9DQlUnCmNhc2UgIiR1c2V0aHJlYWRzIiBpbgokZGVmaW5lfHRydWV8W3lZ
XSopCgkjIGFueSBvcGVuYnNkIHZlcnNpb24gZGVwZW5kZW5jaWVzIHdpdGggcHRocmVhZHM/Cglj
Y2ZsYWdzPSItcHRocmVhZCAkY2NmbGFncyIKCWxkZmxhZ3M9Ii1wdGhyZWFkICRsZGZsYWdzIgoJ
Y2FzZSAiJG9zdmVycyIgaW4KCVswLTJdLip8My5bMC0yXSkKCQkjIENoYW5nZSBmcm9tIC1sYyB0
byAtbGNfcgoJCXNldCBgZWNobyAiWCAkbGlic3dhbnRlZCAiIHwgc2VkICdzLyBjIC8gY19yIC8n
YAoJCXNoaWZ0CgkJbGlic3dhbnRlZD0iJCoiCgk7OwoJZXNhYwoJY2FzZSAiJG9zdmVycyIgaW4K
CVswMTJdLip8My5bMC02XSkKICAgICAgICAJIyBCcm9rZW4gdXAgdG8gT3BlbkJTRCAzLjYsIGZp
eGVkIGluIE9wZW5CU0QgMy43CgkJZF9nZXRzZXJ2YnluYW1lX3I9JHVuZGVmIDs7Cgllc2FjCmVz
YWMKRU9DQlUKCiMgV2hlbiBidWlsZGluZyBpbiB0aGUgT3BlbkJTRCB0cmVlIHdlIHVzZSBkaWZm
ZXJlbnQgcGF0aHMKIyBUaGlzIGlzIG9ubHkgcGFydCBvZiB0aGUgc3RvcnksIHRoZSByZXN0IGNv
bWVzIGZyb20gY29uZmlnLm92ZXIKY2FzZSAiJG9wZW5ic2RfZGlzdHJpYnV0aW9uIiBpbgonJ3wk
dW5kZWZ8ZmFsc2UpIDs7CiopCgkjIFdlIHB1dCB0aGluZ3MgaW4gL3Vzciwgbm90IC91c3IvbG9j
YWwKCXByZWZpeD0nL3VzcicKCXByZWZpeGV4cD0nL3VzcicKCXN5c21hbj0nL3Vzci9zaGFyZS9t
YW4vbWFuMScKCWxpYnB0aD0nL3Vzci9saWInCglnbGlicHRoPScvdXNyL2xpYicKCSMgTG9jYWwg
dGhpbmdzLCBob3dldmVyLCBkbyBnbyBpbiAvdXNyL2xvY2FsCglzaXRlcHJlZml4PScvdXNyL2xv
Y2FsJwoJc2l0ZXByZWZpeGV4cD0nL3Vzci9sb2NhbCcKCSMgUG9ydHMgaW5zdGFsbHMgbm9uLXN0
ZCBsaWJzIGluIC91c3IvbG9jYWwvbGliIHNvIGxvb2sgdGhlcmUgdG9vCglsb2NpbmNwdGg9Jy91
c3IvbG9jYWwvaW5jbHVkZScKCWxvY2xpYnB0aD0nL3Vzci9sb2NhbC9saWInCgkjIExpbmsgcGVy
bCB3aXRoIHNoYXJlZCBsaWJwZXJsCglpZiBbICIkdXNlZGwiID0gIiRkZWZpbmUiIC1hIC1yIHNo
bGliX3ZlcnNpb24gXTsgdGhlbgoJCXVzZXNocnBsaWI9dHJ1ZQoJCWxpYnBlcmw9YC4gLi9zaGxp
Yl92ZXJzaW9uOyBlY2hvIGxpYnBlcmwuc28uJHttYWpvcn0uJHttaW5vcn1gCglmaQoJOzsKZXNh
YwoKIyBvcGVuYnNkIGhhcyBhIHByb2JsZW0gcmVnYXJkaW5nIG5ld2xvY2FsZSgpCiMgaHR0cHM6
Ly9tYXJjLmluZm8vP2w9b3BlbmJzZC1idWdzJm09MTU1MzY0NTY4NjA4NzU5Jnc9MgojIHdoaWNo
IGlzIGJlaW5nIGZpeGVkLiAgSW4gdGhlIG1lYW50aW1lLCBmb3JiaWQgUE9TSVggMjAwOCBsb2Nh
bGVzCiNkX25ld2xvY2FsZT0iJHVuZGVmIgoKIyBsaWJjIG9uIHRoaXMgcGxhdGZvcm0gYWx3YXlz
IGtlZXBzIHRoZXNlIGNhdGVnb3JpZXMgaW4gdGhlIEMgbG9jYWxlCmNjZmxhZ3M9IiRjY2ZsYWdz
IC1ETk9fTE9DQUxFX05VTUVSSUMgLUROT19MT0NBTEVfQ09MTEFURSAtRE5PX0xPQ0FMRV9NT05F
VEFSWSAtRE5PX0xPQ0FMRV9USU1FIC1ETk9fTE9DQUxFX01FU1NBR0VTIgoKIyBBbmQgdGhlIG9u
bHkgcG9zc2libGUgbWlzbWF0Y2hlZCBMQ19DVFlQRSBsb2NhbGUgaXMgQy5VVEYtOCAoYXMgb25s
eSBpdCBhbmQKIyBwbGFpbiBDIGFyZSBsZWdhbCBmb3IgdGhpcyBjYXRlZ29yeSkuICBBbGwgb3Ro
ZXIgY2F0ZWdvcmllcyBkZWFsIG9ubHkgaW4KIyBBU0NJSSBjaGFyYWN0ZXJzIHdoaWNoIGFyZSBh
IHN1YnNldCBvZiBDLlVURi04LgpjY2ZsYWdzPSIkY2NmbGFncyAtRExJQkNfSEFORExFU19NSVNN
QVRDSEVEX0NUWVBFIgoKIyBTZWVtcyB0aGF0IE9wZW5CU0QgcmV0dXJucyBib2d1cyB2YWx1ZXMg
aW4gX1RocmVhZF9sb2NhbCB2YXJpYWJsZXMgaW4gY29kZSBpbgojIHNoYXJlZCBvYmplY3RzLCBz
byB3ZSBuZWVkIHRvIGRpc2FibGUgaXQuIFNlZSBHSCAjMTkxMDkKZF90aHJlYWRfbG9jYWw9dW5k
ZWYKCiMgZW5kCg==',
'solaris' =>
'IyBoaW50cy9zb2xhcmlzXzIuc2gKIyBDb250cmlidXRpb25zIGJ5IChpbiBhbHBoYWJldGljYWwg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',
);

my %files = (
  'freebsd' => 'freebsd.sh',
  'netbsd'  => 'netbsd.sh',
  'openbsd' => 'openbsd.sh',
  'linux'   => 'linux.sh',
  'dragonfly' => 'dragonfly.sh',
  'darwin' => 'darwin.sh',
  'hpux' => 'hpux.sh',
  'cygwin' => 'cygwin.sh',
  'midnightbsd' => 'midnightbsd.sh',
  'gnukfreebsd' => 'gnukfreebsd.sh',
  'solaris' => 'solaris_2.sh',
  'bitrig' => 'bitrig.sh',
  'gnu' => 'gnu.sh',
);

sub hint_file {
  my $os = shift;
  $os = shift if eval { $os->isa(__PACKAGE__) };
  $os = $^O unless $os;
  return unless defined $hints{ $os };
  my $content = decode_base64( $hints{ $os } );
  return $content unless wantarray;
  return ( $files{ $os }, $content );
}

sub hints {
  return sort keys %hints;
}

qq'nudge nudge wink wink';

__END__

=pod

=encoding UTF-8

=head1 NAME

Devel::PatchPerl::Hints - replacement 'hints' files

=head1 VERSION

version 2.12

=head1 SYNOPSIS

  use Devel::PatchPerl::Hints;

  if ( my $content = Devel::PatchPerl::Hints->hint_file() ) {
    chmod 0644, 'hints/netbsd.sh' or die "$!";
    open my $hints, '>', 'hints/netbsd.sh' or die "$!";
    print $hints $content;
    close $hints;
  }

  # Get a list of OS for which we have hints

  my @os = Devel::PatchPerl::Hints->hints();

=head1 DESCRIPTION

Sometimes there is a problem with Perls C<hints> file for a particular
perl port. This module provides fixed C<hints> files encoded using
C<MIME::Base64>.

=head1 FUNCTION

The function is exported, but has to implicitly imported into the
requesting package.

  use Devel::PatchPerl::Hints qw[hint_file];

It may also be called as a class method:

  use Devel::PatchPerl::Hints;

  my $content = Devel::PatchPerl::Hints->hint_file();

=over

=item C<hint_file>

Takes an optional argument which is the OS name ( as would be returned by C<$^O> ).
By default it will use C<$^O>.

In a scalar context, Will return the decoded content of the C<hints> file suitable for writing straight to a
file handle or undef list if there isn't an applicable C<hints> file for the given or derived
OS.

If called in a list context, will return a list, the first item will be the name of the C<hints> file that
will need to be amended, the second item will be a string with the decoded content of the C<hints> file suitable
for writing straight to a file handle. Otherwise an empty list will be returned.

=item C<hints>

Takes no arguments, returns a list of OS names for which there are C<hints> files.

=back

=head1 AUTHOR

Chris Williams <chris@bingosnet.co.uk>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2025 by Chris Williams and Marcus Holland-Moritz.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
