/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.graphic;

import java.awt.Color;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import net.sourceforge.plantuml.command.regex.MyPattern;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.HtmlColorGradient;
import net.sourceforge.plantuml.graphic.HtmlColorSimple;
import net.sourceforge.plantuml.graphic.HtmlColorTransparent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HtmlColorUtils {
    public static final String COLOR_REGEXP = "#\\w+[-\\\\|/]?\\w+";
    private static final Map<String, String> htmlNames = new HashMap<String, String>();
    private static final Set<String> names = new TreeSet<String>();
    public static final HtmlColor BLACK;
    public static final HtmlColor WHITE;
    public static final HtmlColor RED_LIGHT;
    public static final HtmlColor RED_DARK;
    public static final HtmlColor RED;
    public static final HtmlColor GREEN;
    public static final HtmlColor BLUE;
    public static final HtmlColor GRAY;
    public static final HtmlColor LIGHT_GRAY;
    public static final HtmlColor TRANSPARENT;
    public static final HtmlColor MY_YELLOW;
    public static final HtmlColor MY_RED;

    private static void register(String string, String string2) {
        htmlNames.put(string.toLowerCase(), string2);
        names.add(string);
    }

    private static HtmlColor build(String string) {
        Color color;
        if ((string = HtmlColorUtils.removeFirstDieseAndToLowercase(string)).equalsIgnoreCase("transparent")) {
            return TRANSPARENT;
        }
        if (string.matches("[0-9A-Fa-f]{6}")) {
            color = new Color(Integer.parseInt(string, 16));
        } else {
            String string2 = htmlNames.get(string);
            if (string2 == null) {
                throw new IllegalArgumentException(string);
            }
            color = new Color(Integer.parseInt(string2.substring(1), 16));
        }
        return new HtmlColorSimple(color, false);
    }

    private static boolean isValid(String string, boolean bl) {
        if ((string = HtmlColorUtils.removeFirstDieseAndToLowercase(string)).matches("[0-9A-Fa-f]{6}")) {
            return true;
        }
        if (bl && string.equalsIgnoreCase("transparent")) {
            return true;
        }
        return htmlNames.containsKey(string);
    }

    public static HtmlColor getColorIfValid(String string) {
        return HtmlColorUtils.getColorIfValid(string, false);
    }

    public static HtmlColor getColorIfValid(String string, boolean bl) {
        if (string == null) {
            return null;
        }
        Matcher matcher = MyPattern.cmpile("[-\\\\|/]").matcher(string);
        if (matcher.find()) {
            char c = matcher.group(0).charAt(0);
            int n = string.indexOf(c);
            String string2 = string.substring(0, n);
            String string3 = string.substring(n + 1);
            if (!HtmlColorUtils.isValid(string2, false) || !HtmlColorUtils.isValid(string3, false)) {
                return null;
            }
            return new HtmlColorGradient(HtmlColorUtils.build(string2), HtmlColorUtils.build(string3), c);
        }
        if (!HtmlColorUtils.isValid(string, bl)) {
            return null;
        }
        return HtmlColorUtils.build(string);
    }

    private static String removeFirstDieseAndToLowercase(String string) {
        if ((string = string.toLowerCase()).startsWith("#")) {
            string = string.substring(1);
        }
        return string;
    }

    public static Collection<String> names() {
        return Collections.unmodifiableSet(names);
    }

    static {
        HtmlColorUtils.register("AliceBlue", "#F0F8FF");
        HtmlColorUtils.register("AntiqueWhite", "#FAEBD7");
        HtmlColorUtils.register("Aqua", "#00FFFF");
        HtmlColorUtils.register("Aquamarine", "#7FFFD4");
        HtmlColorUtils.register("Azure", "#F0FFFF");
        HtmlColorUtils.register("Beige", "#F5F5DC");
        HtmlColorUtils.register("Bisque", "#FFE4C4");
        HtmlColorUtils.register("Black", "#000000");
        HtmlColorUtils.register("BlanchedAlmond", "#FFEBCD");
        HtmlColorUtils.register("Blue", "#0000FF");
        HtmlColorUtils.register("BlueViolet", "#8A2BE2");
        HtmlColorUtils.register("Brown", "#A52A2A");
        HtmlColorUtils.register("BurlyWood", "#DEB887");
        HtmlColorUtils.register("CadetBlue", "#5F9EA0");
        HtmlColorUtils.register("Chartreuse", "#7FFF00");
        HtmlColorUtils.register("Chocolate", "#D2691E");
        HtmlColorUtils.register("Coral", "#FF7F50");
        HtmlColorUtils.register("CornflowerBlue", "#6495ED");
        HtmlColorUtils.register("Cornsilk", "#FFF8DC");
        HtmlColorUtils.register("Crimson", "#DC143C");
        HtmlColorUtils.register("Cyan", "#00FFFF");
        HtmlColorUtils.register("DarkBlue", "#00008B");
        HtmlColorUtils.register("DarkCyan", "#008B8B");
        HtmlColorUtils.register("DarkGoldenRod", "#B8860B");
        HtmlColorUtils.register("DarkGray", "#A9A9A9");
        HtmlColorUtils.register("DarkGrey", "#A9A9A9");
        HtmlColorUtils.register("DarkGreen", "#006400");
        HtmlColorUtils.register("DarkKhaki", "#BDB76B");
        HtmlColorUtils.register("DarkMagenta", "#8B008B");
        HtmlColorUtils.register("DarkOliveGreen", "#556B2F");
        HtmlColorUtils.register("Darkorange", "#FF8C00");
        HtmlColorUtils.register("DarkOrchid", "#9932CC");
        HtmlColorUtils.register("DarkRed", "#8B0000");
        HtmlColorUtils.register("DarkSalmon", "#E9967A");
        HtmlColorUtils.register("DarkSeaGreen", "#8FBC8F");
        HtmlColorUtils.register("DarkSlateBlue", "#483D8B");
        HtmlColorUtils.register("DarkSlateGray", "#2F4F4F");
        HtmlColorUtils.register("DarkSlateGrey", "#2F4F4F");
        HtmlColorUtils.register("DarkTurquoise", "#00CED1");
        HtmlColorUtils.register("DarkViolet", "#9400D3");
        HtmlColorUtils.register("DeepPink", "#FF1493");
        HtmlColorUtils.register("DeepSkyBlue", "#00BFFF");
        HtmlColorUtils.register("DimGray", "#696969");
        HtmlColorUtils.register("DimGrey", "#696969");
        HtmlColorUtils.register("DodgerBlue", "#1E90FF");
        HtmlColorUtils.register("FireBrick", "#B22222");
        HtmlColorUtils.register("FloralWhite", "#FFFAF0");
        HtmlColorUtils.register("ForestGreen", "#228B22");
        HtmlColorUtils.register("Fuchsia", "#FF00FF");
        HtmlColorUtils.register("Gainsboro", "#DCDCDC");
        HtmlColorUtils.register("GhostWhite", "#F8F8FF");
        HtmlColorUtils.register("Gold", "#FFD700");
        HtmlColorUtils.register("GoldenRod", "#DAA520");
        HtmlColorUtils.register("Gray", "#808080");
        HtmlColorUtils.register("Grey", "#808080");
        HtmlColorUtils.register("Green", "#008000");
        HtmlColorUtils.register("GreenYellow", "#ADFF2F");
        HtmlColorUtils.register("HoneyDew", "#F0FFF0");
        HtmlColorUtils.register("HotPink", "#FF69B4");
        HtmlColorUtils.register("IndianRed", "#CD5C5C");
        HtmlColorUtils.register("Indigo", "#4B0082");
        HtmlColorUtils.register("Ivory", "#FFFFF0");
        HtmlColorUtils.register("Khaki", "#F0E68C");
        HtmlColorUtils.register("Lavender", "#E6E6FA");
        HtmlColorUtils.register("LavenderBlush", "#FFF0F5");
        HtmlColorUtils.register("LawnGreen", "#7CFC00");
        HtmlColorUtils.register("LemonChiffon", "#FFFACD");
        HtmlColorUtils.register("LightBlue", "#ADD8E6");
        HtmlColorUtils.register("LightCoral", "#F08080");
        HtmlColorUtils.register("LightCyan", "#E0FFFF");
        HtmlColorUtils.register("LightGoldenRodYellow", "#FAFAD2");
        HtmlColorUtils.register("LightGray", "#D3D3D3");
        HtmlColorUtils.register("LightGrey", "#D3D3D3");
        HtmlColorUtils.register("LightGreen", "#90EE90");
        HtmlColorUtils.register("LightPink", "#FFB6C1");
        HtmlColorUtils.register("LightSalmon", "#FFA07A");
        HtmlColorUtils.register("LightSeaGreen", "#20B2AA");
        HtmlColorUtils.register("LightSkyBlue", "#87CEFA");
        HtmlColorUtils.register("LightSlateGray", "#778899");
        HtmlColorUtils.register("LightSlateGrey", "#778899");
        HtmlColorUtils.register("LightSteelBlue", "#B0C4DE");
        HtmlColorUtils.register("LightYellow", "#FFFFE0");
        HtmlColorUtils.register("Lime", "#00FF00");
        HtmlColorUtils.register("LimeGreen", "#32CD32");
        HtmlColorUtils.register("Linen", "#FAF0E6");
        HtmlColorUtils.register("Magenta", "#FF00FF");
        HtmlColorUtils.register("Maroon", "#800000");
        HtmlColorUtils.register("MediumAquaMarine", "#66CDAA");
        HtmlColorUtils.register("MediumBlue", "#0000CD");
        HtmlColorUtils.register("MediumOrchid", "#BA55D3");
        HtmlColorUtils.register("MediumPurple", "#9370D8");
        HtmlColorUtils.register("MediumSeaGreen", "#3CB371");
        HtmlColorUtils.register("MediumSlateBlue", "#7B68EE");
        HtmlColorUtils.register("MediumSpringGreen", "#00FA9A");
        HtmlColorUtils.register("MediumTurquoise", "#48D1CC");
        HtmlColorUtils.register("MediumVioletRed", "#C71585");
        HtmlColorUtils.register("MidnightBlue", "#191970");
        HtmlColorUtils.register("MintCream", "#F5FFFA");
        HtmlColorUtils.register("MistyRose", "#FFE4E1");
        HtmlColorUtils.register("Moccasin", "#FFE4B5");
        HtmlColorUtils.register("NavajoWhite", "#FFDEAD");
        HtmlColorUtils.register("Navy", "#000080");
        HtmlColorUtils.register("OldLace", "#FDF5E6");
        HtmlColorUtils.register("Olive", "#808000");
        HtmlColorUtils.register("OliveDrab", "#6B8E23");
        HtmlColorUtils.register("Orange", "#FFA500");
        HtmlColorUtils.register("OrangeRed", "#FF4500");
        HtmlColorUtils.register("Orchid", "#DA70D6");
        HtmlColorUtils.register("PaleGoldenRod", "#EEE8AA");
        HtmlColorUtils.register("PaleGreen", "#98FB98");
        HtmlColorUtils.register("PaleTurquoise", "#AFEEEE");
        HtmlColorUtils.register("PaleVioletRed", "#D87093");
        HtmlColorUtils.register("PapayaWhip", "#FFEFD5");
        HtmlColorUtils.register("PeachPuff", "#FFDAB9");
        HtmlColorUtils.register("Peru", "#CD853F");
        HtmlColorUtils.register("Pink", "#FFC0CB");
        HtmlColorUtils.register("Plum", "#DDA0DD");
        HtmlColorUtils.register("PowderBlue", "#B0E0E6");
        HtmlColorUtils.register("Purple", "#800080");
        HtmlColorUtils.register("Red", "#FF0000");
        HtmlColorUtils.register("RosyBrown", "#BC8F8F");
        HtmlColorUtils.register("RoyalBlue", "#4169E1");
        HtmlColorUtils.register("SaddleBrown", "#8B4513");
        HtmlColorUtils.register("Salmon", "#FA8072");
        HtmlColorUtils.register("SandyBrown", "#F4A460");
        HtmlColorUtils.register("SeaGreen", "#2E8B57");
        HtmlColorUtils.register("SeaShell", "#FFF5EE");
        HtmlColorUtils.register("Sienna", "#A0522D");
        HtmlColorUtils.register("Silver", "#C0C0C0");
        HtmlColorUtils.register("SkyBlue", "#87CEEB");
        HtmlColorUtils.register("SlateBlue", "#6A5ACD");
        HtmlColorUtils.register("SlateGray", "#708090");
        HtmlColorUtils.register("SlateGrey", "#708090");
        HtmlColorUtils.register("Snow", "#FFFAFA");
        HtmlColorUtils.register("SpringGreen", "#00FF7F");
        HtmlColorUtils.register("SteelBlue", "#4682B4");
        HtmlColorUtils.register("Tan", "#D2B48C");
        HtmlColorUtils.register("Teal", "#008080");
        HtmlColorUtils.register("Thistle", "#D8BFD8");
        HtmlColorUtils.register("Tomato", "#FF6347");
        HtmlColorUtils.register("Turquoise", "#40E0D0");
        HtmlColorUtils.register("Violet", "#EE82EE");
        HtmlColorUtils.register("Wheat", "#F5DEB3");
        HtmlColorUtils.register("White", "#FFFFFF");
        HtmlColorUtils.register("WhiteSmoke", "#F5F5F5");
        HtmlColorUtils.register("Yellow", "#FFFF00");
        HtmlColorUtils.register("YellowGreen", "#9ACD32");
        BLACK = HtmlColorUtils.getColorIfValid("black");
        WHITE = HtmlColorUtils.getColorIfValid("white");
        RED_LIGHT = HtmlColorUtils.getColorIfValid("#FEF6F3");
        RED_DARK = HtmlColorUtils.getColorIfValid("#CD0A0A");
        RED = HtmlColorUtils.getColorIfValid("#FF0000");
        GREEN = HtmlColorUtils.getColorIfValid("#00FF00");
        BLUE = HtmlColorUtils.getColorIfValid("#0000FF");
        GRAY = HtmlColorUtils.getColorIfValid("#808080");
        LIGHT_GRAY = HtmlColorUtils.getColorIfValid("#C0C0C0");
        TRANSPARENT = new HtmlColorTransparent();
        MY_YELLOW = HtmlColorUtils.getColorIfValid("#FEFECE");
        MY_RED = HtmlColorUtils.getColorIfValid("#A80036");
    }
}

