# This file was automatically generated by SWIG (http://www.swig.org).
# Version 1.3.40
#
# Do not make changes to this file unless you know what you are doing--modify
# the SWIG interface file instead.

package Crypt::HC128;
# ABSTRACT: Perl extension module for the HC-128 stream cipher based on wolfssl  
# KEYWORDS: HC-128 stream cipher wolfssl

use strict; 
use base qw(Exporter);
use base qw(DynaLoader);

our $VERSION = '0.0.2';

package Crypt::HC128c;
bootstrap Crypt::HC128;
package Crypt::HC128;
our @EXPORT = qw();

# ---------- BASE METHODS -------------

package Crypt::HC128;

sub TIEHASH {
    my ($classname,$obj) = @_;
    return bless $obj, $classname;
}

sub CLEAR { }

sub FIRSTKEY { }

sub NEXTKEY { }

sub FETCH {
    my ($self,$field) = @_;
    my $member_func = "swig_${field}_get";
    $self->$member_func();
}

sub STORE {
    my ($self,$field,$newval) = @_;
    my $member_func = "swig_${field}_set";
    $self->$member_func($newval);
}

sub this {
    my $ptr = shift;
    return tied(%$ptr);
}


# ------- FUNCTION WRAPPERS --------

package Crypt::HC128;

*Hc128_Process = *Crypt::HC128c::Hc128_Process;
*Hc128_SetKey = *Crypt::HC128c::Hc128_SetKey;

############# Class : Crypt::HC128::HC128 ##############

package Crypt::HC128::HC128;
use vars qw(@ISA %OWNER %ITERATORS %BLESSEDMEMBERS);
@ISA = qw( Crypt::HC128 );
%OWNER = ();
%ITERATORS = ();
*swig_T_get = *Crypt::HC128c::HC128_T_get;
*swig_T_set = *Crypt::HC128c::HC128_T_set;
*swig_X_get = *Crypt::HC128c::HC128_X_get;
*swig_X_set = *Crypt::HC128c::HC128_X_set;
*swig_Y_get = *Crypt::HC128c::HC128_Y_get;
*swig_Y_set = *Crypt::HC128c::HC128_Y_set;
*swig_counter1024_get = *Crypt::HC128c::HC128_counter1024_get;
*swig_counter1024_set = *Crypt::HC128c::HC128_counter1024_set;
*swig_key_get = *Crypt::HC128c::HC128_key_get;
*swig_key_set = *Crypt::HC128c::HC128_key_set;
*swig_iv_get = *Crypt::HC128c::HC128_iv_get;
*swig_iv_set = *Crypt::HC128c::HC128_iv_set;
sub new {
    my $pkg = shift;
    my $self = Crypt::HC128c::new_HC128(@_);
    bless $self, $pkg if defined($self);
}

sub DESTROY {
    return unless $_[0]->isa('HASH');
    my $self = tied(%{$_[0]});
    return unless defined $self;
    delete $ITERATORS{$self};
    if (exists $OWNER{$self}) {
        Crypt::HC128c::delete_HC128($self);
        delete $OWNER{$self};
    }
}

sub DISOWN {
    my $self = shift;
    my $ptr = tied(%$self);
    delete $OWNER{$ptr};
}

sub ACQUIRE {
    my $self = shift;
    my $ptr = tied(%$self);
    $OWNER{$ptr} = 1;
}


# ------- VARIABLE STUBS --------

package Crypt::HC128;

*HC128_ENC_TYPE = *Crypt::HC128c::HC128_ENC_TYPE;
1;

=pod

=encoding UTF-8

=head1 NAME

Crypt::HC128 - Perl extension module for the HC-128 stream cipher based on wolfssl  

=head1 SYNOPSIS

  use Crypt::HC128;

=head1 DESCRIPTION

Perl extension module for the HC-128 stream cipher based on wolfssl. 

=head2 EXPORT

None by default.

=head2 Exportable constants

  HC128_ENC_TYPE

=head2 Exportable functions

  int Hc128_Process(HC128*, byte*, const byte*, word32)
  int Hc128_SetKey(HC128*, const byte* key, const byte* iv)

=head1 NAME

Crypt::HC128 - Perl extension for HC-128 stream cipher

=head1 SEE ALSO

 L<Chapter 18: wolfCrypt API Reference|https://wolfssl.com/wolfSSL/Docs-wolfssl-manual-18-17-wolfcrypt-api-hc128.html>

=head1 AUTHOR

Li ZHOU, E<lt>lzh@cpan.orgE<gt>

=head1 COPYRIGHT AND LICENSE

Copyright (C) 2017 by Li ZHOU

This library is free software; you can redistribute it and/or modify
it under the same terms as Perl itself, either Perl version 5.20.3 or,
at your option, any later version of Perl 5 you may have available.

=cut

=head1 AUTHOR

Li ZHOU <lzh@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2017 by Li ZHOU.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut

__END__
# Below is stub documentation for your module. You'd better edit it!
 

