/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.event.ComplexContentOutputter;
import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.StringValue;

public class StringJoin
extends SystemFunction {
    private boolean returnEmptyIfEmpty;

    public void setReturnEmptyIfEmpty(boolean option) {
        this.returnEmptyIfEmpty = option;
    }

    public boolean isReturnEmptyIfEmpty() {
        return this.returnEmptyIfEmpty;
    }

    public Expression copy() {
        StringJoin sj = (StringJoin)super.copy();
        sj.returnEmptyIfEmpty = this.returnEmptyIfEmpty;
        return sj;
    }

    public boolean equals(Object o) {
        return o instanceof StringJoin && super.equals(o) && this.returnEmptyIfEmpty == ((StringJoin)o).returnEmptyIfEmpty;
    }

    public int getImplementationMethod() {
        return super.getImplementationMethod() | 0x10;
    }

    public Expression optimize(ExpressionVisitor visitor, ExpressionVisitor.ContextItemType contextItemType) throws XPathException {
        Expression exp2;
        Expression exp = super.optimize(visitor, contextItemType);
        if (exp instanceof StringJoin && exp != (exp2 = ((StringJoin)exp).simplifySingleton())) {
            return visitor.optimize(exp2, contextItemType);
        }
        return exp;
    }

    private Expression simplifySingleton() {
        int card = this.argument[0].getCardinality();
        if (!Cardinality.allowsMany(card)) {
            if (Cardinality.allowsZero(card)) {
                return SystemFunction.makeSystemFunction("string", new Expression[]{this.argument[0]});
            }
            return this.argument[0];
        }
        return this;
    }

    public Item evaluateItem(XPathContext c) throws XPathException {
        SequenceIterator<? extends Item> iter = this.argument[0].iterate(c);
        Item it = iter.next();
        if (it == null) {
            return this.returnEmptyIfEmpty ? null : StringValue.EMPTY_STRING;
        }
        CharSequence first = it.getStringValueCS();
        it = iter.next();
        if (it == null) {
            return StringValue.makeStringValue(first);
        }
        FastStringBuffer sb = new FastStringBuffer(64);
        sb.append(first);
        if (this.argument.length == 1) {
            sb.append(it.getStringValueCS());
            while (true) {
                if ((it = iter.next()) == null) {
                    return StringValue.makeStringValue(sb.condense());
                }
                sb.append(it.getStringValueCS());
            }
        }
        Item sepItem = this.argument[1].evaluateItem(c);
        assert (sepItem != null);
        CharSequence sep = sepItem.getStringValueCS();
        sb.append(sep);
        sb.append(it.getStringValueCS());
        while ((it = iter.next()) != null) {
            sb.append(sep);
            sb.append(it.getStringValueCS());
        }
        return StringValue.makeStringValue(sb.condense());
    }

    public void process(XPathContext context) throws XPathException {
        SequenceReceiver out = context.getReceiver();
        if (out instanceof ComplexContentOutputter) {
            out.append(StringValue.EMPTY_STRING, 0, 0);
            SequenceIterator<? extends Item> iter = this.argument[0].iterate(context);
            Item it = iter.next();
            if (it == null) {
                return;
            }
            CharSequence first = it.getStringValueCS();
            out.characters(first, 0, 0);
            it = iter.next();
            if (it == null) {
                out.append(StringValue.EMPTY_STRING, 0, 0);
                return;
            }
            if (this.argument.length == 1) {
                out.characters(it.getStringValueCS(), 0, 0);
                while ((it = iter.next()) != null) {
                    out.characters(it.getStringValueCS(), 0, 0);
                }
            } else {
                Item sepItem = this.argument[1].evaluateItem(context);
                assert (sepItem != null);
                CharSequence sep = sepItem.getStringValueCS();
                out.characters(sep, 0, 0);
                out.characters(it.getStringValueCS(), 0, 0);
                while ((it = iter.next()) != null) {
                    out.characters(sep, 0, 0);
                    out.characters(it.getStringValueCS(), 0, 0);
                }
            }
            out.append(StringValue.EMPTY_STRING, 0, 0);
        } else {
            out.append(this.evaluateItem(context), 0, 0);
        }
    }
}

