# Generated by default/object.tt
package Paws::CloudFront::DistributionIdList;
  use Moose;
  has IsTruncated => (is => 'ro', isa => 'Bool', required => 1);
  has Items => (is => 'ro', isa => 'ArrayRef[Str|Undef]', request_name => 'DistributionId', traits => ['NameInRequest']);
  has Marker => (is => 'ro', isa => 'Str', required => 1);
  has MaxItems => (is => 'ro', isa => 'Int', required => 1);
  has NextMarker => (is => 'ro', isa => 'Str');
  has Quantity => (is => 'ro', isa => 'Int', required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::CloudFront::DistributionIdList

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::CloudFront::DistributionIdList object:

  $service_obj->Method(Att1 => { IsTruncated => $value, ..., Quantity => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::CloudFront::DistributionIdList object:

  $result = $service_obj->Method(...);
  $result->Att1->IsTruncated

=head1 DESCRIPTION

A list of distribution IDs.

=head1 ATTRIBUTES


=head2 B<REQUIRED> IsTruncated => Bool

A flag that indicates whether more distribution IDs remain to be
listed. If your results were truncated, you can make a subsequent
request using the C<Marker> request field to retrieve more distribution
IDs in the list.


=head2 Items => ArrayRef[Str|Undef]

Contains the distribution IDs in the list.


=head2 B<REQUIRED> Marker => Str

The value provided in the C<Marker> request field.


=head2 B<REQUIRED> MaxItems => Int

The maximum number of distribution IDs requested.


=head2 NextMarker => Str

Contains the value that you should use in the C<Marker> field of a
subsequent request to continue listing distribution IDs where you left
off.


=head2 B<REQUIRED> Quantity => Int

The total number of distribution IDs returned in the response.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::CloudFront>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

