#!/usr/bin/perl

package eBay::API::XML::DataType::BestOfferDetailsType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. BestOfferDetailsType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::DataType::BestOfferDetailsType

=head1 DESCRIPTION

Container for BestOffer properties associated with the item.



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::DataType::BestOfferDetailsType inherits from the L<eBay::API::XML::BaseDataType> class

=cut

use eBay::API::XML::BaseDataType;
our @ISA = ("eBay::API::XML::BaseDataType");

use eBay::API::XML::DataType::AmountType;
use eBay::API::XML::DataType::Enum::BestOfferStatusCodeType;
use eBay::API::XML::DataType::Enum::BestOfferTypeCodeType;


my @gaProperties = ( [ 'BestOffer', 'ns:AmountType', ''
	     ,'eBay::API::XML::DataType::AmountType', '1' ]
	, [ 'BestOfferCount', 'xs:int', '', '', '' ]
	, [ 'BestOfferEnabled', 'xs:boolean', '', '', '' ]
	, [ 'BestOfferStatus', 'ns:BestOfferStatusCodeType', ''
	     ,'eBay::API::XML::DataType::Enum::BestOfferStatusCodeType', '' ]
	, [ 'BestOfferType', 'ns:BestOfferTypeCodeType', ''
	     ,'eBay::API::XML::DataType::Enum::BestOfferTypeCodeType', '' ]
                    );
push @gaProperties, @{eBay::API::XML::BaseDataType::getPropertiesList()};

my @gaAttributes = ( 
                    );
push @gaAttributes, @{eBay::API::XML::BaseDataType::getAttributesList()};

=head1 Subroutines:

=cut

sub new {
  my $classname = shift;
  my %args = @_;
  my $self = $classname->SUPER::new(%args);
  return $self;
}

sub isScalar {
   return 0; 
}



=head2 setBestOffer()

(GetMyeBayBuying only) Indicates the latest BestOffer the user has provided for the item.

#    Argument: 'ns:AmountType'

=cut

sub setBestOffer {
  my $self = shift;
  $self->{'BestOffer'} = shift
}

=head2 getBestOffer()

  Calls: GetMyeBayBuying
  Returned: Conditionally
  Details: DetailLevel: none, ReturnSummary, ReturnAll
  Context: BestOfferList

#    Returns: 'ns:AmountType'

=cut

sub getBestOffer {
  my $self = shift;
  return $self->_getDataTypeInstance( 'BestOffer'
		,'eBay::API::XML::DataType::AmountType');
}


=head2 setBestOfferCount()

The number of best offers made for this item, if any.

#    Argument: 'xs:int'

=cut

sub setBestOfferCount {
  my $self = shift;
  $self->{'BestOfferCount'} = shift
}

=head2 getBestOfferCount()

  Calls: GetBidderList
         GetSellerList
  Returned: Conditionally

  Calls: GetItem
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription, ItemReturnAttributes, ReturnAll

#    Returns: 'xs:int'

=cut

sub getBestOfferCount {
  my $self = shift;
  return $self->{'BestOfferCount'};
}


=head2 setBestOfferEnabled()

Whether best offer is enabled for this item.
A seller of a fixed price format item (in a category for which Best Offer is also enabled) can opt that item into the Best Offer feature. This feature enables a buyer to make a lower priced binding offer on that item.
If a listing has no active best offers, you can change this value (true to false, and vice versa).
If a listing does have active best offers, you cannot change the value to false.

  Calls: AddItem
         GetItemRecommendations
         RelistItem
         ReviseItem
         VerifyAddItem
  RequiredInput: No

#    Argument: 'xs:boolean'

=cut

sub setBestOfferEnabled {
  my $self = shift;
  $self->{'BestOfferEnabled'} = shift
}

=head2 isBestOfferEnabled()

  Calls: GetBidderList
  Returned: Conditionally

  Calls: GetItem
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription, ItemReturnAttributes, ReturnAll

  Calls: GetSellerEvents
  Returned: Conditionally
  Details: DetailLevel: none, ReturnAll

#    Returns: 'xs:boolean'

=cut

sub isBestOfferEnabled {
  my $self = shift;
  return $self->{'BestOfferEnabled'};
}


=head2 setBestOfferStatus()

(GetMyeBayBuying only) Indicates the status of the latest BestOffer the user has provided for the item.

#    Argument: 'ns:BestOfferStatusCodeType'

=cut

sub setBestOfferStatus {
  my $self = shift;
  $self->{'BestOfferStatus'} = shift
}

=head2 getBestOfferStatus()

  Calls: GetMyeBayBuying
  Returned: Conditionally
  Details: DetailLevel: none, ReturnSummary, ReturnAll
  Context: BestOfferList

#    Returns: 'ns:BestOfferStatusCodeType'

=cut

sub getBestOfferStatus {
  my $self = shift;
  return $self->{'BestOfferStatus'};
}


=head2 setBestOfferType()

Indicates the best offer type of the latest BestOffer the user has provided for the item.

#    Argument: 'ns:BestOfferTypeCodeType'

=cut

sub setBestOfferType {
  my $self = shift;
  $self->{'BestOfferType'} = shift
}

=head2 getBestOfferType()

#    Returns: 'ns:BestOfferTypeCodeType'

=cut

sub getBestOfferType {
  my $self = shift;
  return $self->{'BestOfferType'};
}





##  Attribute and Property lists
sub getPropertiesList {
   my $self = shift;
   return \@gaProperties;
}

sub getAttributesList {
   my $self = shift;
   return \@gaAttributes;
}



1;   
