#!/usr/bin/perl

package eBay::API::XML::DataType::Enum::ShippingServiceCodeType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. ShippingServiceCodeType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::DataType::Enum::ShippingServiceCodeType

=head1 DESCRIPTION

A shipping service used to ship an item. Applications should not depend on the
completeness of ShippingServiceCodeType. GeteBayDetails will return the complete
list of shipping services. To check whether a shipping service is domestic or
international, call GeteBayDetails with a DetailName of ShippingServiceDetails,
specifying a site in the header. Shipping services with a ShippingServiceID of
50000 or higher are international, and the other services are domestic, for that
site.



=head1 SYNOPSIS

=cut



=head1 Enums:

=cut


=head2 UPSGround

UPS Ground



=cut


use constant UPSGround => scalar('UPSGround');


=head2 UPS3rdDay

UPS 3rd Day



=cut


use constant UPS3rdDay => scalar('UPS3rdDay');


=head2 UPS2ndDay

UPS 2nd Day



=cut


use constant UPS2ndDay => scalar('UPS2ndDay');


=head2 UPSNextDay

UPS Next Day



=cut


use constant UPSNextDay => scalar('UPSNextDay');


=head2 USPSPriority

USPS Priority



=cut


use constant USPSPriority => scalar('USPSPriority');


=head2 USPSParcel

USPS Parcel



=cut


use constant USPSParcel => scalar('USPSParcel');


=head2 USPSMedia

USPS Media



=cut


use constant USPSMedia => scalar('USPSMedia');


=head2 USPSFirstClass

USPS First Class



=cut


use constant USPSFirstClass => scalar('USPSFirstClass');


=head2 ShippingMethodStandard

Standard shipping method



=cut


use constant ShippingMethodStandard => scalar('ShippingMethodStandard');


=head2 ShippingMethodExpress

Reserved for internal or future use



=cut


use constant ShippingMethodExpress => scalar('ShippingMethodExpress');


=head2 USPSExpressMail

USPS Express Mail



=cut


use constant USPSExpressMail => scalar('USPSExpressMail');


=head2 UPSNextDayAir

UPS Next Day Air



=cut


use constant UPSNextDayAir => scalar('UPSNextDayAir');


=head2 UPS2DayAirAM

UPS Next Day Air



=cut


use constant UPS2DayAirAM => scalar('UPS2DayAirAM');


=head2 USPSExpressMailFlatRateEnvelope

USPS Express Mail Flat Rate Envelope
To use this service, a seller must specify a package weight so that eBay can validate
the weight against the maximum weight limit for the service. The seller must specify a
package size of Package/Thick Envelope when using calculated shipping



=cut


use constant USPSExpressMailFlatRateEnvelope => scalar('USPSExpressMailFlatRateEnvelope');


=head2 USPSPriorityMailFlatRateEnvelope

USPS Priority Mail Flat Rate Envelope
To use this service, a seller must specify a package weight so that eBay can validate
the weight against the maximum weight limit for the service. The seller must specify a
package size of Package/Thick Envelope when using calculated shipping



=cut


use constant USPSPriorityMailFlatRateEnvelope => scalar('USPSPriorityMailFlatRateEnvelope');


=head2 USPSPriorityMailFlatRateBox

USPS Priority Mail Flat Rate Box
To use this service, a seller must specify a package weight so that eBay can validate
the weight against the maximum weight limit for the service. The seller must specify a
package size of Package/Thick Envelope when using calculated shipping



=cut


use constant USPSPriorityMailFlatRateBox => scalar('USPSPriorityMailFlatRateBox');


=head2 USPSPriorityMailLargeFlatRateBox

USPS Priority Mail Large Flat Rate Box
To use this service, a seller must specify a package weight so that eBay can validate
the weight against the maximum weight limit for the service



=cut


use constant USPSPriorityMailLargeFlatRateBox => scalar('USPSPriorityMailLargeFlatRateBox');


=head2 Other

Other (see description)



=cut


use constant Other => scalar('Other');


=head2 LocalDelivery

Local Delivery/Pickup



=cut


use constant LocalDelivery => scalar('LocalDelivery');


=head2 NotSelected

Not Selected



=cut


use constant NotSelected => scalar('NotSelected');


=head2 InternationalNotSelected

International Not Selected



=cut


use constant InternationalNotSelected => scalar('InternationalNotSelected');


=head2 StandardInternational

Standard International Flat Rate Shipping



=cut


use constant StandardInternational => scalar('StandardInternational');


=head2 ExpeditedInternational

Expedited International Flat Rate Shipping



=cut


use constant ExpeditedInternational => scalar('ExpeditedInternational');


=head2 USPSGlobalExpress

USPS Global Express Mail



=cut


use constant USPSGlobalExpress => scalar('USPSGlobalExpress');


=head2 USPSGlobalPriority

USPS Global Priority Mail



=cut


use constant USPSGlobalPriority => scalar('USPSGlobalPriority');


=head2 USPSEconomyParcel

USPS Economy Parcel Post



=cut


use constant USPSEconomyParcel => scalar('USPSEconomyParcel');


=head2 USPSEconomyLetter

USPS Economy Letter Post



=cut


use constant USPSEconomyLetter => scalar('USPSEconomyLetter');


=head2 USPSAirmailLetter

USPS Airmail Letter Post



=cut


use constant USPSAirmailLetter => scalar('USPSAirmailLetter');


=head2 USPSAirmailParcel

USPS Airmail Parcel Post



=cut


use constant USPSAirmailParcel => scalar('USPSAirmailParcel');


=head2 UPSWorldWideExpressPlus

UPS Worldwide Express Plus



=cut


use constant UPSWorldWideExpressPlus => scalar('UPSWorldWideExpressPlus');


=head2 UPSWorldWideExpress

UPS Worldwide Express



=cut


use constant UPSWorldWideExpress => scalar('UPSWorldWideExpress');


=head2 UPSWorldWideExpedited

UPS Worldwide Expedited



=cut


use constant UPSWorldWideExpedited => scalar('UPSWorldWideExpedited');


=head2 UPSStandardToCanada

UPS Standard To Canada



=cut


use constant UPSStandardToCanada => scalar('UPSStandardToCanada');


=head2 USPSExpressMailInternationalFlatRateEnvelope

USPS Express Mail International Flat Rate Envelope
To use this service, a seller must specify a package weight so that eBay can validate
the weight against the maximum weight limit for the service. The seller must specify a
package size of Package/Thick Envelope when using calculated shipping



=cut


use constant USPSExpressMailInternationalFlatRateEnvelope => scalar('USPSExpressMailInternationalFlatRateEnvelope');


=head2 USPSPriorityMailInternationalFlatRateEnvelope

USPS Priority Mail International Flat Rate Envelope
To use this service, a seller must specify a package weight so that eBay can validate
the weight against the maximum weight limit for the service. The seller must specify a
package size of Package/Thick Envelope when using calculated shipping



=cut


use constant USPSPriorityMailInternationalFlatRateEnvelope => scalar('USPSPriorityMailInternationalFlatRateEnvelope');


=head2 USPSPriorityMailInternationalFlatRateBox

USPS Priority Mail International Flat Rate Box
To use this service, a seller must specify a package weight so that eBay can validate
the weight against the maximum weight limit for the service. The seller must specify a
package size of Package/Thick Envelope when using calculated shipping



=cut


use constant USPSPriorityMailInternationalFlatRateBox => scalar('USPSPriorityMailInternationalFlatRateBox');


=head2 USPSPriorityMailInternationalLargeFlatRateBox

USPS Priority Mail International Large Flat Rate Box
To use this service, a seller must specify a package weight so that eBay can validate
the weight against the maximum weight limit for the service



=cut


use constant USPSPriorityMailInternationalLargeFlatRateBox => scalar('USPSPriorityMailInternationalLargeFlatRateBox');


=head2 OtherInternational

Other International Shipping (see description)



=cut


use constant OtherInternational => scalar('OtherInternational');


=head2 AT_StandardDispatch

Standardversand (unversichert)



=cut


use constant AT_StandardDispatch => scalar('AT_StandardDispatch');


=head2 AT_InsuredDispatch

Versicherter Versand



=cut


use constant AT_InsuredDispatch => scalar('AT_InsuredDispatch');


=head2 AT_Writing

=cut


use constant AT_Writing => scalar('AT_Writing');


=head2 AT_COD

=cut


use constant AT_COD => scalar('AT_COD');


=head2 AT_ExpressOrCourier

Express- oder Kurierversand



=cut


use constant AT_ExpressOrCourier => scalar('AT_ExpressOrCourier');


=head2 AT_InsuredExpressOrCourier

Versicherter Express- oder Kurierversand



=cut


use constant AT_InsuredExpressOrCourier => scalar('AT_InsuredExpressOrCourier');


=head2 AT_SpecialDispatch

=cut


use constant AT_SpecialDispatch => scalar('AT_SpecialDispatch');


=head2 AT_InsuredSpecialDispatch

=cut


use constant AT_InsuredSpecialDispatch => scalar('AT_InsuredSpecialDispatch');


=head2 AT_Sonstige

Sonstige (Siehe Artikelbeschreibung)



=cut


use constant AT_Sonstige => scalar('AT_Sonstige');


=head2 AT_UnversicherterVersandInternational

Unversicherter Versand International



=cut


use constant AT_UnversicherterVersandInternational => scalar('AT_UnversicherterVersandInternational');


=head2 AT_VersicherterVersandInternational

Versicherter Versand International



=cut


use constant AT_VersicherterVersandInternational => scalar('AT_VersicherterVersandInternational');


=head2 AT_SonstigerVersandInternational

Sonstiger Versand International



=cut


use constant AT_SonstigerVersandInternational => scalar('AT_SonstigerVersandInternational');


=head2 AT_UnversicherterExpressVersandInternational

Unversicherter Express Versand International



=cut


use constant AT_UnversicherterExpressVersandInternational => scalar('AT_UnversicherterExpressVersandInternational');


=head2 AT_VersicherterExpressVersandInternational

Versicherter Express Versand International



=cut


use constant AT_VersicherterExpressVersandInternational => scalar('AT_VersicherterExpressVersandInternational');


=head2 AU_Regular

Regular



=cut


use constant AU_Regular => scalar('AU_Regular');


=head2 AU_Express

Express



=cut


use constant AU_Express => scalar('AU_Express');


=head2 AU_Registered

Registered



=cut


use constant AU_Registered => scalar('AU_Registered');


=head2 AU_Courier

Courier



=cut


use constant AU_Courier => scalar('AU_Courier');


=head2 AU_Other

Other



=cut


use constant AU_Other => scalar('AU_Other');


=head2 AU_EMSInternationalCourierParcels

EMS International Courier - Parcels



=cut


use constant AU_EMSInternationalCourierParcels => scalar('AU_EMSInternationalCourierParcels');


=head2 AU_EMSInternationalCourierDocuments

EMS International Courier - Documents



=cut


use constant AU_EMSInternationalCourierDocuments => scalar('AU_EMSInternationalCourierDocuments');


=head2 AU_ExpressPostInternationalDocuments

Express Post International - Documents



=cut


use constant AU_ExpressPostInternationalDocuments => scalar('AU_ExpressPostInternationalDocuments');


=head2 AU_AirMailInternational

Air Mail



=cut


use constant AU_AirMailInternational => scalar('AU_AirMailInternational');


=head2 AU_EconomyAirInternational

Economy Air



=cut


use constant AU_EconomyAirInternational => scalar('AU_EconomyAirInternational');


=head2 AU_SeaMailInternational

Sea Mail



=cut


use constant AU_SeaMailInternational => scalar('AU_SeaMailInternational');


=head2 AU_StandardInternational

Standard International Flat Rate Postage



=cut


use constant AU_StandardInternational => scalar('AU_StandardInternational');


=head2 AU_ExpeditedInternational

Expedited International Flat Rate Postage



=cut


use constant AU_ExpeditedInternational => scalar('AU_ExpeditedInternational');


=head2 AU_OtherInternational

Other International Postage



=cut


use constant AU_OtherInternational => scalar('AU_OtherInternational');


=head2 BEFR_StandardDelivery

=cut


use constant BEFR_StandardDelivery => scalar('BEFR_StandardDelivery');


=head2 BEFR_PriorityDelivery

=cut


use constant BEFR_PriorityDelivery => scalar('BEFR_PriorityDelivery');


=head2 BEFR_ParcelPost

=cut


use constant BEFR_ParcelPost => scalar('BEFR_ParcelPost');


=head2 BEFR_RegisteredMail

=cut


use constant BEFR_RegisteredMail => scalar('BEFR_RegisteredMail');


=head2 BEFR_Other

=cut


use constant BEFR_Other => scalar('BEFR_Other');


=head2 BEFR_DePostInternational

De Post



=cut


use constant BEFR_DePostInternational => scalar('BEFR_DePostInternational');


=head2 BEFR_UPSInternational

UPS



=cut


use constant BEFR_UPSInternational => scalar('BEFR_UPSInternational');


=head2 BEFR_FedExInternational

Fedex



=cut


use constant BEFR_FedExInternational => scalar('BEFR_FedExInternational');


=head2 BEFR_DHLInternational

DHL



=cut


use constant BEFR_DHLInternational => scalar('BEFR_DHLInternational');


=head2 BEFR_TPGPostTNTInternational

TPG Post/TNT (Netherlands)



=cut


use constant BEFR_TPGPostTNTInternational => scalar('BEFR_TPGPostTNTInternational');


=head2 BEFR_StandardInternational

Frais de livraison internationale fixes



=cut


use constant BEFR_StandardInternational => scalar('BEFR_StandardInternational');


=head2 BEFR_ExpeditedInternational

Frais fixes pour livraison internationale express



=cut


use constant BEFR_ExpeditedInternational => scalar('BEFR_ExpeditedInternational');


=head2 BEFR_OtherInternational

Autres livraisons internationales (voir description)



=cut


use constant BEFR_OtherInternational => scalar('BEFR_OtherInternational');


=head2 BEFR_LaPosteInternational

La Poste (France)



=cut


use constant BEFR_LaPosteInternational => scalar('BEFR_LaPosteInternational');


=head2 BEFR_LaPosteStandardShipping

La Poste - livraison standard (1 a 2 jours ouvrables)



=cut


use constant BEFR_LaPosteStandardShipping => scalar('BEFR_LaPosteStandardShipping');


=head2 BEFR_LaPosteCertifiedShipping

La Poste - envoi recommande (1 jour ouvrable)



=cut


use constant BEFR_LaPosteCertifiedShipping => scalar('BEFR_LaPosteCertifiedShipping');


=head2 BEFR_LaPosteTaxipostLLS

La Poste - Taxipost LLS (2 jours ouvrables)



=cut


use constant BEFR_LaPosteTaxipostLLS => scalar('BEFR_LaPosteTaxipostLLS');


=head2 BEFR_LaPosteTaxipost24h

La Poste - Taxipost 24h (1 jour ouvrable)



=cut


use constant BEFR_LaPosteTaxipost24h => scalar('BEFR_LaPosteTaxipost24h');


=head2 BEFR_LaPosteTaxipostSecur

Autres livraisons



=cut


use constant BEFR_LaPosteTaxipostSecur => scalar('BEFR_LaPosteTaxipostSecur');


=head2 BEFR_PostInternationalStandard

La Poste - livraison standard



=cut


use constant BEFR_PostInternationalStandard => scalar('BEFR_PostInternationalStandard');


=head2 BEFR_PostInternationalRegistered

La Poste - envoi recommande



=cut


use constant BEFR_PostInternationalRegistered => scalar('BEFR_PostInternationalRegistered');


=head2 BEFR_TNTInternational

TNT



=cut


use constant BEFR_TNTInternational => scalar('BEFR_TNTInternational');


=head2 BENL_StandardDelivery

Standard Delivery



=cut


use constant BENL_StandardDelivery => scalar('BENL_StandardDelivery');


=head2 BENL_PriorityDelivery

Priority Delivery



=cut


use constant BENL_PriorityDelivery => scalar('BENL_PriorityDelivery');


=head2 BENL_ParcelPost

Parcel Post



=cut


use constant BENL_ParcelPost => scalar('BENL_ParcelPost');


=head2 BENL_RegisteredMail

Registered Mail



=cut


use constant BENL_RegisteredMail => scalar('BENL_RegisteredMail');


=head2 BENL_Other

Other Shipping Service



=cut


use constant BENL_Other => scalar('BENL_Other');


=head2 BENL_DePostInternational

De Post



=cut


use constant BENL_DePostInternational => scalar('BENL_DePostInternational');


=head2 BENL_UPSInternational

UPS



=cut


use constant BENL_UPSInternational => scalar('BENL_UPSInternational');


=head2 BENL_FedExInternational

Fedex



=cut


use constant BENL_FedExInternational => scalar('BENL_FedExInternational');


=head2 BENL_DHLInternational

DHL



=cut


use constant BENL_DHLInternational => scalar('BENL_DHLInternational');


=head2 BENL_TPGPostTNTInternational

TPG Post/TNT (Netherlands)



=cut


use constant BENL_TPGPostTNTInternational => scalar('BENL_TPGPostTNTInternational');


=head2 BENL_StandardInternational

Standard International



=cut


use constant BENL_StandardInternational => scalar('BENL_StandardInternational');


=head2 BENL_ExpeditedInternational

Expedited International



=cut


use constant BENL_ExpeditedInternational => scalar('BENL_ExpeditedInternational');


=head2 BENL_OtherInternational

Other International Shipping Services



=cut


use constant BENL_OtherInternational => scalar('BENL_OtherInternational');


=head2 BENL_LaPosteInternational

La Poste (France)



=cut


use constant BENL_LaPosteInternational => scalar('BENL_LaPosteInternational');


=head2 BENL_DePostStandardShipping

De Post - standaardverzending (1 tot 2 werkdagen)



=cut


use constant BENL_DePostStandardShipping => scalar('BENL_DePostStandardShipping');


=head2 BENL_DePostCertifiedShipping

De Post - aangetekende zending (1 werkdag)



=cut


use constant BENL_DePostCertifiedShipping => scalar('BENL_DePostCertifiedShipping');


=head2 BENL_DePostTaxipostLLS

De Post - Taxipost LLS (2 werkdagen)



=cut


use constant BENL_DePostTaxipostLLS => scalar('BENL_DePostTaxipostLLS');


=head2 BENL_DePostTaxipost24h

De Post - Taxipost 24u (1 werkdag)



=cut


use constant BENL_DePostTaxipost24h => scalar('BENL_DePostTaxipost24h');


=head2 BENL_DePostTaxipostSecur

De Post - Taxipost Secur (1 werkdag)



=cut


use constant BENL_DePostTaxipostSecur => scalar('BENL_DePostTaxipostSecur');


=head2 BENL_OtherShippingMethods

Andere verzending



=cut


use constant BENL_OtherShippingMethods => scalar('BENL_OtherShippingMethods');


=head2 BENL_PostInternationalStandard

De Post - standaardverzending



=cut


use constant BENL_PostInternationalStandard => scalar('BENL_PostInternationalStandard');


=head2 BENL_PostInternationalRegistered

De Post - aangetekende zending



=cut


use constant BENL_PostInternationalRegistered => scalar('BENL_PostInternationalRegistered');


=head2 BENL_TNTInternational

TNT



=cut


use constant BENL_TNTInternational => scalar('BENL_TNTInternational');


=head2 CA_StandardDelivery

Standard Delivery



=cut


use constant CA_StandardDelivery => scalar('CA_StandardDelivery');


=head2 CA_ExpeditedDelivery

=cut


use constant CA_ExpeditedDelivery => scalar('CA_ExpeditedDelivery');


=head2 CA_PostLettermail

Canada Post Lettermail



=cut


use constant CA_PostLettermail => scalar('CA_PostLettermail');


=head2 CA_PostRegularParcel

Canada Post Regular Parcel



=cut


use constant CA_PostRegularParcel => scalar('CA_PostRegularParcel');


=head2 CA_PostExpeditedParcel

Canada Post Expedited Parcel



=cut


use constant CA_PostExpeditedParcel => scalar('CA_PostExpeditedParcel');


=head2 CA_PostXpresspost

=cut


use constant CA_PostXpresspost => scalar('CA_PostXpresspost');


=head2 CA_PostPriorityCourier

Canada Post Priority Courier



=cut


use constant CA_PostPriorityCourier => scalar('CA_PostPriorityCourier');


=head2 CanadaPostExpeditedFlatRateBox

Canada Post Expedited Flat Rate Box



=cut


use constant CanadaPostExpeditedFlatRateBox => scalar('CanadaPostExpeditedFlatRateBox');


=head2 CA_StandardInternational

Standard International Flat Rate Shipping



=cut


use constant CA_StandardInternational => scalar('CA_StandardInternational');


=head2 CA_ExpeditedInternational

Expedited International Flat Rate Shipping



=cut


use constant CA_ExpeditedInternational => scalar('CA_ExpeditedInternational');


=head2 CA_OtherInternational

Other International Shipping (see description)



=cut


use constant CA_OtherInternational => scalar('CA_OtherInternational');


=head2 CA_PostExpeditedParcelUSA

=cut


use constant CA_PostExpeditedParcelUSA => scalar('CA_PostExpeditedParcelUSA');


=head2 CA_PostSmallPacketsUSA

=cut


use constant CA_PostSmallPacketsUSA => scalar('CA_PostSmallPacketsUSA');


=head2 CA_PostXpresspostUSA

=cut


use constant CA_PostXpresspostUSA => scalar('CA_PostXpresspostUSA');


=head2 CA_PostXpresspostInternational

=cut


use constant CA_PostXpresspostInternational => scalar('CA_PostXpresspostInternational');


=head2 CA_PostInternationalParcelSurface

=cut


use constant CA_PostInternationalParcelSurface => scalar('CA_PostInternationalParcelSurface');


=head2 CA_PostInternationalParcelAir

=cut


use constant CA_PostInternationalParcelAir => scalar('CA_PostInternationalParcelAir');


=head2 CA_SmallPacketsInternational

Small Packets - International



=cut


use constant CA_SmallPacketsInternational => scalar('CA_SmallPacketsInternational');


=head2 CA_PurolatorInternational

Purolator International



=cut


use constant CA_PurolatorInternational => scalar('CA_PurolatorInternational');


=head2 CA_PostSmallPacketsUSAGround

Canada Post Small Packets - USA - Ground



=cut


use constant CA_PostSmallPacketsUSAGround => scalar('CA_PostSmallPacketsUSAGround');


=head2 CA_PostSmallPacketsUSAAir

Canada Post Small Packets - USA - Air



=cut


use constant CA_PostSmallPacketsUSAAir => scalar('CA_PostSmallPacketsUSAAir');


=head2 CA_SmallPacketsInternationalGround

Small Packets - International - Ground



=cut


use constant CA_SmallPacketsInternationalGround => scalar('CA_SmallPacketsInternationalGround');


=head2 CA_SmallPacketsInternationalAir

Small Packets - International - Air



=cut


use constant CA_SmallPacketsInternationalAir => scalar('CA_SmallPacketsInternationalAir');


=head2 CA_PostUSALetterPost

Canada Post USA Letter-post



=cut


use constant CA_PostUSALetterPost => scalar('CA_PostUSALetterPost');


=head2 CA_PostInternationalLetterPost

Canada Post International Letter-post



=cut


use constant CA_PostInternationalLetterPost => scalar('CA_PostInternationalLetterPost');


=head2 CA_UPSExpressCanada

UPS Express Canada



=cut


use constant CA_UPSExpressCanada => scalar('CA_UPSExpressCanada');


=head2 CA_UPSExpressSaverCanada

UPS Express Saver Canada



=cut


use constant CA_UPSExpressSaverCanada => scalar('CA_UPSExpressSaverCanada');


=head2 CA_UPSExpeditedCanada

UPS Expedited Canada



=cut


use constant CA_UPSExpeditedCanada => scalar('CA_UPSExpeditedCanada');


=head2 CA_UPSStandardCanada

UPS Standard Canada



=cut


use constant CA_UPSStandardCanada => scalar('CA_UPSStandardCanada');


=head2 CA_UPSExpressUnitedStates

UPS Express United States



=cut


use constant CA_UPSExpressUnitedStates => scalar('CA_UPSExpressUnitedStates');


=head2 CA_UPSExpeditedUnitedStates

UPS Expedited United States



=cut


use constant CA_UPSExpeditedUnitedStates => scalar('CA_UPSExpeditedUnitedStates');


=head2 CA_UPS3DaySelectUnitedStates

UPS 3 Day Select United States



=cut


use constant CA_UPS3DaySelectUnitedStates => scalar('CA_UPS3DaySelectUnitedStates');


=head2 CA_UPSStandardUnitedStates

UPS Standard United States



=cut


use constant CA_UPSStandardUnitedStates => scalar('CA_UPSStandardUnitedStates');


=head2 CA_UPSWorldWideExpress

UPS Worldwide Express



=cut


use constant CA_UPSWorldWideExpress => scalar('CA_UPSWorldWideExpress');


=head2 CA_UPSWorldWideExpedited

UPS Worldwide Expedited



=cut


use constant CA_UPSWorldWideExpedited => scalar('CA_UPSWorldWideExpedited');


=head2 CanadaPostExpeditedFlatRateBoxUSA

Canada Post Expedited Flat Rate Box USA



=cut


use constant CanadaPostExpeditedFlatRateBoxUSA => scalar('CanadaPostExpeditedFlatRateBoxUSA');


=head2 CH_StandardDispatchAPost

Standardversand (A-Post/Priority)



=cut


use constant CH_StandardDispatchAPost => scalar('CH_StandardDispatchAPost');


=head2 CH_StandardDispatchBPost

Standardversand (B-Post/Economy)



=cut


use constant CH_StandardDispatchBPost => scalar('CH_StandardDispatchBPost');


=head2 CH_InsuredDispatch

Versicherter Versand (z.B. Assurance/Fragile)



=cut


use constant CH_InsuredDispatch => scalar('CH_InsuredDispatch');


=head2 CH_Writing

=cut


use constant CH_Writing => scalar('CH_Writing');


=head2 CH_COD

=cut


use constant CH_COD => scalar('CH_COD');


=head2 CH_ExpressOrCourier

Express- oder Kurierversand



=cut


use constant CH_ExpressOrCourier => scalar('CH_ExpressOrCourier');


=head2 CH_InsuredExpressOrCourier

Versicherter Express- oder Kurierversand



=cut


use constant CH_InsuredExpressOrCourier => scalar('CH_InsuredExpressOrCourier');


=head2 CH_SpecialDispatch

=cut


use constant CH_SpecialDispatch => scalar('CH_SpecialDispatch');


=head2 CH_InsuredSpecialDispatch

=cut


use constant CH_InsuredSpecialDispatch => scalar('CH_InsuredSpecialDispatch');


=head2 CH_Sonstige

Sonstige (Siehe Artikelbeschreibung)



=cut


use constant CH_Sonstige => scalar('CH_Sonstige');


=head2 CH_SonstigerVersandInternational

Sonstiger Versand (Siehe Artikelbeschreibung)



=cut


use constant CH_SonstigerVersandInternational => scalar('CH_SonstigerVersandInternational');


=head2 CH_EconomySendungenInternational

ECONOMY Sendungen



=cut


use constant CH_EconomySendungenInternational => scalar('CH_EconomySendungenInternational');


=head2 CH_PrioritySendungenInternational

PRIORITY Sendungen



=cut


use constant CH_PrioritySendungenInternational => scalar('CH_PrioritySendungenInternational');


=head2 CH_UrgentSendungenInternational

URGENT Sendungen



=cut


use constant CH_UrgentSendungenInternational => scalar('CH_UrgentSendungenInternational');


=head2 CN_PersonalDelivery

=cut


use constant CN_PersonalDelivery => scalar('CN_PersonalDelivery');


=head2 CN_RegularPackage

=cut


use constant CN_RegularPackage => scalar('CN_RegularPackage');


=head2 CN_DeliveryCompanyExpress

=cut


use constant CN_DeliveryCompanyExpress => scalar('CN_DeliveryCompanyExpress');


=head2 CN_PostOfficeExpress

=cut


use constant CN_PostOfficeExpress => scalar('CN_PostOfficeExpress');


=head2 CN_Others

=cut


use constant CN_Others => scalar('CN_Others');


=head2 CN_FastPostOffice

=cut


use constant CN_FastPostOffice => scalar('CN_FastPostOffice');


=head2 CN_ExpressDeliverySameCity

=cut


use constant CN_ExpressDeliverySameCity => scalar('CN_ExpressDeliverySameCity');


=head2 CN_ExpressDeliveryOtherCities

=cut


use constant CN_ExpressDeliveryOtherCities => scalar('CN_ExpressDeliveryOtherCities');


=head2 CN_StandardInternational

=cut


use constant CN_StandardInternational => scalar('CN_StandardInternational');


=head2 CN_ExpeditedInternational

=cut


use constant CN_ExpeditedInternational => scalar('CN_ExpeditedInternational');


=head2 CN_OtherInternational

=cut


use constant CN_OtherInternational => scalar('CN_OtherInternational');


=head2 CN_CODInternational

=cut


use constant CN_CODInternational => scalar('CN_CODInternational');


=head2 CN_StandardMailingInternational

=cut


use constant CN_StandardMailingInternational => scalar('CN_StandardMailingInternational');


=head2 CN_RegularLogisticsInternational

=cut


use constant CN_RegularLogisticsInternational => scalar('CN_RegularLogisticsInternational');


=head2 CN_EMSInternational

=cut


use constant CN_EMSInternational => scalar('CN_EMSInternational');


=head2 CN_OthersInternational

=cut


use constant CN_OthersInternational => scalar('CN_OthersInternational');


=head2 DE_StandardDispatch

Unversicherter Versand



=cut


use constant DE_StandardDispatch => scalar('DE_StandardDispatch');


=head2 DE_InsuredDispatch

Versicherter Versand



=cut


use constant DE_InsuredDispatch => scalar('DE_InsuredDispatch');


=head2 DE_Writing

=cut


use constant DE_Writing => scalar('DE_Writing');


=head2 DE_COD

=cut


use constant DE_COD => scalar('DE_COD');


=head2 DE_ExpressOrCourier

Express- oder Kurierversand



=cut


use constant DE_ExpressOrCourier => scalar('DE_ExpressOrCourier');


=head2 DE_InsuredExpressOrCourier

Versicherter Express- oder Kurierversand



=cut


use constant DE_InsuredExpressOrCourier => scalar('DE_InsuredExpressOrCourier');


=head2 DE_SpecialDispatch

=cut


use constant DE_SpecialDispatch => scalar('DE_SpecialDispatch');


=head2 DE_InsuredSpecialDispatch

=cut


use constant DE_InsuredSpecialDispatch => scalar('DE_InsuredSpecialDispatch');


=head2 DE_UnversicherterVersand

Unversicherter Versand



=cut


use constant DE_UnversicherterVersand => scalar('DE_UnversicherterVersand');


=head2 DE_DeutschePostBrief

Deutsche Post Brief



=cut


use constant DE_DeutschePostBrief => scalar('DE_DeutschePostBrief');


=head2 DE_DHLPostpaket

DHL Postpaket



=cut


use constant DE_DHLPostpaket => scalar('DE_DHLPostpaket');


=head2 DE_DHLPackchen

=cut


use constant DE_DHLPackchen => scalar('DE_DHLPackchen');


=head2 DE_DeutschePostWarensendung

Deutsche Post Warensendung



=cut


use constant DE_DeutschePostWarensendung => scalar('DE_DeutschePostWarensendung');


=head2 DE_DeutschePostBuchersendung

=cut


use constant DE_DeutschePostBuchersendung => scalar('DE_DeutschePostBuchersendung');


=head2 DE_HermesPaketUnversichert

Hermes Paket (unversichert)



=cut


use constant DE_HermesPaketUnversichert => scalar('DE_HermesPaketUnversichert');


=head2 DE_HermesPaketVersichert

Hermes Paket (versichert)



=cut


use constant DE_HermesPaketVersichert => scalar('DE_HermesPaketVersichert');


=head2 DE_IloxxTransportXXL

iloxx Transport XXL



=cut


use constant DE_IloxxTransportXXL => scalar('DE_IloxxTransportXXL');


=head2 DE_IloxxUbernachtExpress

=cut


use constant DE_IloxxUbernachtExpress => scalar('DE_IloxxUbernachtExpress');


=head2 DE_IloxxStandard

iloxx Standard



=cut


use constant DE_IloxxStandard => scalar('DE_IloxxStandard');


=head2 DE_Sonstige

Sonstige (Siehe Artikelbeschreibung)



=cut


use constant DE_Sonstige => scalar('DE_Sonstige');


=head2 DE_UnversicherterVersandInternational

Unversicherter Versand



=cut


use constant DE_UnversicherterVersandInternational => scalar('DE_UnversicherterVersandInternational');


=head2 DE_VersicherterVersandInternational

Versicherter Versand



=cut


use constant DE_VersicherterVersandInternational => scalar('DE_VersicherterVersandInternational');


=head2 DE_DHLPostpaketInternational

DHL Postpaket International



=cut


use constant DE_DHLPostpaketInternational => scalar('DE_DHLPostpaketInternational');


=head2 DE_DHLPackchenInternational

=cut


use constant DE_DHLPackchenInternational => scalar('DE_DHLPackchenInternational');


=head2 DE_SonstigerVersandInternational

Sonstiger Versand (Siehe Artikelbeschreibung)



=cut


use constant DE_SonstigerVersandInternational => scalar('DE_SonstigerVersandInternational');


=head2 DE_UnversicherterExpressVersandInternational

Unversicherter Express - Versand



=cut


use constant DE_UnversicherterExpressVersandInternational => scalar('DE_UnversicherterExpressVersandInternational');


=head2 DE_VersicherterExpressVersandInternational

Versicherter Express - Versand



=cut


use constant DE_VersicherterExpressVersandInternational => scalar('DE_VersicherterExpressVersandInternational');


=head2 DE_DeutschePostBriefLandInternational

Deutsche Post Brief (Land)



=cut


use constant DE_DeutschePostBriefLandInternational => scalar('DE_DeutschePostBriefLandInternational');


=head2 DE_DeutschePostBriefLuftInternational

Deutsche Post Brief (Luft)



=cut


use constant DE_DeutschePostBriefLuftInternational => scalar('DE_DeutschePostBriefLuftInternational');


=head2 DE_IloxxEuropaInternational

iloxx Europa



=cut


use constant DE_IloxxEuropaInternational => scalar('DE_IloxxEuropaInternational');


=head2 DE_IloxxWorldWideInternational

iloxx World Wide



=cut


use constant DE_IloxxWorldWideInternational => scalar('DE_IloxxWorldWideInternational');


=head2 DE_Paket

Paketversand



=cut


use constant DE_Paket => scalar('DE_Paket');


=head2 DE_Express

Expressversand



=cut


use constant DE_Express => scalar('DE_Express');


=head2 DE_DHLPaket

DHL Paket



=cut


use constant DE_DHLPaket => scalar('DE_DHLPaket');


=head2 DE_DPBuecherWarensendung

Deutsche Post Buecher-/Warensendung



=cut


use constant DE_DPBuecherWarensendung => scalar('DE_DPBuecherWarensendung');


=head2 DE_HermesPaket

Hermes Paket



=cut


use constant DE_HermesPaket => scalar('DE_HermesPaket');


=head2 DE_IloxxTransport

iloxx Transport



=cut


use constant DE_IloxxTransport => scalar('DE_IloxxTransport');


=head2 DE_SonstigeDomestic

Sonstige



=cut


use constant DE_SonstigeDomestic => scalar('DE_SonstigeDomestic');


=head2 DE_Einschreiben

Einschreiben (inkl. aller Gebuehren)



=cut


use constant DE_Einschreiben => scalar('DE_Einschreiben');


=head2 DE_Nachname

Nachnahme (inkl. aller Gebuehren)



=cut


use constant DE_Nachname => scalar('DE_Nachname');


=head2 DE_SpecialDelivery

Sonderversand



=cut


use constant DE_SpecialDelivery => scalar('DE_SpecialDelivery');


=head2 DE_UPS

UPS



=cut


use constant DE_UPS => scalar('DE_UPS');


=head2 DE_DPD

DPD



=cut


use constant DE_DPD => scalar('DE_DPD');


=head2 DE_GLS

GLS



=cut


use constant DE_GLS => scalar('DE_GLS');


=head2 DE_PaketInternational

Paketversand



=cut


use constant DE_PaketInternational => scalar('DE_PaketInternational');


=head2 DE_DHLPaketInternational

DHL Paket International



=cut


use constant DE_DHLPaketInternational => scalar('DE_DHLPaketInternational');


=head2 DE_SonstigeInternational

Sonstige



=cut


use constant DE_SonstigeInternational => scalar('DE_SonstigeInternational');


=head2 DE_ExpressInternational

Expressversand



=cut


use constant DE_ExpressInternational => scalar('DE_ExpressInternational');


=head2 DE_DPBriefInternational

Deutsche Post Brief



=cut


use constant DE_DPBriefInternational => scalar('DE_DPBriefInternational');


=head2 DE_IloxxTransportInternational

iloxx Transport International



=cut


use constant DE_IloxxTransportInternational => scalar('DE_IloxxTransportInternational');


=head2 DE_HermesPaketInternational

Hermes Paket International



=cut


use constant DE_HermesPaketInternational => scalar('DE_HermesPaketInternational');


=head2 DE_UPSInternational

UPS International



=cut


use constant DE_UPSInternational => scalar('DE_UPSInternational');


=head2 DE_DPDInternational

DPD International



=cut


use constant DE_DPDInternational => scalar('DE_DPDInternational');


=head2 DE_GLSInternational

GLS International



=cut


use constant DE_GLSInternational => scalar('DE_GLSInternational');


=head2 ES_CartasNacionalesHasta20

Cartas nacionales hasta 20 gr



=cut


use constant ES_CartasNacionalesHasta20 => scalar('ES_CartasNacionalesHasta20');


=head2 ES_CartasNacionalesDeMas20

=cut


use constant ES_CartasNacionalesDeMas20 => scalar('ES_CartasNacionalesDeMas20');


=head2 ES_CartasInternacionalesHasta20

Cartas internacionales hasta 20 gr



=cut


use constant ES_CartasInternacionalesHasta20 => scalar('ES_CartasInternacionalesHasta20');


=head2 ES_CartasInternacionalesDeMas20

Cartas internacionales de mas de 20 gr



=cut


use constant ES_CartasInternacionalesDeMas20 => scalar('ES_CartasInternacionalesDeMas20');


=head2 ES_PaqueteAzulHasta2kg

Paquete Azul (nacional) hasta 2 kg



=cut


use constant ES_PaqueteAzulHasta2kg => scalar('ES_PaqueteAzulHasta2kg');


=head2 ES_PaqueteAzulDeMas2kg

=cut


use constant ES_PaqueteAzulDeMas2kg => scalar('ES_PaqueteAzulDeMas2kg');


=head2 ES_PaqueteInternacionalEconomico

=cut


use constant ES_PaqueteInternacionalEconomico => scalar('ES_PaqueteInternacionalEconomico');


=head2 ES_Urgente

=cut


use constant ES_Urgente => scalar('ES_Urgente');


=head2 ES_Otros

=cut


use constant ES_Otros => scalar('ES_Otros');


=head2 ES_StandardInternational

=cut


use constant ES_StandardInternational => scalar('ES_StandardInternational');


=head2 ES_ExpeditedInternational

=cut


use constant ES_ExpeditedInternational => scalar('ES_ExpeditedInternational');


=head2 ES_OtherInternational

=cut


use constant ES_OtherInternational => scalar('ES_OtherInternational');


=head2 ES_CartasPostalInternational

Cartas y tarjetas postales internacionales



=cut


use constant ES_CartasPostalInternational => scalar('ES_CartasPostalInternational');


=head2 ES_EmsPostalExpressInternational

Ems postal expres internacional



=cut


use constant ES_EmsPostalExpressInternational => scalar('ES_EmsPostalExpressInternational');


=head2 ES_EconomyPacketInternational

Paquete internacional economico



=cut


use constant ES_EconomyPacketInternational => scalar('ES_EconomyPacketInternational');


=head2 FR_ChronoposteInternationalClassic

Chronoposte International Classic



=cut


use constant FR_ChronoposteInternationalClassic => scalar('FR_ChronoposteInternationalClassic');


=head2 FR_ColiposteColissimoDirect

Coliposte Colissimo Direct



=cut


use constant FR_ColiposteColissimoDirect => scalar('FR_ColiposteColissimoDirect');


=head2 FR_DHLExpressEuropack

DHL Express Europack



=cut


use constant FR_DHLExpressEuropack => scalar('FR_DHLExpressEuropack');


=head2 FR_UPSStandard

UPS Standard



=cut


use constant FR_UPSStandard => scalar('FR_UPSStandard');


=head2 FR_PostOfficeLetter

Lettre



=cut


use constant FR_PostOfficeLetter => scalar('FR_PostOfficeLetter');


=head2 FR_PostOfficeLetterFollowed

Lettre avec suivi



=cut


use constant FR_PostOfficeLetterFollowed => scalar('FR_PostOfficeLetterFollowed');


=head2 FR_PostOfficeLetterRecommended

=cut


use constant FR_PostOfficeLetterRecommended => scalar('FR_PostOfficeLetterRecommended');


=head2 FR_ColiposteColissimo

Colissimo



=cut


use constant FR_ColiposteColissimo => scalar('FR_ColiposteColissimo');


=head2 FR_ColiposteColissimoRecommended

=cut


use constant FR_ColiposteColissimoRecommended => scalar('FR_ColiposteColissimoRecommended');


=head2 FR_UPSStandardAgainstRefund

Contre remboursement



=cut


use constant FR_UPSStandardAgainstRefund => scalar('FR_UPSStandardAgainstRefund');


=head2 FR_Autre

Autre mode d'envoi de courrier



=cut


use constant FR_Autre => scalar('FR_Autre');


=head2 FR_Ecopli

Ecopli



=cut


use constant FR_Ecopli => scalar('FR_Ecopli');


=head2 FR_Colieco

=cut


use constant FR_Colieco => scalar('FR_Colieco');


=head2 FR_AuteModeDenvoiDeColis

Autre mode d'envoi de colis



=cut


use constant FR_AuteModeDenvoiDeColis => scalar('FR_AuteModeDenvoiDeColis');


=head2 FR_RemiseEnMainPropre

Remise en main propre



=cut


use constant FR_RemiseEnMainPropre => scalar('FR_RemiseEnMainPropre');


=head2 FR_StandardInternational

=cut


use constant FR_StandardInternational => scalar('FR_StandardInternational');


=head2 FR_ExpeditedInternational

=cut


use constant FR_ExpeditedInternational => scalar('FR_ExpeditedInternational');


=head2 FR_OtherInternational

=cut


use constant FR_OtherInternational => scalar('FR_OtherInternational');


=head2 FR_LaPosteInternationalPriorityCourier

La Poste - Courrier International Prioritaire



=cut


use constant FR_LaPosteInternationalPriorityCourier => scalar('FR_LaPosteInternationalPriorityCourier');


=head2 FR_LaPosteInternationalEconomyCourier

La Poste - Courrier International Economique



=cut


use constant FR_LaPosteInternationalEconomyCourier => scalar('FR_LaPosteInternationalEconomyCourier');


=head2 FR_LaPosteColissimoInternational

La Poste - Colissimo International



=cut


use constant FR_LaPosteColissimoInternational => scalar('FR_LaPosteColissimoInternational');


=head2 FR_LaPosteColisEconomiqueInternational

La Poste - Colis Economique International



=cut


use constant FR_LaPosteColisEconomiqueInternational => scalar('FR_LaPosteColisEconomiqueInternational');


=head2 FR_LaPosteColissimoEmballageInternational

La Poste - Colissimo Emballage International



=cut


use constant FR_LaPosteColissimoEmballageInternational => scalar('FR_LaPosteColissimoEmballageInternational');


=head2 FR_ChronopostClassicInternational

Chronopost Classic International



=cut


use constant FR_ChronopostClassicInternational => scalar('FR_ChronopostClassicInternational');


=head2 FR_ChronopostPremiumInternational

Chronopost Premium International



=cut


use constant FR_ChronopostPremiumInternational => scalar('FR_ChronopostPremiumInternational');


=head2 FR_UPSStandardInternational

UPS Standard



=cut


use constant FR_UPSStandardInternational => scalar('FR_UPSStandardInternational');


=head2 FR_UPSExpressInternational

UPS Express



=cut


use constant FR_UPSExpressInternational => scalar('FR_UPSExpressInternational');


=head2 FR_DHLInternational

DHL



=cut


use constant FR_DHLInternational => scalar('FR_DHLInternational');


=head2 FR_LaPosteLetterMax

La Poste Lettre Max



=cut


use constant FR_LaPosteLetterMax => scalar('FR_LaPosteLetterMax');


=head2 IN_Regular

National - Regular



=cut


use constant IN_Regular => scalar('IN_Regular');


=head2 IN_Express

National - Express



=cut


use constant IN_Express => scalar('IN_Express');


=head2 IN_NationalCOD

National - COD



=cut


use constant IN_NationalCOD => scalar('IN_NationalCOD');


=head2 IN_Courier

Local - Courier



=cut


use constant IN_Courier => scalar('IN_Courier');


=head2 IN_LocalCOD

Local - COD



=cut


use constant IN_LocalCOD => scalar('IN_LocalCOD');


=head2 IN_StandardInternational

International - Standard



=cut


use constant IN_StandardInternational => scalar('IN_StandardInternational');


=head2 IN_ExpeditedInternational

International - Expedited



=cut


use constant IN_ExpeditedInternational => scalar('IN_ExpeditedInternational');


=head2 IN_OtherInternational

International - other



=cut


use constant IN_OtherInternational => scalar('IN_OtherInternational');


=head2 IN_FlatRateCOD

Flat Rate COD



=cut


use constant IN_FlatRateCOD => scalar('IN_FlatRateCOD');


=head2 IN_BuyerPicksUpAndPays

Buyer picks up and pays



=cut


use constant IN_BuyerPicksUpAndPays => scalar('IN_BuyerPicksUpAndPays');


=head2 IT_RegularMail

Posta ordinaria



=cut


use constant IT_RegularMail => scalar('IT_RegularMail');


=head2 IT_PriorityMail

Posta prioritaria



=cut


use constant IT_PriorityMail => scalar('IT_PriorityMail');


=head2 IT_MailRegisteredLetter

Posta raccomandata



=cut


use constant IT_MailRegisteredLetter => scalar('IT_MailRegisteredLetter');


=head2 IT_MailRegisteredLetterWithMark

Posta raccomandata con contrassegno



=cut


use constant IT_MailRegisteredLetterWithMark => scalar('IT_MailRegisteredLetterWithMark');


=head2 IT_InsuredMail

Posta assicurata



=cut


use constant IT_InsuredMail => scalar('IT_InsuredMail');


=head2 IT_QuickMail

Posta celere



=cut


use constant IT_QuickMail => scalar('IT_QuickMail');


=head2 IT_RegularPackage

Pacco ordinario



=cut


use constant IT_RegularPackage => scalar('IT_RegularPackage');


=head2 IT_QuickPackage1

Pacco celere 1



=cut


use constant IT_QuickPackage1 => scalar('IT_QuickPackage1');


=head2 IT_QuickPackage3

Pacco celere 3



=cut


use constant IT_QuickPackage3 => scalar('IT_QuickPackage3');


=head2 IT_ExpressCourier

Corriere espresso



=cut


use constant IT_ExpressCourier => scalar('IT_ExpressCourier');


=head2 IT_ExpressPackageMaxi

Paccocelere Maxi



=cut


use constant IT_ExpressPackageMaxi => scalar('IT_ExpressPackageMaxi');


=head2 IT_StandardInternational

Spedizione internazionale standard a prezzo fisso



=cut


use constant IT_StandardInternational => scalar('IT_StandardInternational');


=head2 IT_ExpeditedInternational

Spedizione internazionale celere a prezzo fisso



=cut


use constant IT_ExpeditedInternational => scalar('IT_ExpeditedInternational');


=head2 IT_OtherInternational

Altre spedizioni internazionali (vedi descrizione)



=cut


use constant IT_OtherInternational => scalar('IT_OtherInternational');


=head2 NL_StandardDelivery

Standaardverzending



=cut


use constant NL_StandardDelivery => scalar('NL_StandardDelivery');


=head2 NL_ParcelPost

Pakketpost



=cut


use constant NL_ParcelPost => scalar('NL_ParcelPost');


=head2 NL_RegisteredMail

Verzending met ontvangstbevestiging



=cut


use constant NL_RegisteredMail => scalar('NL_RegisteredMail');


=head2 NL_Other

Andere verzendservice



=cut


use constant NL_Other => scalar('NL_Other');


=head2 NL_TPGPostTNTInternational

TPG Post/TNT



=cut


use constant NL_TPGPostTNTInternational => scalar('NL_TPGPostTNTInternational');


=head2 NL_UPSInternational

UPS



=cut


use constant NL_UPSInternational => scalar('NL_UPSInternational');


=head2 NL_FedExInternational

Fedex



=cut


use constant NL_FedExInternational => scalar('NL_FedExInternational');


=head2 NL_DHLInternational

DHL



=cut


use constant NL_DHLInternational => scalar('NL_DHLInternational');


=head2 NL_DPDGBRInternational

DPD (Germany)



=cut


use constant NL_DPDGBRInternational => scalar('NL_DPDGBRInternational');


=head2 NL_GLSBusinessInternational

GLS (Business only)



=cut


use constant NL_GLSBusinessInternational => scalar('NL_GLSBusinessInternational');


=head2 NL_StandardInternational

Vaste kosten standaard internationale verzending



=cut


use constant NL_StandardInternational => scalar('NL_StandardInternational');


=head2 NL_ExpeditedInternational

Vaste kosten versnelde internationale verzending



=cut


use constant NL_ExpeditedInternational => scalar('NL_ExpeditedInternational');


=head2 NL_OtherInternational

Andere internationale verzending (zie beschrijving)



=cut


use constant NL_OtherInternational => scalar('NL_OtherInternational');


=head2 TW_RegisteredMail

=cut


use constant TW_RegisteredMail => scalar('TW_RegisteredMail');


=head2 TW_UnregisteredMail

=cut


use constant TW_UnregisteredMail => scalar('TW_UnregisteredMail');


=head2 TW_COD

=cut


use constant TW_COD => scalar('TW_COD');


=head2 TW_DwellingMatchPost

=cut


use constant TW_DwellingMatchPost => scalar('TW_DwellingMatchPost');


=head2 TW_DwellingMatchCOD

=cut


use constant TW_DwellingMatchCOD => scalar('TW_DwellingMatchCOD');


=head2 TW_SelfPickup

=cut


use constant TW_SelfPickup => scalar('TW_SelfPickup');


=head2 TW_ParcelPost

=cut


use constant TW_ParcelPost => scalar('TW_ParcelPost');


=head2 TW_ExpressMail

=cut


use constant TW_ExpressMail => scalar('TW_ExpressMail');


=head2 TW_Other

=cut


use constant TW_Other => scalar('TW_Other');


=head2 TW_CPInternationalLetterPost

=cut


use constant TW_CPInternationalLetterPost => scalar('TW_CPInternationalLetterPost');


=head2 TW_CPInternationalParcelPost

=cut


use constant TW_CPInternationalParcelPost => scalar('TW_CPInternationalParcelPost');


=head2 TW_CPInternationalRegisteredLetterPost

=cut


use constant TW_CPInternationalRegisteredLetterPost => scalar('TW_CPInternationalRegisteredLetterPost');


=head2 TW_CPInternationalRegisteredParcelPost

=cut


use constant TW_CPInternationalRegisteredParcelPost => scalar('TW_CPInternationalRegisteredParcelPost');


=head2 TW_CPInternationalEMS

=cut


use constant TW_CPInternationalEMS => scalar('TW_CPInternationalEMS');


=head2 TW_CPInternationalOceanShippingParcel

=cut


use constant TW_CPInternationalOceanShippingParcel => scalar('TW_CPInternationalOceanShippingParcel');


=head2 TW_FedExInternationalPriority

Fedex International Priority



=cut


use constant TW_FedExInternationalPriority => scalar('TW_FedExInternationalPriority');


=head2 TW_FedExInternationalEconomy

Fedex International Economy



=cut


use constant TW_FedExInternationalEconomy => scalar('TW_FedExInternationalEconomy');


=head2 TW_UPSWorldwideExpedited

UPS Worldwide Expedited



=cut


use constant TW_UPSWorldwideExpedited => scalar('TW_UPSWorldwideExpedited');


=head2 TW_UPSWorldwideExpress

UPS Worldwide Express



=cut


use constant TW_UPSWorldwideExpress => scalar('TW_UPSWorldwideExpress');


=head2 TW_UPSWorldwideExpressPlus

UPS Worldwide Express Plus



=cut


use constant TW_UPSWorldwideExpressPlus => scalar('TW_UPSWorldwideExpressPlus');


=head2 TW_OtherInternational

=cut


use constant TW_OtherInternational => scalar('TW_OtherInternational');


=head2 UK_RoyalMailFirstClassStandard

Royal Mail 1st Class Standard



=cut


use constant UK_RoyalMailFirstClassStandard => scalar('UK_RoyalMailFirstClassStandard');


=head2 UK_RoyalMailSecondClassStandard

Royal Mail 2nd Class Standard



=cut


use constant UK_RoyalMailSecondClassStandard => scalar('UK_RoyalMailSecondClassStandard');


=head2 UK_RoyalMailFirstClassRecorded

Royal Mail 1st Class Recorded



=cut


use constant UK_RoyalMailFirstClassRecorded => scalar('UK_RoyalMailFirstClassRecorded');


=head2 UK_RoyalMailSecondClassRecorded

Royal Mail 2nd Class Recorded



=cut


use constant UK_RoyalMailSecondClassRecorded => scalar('UK_RoyalMailSecondClassRecorded');


=head2 UK_RoyalMailSpecialDelivery

Royal Mail Special Delivery



=cut


use constant UK_RoyalMailSpecialDelivery => scalar('UK_RoyalMailSpecialDelivery');


=head2 UK_RoyalMailStandardParcel

Royal Mail Standard Parcels



=cut


use constant UK_RoyalMailStandardParcel => scalar('UK_RoyalMailStandardParcel');


=head2 UK_Parcelforce24

Parcelforce 24



=cut


use constant UK_Parcelforce24 => scalar('UK_Parcelforce24');


=head2 UK_Parcelforce48

Parcelforce 48



=cut


use constant UK_Parcelforce48 => scalar('UK_Parcelforce48');


=head2 UK_OtherCourier

Other Courier



=cut


use constant UK_OtherCourier => scalar('UK_OtherCourier');


=head2 UK_SellersStandardRate

Seller's Standard Rate



=cut


use constant UK_SellersStandardRate => scalar('UK_SellersStandardRate');


=head2 UK_CollectInPerson

Collection in Person



=cut


use constant UK_CollectInPerson => scalar('UK_CollectInPerson');


=head2 UK_SellersStandardInternationalRate

Sellers Standard International Rate



=cut


use constant UK_SellersStandardInternationalRate => scalar('UK_SellersStandardInternationalRate');


=head2 UK_RoyalMailAirmailInternational

Royal Mail Airmail



=cut


use constant UK_RoyalMailAirmailInternational => scalar('UK_RoyalMailAirmailInternational');


=head2 UK_RoyalMailAirsureInternational

Royal Mail Airsure



=cut


use constant UK_RoyalMailAirsureInternational => scalar('UK_RoyalMailAirsureInternational');


=head2 UK_RoyalMailSurfaceMailInternational

Royal Mail Surface Mail



=cut


use constant UK_RoyalMailSurfaceMailInternational => scalar('UK_RoyalMailSurfaceMailInternational');


=head2 UK_RoyalMailInternationalSignedFor

Royal Mail International Signed-for



=cut


use constant UK_RoyalMailInternationalSignedFor => scalar('UK_RoyalMailInternationalSignedFor');


=head2 UK_RoyalMailHMForcesMailInternational

Royal Mail HM Forces Mail



=cut


use constant UK_RoyalMailHMForcesMailInternational => scalar('UK_RoyalMailHMForcesMailInternational');


=head2 UK_ParcelForceInternationalDatapost

Parcelforce International Datapost



=cut


use constant UK_ParcelForceInternationalDatapost => scalar('UK_ParcelForceInternationalDatapost');


=head2 UK_ParcelForceIreland24International

Parcelforce Ireland 24



=cut


use constant UK_ParcelForceIreland24International => scalar('UK_ParcelForceIreland24International');


=head2 UK_ParcelForceEuro48International

Parcelforce Euro 48



=cut


use constant UK_ParcelForceEuro48International => scalar('UK_ParcelForceEuro48International');


=head2 UK_ParcelForceInternationalScheduled

Parcelforce International Scheduled



=cut


use constant UK_ParcelForceInternationalScheduled => scalar('UK_ParcelForceInternationalScheduled');


=head2 UK_OtherCourierOrDeliveryInternational

Other courier or delivery service



=cut


use constant UK_OtherCourierOrDeliveryInternational => scalar('UK_OtherCourierOrDeliveryInternational');


=head2 UK_CollectInPersonInternational

Collect in person



=cut


use constant UK_CollectInPersonInternational => scalar('UK_CollectInPersonInternational');


=head2 IE_SellersStandardRate

Seller's standard rate



=cut


use constant IE_SellersStandardRate => scalar('IE_SellersStandardRate');


=head2 IE_FirstClassLetterService

First Class Letter Service



=cut


use constant IE_FirstClassLetterService => scalar('IE_FirstClassLetterService');


=head2 IE_SwiftPostNational

SwiftPost National



=cut


use constant IE_SwiftPostNational => scalar('IE_SwiftPostNational');


=head2 IE_RegisteredPost

Registered Post



=cut


use constant IE_RegisteredPost => scalar('IE_RegisteredPost');


=head2 IE_EMSSDSCourier

EMS SDS Courier



=cut


use constant IE_EMSSDSCourier => scalar('IE_EMSSDSCourier');


=head2 IE_EconomySDSCourier

Economy SDS Courier



=cut


use constant IE_EconomySDSCourier => scalar('IE_EconomySDSCourier');


=head2 IE_OtherCourier

Other courier



=cut


use constant IE_OtherCourier => scalar('IE_OtherCourier');


=head2 IE_CollectionInPerson

Collection in person



=cut


use constant IE_CollectionInPerson => scalar('IE_CollectionInPerson');


=head2 IE_SellersStandardRateInternational

Seller's Standard International Rate



=cut


use constant IE_SellersStandardRateInternational => scalar('IE_SellersStandardRateInternational');


=head2 IE_InternationalEconomyService

International Economy Service



=cut


use constant IE_InternationalEconomyService => scalar('IE_InternationalEconomyService');


=head2 IE_InternationalPriorityService

International Priority Service



=cut


use constant IE_InternationalPriorityService => scalar('IE_InternationalPriorityService');


=head2 IE_SwiftPostExpressInternational

SwiftPost Express



=cut


use constant IE_SwiftPostExpressInternational => scalar('IE_SwiftPostExpressInternational');


=head2 IE_SwiftPostInternational

SwiftPost International



=cut


use constant IE_SwiftPostInternational => scalar('IE_SwiftPostInternational');


=head2 IE_EMSSDSCourierInternational

EMS SDS Courier



=cut


use constant IE_EMSSDSCourierInternational => scalar('IE_EMSSDSCourierInternational');


=head2 IE_EconomySDSCourierInternational

Economy SDS Courier



=cut


use constant IE_EconomySDSCourierInternational => scalar('IE_EconomySDSCourierInternational');


=head2 IE_OtherCourierInternational

Other courier or delivery service



=cut


use constant IE_OtherCourierInternational => scalar('IE_OtherCourierInternational');


=head2 IE_CollectionInPersonInternational

International collection in person



=cut


use constant IE_CollectionInPersonInternational => scalar('IE_CollectionInPersonInternational');


=head2 PL_DomesticRegular

Domestic Regular shipping



=cut


use constant PL_DomesticRegular => scalar('PL_DomesticRegular');


=head2 PL_DomesticSpecial

Domestic Special shipping



=cut


use constant PL_DomesticSpecial => scalar('PL_DomesticSpecial');


=head2 FreightShipping

Service associated with FreightQuote.com



=cut


use constant FreightShipping => scalar('FreightShipping');


=head2 FreightOtherShipping

Freight Other Shipping



=cut


use constant FreightOtherShipping => scalar('FreightOtherShipping');


=head2 Freight

Service associated with any freight service other than FreightQuote.com



=cut


use constant Freight => scalar('Freight');


=head2 FreightShippingInternational

Freight Shipping International



=cut


use constant FreightShippingInternational => scalar('FreightShippingInternational');


=head2 USPSGround

=cut


use constant USPSGround => scalar('USPSGround');


=head2 ShippingMethodOvernight

Overnight flat rate shipping service (domestic only)



=cut


use constant ShippingMethodOvernight => scalar('ShippingMethodOvernight');


=head2 CustomCode

Reserved for internal or future use



=cut


use constant CustomCode => scalar('CustomCode');


=head2 USPSPriorityFlatRateEnvelope

USPS Priority Flat Rate Envelope



=cut


use constant USPSPriorityFlatRateEnvelope => scalar('USPSPriorityFlatRateEnvelope');


=head2 USPSPriorityFlatRateBox

USPS Priority Flat Rate Box



=cut


use constant USPSPriorityFlatRateBox => scalar('USPSPriorityFlatRateBox');


=head2 USPSGlobalPrioritySmallEnvelope

USPS Global Priority Mail Small Envelope



=cut


use constant USPSGlobalPrioritySmallEnvelope => scalar('USPSGlobalPrioritySmallEnvelope');


=head2 USPSGlobalPriorityLargeEnvelope

USPS Global Priority Mail Large Envelope



=cut


use constant USPSGlobalPriorityLargeEnvelope => scalar('USPSGlobalPriorityLargeEnvelope');


=head2 USPSExpressFlatRateEnvelope

USPS Express Mail Flat Rate Envelope



=cut


use constant USPSExpressFlatRateEnvelope => scalar('USPSExpressFlatRateEnvelope');


=head2 UPSWorldWideExpressBox10kg

UPS Worldwide Express Box 10 Kg



=cut


use constant UPSWorldWideExpressBox10kg => scalar('UPSWorldWideExpressBox10kg');


=head2 UPSWorldWideExpressBox25kg

UPS Worldwide Express Box 25 Kg



=cut


use constant UPSWorldWideExpressBox25kg => scalar('UPSWorldWideExpressBox25kg');


=head2 UPSWorldWideExpressPlusBox10kg

UPS Worldwide Express Plus Box 10 Kg



=cut


use constant UPSWorldWideExpressPlusBox10kg => scalar('UPSWorldWideExpressPlusBox10kg');


=head2 UPSWorldWideExpressPlusBox25kg

UPS Worldwide Express Plus box 25 Kg



=cut


use constant UPSWorldWideExpressPlusBox25kg => scalar('UPSWorldWideExpressPlusBox25kg');


=head2 HK_LocalPickUpOnly

Local pick up only



=cut


use constant HK_LocalPickUpOnly => scalar('HK_LocalPickUpOnly');


=head2 HK_LocalCourier

Local courier



=cut


use constant HK_LocalCourier => scalar('HK_LocalCourier');


=head2 HK_DomesticRegularShipping

Domestic regular shipping



=cut


use constant HK_DomesticRegularShipping => scalar('HK_DomesticRegularShipping');


=head2 HK_DomesticSpecialShipping

Domestic special shipping



=cut


use constant HK_DomesticSpecialShipping => scalar('HK_DomesticSpecialShipping');


=head2 HK_InternationalRegularShipping

International regular shipping



=cut


use constant HK_InternationalRegularShipping => scalar('HK_InternationalRegularShipping');


=head2 HK_InternationalSpecialShipping

International special shipping



=cut


use constant HK_InternationalSpecialShipping => scalar('HK_InternationalSpecialShipping');


=head2 SG_LocalPickUpOnly

Local pick up only



=cut


use constant SG_LocalPickUpOnly => scalar('SG_LocalPickUpOnly');


=head2 SG_LocalCourier

Local courier



=cut


use constant SG_LocalCourier => scalar('SG_LocalCourier');


=head2 SG_DomesticStandardMail

Domestic standard mail



=cut


use constant SG_DomesticStandardMail => scalar('SG_DomesticStandardMail');


=head2 SG_DomesticNonStandardMail

Domestic non standard mail



=cut


use constant SG_DomesticNonStandardMail => scalar('SG_DomesticNonStandardMail');


=head2 SG_DomesticSpeedpostIslandwide

Domestic Speedpost Islandwide



=cut


use constant SG_DomesticSpeedpostIslandwide => scalar('SG_DomesticSpeedpostIslandwide');


=head2 SG_InternationalStandardMail

International standard mail



=cut


use constant SG_InternationalStandardMail => scalar('SG_InternationalStandardMail');


=head2 SG_InternationalExpressMailService

International Express Mail Service (EMS)



=cut


use constant SG_InternationalExpressMailService => scalar('SG_InternationalExpressMailService');


=head2 SG_InternationalCourier

International courier (DHL, FedEx, UPS)



=cut


use constant SG_InternationalCourier => scalar('SG_InternationalCourier');


=head2 BENL_DePostZendingNONPRIOR

De Post zending - NON PRIOR (2 werkdagen)



=cut


use constant BENL_DePostZendingNONPRIOR => scalar('BENL_DePostZendingNONPRIOR');


=head2 BENL_DePostZendingPRIOR

De Post zending - PRIOR (1 werkdag)



=cut


use constant BENL_DePostZendingPRIOR => scalar('BENL_DePostZendingPRIOR');


=head2 BENL_DePostZendingAangetekend

De Post zending - aangetekend (1 werkdag)



=cut


use constant BENL_DePostZendingAangetekend => scalar('BENL_DePostZendingAangetekend');


=head2 BENL_KilopostPakje

Kilopost pakje (2 werkdagen)



=cut


use constant BENL_KilopostPakje => scalar('BENL_KilopostPakje');


=head2 BENL_Taxipost

Taxipost (express)



=cut


use constant BENL_Taxipost => scalar('BENL_Taxipost');


=head2 BENL_KialaAfhaalpunt

Kiala afhaalpunt (1 tot 4 werkdagen)



=cut


use constant BENL_KialaAfhaalpunt => scalar('BENL_KialaAfhaalpunt');


=head2 BENL_VasteKostenStandaardVerzending

Vaste kosten standaard verzending



=cut


use constant BENL_VasteKostenStandaardVerzending => scalar('BENL_VasteKostenStandaardVerzending');


=head2 BENL_VasteKostenVersneldeVerzending

Vaste kosten versnelde verzending



=cut


use constant BENL_VasteKostenVersneldeVerzending => scalar('BENL_VasteKostenVersneldeVerzending');


=head2 BENL_VerzekerdeVerzending

Verzekerde verzending



=cut


use constant BENL_VerzekerdeVerzending => scalar('BENL_VerzekerdeVerzending');


=head2 BEFR_LaPosteEnvoiNONPRIOR

La Poste envoi NON PRIOR (2 jours ouvrables)



=cut


use constant BEFR_LaPosteEnvoiNONPRIOR => scalar('BEFR_LaPosteEnvoiNONPRIOR');


=head2 BEFR_LaPosteEnvoiPRIOR

La Poste envoi PRIOR (1 jour ouvrable)



=cut


use constant BEFR_LaPosteEnvoiPRIOR => scalar('BEFR_LaPosteEnvoiPRIOR');


=head2 BEFR_LaPosteEnvoiRecommande

La Poste envoi recommande (1 jour ouvrable)



=cut


use constant BEFR_LaPosteEnvoiRecommande => scalar('BEFR_LaPosteEnvoiRecommande');


=head2 BEFR_PaquetKilopost

Paquet Kilopost (2 jours ouvrables)



=cut


use constant BEFR_PaquetKilopost => scalar('BEFR_PaquetKilopost');


=head2 BEFR_Taxipost

Taxipost (express)



=cut


use constant BEFR_Taxipost => scalar('BEFR_Taxipost');


=head2 BEFR_PointRetraitKiala

Point retrait Kiala (1 a 4 jours ouvrables)



=cut


use constant BEFR_PointRetraitKiala => scalar('BEFR_PointRetraitKiala');


=head2 BEFR_LivraisonStandardPrixforFaitaire

Livraison standard - prix forfaitaire



=cut


use constant BEFR_LivraisonStandardPrixforFaitaire => scalar('BEFR_LivraisonStandardPrixforFaitaire');


=head2 BEFR_LivraisonExpressPrixforFaitaire

Livraison express - prix forfaitaire



=cut


use constant BEFR_LivraisonExpressPrixforFaitaire => scalar('BEFR_LivraisonExpressPrixforFaitaire');


=head2 BEFR_LivraisonSecurise

Livraison securisee



=cut


use constant BEFR_LivraisonSecurise => scalar('BEFR_LivraisonSecurise');


=head2 BENL_DePostZendingPRIORInternational

De Post zending - PRIOR



=cut


use constant BENL_DePostZendingPRIORInternational => scalar('BENL_DePostZendingPRIORInternational');


=head2 BENL_DePostZendingNONPRIORInternational

De Post zending - NON PRIOR



=cut


use constant BENL_DePostZendingNONPRIORInternational => scalar('BENL_DePostZendingNONPRIORInternational');


=head2 BENL_DePostZendingAangetekendInternational

De Post zending - aangetekend



=cut


use constant BENL_DePostZendingAangetekendInternational => scalar('BENL_DePostZendingAangetekendInternational');


=head2 BENL_KilopostPakjeInternational

Kilopost pakje Internationaal



=cut


use constant BENL_KilopostPakjeInternational => scalar('BENL_KilopostPakjeInternational');


=head2 BENL_TaxipostExpressverzending

Taxipost expressverzending



=cut


use constant BENL_TaxipostExpressverzending => scalar('BENL_TaxipostExpressverzending');


=head2 BENL_VerzekerdeVerzendingInternational

Verzekerde verzending



=cut


use constant BENL_VerzekerdeVerzendingInternational => scalar('BENL_VerzekerdeVerzendingInternational');


=head2 BEFR_LaPosteenvoiePRIOR

La Poste envoie PRIOR



=cut


use constant BEFR_LaPosteenvoiePRIOR => scalar('BEFR_LaPosteenvoiePRIOR');


=head2 BEFR_LaPosteenvoieNONPRIOR

La Poste envoie NON PRIOR



=cut


use constant BEFR_LaPosteenvoieNONPRIOR => scalar('BEFR_LaPosteenvoieNONPRIOR');


=head2 BEFR_LaPosteenvoieRecommande

La Poste envoie recommande



=cut


use constant BEFR_LaPosteenvoieRecommande => scalar('BEFR_LaPosteenvoieRecommande');


=head2 BEFR_PaquetKilopostInternationale

Paquet  Kilopost Internationale



=cut


use constant BEFR_PaquetKilopostInternationale => scalar('BEFR_PaquetKilopostInternationale');


=head2 BEFR_ExpressTaxipost

BEFR_Express Taxipost



=cut


use constant BEFR_ExpressTaxipost => scalar('BEFR_ExpressTaxipost');


=head2 BEFR_LivraisonStandardInternationalePrixforFaitaire

Livraison standard internationale - prix forfaitaire



=cut


use constant BEFR_LivraisonStandardInternationalePrixforFaitaire => scalar('BEFR_LivraisonStandardInternationalePrixforFaitaire');


=head2 BEFR_LivraisonExpressInternationalePrixforFaitaire

Livraison express internationale - prix forfaitaire



=cut


use constant BEFR_LivraisonExpressInternationalePrixforFaitaire => scalar('BEFR_LivraisonExpressInternationalePrixforFaitaire');


=head2 BEFR_LivraisonSecuriseInternational

Livraison securisee



=cut


use constant BEFR_LivraisonSecuriseInternational => scalar('BEFR_LivraisonSecuriseInternational');


=head2 FR_Chronopost

Chronopost



=cut


use constant FR_Chronopost => scalar('FR_Chronopost');


=head2 UK_RoyalMailSpecialDeliveryNextDay

Royal Mail Special Delivery Next Day



=cut


use constant UK_RoyalMailSpecialDeliveryNextDay => scalar('UK_RoyalMailSpecialDeliveryNextDay');


=head2 CA_PostLightPacketInternational

Canada Post Light Packet International



=cut


use constant CA_PostLightPacketInternational => scalar('CA_PostLightPacketInternational');


=head2 CA_PostLightPacketUSA

Canada Post Light Packet USA



=cut


use constant CA_PostLightPacketUSA => scalar('CA_PostLightPacketUSA');


=head2 PL_DHLInternational

DHL



=cut


use constant PL_DHLInternational => scalar('PL_DHLInternational');


=head2 PL_InternationalRegular

Przesylka zagraniczna - zwykla



=cut


use constant PL_InternationalRegular => scalar('PL_InternationalRegular');


=head2 PL_InternationalSpecial

Przesylka zagraniczna - priorytetowa



=cut


use constant PL_InternationalSpecial => scalar('PL_InternationalSpecial');


=head2 PL_UPSInternational

UPS



=cut


use constant PL_UPSInternational => scalar('PL_UPSInternational');


=head2 CAFR_StandardDelivery

Normes de livraison postale



=cut


use constant CAFR_StandardDelivery => scalar('CAFR_StandardDelivery');


=head2 CAFR_ExpeditedDelivery

Expedition acceleree



=cut


use constant CAFR_ExpeditedDelivery => scalar('CAFR_ExpeditedDelivery');


=head2 CAFR_PostLettermail

Postes Canada, Poste-lettres



=cut


use constant CAFR_PostLettermail => scalar('CAFR_PostLettermail');


=head2 CAFR_PostRegularParcel

Postes Canada, Colis standard



=cut


use constant CAFR_PostRegularParcel => scalar('CAFR_PostRegularParcel');


=head2 CAFR_PostExpeditedParcel

Postes Canada, Colis acceleres



=cut


use constant CAFR_PostExpeditedParcel => scalar('CAFR_PostExpeditedParcel');


=head2 CAFR_PostXpresspost

Postes Canada, Xpresspost



=cut


use constant CAFR_PostXpresspost => scalar('CAFR_PostXpresspost');


=head2 CAFR_PostPriorityCourier

Postes Canada, Messageries prioritaires



=cut


use constant CAFR_PostPriorityCourier => scalar('CAFR_PostPriorityCourier');


=head2 CAFR_StandardInternational

Expedition standard - International, tarif fixe



=cut


use constant CAFR_StandardInternational => scalar('CAFR_StandardInternational');


=head2 CAFR_ExpeditedInternational

Expedition acceleree - International, tarif fixe



=cut


use constant CAFR_ExpeditedInternational => scalar('CAFR_ExpeditedInternational');


=head2 CAFR_OtherInternational

Autres services d'expedition internationale (voir description)



=cut


use constant CAFR_OtherInternational => scalar('CAFR_OtherInternational');


=head2 CAFR_PostExpeditedParcelUSA

Postes Canada, Colis acceleres - E.U.



=cut


use constant CAFR_PostExpeditedParcelUSA => scalar('CAFR_PostExpeditedParcelUSA');


=head2 CAFR_PostSmallPacketsUSA

Postes Canada, Petits paquets - E.U.



=cut


use constant CAFR_PostSmallPacketsUSA => scalar('CAFR_PostSmallPacketsUSA');


=head2 CAFR_PostXpresspostUSA

Postes Canada, Xpresspost - E.U.



=cut


use constant CAFR_PostXpresspostUSA => scalar('CAFR_PostXpresspostUSA');


=head2 CAFR_PostXpresspostInternational

Postes Canada, Xpresspost - International



=cut


use constant CAFR_PostXpresspostInternational => scalar('CAFR_PostXpresspostInternational');


=head2 CAFR_PostInternationalParcelSurface

Postes Canada, Colis international de surface



=cut


use constant CAFR_PostInternationalParcelSurface => scalar('CAFR_PostInternationalParcelSurface');


=head2 CAFR_PostInternationalParcelAir

Postes Canada, Colis-avion - International



=cut


use constant CAFR_PostInternationalParcelAir => scalar('CAFR_PostInternationalParcelAir');


=head2 CAFR_SmallPacketsInternational

Petits paquets - International



=cut


use constant CAFR_SmallPacketsInternational => scalar('CAFR_SmallPacketsInternational');


=head2 CAFR_PurolatorInternational

Purolator International



=cut


use constant CAFR_PurolatorInternational => scalar('CAFR_PurolatorInternational');


=head2 CAFR_PostSmallPacketsUSAGround

Postes Canada, Petits paquets - E.U. service de surface



=cut


use constant CAFR_PostSmallPacketsUSAGround => scalar('CAFR_PostSmallPacketsUSAGround');


=head2 CAFR_PostSmallPacketsUSAAir

Postes Canada, Petits paquets - E.U. par avion



=cut


use constant CAFR_PostSmallPacketsUSAAir => scalar('CAFR_PostSmallPacketsUSAAir');


=head2 CAFR_SmallPacketsInternationalGround

Petits paquets - International, courrier-surface



=cut


use constant CAFR_SmallPacketsInternationalGround => scalar('CAFR_SmallPacketsInternationalGround');


=head2 CAFR_SmallPacketsInternationalAir

Petits paquets - International, courrier-avion



=cut


use constant CAFR_SmallPacketsInternationalAir => scalar('CAFR_SmallPacketsInternationalAir');


=head2 CAFR_PostUSALetterPost

Postes Canada, Poste aux lettres - E.U.



=cut


use constant CAFR_PostUSALetterPost => scalar('CAFR_PostUSALetterPost');


=head2 CAFR_PostInternationalLetterPost

Postes Canada, Poste aux lettres - International



=cut


use constant CAFR_PostInternationalLetterPost => scalar('CAFR_PostInternationalLetterPost');


=head2 CAFR_UPSExpressCanada

UPS Express Saver



=cut


use constant CAFR_UPSExpressCanada => scalar('CAFR_UPSExpressCanada');


=head2 CAFR_UPSExpressSaverCanada

UPS Express Saver Canada



=cut


use constant CAFR_UPSExpressSaverCanada => scalar('CAFR_UPSExpressSaverCanada');


=head2 CAFR_UPSExpeditedCanada

UPS Expedited Canada



=cut


use constant CAFR_UPSExpeditedCanada => scalar('CAFR_UPSExpeditedCanada');


=head2 CAFR_UPSStandardCanada

UPS Standard au Canada



=cut


use constant CAFR_UPSStandardCanada => scalar('CAFR_UPSStandardCanada');


=head2 CAFR_UPSExpressUnitedStates

UPS Express Etats-Unis



=cut


use constant CAFR_UPSExpressUnitedStates => scalar('CAFR_UPSExpressUnitedStates');


=head2 CAFR_UPSExpeditedUnitedStates

UPS Expedited Etats-Unis



=cut


use constant CAFR_UPSExpeditedUnitedStates => scalar('CAFR_UPSExpeditedUnitedStates');


=head2 CAFR_UPS3DaySelectUnitedStates

3Day Select aux Etats-Unis



=cut


use constant CAFR_UPS3DaySelectUnitedStates => scalar('CAFR_UPS3DaySelectUnitedStates');


=head2 CAFR_UPSStandardUnitedStates

UPS Standard aux Etats-Unis



=cut


use constant CAFR_UPSStandardUnitedStates => scalar('CAFR_UPSStandardUnitedStates');


=head2 CAFR_UPSWorldWideExpress

UPS Worlwide Express



=cut


use constant CAFR_UPSWorldWideExpress => scalar('CAFR_UPSWorldWideExpress');


=head2 CAFR_UPSWorldWideExpedited

UPS Worlwide Expedited



=cut


use constant CAFR_UPSWorldWideExpedited => scalar('CAFR_UPSWorldWideExpedited');


=head2 UK_RoyalMailSpecialDelivery9am

Royal Mail Special Delivery 9:00 am



=cut


use constant UK_RoyalMailSpecialDelivery9am => scalar('UK_RoyalMailSpecialDelivery9am');


=head2 USPSFirstClassMailInternational

USPS First Class Mail International



=cut


use constant USPSFirstClassMailInternational => scalar('USPSFirstClassMailInternational');


=head2 USPSPriorityMailInternational

USPS Priority Mail International



=cut


use constant USPSPriorityMailInternational => scalar('USPSPriorityMailInternational');


=head2 USPSExpressMailInternational

USPS Express Mail International



=cut


use constant USPSExpressMailInternational => scalar('USPSExpressMailInternational');


=head2 CH_StandardInternational

Standardpauschale fur internationalen Versand



=cut


use constant CH_StandardInternational => scalar('CH_StandardInternational');


=head2 CH_ExpeditedInternational

Expresspauschale fur internationalen Versand



=cut


use constant CH_ExpeditedInternational => scalar('CH_ExpeditedInternational');


=head2 CH_SonstigerVersandSieheArtikelbeschreibung

Sonstiger Versand (Siehe Artikelbeschreibung)



=cut


use constant CH_SonstigerVersandSieheArtikelbeschreibung => scalar('CH_SonstigerVersandSieheArtikelbeschreibung');


=head2 TW_StandardInternationalFixedRate

International Standard FixedRate for Taiwan



=cut


use constant TW_StandardInternationalFixedRate => scalar('TW_StandardInternationalFixedRate');


=head2 TW_ExpeditedInternationalFixedRate

International Express FixedRate for Taiwan



=cut


use constant TW_ExpeditedInternationalFixedRate => scalar('TW_ExpeditedInternationalFixedRate');


=head2 USPSGlobalExpressGuaranteed

USPS Global Express Guaranteed



=cut


use constant USPSGlobalExpressGuaranteed => scalar('USPSGlobalExpressGuaranteed');


=head2 AU_RegularWithInsurance

Regular with Insurance



=cut


use constant AU_RegularWithInsurance => scalar('AU_RegularWithInsurance');


=head2 AU_ExpressWithInsurance

Express with Insurance



=cut


use constant AU_ExpressWithInsurance => scalar('AU_ExpressWithInsurance');


=head2 DE_DeutschePostWarensendungInternational

Deutsche Post Warensendung



=cut


use constant DE_DeutschePostWarensendungInternational => scalar('DE_DeutschePostWarensendungInternational');


=head2 DE_DeutschePostByendung

Deutsche Post Byendung



=cut


use constant DE_DeutschePostByendung => scalar('DE_DeutschePostByendung');


=head2 DE_HermesPaketUnversichertInternational

Hermes Paket (unversichert)



=cut


use constant DE_HermesPaketUnversichertInternational => scalar('DE_HermesPaketUnversichertInternational');


=head2 DE_HermesPaketVersichertInternational

Hermes Paket (versichert)



=cut


use constant DE_HermesPaketVersichertInternational => scalar('DE_HermesPaketVersichertInternational');


=head2 DE_iLoxxTransportXXLInternational

iloxx Transport XXL



=cut


use constant DE_iLoxxTransportXXLInternational => scalar('DE_iLoxxTransportXXLInternational');


=head2 DE_iLoxxUbernachtExpressInternational

iloxx Ubernacht Express



=cut


use constant DE_iLoxxUbernachtExpressInternational => scalar('DE_iLoxxUbernachtExpressInternational');


=head2 DE_iLoxxStandardInternational

iloxx Standard



=cut


use constant DE_iLoxxStandardInternational => scalar('DE_iLoxxStandardInternational');


=head2 DE_StandardInternational

Standardpauschale fur internationalen Versand



=cut


use constant DE_StandardInternational => scalar('DE_StandardInternational');


=head2 DE_ExpeditedInternational

Expresspauschale fur internationalen Versand



=cut


use constant DE_ExpeditedInternational => scalar('DE_ExpeditedInternational');


=head2 AT_BitteTreffenSieEineAuswahl

AT_BITTE_TREFFEN_SIE_EINE_AUSWAHL



=cut


use constant AT_BitteTreffenSieEineAuswahl => scalar('AT_BitteTreffenSieEineAuswahl');


=head2 AT_EinschreibenVersandInklEinschreibengebuhr

Einschreiben (Versand inkl. Einschreibengebuhr)



=cut


use constant AT_EinschreibenVersandInklEinschreibengebuhr => scalar('AT_EinschreibenVersandInklEinschreibengebuhr');


=head2 AT_NachnahmeVersandInklNachnahmegebuhr

Nachnahme (Versand inkl. Nachnahmegebuhr)



=cut


use constant AT_NachnahmeVersandInklNachnahmegebuhr => scalar('AT_NachnahmeVersandInklNachnahmegebuhr');


=head2 AT_ExpressOrCourierInternational

Express- oder Kurierversand



=cut


use constant AT_ExpressOrCourierInternational => scalar('AT_ExpressOrCourierInternational');


=head2 AT_InsuredExpressOrCourierInternational

Versicherter Express- oder Kurierversand



=cut


use constant AT_InsuredExpressOrCourierInternational => scalar('AT_InsuredExpressOrCourierInternational');


=head2 AT_SpecialDispatchInternational

Sonderversand (z.B. Sperrgut, KFZ)



=cut


use constant AT_SpecialDispatchInternational => scalar('AT_SpecialDispatchInternational');


=head2 AT_InsuredSpecialDispatchInternational

Versicherter Sonderversand (z.B. Sperrgut, KFZ)



=cut


use constant AT_InsuredSpecialDispatchInternational => scalar('AT_InsuredSpecialDispatchInternational');


=head2 AT_StandardInternational

Standardpauschale fur internationalen Versand



=cut


use constant AT_StandardInternational => scalar('AT_StandardInternational');


=head2 AT_ExpeditedInternational

Expresspauschale fur internationalen Versand



=cut


use constant AT_ExpeditedInternational => scalar('AT_ExpeditedInternational');


=head2 AT_OtherInternationalShipping

Sonstiger Versand (Siehe Artikelbeschreibung)



=cut


use constant AT_OtherInternationalShipping => scalar('AT_OtherInternationalShipping');


=head2 CH_BitteTreffenSieEineAuswahl

CH_BITTE_TREFFEN_SIE_EINE_AUSWAHL



=cut


use constant CH_BitteTreffenSieEineAuswahl => scalar('CH_BitteTreffenSieEineAuswahl');


=head2 CH_UnversicherterVersand

Unversicherter Versand



=cut


use constant CH_UnversicherterVersand => scalar('CH_UnversicherterVersand');


=head2 CH_VersicherterVersand

Versicherter Versand



=cut


use constant CH_VersicherterVersand => scalar('CH_VersicherterVersand');


=head2 CH_EinschreibenVersandInklEinschreibengebuhr

Einschreiben (Versand inkl. Einschreibengebuhr)



=cut


use constant CH_EinschreibenVersandInklEinschreibengebuhr => scalar('CH_EinschreibenVersandInklEinschreibengebuhr');


=head2 CH_NachnahmeVersandInklNachnahmegebuhr

Nachnahme (Versand inkl. Nachnahmegebuhr)



=cut


use constant CH_NachnahmeVersandInklNachnahmegebuhr => scalar('CH_NachnahmeVersandInklNachnahmegebuhr');


=head2 CH_ExpressOrCourierInternational

Express- oder Kurierversand



=cut


use constant CH_ExpressOrCourierInternational => scalar('CH_ExpressOrCourierInternational');


=head2 CH_InsuredExpressOrCourierInternational

Versicherter Express- oder Kurierversand



=cut


use constant CH_InsuredExpressOrCourierInternational => scalar('CH_InsuredExpressOrCourierInternational');


=head2 CH_SonderversandZBSperrgutKFZ

Sonderversand (z.B. Sperrgut, KFZ)



=cut


use constant CH_SonderversandZBSperrgutKFZ => scalar('CH_SonderversandZBSperrgutKFZ');


=head2 CH_VersicherterSonderversandZBSperrgutKFZ

Versicherter Sonderversand (z.B. Sperrgut, KFZ)



=cut


use constant CH_VersicherterSonderversandZBSperrgutKFZ => scalar('CH_VersicherterSonderversandZBSperrgutKFZ');


=head2 CH_StandardversandAPostPriority

Standardversand (A-Post/Priority)



=cut


use constant CH_StandardversandAPostPriority => scalar('CH_StandardversandAPostPriority');


=head2 CH_StandardversandBPostEconomy

Standardversand (B-Post/Economy)



=cut


use constant CH_StandardversandBPostEconomy => scalar('CH_StandardversandBPostEconomy');


=head2 DE_BitteTreffenSieEineAuswahl

DE_BITTE_TREFFEN_SIE_EINE_AUSWAHL



=cut


use constant DE_BitteTreffenSieEineAuswahl => scalar('DE_BitteTreffenSieEineAuswahl');


=head2 DE_EinschreibenVersandInklEinschreibengebuhr

Einschreiben (Versand inkl. Einschreibengebuhr)



=cut


use constant DE_EinschreibenVersandInklEinschreibengebuhr => scalar('DE_EinschreibenVersandInklEinschreibengebuhr');


=head2 DE_NachnahmeVersandInklNachnahmegebuhr

Nachnahme (Versand inkl. Nachnahmegebuhr)



=cut


use constant DE_NachnahmeVersandInklNachnahmegebuhr => scalar('DE_NachnahmeVersandInklNachnahmegebuhr');


=head2 DE_ExpressOrCourierInternational

Express- oder Kurierversand



=cut


use constant DE_ExpressOrCourierInternational => scalar('DE_ExpressOrCourierInternational');


=head2 DE_InsuredExpressOrCourierInternational

Versicherter Express- oder Kurierversand



=cut


use constant DE_InsuredExpressOrCourierInternational => scalar('DE_InsuredExpressOrCourierInternational');


=head2 DE_SonderversandZBMobelKFZ

Sonderversand (z.B. Mobel, KFZ)



=cut


use constant DE_SonderversandZBMobelKFZ => scalar('DE_SonderversandZBMobelKFZ');


=head2 DE_VersicherterSonderversandZBMobelKFZ

Versicherter Sonderversand (z.B. Mobel, KFZ)



=cut


use constant DE_VersicherterSonderversandZBMobelKFZ => scalar('DE_VersicherterSonderversandZBMobelKFZ');


=head2 DE_DeutschePostBriefInternational

Deutsche Post Brief



=cut


use constant DE_DeutschePostBriefInternational => scalar('DE_DeutschePostBriefInternational');


=head2 IE_StandardInternationalFlatRatePostage

Standard Int'l Flat Rate Postage



=cut


use constant IE_StandardInternationalFlatRatePostage => scalar('IE_StandardInternationalFlatRatePostage');


=head2 IE_ExpeditedInternationalFlatRatePostage

Expedited Int'l Flat Rate Postage



=cut


use constant IE_ExpeditedInternationalFlatRatePostage => scalar('IE_ExpeditedInternationalFlatRatePostage');


=head2 IE_OtherInternationalPostage

Other Int'l Postage (see description)



=cut


use constant IE_OtherInternationalPostage => scalar('IE_OtherInternationalPostage');


=head2 UK_StandardInternationalFlatRatePostage

Standard Int'l Flat Rate Postage



=cut


use constant UK_StandardInternationalFlatRatePostage => scalar('UK_StandardInternationalFlatRatePostage');


=head2 UK_ExpeditedInternationalFlatRatePostage

Expedited Int'l Flat Rate Postage



=cut


use constant UK_ExpeditedInternationalFlatRatePostage => scalar('UK_ExpeditedInternationalFlatRatePostage');


=head2 UK_OtherInternationalPostage

Other Int'l Postage (see description)



=cut


use constant UK_OtherInternationalPostage => scalar('UK_OtherInternationalPostage');


=head2 FR_ChronopostChronoRelais

Chronopost - Chrono Relais



=cut


use constant FR_ChronopostChronoRelais => scalar('FR_ChronopostChronoRelais');


=head2 FR_Chrono10

Chrono 10



=cut


use constant FR_Chrono10 => scalar('FR_Chrono10');


=head2 FR_Chrono13

Chrono 13



=cut


use constant FR_Chrono13 => scalar('FR_Chrono13');


=head2 FR_Chrono18

Chrono 18



=cut


use constant FR_Chrono18 => scalar('FR_Chrono18');


=head2 FR_ChronopostExpressInternational

Chronopost Express International



=cut


use constant FR_ChronopostExpressInternational => scalar('FR_ChronopostExpressInternational');


=head2 Pickup

PickUp Only Service



=cut


use constant Pickup => scalar('Pickup');


=head2 Delivery

Delivery



=cut


use constant Delivery => scalar('Delivery');


=head2 CA_Pickup

Pickup Only Service



=cut


use constant CA_Pickup => scalar('CA_Pickup');


=head2 DE_Pickup

Abholung



=cut


use constant DE_Pickup => scalar('DE_Pickup');


=head2 AU_Pickup

Pickup



=cut


use constant AU_Pickup => scalar('AU_Pickup');


=head2 AU_SmallParcels

Small Parcels



=cut


use constant AU_SmallParcels => scalar('AU_SmallParcels');


=head2 AU_PrePaidParcelPostSatchels500g

PrePaid Parcel Post Satchels 500g



=cut


use constant AU_PrePaidParcelPostSatchels500g => scalar('AU_PrePaidParcelPostSatchels500g');


=head2 AU_PrePaidParcelPostSatchels3kg

PrePaid Parcel Post Satchels 3kg



=cut


use constant AU_PrePaidParcelPostSatchels3kg => scalar('AU_PrePaidParcelPostSatchels3kg');


=head2 AU_PrePaidExpressPostSatchel500g

PrePaid Express Post Satchel 500g



=cut


use constant AU_PrePaidExpressPostSatchel500g => scalar('AU_PrePaidExpressPostSatchel500g');


=head2 AU_PrePaidExpressPostSatchel3kg

PrePaid Express Post Satchel 3kg



=cut


use constant AU_PrePaidExpressPostSatchel3kg => scalar('AU_PrePaidExpressPostSatchel3kg');


=head2 AU_PrePaidExpressPostPlatinum500g

PrePaid Express Post Platinum 500g



=cut


use constant AU_PrePaidExpressPostPlatinum500g => scalar('AU_PrePaidExpressPostPlatinum500g');


=head2 AU_PrePaidExpressPostPlatinum3kg

PrePaid Express Post Platinum 3kg



=cut


use constant AU_PrePaidExpressPostPlatinum3kg => scalar('AU_PrePaidExpressPostPlatinum3kg');


=head2 AU_ExpressCourierInternational

Express Courier International



=cut


use constant AU_ExpressCourierInternational => scalar('AU_ExpressCourierInternational');


=head2 AU_ExpressPostInternational

Express Post International



=cut


use constant AU_ExpressPostInternational => scalar('AU_ExpressPostInternational');


=head2 AU_PrePaidExpressPostInternationalEnvelopeC5

PrePaid Express Post International Envelope C5



=cut


use constant AU_PrePaidExpressPostInternationalEnvelopeC5 => scalar('AU_PrePaidExpressPostInternationalEnvelopeC5');


=head2 AU_PrePaidExpressPostInternationalEnvelopeB4

PrePaid Express Post International Envelope B4



=cut


use constant AU_PrePaidExpressPostInternationalEnvelopeB4 => scalar('AU_PrePaidExpressPostInternationalEnvelopeB4');


=head2 AU_PrePaidExpressPostInternationalSatchels2kg

PrePaid Express Post International Satchels 2kg



=cut


use constant AU_PrePaidExpressPostInternationalSatchels2kg => scalar('AU_PrePaidExpressPostInternationalSatchels2kg');


=head2 AU_PrePaidExpressPostInternationalSatchels3kg

PrePaid Express Post International Satchels 3kg



=cut


use constant AU_PrePaidExpressPostInternationalSatchels3kg => scalar('AU_PrePaidExpressPostInternationalSatchels3kg');


=head2 AU_PrePaidExpressPostInternationalBox5kg

PrePaid Express Post International Box 5kg



=cut


use constant AU_PrePaidExpressPostInternationalBox5kg => scalar('AU_PrePaidExpressPostInternationalBox5kg');


=head2 AU_PrePaidExpressPostInternationalBox10kg

PrePaid Express Post International Box 10kg



=cut


use constant AU_PrePaidExpressPostInternationalBox10kg => scalar('AU_PrePaidExpressPostInternationalBox10kg');


=head2 AU_PrePaidExpressPostInternationalBox20kg

PrePaid Express Post International Box 20kg



=cut


use constant AU_PrePaidExpressPostInternationalBox20kg => scalar('AU_PrePaidExpressPostInternationalBox20kg');


=head2 AU_RegisteredParcelPost

Registered Parcel Post



=cut


use constant AU_RegisteredParcelPost => scalar('AU_RegisteredParcelPost');


=head2 AU_RegisteredSmallParcel

Registered Small Parcel



=cut


use constant AU_RegisteredSmallParcel => scalar('AU_RegisteredSmallParcel');


=head2 AU_RegisteredParcelPostPrepaidSatchel500g

Registered Parcel Post Prepaid Satchel 500g



=cut


use constant AU_RegisteredParcelPostPrepaidSatchel500g => scalar('AU_RegisteredParcelPostPrepaidSatchel500g');


=head2 AU_RegisteredParcelPostPrepaidSatchel3kg

Registered Parcel Post Prepaid Satchel 3kg



=cut


use constant AU_RegisteredParcelPostPrepaidSatchel3kg => scalar('AU_RegisteredParcelPostPrepaidSatchel3kg');


=head2 FR_Pickup

Enlevement



=cut


use constant FR_Pickup => scalar('FR_Pickup');


=head2 AT_Pickup

Pickup



=cut


use constant AT_Pickup => scalar('AT_Pickup');


=head2 BENL_Pickup

Afhalen



=cut


use constant BENL_Pickup => scalar('BENL_Pickup');


=head2 BEFR_Pickup

Pickup



=cut


use constant BEFR_Pickup => scalar('BEFR_Pickup');


=head2 CH_Pickup

Pickup



=cut


use constant CH_Pickup => scalar('CH_Pickup');


=head2 IT_Pickup

Pickup



=cut


use constant IT_Pickup => scalar('IT_Pickup');


=head2 NL_Pickup

Pickup



=cut


use constant NL_Pickup => scalar('NL_Pickup');


=head2 PL_Pickup

Pickup



=cut


use constant PL_Pickup => scalar('PL_Pickup');


=head2 ES_Pickup

Pickup



=cut


use constant ES_Pickup => scalar('ES_Pickup');


=head2 SG_Delivery

Pickup



=cut


use constant SG_Delivery => scalar('SG_Delivery');


=head2 UK_OtherCourier24

Other 24 Hour Courier



=cut


use constant UK_OtherCourier24 => scalar('UK_OtherCourier24');


=head2 UK_OtherCourier48

Other 48 Hour Courier



=cut


use constant UK_OtherCourier48 => scalar('UK_OtherCourier48');


=head2 Courier

Courier Shipping



=cut


use constant Courier => scalar('Courier');







1;   
