#!/usr/bin/perl

package eBay::API::XML::Call::ReviseCheckoutStatus;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. ReviseCheckoutStatus.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::Call::ReviseCheckoutStatus

=head1 DESCRIPTION



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::Call::ReviseCheckoutStatus inherits from the L<eBay::API::XML::BaseCall> class

=cut

use eBay::API::XML::BaseCall;
our @ISA = ("eBay::API::XML::BaseCall");

use eBay::API::XML::Call::ReviseCheckoutStatus::ReviseCheckoutStatusRequestType;
use eBay::API::XML::Call::ReviseCheckoutStatus::ReviseCheckoutStatusResponseType;


=head1 Subroutines:

=cut

sub getApiCallName {
   return 'ReviseCheckoutStatus';
}
sub getRequestDataTypeFullPackage {
   return 'eBay::API::XML::Call::ReviseCheckoutStatus::ReviseCheckoutStatusRequestType';
}
sub getResponseDataTypeFullPackage {
   return 'eBay::API::XML::Call::ReviseCheckoutStatus::ReviseCheckoutStatusResponseType';
}

#
# input properties
#

=head2 setAdjustmentAmount()

Discount or charge agreed to by the buyer and seller. A positive value
indicates that the amount is an extra charge being paid to the seller by
the buyer. A negative value indicates that the amount is a discount given
to the buyer by the seller.

  RequiredInput: No
#    Argument: 'ns:AmountType'

=cut
       
sub setAdjustmentAmount {
   my $self   = shift;
   my $pAdjustmentAmount = shift;
   $self->getRequestDataType()->setAdjustmentAmount($pAdjustmentAmount);
}

=head2 setAmountPaid()

The amount paid by the buyer. For an eBay Stores item, the value passed in
AmountPaid is the transaction/item price. For a US eBay Motors item,
AmountPaid is the total amount paid by the buyer for the deposit.

  RequiredInput: No
#    Argument: 'ns:AmountType'

=cut
       
sub setAmountPaid {
   my $self   = shift;
   my $pAmountPaid = shift;
   $self->getRequestDataType()->setAmountPaid($pAmountPaid);
}

=head2 setBuyerID()

eBay ID for the buyer in the transaction being revised. A transaction is
uniquely identified by one of two means: (a) You provide a TransactionID
and ItemID. (This is the preferred approach.), OR, (b) You provide a
BuyerID and ItemID and eBay identifies only one transaction for that
combination (an error is returned if there are multiple transactions for
that combination). Note: If all three are provided (that is, BuyerID,
ItemID and TransactionID), BuyerID is ignored.

  RequiredInput: Conditionally
#    Argument: 'xs:string'

=cut
       
sub setBuyerID {
   my $self   = shift;
   my $sBuyerID = shift;
   $self->getRequestDataType()->setBuyerID($sBuyerID);
}

=head2 setCODCost()

Italy site (site ID 101) only.
Enables you to specify the cash-on-delivery (COD) cost, for COD shipping.

SeeLink: URL: http://developer.ebay.com/DevZone/XML/docs/WebHelp/index.htm?context=eBay_XML_API&topic=CODInShippingDetails
Title: Specifying the Cash on Delivery Option in Shipping Details

  RequiredInput: No
#    Argument: 'ns:AmountType'

=cut
       
sub setCODCost {
   my $self   = shift;
   my $pCODCost = shift;
   $self->getRequestDataType()->setCODCost($pCODCost);
}

=head2 setCheckoutMethod()

Not supported.

  RequiredInput: No
#    Argument: 'ns:CheckoutMethodCodeType'

=cut
       
sub setCheckoutMethod {
   my $self   = shift;
   my $sCheckoutMethod = shift;
   $self->getRequestDataType()->setCheckoutMethod($sCheckoutMethod);
}

=head2 setCheckoutStatus()

The current status of the checkout process for the transaction.

  RequiredInput: Yes
#    Argument: 'ns:CompleteStatusCodeType'

=cut
       
sub setCheckoutStatus {
   my $self   = shift;
   my $sCheckoutStatus = shift;
   $self->getRequestDataType()->setCheckoutStatus($sCheckoutStatus);
}

=head2 setEncryptedID()

Not supported.

MaxLength: 20

  RequiredInput: No
#    Argument: 'xs:string'

=cut
       
sub setEncryptedID {
   my $self   = shift;
   my $sEncryptedID = shift;
   $self->getRequestDataType()->setEncryptedID($sEncryptedID);
}

=head2 setExternalTransaction()

Not supported.

  RequiredInput: No
#    Argument: 'ns:ExternalTransactionType'

=cut
       
sub setExternalTransaction {
   my $self   = shift;
   my $pExternalTransaction = shift;
   $self->getRequestDataType()->setExternalTransaction($pExternalTransaction);
}

=head2 setInsuranceType()

The insurance option selected by the buyer.

  RequiredInput: No
#    Argument: 'ns:InsuranceSelectedCodeType'

=cut
       
sub setInsuranceType {
   my $self   = shift;
   my $sInsuranceType = shift;
   $self->getRequestDataType()->setInsuranceType($sInsuranceType);
}

=head2 setItemID()

Unique ID for the item associated with the checkout. A transaction is
uniquely identified by one of two means: (a) You provide a TransactionID
and ItemID. (This is the preferred approach.), OR, (b) You provide a
BuyerID and ItemID and eBay identifies only one transaction for that
combination (an error is returned if there are multiple transactions for
that combination). Note: If all three are provided (that is, BuyerID,
ItemID and TransactionID), BuyerID is ignored.

MaxLength: 19 (Note: The eBay database specifies 38. Currently, Item IDs are usually 9 to 12 digits)

  RequiredInput: Yes
#    Argument: 'ns:ItemIDType'

=cut
       
sub setItemID {
   my $self   = shift;
   my $pItemID = shift;
   $self->getRequestDataType()->setItemID($pItemID);
}

=head2 setMultipleSellerPaymentID()

Not supported.

  RequiredInput: No
#    Argument: 'xs:string'

=cut
       
sub setMultipleSellerPaymentID {
   my $self   = shift;
   my $sMultipleSellerPaymentID = shift;
   $self->getRequestDataType()->setMultipleSellerPaymentID($sMultipleSellerPaymentID);
}

=head2 setOrderID()

Unique ID for a multi-item order. If specified, ItemID and
TransactionID are ignored if specified in the same call.
Changes to the checkout status are applied to the specified
order as a whole (and thus the child transactions
associated with the order).

  RequiredInput: No
#    Argument: 'xs:string'

=cut
       
sub setOrderID {
   my $self   = shift;
   my $sOrderID = shift;
   $self->getRequestDataType()->setOrderID($sOrderID);
}

=head2 setPaymentMethodUsed()

Payment method used by the buyer.
Required if CheckoutStatus is Complete.
(Please note that only PayPal can set this value to PayPal.)
<br>
<span class="tablenote"><b>Note:</b>
Required or allowed payment methods vary by site and category. Refer to
<a href="http://developer.ebay.com/DevZone/XML/docs/WebHelp/wwhelp/wwhimpl/js/html/wwhelp.htm?context=eBay_XML_API&topic=PaymentMethodDifferences">
Payment Method Differences (PaymentMethod)</a> in the eBay
Trading API Guide for information to help you determine which payment
methods you are required or allowed to specify.
</span><br>
<br>

AllValuesExcept: PayPal

  RequiredInput: Conditionally
#    Argument: 'ns:BuyerPaymentMethodCodeType'

=cut
       
sub setPaymentMethodUsed {
   my $self   = shift;
   my $sPaymentMethodUsed = shift;
   $self->getRequestDataType()->setPaymentMethodUsed($sPaymentMethodUsed);
}

=head2 setPaymentStatus()

Not supported.

  RequiredInput: No
#    Argument: 'ns:RCSPaymentStatusCodeType'

=cut
       
sub setPaymentStatus {
   my $self   = shift;
   my $sPaymentStatus = shift;
   $self->getRequestDataType()->setPaymentStatus($sPaymentStatus);
}

=head2 setSalesTax()

Amount of money paid for sales tax. For Third-Party Checkout
applications.

  RequiredInput: No
#    Argument: 'ns:AmountType'

=cut
       
sub setSalesTax {
   my $self   = shift;
   my $pSalesTax = shift;
   $self->getRequestDataType()->setSalesTax($pSalesTax);
}

=head2 setShippingAddress()

For internal use.

  RequiredInput: No
#    Argument: 'ns:AddressType'

=cut
       
sub setShippingAddress {
   my $self   = shift;
   my $pShippingAddress = shift;
   $self->getRequestDataType()->setShippingAddress($pShippingAddress);
}

=head2 setShippingCost()

Amount of money paid for shipping. For Third-party Checkout
applications.

  RequiredInput: No
#    Argument: 'ns:AmountType'

=cut
       
sub setShippingCost {
   my $self   = shift;
   my $pShippingCost = shift;
   $self->getRequestDataType()->setShippingCost($pShippingCost);
}

=head2 setShippingIncludedInTax()

An indicator of whether shipping costs were included in the
taxable amount. For Third-Party Checkout applications.

Default: false

  RequiredInput: No
#    Argument: 'xs:boolean'

=cut
       
sub setShippingIncludedInTax {
   my $self   = shift;
   my $sShippingIncludedInTax = shift;
   $self->getRequestDataType()->setShippingIncludedInTax($sShippingIncludedInTax);
}

=head2 setShippingInsuranceCost()

Amount of money paid for insurance. For Third Party Checkout
applications.

  RequiredInput: No
#    Argument: 'ns:AmountType'

=cut
       
sub setShippingInsuranceCost {
   my $self   = shift;
   my $pShippingInsuranceCost = shift;
   $self->getRequestDataType()->setShippingInsuranceCost($pShippingInsuranceCost);
}

=head2 setShippingService()

The shipping service selected by the buyer from among the shipping
services offered by the seller (such as UPS Ground). For a list of valid
values that you can cache for future use, call GeteBayDetails with
DetailName set to ShippingServiceDetails.

  RequiredInput: No
#    Argument: 'xs:token'

=cut
       
sub setShippingService {
   my $self   = shift;
   my $sShippingService = shift;
   $self->getRequestDataType()->setShippingService($sShippingService);
}

=head2 setTransactionID()

Unique ID for the transaction associated with the checkout. For Chinese
auctions, the value passed in the TransactionID argument must be 0 or the
call will fail with an error. For all other auction types, TransactionID
accepts the actual, nonzero transaction ID. Call GetItemTransactionsCall
or GetSellerTransactionsCall to determine the correct transaction ID. A
transaction is uniquely identified by one of two means: (a) You provide a
TransactionID and ItemID. (This is the preferred approach.), OR, (b) You
provide a BuyerID and ItemID and eBay identifies only one transaction for
that combination (an error is returned if there are multiple transactions
for that combination). Note: If all three are provided (that is, BuyerID,
ItemID and TransactionID), BuyerID is ignored.

MaxLength: 19 (Note: The eBay database specifies 38. Currently, transaction IDs are usually 9 to 12 digits.)

  RequiredInput: Conditionally
#    Argument: 'xs:string'

=cut
       
sub setTransactionID {
   my $self   = shift;
   my $sTransactionID = shift;
   $self->getRequestDataType()->setTransactionID($sTransactionID);
}



#
# output properties
#





1;   
