/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.language.translate;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.Properties;
import org.apache.tika.exception.TikaException;
import org.apache.tika.language.translate.ExternalTranslator;

public class MosesTranslator
extends ExternalTranslator {
    private static final String DEFAULT_PATH = "dummy-path";
    private static final String TMP_FILE_NAME = "tika.moses.translation.tmp";
    private String smtPath = "dummy-path";
    private String scriptPath = "dummy-path";

    public MosesTranslator() {
        Properties config = new Properties();
        try {
            config.load(MosesTranslator.class.getResourceAsStream("translator.moses.properties"));
            new MosesTranslator(config.getProperty("translator.smt_path"), config.getProperty("translator.script_path"));
        }
        catch (IOException e) {
            throw new AssertionError((Object)"Failed to read translator.moses.properties.");
        }
    }

    public MosesTranslator(String smtPath, String scriptPath) {
        this.smtPath = smtPath;
        this.scriptPath = scriptPath;
        System.out.println(this.buildCommand(smtPath, scriptPath));
    }

    @Override
    public String translate(String text, String sourceLanguage, String targetLanguage) throws TikaException, IOException {
        String line;
        if (!this.isAvailable() || !this.checkCommand(this.buildCheckCommand(this.smtPath), 1)) {
            return text;
        }
        File tmpFile = new File(TMP_FILE_NAME);
        OutputStreamWriter out = new OutputStreamWriter((OutputStream)new FileOutputStream(tmpFile), Charset.defaultCharset());
        out.append(text).append('\n').close();
        Runtime.getRuntime().exec(this.buildCommand(this.smtPath, this.scriptPath), new String[0], this.buildWorkingDirectory(this.scriptPath));
        File tmpTranslatedFile = new File("tika.moses.translation.tmp.translated");
        StringBuilder stringBuilder = new StringBuilder();
        BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(tmpTranslatedFile), Charset.defaultCharset()));
        while ((line = reader.readLine()) != null) {
            stringBuilder.append(line);
        }
        if (!tmpFile.delete() || !tmpTranslatedFile.delete()) {
            throw new IOException("Failed to delete temporary files.");
        }
        return stringBuilder.toString();
    }

    @Override
    public boolean isAvailable() {
        return !this.smtPath.equals(DEFAULT_PATH) && !this.scriptPath.equals(DEFAULT_PATH);
    }

    private String buildCommand(String smtPath, String scriptPath) {
        return "java -jar " + smtPath + " -c NONE " + scriptPath + " " + System.getProperty("user.dir") + "/" + TMP_FILE_NAME;
    }

    private String buildCheckCommand(String smtPath) {
        return "java -jar " + smtPath;
    }

    private File buildWorkingDirectory(String scriptPath) {
        return new File(scriptPath.substring(0, scriptPath.lastIndexOf("/") + 1));
    }
}

