/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso.distribution;

import java.util.Currency;
import java.util.Date;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.sis.internal.metadata.MetadataUtilities;
import org.apache.sis.metadata.iso.ISOMetadata;
import org.opengis.annotation.Obligation;
import org.opengis.annotation.Specification;
import org.opengis.annotation.UML;
import org.opengis.metadata.distribution.StandardOrderProcess;
import org.opengis.util.InternationalString;
import org.opengis.util.Record;
import org.opengis.util.RecordType;

@XmlType(name="MD_StandardOrderProcess_Type", propOrder={"fees", "plannedAvailableDateTime", "orderingInstructions", "turnaround"})
@XmlRootElement(name="MD_StandardOrderProcess")
public class DefaultStandardOrderProcess
extends ISOMetadata
implements StandardOrderProcess {
    private static final long serialVersionUID = 6107884863471045743L;
    private InternationalString fees;
    private Currency currency;
    private long plannedAvailableDateTime = Long.MIN_VALUE;
    private InternationalString orderingInstructions;
    private InternationalString turnaround;
    private RecordType orderOptionType;
    private Record orderOptions;

    public DefaultStandardOrderProcess() {
    }

    public DefaultStandardOrderProcess(StandardOrderProcess standardOrderProcess) {
        super(standardOrderProcess);
        if (standardOrderProcess != null) {
            this.fees = standardOrderProcess.getFees();
            this.plannedAvailableDateTime = MetadataUtilities.toMilliseconds(standardOrderProcess.getPlannedAvailableDateTime());
            this.orderingInstructions = standardOrderProcess.getOrderingInstructions();
            this.turnaround = standardOrderProcess.getTurnaround();
            if (standardOrderProcess instanceof DefaultStandardOrderProcess) {
                this.orderOptionType = ((DefaultStandardOrderProcess)standardOrderProcess).getOrderOptionType();
                this.orderOptions = ((DefaultStandardOrderProcess)standardOrderProcess).getOrderOptions();
            }
        }
    }

    public static DefaultStandardOrderProcess castOrCopy(StandardOrderProcess standardOrderProcess) {
        if (standardOrderProcess == null || standardOrderProcess instanceof DefaultStandardOrderProcess) {
            return (DefaultStandardOrderProcess)standardOrderProcess;
        }
        return new DefaultStandardOrderProcess(standardOrderProcess);
    }

    @Override
    @XmlElement(name="fees")
    public InternationalString getFees() {
        return this.fees;
    }

    public void setFees(InternationalString internationalString) {
        this.checkWritePermission();
        this.fees = internationalString;
    }

    public Currency getCurrency() {
        return this.currency;
    }

    public void setCurrency(Currency currency) {
        this.checkWritePermission();
        this.currency = currency;
    }

    @Override
    @XmlElement(name="plannedAvailableDateTime")
    public Date getPlannedAvailableDateTime() {
        return MetadataUtilities.toDate(this.plannedAvailableDateTime);
    }

    public void setPlannedAvailableDateTime(Date date) {
        this.checkWritePermission();
        this.plannedAvailableDateTime = MetadataUtilities.toMilliseconds(date);
    }

    @Override
    @XmlElement(name="orderingInstructions")
    public InternationalString getOrderingInstructions() {
        return this.orderingInstructions;
    }

    public void setOrderingInstructions(InternationalString internationalString) {
        this.checkWritePermission();
        this.orderingInstructions = internationalString;
    }

    @Override
    @XmlElement(name="turnaround")
    public InternationalString getTurnaround() {
        return this.turnaround;
    }

    public void setTurnaround(InternationalString internationalString) {
        this.checkWritePermission();
        this.turnaround = internationalString;
    }

    @UML(identifier="orderOptionType", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public RecordType getOrderOptionType() {
        return this.orderOptionType;
    }

    public void setOrderOptionType(RecordType recordType) {
        this.checkWritePermission();
        this.orderOptionType = recordType;
    }

    @UML(identifier="orderOptions", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public Record getOrderOptions() {
        return this.orderOptions;
    }

    public void setOrderOptions(Record record) {
        this.checkWritePermission();
        this.orderOptions = record;
    }
}

