/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso.citation;

import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.sis.metadata.iso.citation.AbstractParty;
import org.apache.sis.util.iso.Types;
import org.opengis.annotation.Obligation;
import org.opengis.annotation.Specification;
import org.opengis.annotation.UML;
import org.opengis.metadata.citation.Contact;
import org.opengis.util.InternationalString;

@XmlType(name="CI_Individual_Type", propOrder={"positionName"})
@XmlRootElement(name="CI_Individual")
@UML(identifier="CI_Individual", specification=Specification.ISO_19115)
public class DefaultIndividual
extends AbstractParty {
    private static final long serialVersionUID = -5116802681895278739L;
    private InternationalString positionName;

    public DefaultIndividual() {
    }

    public DefaultIndividual(CharSequence charSequence, CharSequence charSequence2, Contact contact) {
        super(charSequence, contact);
        this.positionName = Types.toInternationalString(charSequence2);
    }

    public DefaultIndividual(DefaultIndividual defaultIndividual) {
        super(defaultIndividual);
        if (defaultIndividual != null) {
            this.positionName = defaultIndividual.getPositionName();
        }
    }

    @XmlElement(name="positionName")
    @UML(identifier="positionName", obligation=Obligation.CONDITIONAL, specification=Specification.ISO_19115)
    public InternationalString getPositionName() {
        return this.positionName;
    }

    public void setPositionName(InternationalString internationalString) {
        this.checkWritePermission();
        this.positionName = internationalString;
    }
}

