/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.jaxb.gco;

import javax.xml.bind.annotation.adapters.XmlAdapter;
import org.apache.sis.internal.jaxb.Context;
import org.apache.sis.internal.jaxb.gco.GO_CharacterString;
import org.apache.sis.internal.jaxb.gmd.PT_FreeText;
import org.apache.sis.internal.jaxb.gmx.Anchor;
import org.apache.sis.util.CharSequences;
import org.apache.sis.xml.XLink;
import org.opengis.util.InternationalString;

public final class CharSequenceAdapter
extends XmlAdapter<GO_CharacterString, CharSequence> {
    private CharSequenceAdapter() {
    }

    @Override
    public CharSequence unmarshal(GO_CharacterString gO_CharacterString) {
        return gO_CharacterString != null ? gO_CharacterString.toCharSequence() : null;
    }

    @Override
    public GO_CharacterString marshal(CharSequence charSequence) {
        return CharSequenceAdapter.wrap(charSequence);
    }

    static GO_CharacterString wrap(CharSequence charSequence) {
        Context context;
        XLink xLink;
        Object object;
        if (charSequence instanceof String) {
            return CharSequenceAdapter.wrap(Context.current(), charSequence, (String)charSequence);
        }
        if (charSequence instanceof InternationalString && (object = PT_FreeText.create((InternationalString)charSequence)) != null) {
            return object;
        }
        if ((charSequence = CharSequences.trimWhitespaces(charSequence)) == null || charSequence.length() == 0) {
            return null;
        }
        if (!(charSequence instanceof Anchor) && (object = CharSequences.trimWhitespaces(charSequence.toString())) != null && !((String)object).isEmpty() && (xLink = Context.resolver(context = Context.current()).anchor(context, charSequence, (CharSequence)object)) != null) {
            charSequence = xLink instanceof Anchor ? (Anchor)xLink : new Anchor(xLink, (String)object);
        }
        return new GO_CharacterString(charSequence);
    }

    public static GO_CharacterString wrap(Context context, Object object, String string) {
        CharSequence charSequence = CharSequenceAdapter.value(context, object, string);
        return charSequence != null ? new GO_CharacterString(charSequence) : null;
    }

    public static CharSequence value(Context context, Object object, String string) {
        if ((string = CharSequences.trimWhitespaces(string)) == null || string.isEmpty()) {
            return null;
        }
        XLink xLink = Context.resolver(context).anchor(context, object, string);
        if (xLink != null) {
            if (xLink instanceof Anchor) {
                return (Anchor)xLink;
            }
            return new Anchor(xLink, string);
        }
        return string;
    }
}

