#!/usr/bin/perl

use strict;
use warnings;
no  warnings 'syntax';

use Regexp::Common;
use Test::More;
use t::zip::Zip;

my $r = eval "require Test::Regexp; 1";

unless ($r) {
    print "1..0 # SKIP Test::Regexp not found\n";
    exit;
}


test_zips country         =>  "Luxembourg",
          name            =>  "Luxembourg zip codes",
          prefix          => {
              iso         =>  "LU",
              cept        =>  "L",
              invalid     =>  "DE",
          },
          prefix_test_set => [2968, 8701],
;


done_testing;


sub valid_zip_codes {
    map {sprintf "%04d" => $_}

     101,    121,    123 ..  125,    131 ..  132,    141 ..  143,
     161,    171,    173,            181 ..  183,    191 ..  192,
     202,    211,    231,    241,    251,            262 ..  263,
     291,            321 ..  325,    332,    342,    361 ..  362,
     372,            381 ..  383,    391,            401 ..  403,
     411 ..  412,    421 ..  422,    441 ..  443,    445 ..  446,
     451,    453,    462 ..  464,    471 ..  472,    481 ..  482,
     491 ..  497,    521,            531 ..  532,    551 ..  554,
     561 ..  562,    581 ..  584,    611 ..  612,    641 ..  644,
     661 ..  664,    671 ..  672,    691 ..  692,    721 ..  723,
     751 ..  754,    761,    763,    771 ..  772,    801 ..  809,
     811 ..  814,    821 ..  823,    831 ..  834,    841,
     852 ..  855,    861,    881,    901,            903 ..  904,
     911 ..  914,    921 ..  922,    942 ..  944,    951 ..  954,
     961 ..  963,    971 ..  973,    981 ..  983,    991 ..  995,

    1009 .. 1030,   1050,   1060,   1090,           1110 .. 1153,
    1159 .. 1161,   1208 .. 1283,   1309 .. 1376,   1409,
    1411 .. 1434,   1445,           1448 .. 1484,   1490,   1499,
    1508 .. 1552,   1610 .. 1611,   1613 .. 1656,   1660 .. 1661,
    1670,           1709 .. 1753,   1811 .. 1818,   1820 .. 1822,
    1831 .. 1843,   1845 .. 1846,   1850 .. 1868,   1870 .. 1873,
    1880 .. 1882,   1896 .. 1899,   1910 .. 1954,

    2010 .. 2020,   2080,   2082,   2084 .. 2091,   2093 .. 2099,
    2111 .. 2125,   2127 .. 2135,   2137 .. 2184,   2210 .. 2215,
    2220 .. 2234,   2240 .. 2243,   2261 .. 2263,   2265 .. 2273,
    2308 .. 2320,   2322 .. 2324,   2326 .. 2361,   2370,
    2380 .. 2381,   2409 .. 2420,   2422 .. 2436,   2440 .. 2454,
    2510 .. 2567,   2609 .. 2617,   2619 .. 2637,   2651 .. 2654,
    2661 .. 2674,   2680 .. 2681,   2711 .. 2734,   2736 .. 2741,
    2761 .. 2764,   2850,   2860,   2880,           2887 .. 2889,
    2900,           2910 .. 2916,   2918 .. 2922,   2925 .. 2926,
    2928 .. 2942,   2946,           2949 .. 2958,   2960 .. 2961,
    2964 .. 2966,   2968,   2971,   2974 .. 2988,   2990 .. 2992,
    2994 .. 2999,

    3201,           3205 .. 3206,   3208 .. 3225,   3229 .. 3243,
    3249 .. 3261,   3265 .. 3267,   3269 .. 3288,   3290,   3311,
    3313 .. 3318,   3320 .. 3330,   3332 .. 3337,   3340 .. 3341,
    3345 .. 3378,   3380,           3382 .. 3386,   3389 .. 3398,
    3401 .. 3403,   3409 .. 3433,   3435 .. 3436,   3439 .. 3454,
    3460 .. 3476,   3480 .. 3493,   3501 .. 3517,   3520 .. 3526,
    3529 .. 3532,   3539 .. 3555,   3560 .. 3576,   3582 .. 3585,
    3588 .. 3598,   3601,           3611 .. 3617,   3620 .. 3622,
    3630 .. 3631,   3635 .. 3638,   3640 .. 3644,   3650 .. 3658,
    3660,           3670 .. 3682,   3701,   3705,   3710 .. 3731,
    3733 .. 3744,   3750 .. 3755,   3761 .. 3768,   3770 .. 3776,
    3780 .. 3782,   3784,           3786 .. 3790,   3801,
    3810 .. 3826,   3830 .. 3844,   3850 .. 3864,   3870 .. 3884,
    3895 .. 3899,   3901,           3909 .. 3941,   3943 .. 3945,
    3960 .. 3961,   3980,   3985,

    4001 .. 4074,   4080 .. 4086,   4088,           4100 .. 4103,
    4105 .. 4116,   4118 .. 4123,   4125 .. 4126,   4130 .. 4143,
    4149 .. 4156,   4164 .. 4180,   4201 .. 4211,   4213 .. 4214,
    4216 .. 4217,   4220 .. 4222,   4230 .. 4256,   4260 .. 4268,
    4270 .. 4272,   4275 .. 4283,   4289,           4301 .. 4310,
    4314 .. 4328,   4330 .. 4337,   4340 .. 4355,   4360 .. 4373,
    4380 .. 4385,   4390 .. 4398,   4401 .. 4402,   4405 .. 4423,
    4429 .. 4451,   4459 .. 4470,   4475 .. 4494,   4499,
    4501 .. 4565,   4569 .. 4583,   4590 .. 4599,   4601 .. 4613,
    4620 .. 4636,   4638 .. 4651,   4653,           4656 .. 4658,
    4660 .. 4672,   4676 .. 4693,   4696 .. 4698,   4701 .. 4702,
    4706 .. 4722,   4730 .. 4745,   4750 .. 4763,   4770 .. 4786,
    4795 .. 4798,   4801 .. 4802,   4804 .. 4815,   4818 .. 4820,
    4822 .. 4826,   4829 .. 4834,   4837 .. 4840,   4842 .. 4850,
    4853,           4870 .. 4895,   4901 .. 4902,   4906 .. 4956,
    4958 .. 4982,   4984 .. 4999,

    5201,           5211 .. 5222,   5230 .. 5241,   5243 .. 5244,
    5250 .. 5256,   5280,   5290,   5299,   5310,   5312,
    5314 .. 5318,   5320,   5322,   5324,   5326,   5328,
    5330 .. 5337,   5339 .. 5342,   5351 .. 5353,   5355,
    5359 .. 5378,   5380,           5401 .. 5405,   5407 .. 5408,
    5410 .. 5419,   5421 .. 5427,   5429 .. 5435,   5439 .. 5447,
    5450 .. 5451,   5460,           5465 .. 5466,   5470 .. 5471,
    5480 .. 5483,   5485,           5488 .. 5489,   5495,   5499,
    5501,           5505 .. 5507,   5511 .. 5523,   5530 .. 5540,
    5544,           5548 .. 5561,   5570 .. 5577,   5601 .. 5602,
    5605,           5610 .. 5620,   5626 .. 5640,   5650 .. 5659,
    5670 .. 5671,   5675,           5680 .. 5687,   5690 .. 5693,
    5695,   5698,   5701,           5710 .. 5714,   5716 .. 5723,
    5730,           5740 .. 5741,   5750 .. 5756,   5760 .. 5762,
    5770 .. 5776,   5801,           5808 .. 5826,   5828 .. 5844,
    5846,   5850,   5852 .. 5856,   5859 .. 5876,   5878,   5880,
    5884 .. 5893,   5898 .. 5899,   5940 .. 5943,   5950 .. 5964,
    5969 .. 5978,

    6101,           6111 .. 6125,   6129 .. 6150,   6155,
    6160 .. 6163,   6165 .. 6166,   6169 .. 6171,   6175,
    6180 .. 6190,   6195 .. 6197,   6201,           6210 .. 6215,
    6225,           6230 .. 6231,   6235,           6238 .. 6240,
    6243,           6245 .. 6246,   6250 .. 6252,   6255,   6301,
    6310 .. 6315,   6340,   6350,   6360,   6370,   6380,
    6401 .. 6402,   6406,           6408 .. 6423,   6430 .. 6443,
    6445 .. 6455,   6460 .. 6488,   6490 .. 6497,   6499,
    6550 .. 6553,   6555,           6557 .. 6560,   6562,
    6570 .. 6572,   6579 .. 6583,   6585 .. 6587,   6590,   6601,
    6610 .. 6623,   6630 .. 6638,   6645 .. 6651,   6660 .. 6661,
    6663,           6665 .. 6666,   6669 .. 6678,   6680 .. 6693,
    6695,   6701,   6711 .. 6726,   6730 .. 6745,   6750 .. 6765,
    6770 .. 6786,   6790 .. 6796,   6815,           6830 .. 6842,
    6850 .. 6852,   6858,           6868 .. 6871,   6880,   6901,
    6905 .. 6906,   6910 .. 6919,   6921 .. 6923,   6925 .. 6926,
    6930 .. 6931,   6933 .. 6934,   6939 .. 6948,   6950 .. 6951,
    6955 .. 6956,   6960 .. 6962,   6969 .. 6982,   6985 .. 6992,
    6995 .. 6999,

    7201 .. 7202,   7209 .. 7264,   7268 .. 7270,   7274,
    7302 .. 7364,   7370 .. 7384,   7390 .. 7392,   7395 .. 7397,
    7409 .. 7412,   7415 .. 7418,   7420 .. 7421,   7423 .. 7425,
    7430 .. 7433,   7435,           7440 .. 7458,   7460 .. 7465,
    7470 .. 7471,   7473,   7475,   7480 .. 7482,   7501 .. 7502,
    7505 .. 7508,   7511 .. 7526,   7531 .. 7547,   7553 .. 7572,
    7590 .. 7599,   7601,   7610,   7612 .. 7613,   7615,
    7618 .. 7627,   7633 .. 7636,   7639 .. 7641,   7649 .. 7653,
    7660 .. 7664,   7670,   7673,   7680 .. 7681,   7701,   7703,
    7710 .. 7716,   7720 .. 7724,   7726 .. 7727,   7730 .. 7735,
    7737 .. 7741,   7750,           7758 .. 7774,   7777 .. 7795,

    8001 .. 8002,   8005 .. 8099,   8110 .. 8112,   8115 .. 8121,
    8123 .. 8135,   8137 .. 8142,   8145 .. 8147,   8149 .. 8154,
    8156 .. 8160,   8165 .. 8167,   8179 .. 8191,   8201,   8205,
    8209 .. 8255,   8258 .. 8274,   8277 .. 8295,   8301 .. 8303,
    8306,           8308 .. 8345,   8350 .. 8376,   8378 .. 8381,
    8383 .. 8388,   8390 .. 8396,   8398 .. 8399,   8401,
    8410 .. 8415,   8420 .. 8424,   8435 .. 8438,   8440 .. 8445,
    8447 .. 8453,   8460 .. 8480,   8501 .. 8502,   8506 .. 8511,
    8521 .. 8523,   8525 .. 8531,   8533,           8537 .. 8546,
    8550 .. 8552,   8557 .. 8558,   8560 .. 8562,   8606,
    8609 .. 8615,   8620,   8701,   8705 .. 8708,   8710 .. 8711,
    8715,   8720,   8801 .. 8802,   8805 .. 8806,   8808 .. 8809,
    8811 .. 8814,   8816 .. 8826,   8831 .. 8835,   8838,

    9001 .. 9004,   9006,           9010 .. 9033,   9040 .. 9048,
    9050 .. 9056,   9060 .. 9072,   9080 .. 9094,   9098 .. 9099,
    9115 .. 9137,   9140,   9142,   9144 .. 9147,   9150 .. 9151,
    9153 .. 9158,   9160 .. 9161,   9163 .. 9173,   9175 .. 9177,
    9179 .. 9184,   9186,           9188 .. 9191,   9201 .. 9218,
    9220 .. 9221,   9224 .. 9245,   9249 .. 9268,   9273,
    9275 .. 9294,   9330,   9340,   9350 .. 9357,   9359 .. 9361,
    9364 .. 9366,   9368 .. 9373,   9375 .. 9378,   9380 .. 9382,
    9390 .. 9392,   9395,   9401,   9405 .. 9412,   9414 .. 9426,
    9440,           9451 .. 9459,   9461 .. 9466,   9501 .. 9502,
    9506,           9510 .. 9523,   9530 .. 9545,   9550 .. 9560,
    9570 .. 9579,   9631 .. 9633,   9635 .. 9641,   9643 .. 9645,
    9647 .. 9648,   9650 .. 9651,   9653 .. 9657,   9659 .. 9660,
    9662 .. 9663,   9665 .. 9666,   9668 .. 9674,   9676,   9678,
    9681 .. 9682,   9684,   9687,   9689 .. 9690,   9696,   9701,
    9706 .. 9715,   9737 .. 9738,   9740 .. 9749,   9751 .. 9776,
    9779 .. 9780,   9801,           9805 .. 9809,   9830 .. 9831,
    9833 .. 9841,   9901 .. 9903,   9905 .. 9913,   9940,
    9942 .. 9944,   9946,   9948,   9950,   9952,   9954,   9956,
    9960,   9962,   9964,   9966,   9968,   9970,   9972,   9974,
    9976,   9980,   9982,           9990 .. 9993,   9999,


}


__END__
