package Task::CPANAuthors::Regional;
$Task::CPANAuthors::Regional::VERSION = '1.001';
use strict;
use warnings;

'BOOK';



=pod

=head1 NAME

Task::CPANAuthors::Regional

=head1 VERSION

version 1.001

=head1 SYNOPSIS

    cpan Task::CPANAuthors::Regional

    cpanp -i Task::CPANAuthors::Regional

    cpanm Task::CPANAuthors::Regional

=head1 DESCRIPTION

This tasks installs all L<Acme::CPANAuthors> modules that list CPAN authors
by nationality, language, country or region.

=encoding utf8

=head1 NAME

Task::CPANAuthors::Regional - All regional Acme::CPANAuthors modules at once

=head1 CONTENT

L<Acme::CPANAuthors> - We are CPAN authors

L<Acme::CPANAuthors::Australian> - We are Australian CPAN authors

L<Acme::CPANAuthors::Austrian> - We are Austrian CPAN authors

L<Acme::CPANAuthors::Belarusian> - We are Belarusian CPAN authors

L<Acme::CPANAuthors::Brazilian> - Nós somos autores brasileiros no CPAN

L<Acme::CPANAuthors::British> - We are British CPAN authors

L<Acme::CPANAuthors::Canadian> - We are Canadian CPAN authors

L<Acme::CPANAuthors::Catalonian> - We are the Catalonian CPAN Authors

L<Acme::CPANAuthors::Chinese> - We are chinese CPAN authors

L<Acme::CPANAuthors::Czech> - We are Czech CPAN authors

L<Acme::CPANAuthors::Danish> - We are Danish CPAN authors

L<Acme::CPANAuthors::Dutch> - Cheese heads and pot smokers

L<Acme::CPANAuthors::EU> - EU CPAN authors

L<Acme::CPANAuthors::European> - European CPAN authors

L<Acme::CPANAuthors::French> - Nous sommes des auteurs CPAN francophones

L<Acme::CPANAuthors::German> - We are German CPAN authors

L<Acme::CPANAuthors::Icelandic> - We are Icelandic CPAN authors

L<Acme::CPANAuthors::India> - We are the Indian CPAN Authors. Coming from that big peninsula in the center of Asia, the original Indians. The ones columbus was looking for. :)

L<Acme::CPANAuthors::Indonesian> - We are Indonesian CPAN authors (Kami para penulis CPAN Indonesia)

L<Acme::CPANAuthors::Israeli> - We are Israeli CPAN Authors

L<Acme::CPANAuthors::Japanese> - We are Japanese CPAN authors

L<Acme::CPANAuthors::Korean> - We are Korean CPAN Authors! (우리는 CPAN Author 다!)

L<Acme::CPANAuthors::Norwegian> - We are Norwegian CPAN authors

L<Acme::CPANAuthors::Polish> - Jesteśmy autorami-Polakami modułów na CPAN

L<Acme::CPANAuthors::Portuguese> - We are the Portuguese CPAN Authors

L<Acme::CPANAuthors::Russian> - We are Russian CPAN authors

L<Acme::CPANAuthors::Spanish> - We are the Spanish CPAN Authors

L<Acme::CPANAuthors::Swedish> - Vi är svenska kontribuerare till CPAN

L<Acme::CPANAuthors::Taiwanese>

L<Acme::CPANAuthors::Turkish> - Türk CPAN Yazarları

L<Acme::CPANAuthors::Ukrainian> - We are Ukrainian CPAN authors

=head1 OTHER CPANAUTHORS MODULES

There are several other modules that are not part of this L<Task>,
but that also make use L<Acme::CPANAuthors>. More tasks are in the works.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website
L<http://rt.cpan.org/NoAuth/Bugs.html?Dist=Task-CPANAuthors-Regional>
or by email to C<bug-task-cpanauthors-regional@rt.cpan.org>.

When submitting a bug or request, please include a test-file or a patch
to an existing test-file that illustrates the bug or desired feature.

=head1 AUTHOR

Philippe Bruhat (BooK) <book@cpan.org>

=head1 COPYRIGHT

Copyright 2014 Philippe Bruhat (BooK), All Rights Reserved.

=head1 LICENSE

This program is free software; you can redistribute it and/or modify it
under the same terms as Perl itself.

=head1 AUTHOR

Philippe Bruhat (BooK) <book@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2014 by Philippe Bruhat (BooK).

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut


__END__

