use strict;
use warnings;
use Test::More;
use lib qw(./lib ./blib/lib);
require './t/600-lhost-code';

my $enginename = 'EZweb';
my $samplepath = sprintf("./set-of-emails/private/lhost-%s", lc $enginename);
my $enginetest = Sisimai::Lhost::Code->makeinquiry;
my $isexpected = {
    # INDEX => [['D.S.N.', 'replycode', 'REASON', 'hardbounce'], [...]]
    '01001' => [['5.1.1',   '550', 'userunknown',     1]],
    '01002' => [['5.0.910', '',    'filtered',        0]],
    '01003' => [['5.0.911', '550', 'userunknown',     1]],
    '01004' => [['5.0.911', '',    'userunknown',     1]],
    '01005' => [['5.0.921', '',    'suspend',         0]],
    '01006' => [['5.0.910', '',    'filtered',        0]],
    '01007' => [['5.0.921', '',    'suspend',         0]],
    '01008' => [['5.0.910', '',    'filtered',        0]],
    '01009' => [['5.0.910', '',    'filtered',        0]],
    '01010' => [['5.0.910', '',    'filtered',        0]],
    '01011' => [['5.0.910', '',    'filtered',        0]],
    '01012' => [['5.0.910', '',    'filtered',        0]],
    '01013' => [['5.0.947', '',    'expired',         0]],
    '01014' => [['5.0.910', '',    'filtered',        0]],
    '01015' => [['5.0.921', '',    'suspend',         0]],
    '01016' => [['5.0.910', '',    'filtered',        0]],
    '01017' => [['5.0.910', '',    'filtered',        0]],
    '01018' => [['5.0.910', '',    'filtered',        0]],
    '01019' => [['5.0.0',   '',    'suspend',         0]],
    '01020' => [['5.0.910', '',    'filtered',        0]],
    '01021' => [['5.0.910', '',    'filtered',        0]],
    '01022' => [['5.0.910', '',    'filtered',        0]],
    '01023' => [['5.0.921', '',    'suspend',         0]],
    '01024' => [['5.0.910', '',    'filtered',        0]],
    '01025' => [['5.0.910', '',    'filtered',        0]],
    '01026' => [['5.0.910', '',    'filtered',        0]],
    '01027' => [['5.0.910', '',    'filtered',        0]],
    '01028' => [['5.0.910', '',    'filtered',        0]],
    '01029' => [['5.0.0',   '',    'suspend',         0]],
    '01030' => [['5.0.910', '',    'filtered',        0]],
    '01031' => [['5.0.921', '',    'suspend',         0]],
    '01032' => [['5.0.910', '',    'filtered',        0]],
    '01033' => [['4.0.922', '',    'mailboxfull',     0]],
    '01034' => [['5.0.910', '',    'filtered',        0]],
    '01035' => [['5.0.921', '',    'suspend',         0]],
    '01036' => [['4.0.922', '',    'mailboxfull',     0]],
    '01037' => [['5.0.911', '550', 'userunknown',     1]],
    '01038' => [['5.0.921', '',    'suspend',         0]],
    '01039' => [['5.0.921', '',    'suspend',         0]],
    '01040' => [['5.0.921', '',    'suspend',         0]],
    '01041' => [['5.0.0',   '',    'suspend',         0]],
    '01042' => [['5.0.921', '',    'suspend',         0]],
    '01043' => [['5.0.921', '',    'suspend',         0]],
    '01044' => [['5.0.911', '',    'userunknown',     1]],
    '01045' => [['5.0.910', '',    'filtered',        0]],
    '01046' => [['5.0.910', '',    'filtered',        0]],
    '01047' => [['5.0.910', '',    'filtered',        0]],
    '01048' => [['5.0.921', '',    'suspend',         0]],
    '01049' => [['5.0.910', '',    'filtered',        0]],
    '01050' => [['5.0.921', '',    'suspend',         0]],
    '01051' => [['5.0.910', '',    'filtered',        0]],
    '01052' => [['5.0.0',   '',    'suspend',         0]],
    '01053' => [['5.0.910', '',    'filtered',        0]],
    '01054' => [['5.0.921', '',    'suspend',         0]],
    '01055' => [['5.0.910', '',    'filtered',        0]],
    '01056' => [['5.0.911', '',    'userunknown',     1]],
    '01057' => [['5.0.910', '',    'filtered',        0]],
    '01058' => [['5.0.0',   '',    'suspend',         0]],
    '01059' => [['5.0.921', '',    'suspend',         0]],
    '01060' => [['5.0.910', '',    'filtered',        0]],
    '01061' => [['5.0.921', '',    'suspend',         0]],
    '01062' => [['5.0.910', '',    'filtered',        0]],
    '01063' => [['5.0.911', '550', 'userunknown',     1]],
    '01064' => [['5.0.910', '',    'filtered',        0]],
    '01065' => [['5.0.921', '',    'suspend',         0]],
    '01066' => [['5.0.910', '',    'filtered',        0]],
    '01067' => [['5.0.910', '',    'filtered',        0]],
    '01068' => [['5.0.0',   '',    'suspend',         0]],
    '01069' => [['5.0.921', '',    'suspend',         0]],
    '01070' => [['5.0.921', '',    'suspend',         0]],
    '01071' => [['5.0.910', '',    'filtered',        0]],
    '01072' => [['5.0.921', '',    'suspend',         0]],
    '01073' => [['5.0.910', '',    'filtered',        0]],
    '01074' => [['5.0.910', '',    'filtered',        0]],
    '01075' => [['5.0.921', '',    'suspend',         0]],
    '01076' => [['5.0.910', '',    'filtered',        0]],
    '01077' => [['5.0.947', '',    'expired',         0]],
    '01078' => [['5.0.910', '',    'filtered',        0]],
    '01079' => [['5.0.910', '',    'filtered',        0]],
    '01080' => [['5.0.910', '',    'filtered',        0]],
    '01081' => [['5.0.910', '',    'filtered',        0]],
    '01082' => [['5.0.910', '',    'filtered',        0]],
    '01083' => [['5.0.910', '',    'filtered',        0]],
    '01084' => [['5.0.910', '',    'filtered',        0]],
    '01085' => [['5.0.947', '',    'expired',         0]],
    '01086' => [['5.0.910', '',    'filtered',        0]],
    '01087' => [['5.0.910', '',    'filtered',        0]],
    '01089' => [['5.0.910', '',    'filtered',        0]],
    '01090' => [['5.0.0',   '',    'suspend',         0]],
    '01091' => [['5.0.910', '',    'filtered',        0]],
    '01092' => [['5.0.910', '',    'filtered',        0]],
    '01093' => [['5.0.921', '',    'suspend',         0]],
    '01094' => [['5.0.911', '',    'userunknown',     1]],
    '01095' => [['5.0.910', '',    'filtered',        0]],
    '01096' => [['5.0.910', '',    'filtered',        0]],
    '01097' => [['5.0.910', '',    'filtered',        0]],
    '01098' => [['5.0.0',   '',    'suspend',         0]],
    '01099' => [['5.0.910', '',    'filtered',        0]],
    '01100' => [['5.0.910', '',    'filtered',        0]],
    '01101' => [['5.0.910', '',    'filtered',        0]],
    '01102' => [['5.0.0',   '',    'suspend',         0]],
    '01103' => [['5.0.911', '550', 'userunknown',     1]],
    '01104' => [['5.0.910', '',    'filtered',        0]],
    '01105' => [['5.0.910', '',    'filtered',        0]],
    '01106' => [['5.0.911', '550', 'userunknown',     1]],
    '01107' => [['5.0.910', '',    'filtered',        0]],
    '01108' => [['5.7.1',   '553', 'norelaying',      0]],
    '01109' => [['5.7.1',   '553', 'userunknown',     1]],
    '01110' => [['5.0.910', '',    'filtered',        0]],
    '01111' => [['5.0.0',   '',    'suspend',         0]],
    '01112' => [['5.0.921', '',    'suspend',         0]],
    '01113' => [['5.0.921', '',    'suspend',         0]],
    '01114' => [['5.0.910', '',    'filtered',        0]],
    '01115' => [['5.0.0',   '',    'suspend',         0]],
    '01116' => [['5.0.910', '',    'filtered',        0]],
    '01118' => [['5.0.921', '',    'suspend',         0]],
    '01119' => [['5.0.910', '',    'filtered',        0]],
    '01120' => [['5.0.911', '550', 'userunknown',     1]],
    '01121' => [['5.0.971', '550', 'blocked',         0]],
};

plan 'skip_all', sprintf("%s not found", $samplepath) unless -d $samplepath;
$enginetest->($enginename, $isexpected, 1, 0);
done_testing;

