# Generated by default/object.tt
package Paws::IoTEvents::DynamoDBAction;
  use Moose;
  has HashKeyField => (is => 'ro', isa => 'Str', request_name => 'hashKeyField', traits => ['NameInRequest'], required => 1);
  has HashKeyType => (is => 'ro', isa => 'Str', request_name => 'hashKeyType', traits => ['NameInRequest']);
  has HashKeyValue => (is => 'ro', isa => 'Str', request_name => 'hashKeyValue', traits => ['NameInRequest'], required => 1);
  has Operation => (is => 'ro', isa => 'Str', request_name => 'operation', traits => ['NameInRequest']);
  has Payload => (is => 'ro', isa => 'Paws::IoTEvents::Payload', request_name => 'payload', traits => ['NameInRequest']);
  has PayloadField => (is => 'ro', isa => 'Str', request_name => 'payloadField', traits => ['NameInRequest']);
  has RangeKeyField => (is => 'ro', isa => 'Str', request_name => 'rangeKeyField', traits => ['NameInRequest']);
  has RangeKeyType => (is => 'ro', isa => 'Str', request_name => 'rangeKeyType', traits => ['NameInRequest']);
  has RangeKeyValue => (is => 'ro', isa => 'Str', request_name => 'rangeKeyValue', traits => ['NameInRequest']);
  has TableName => (is => 'ro', isa => 'Str', request_name => 'tableName', traits => ['NameInRequest'], required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::IoTEvents::DynamoDBAction

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::IoTEvents::DynamoDBAction object:

  $service_obj->Method(Att1 => { HashKeyField => $value, ..., TableName => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::IoTEvents::DynamoDBAction object:

  $result = $service_obj->Method(...);
  $result->Att1->HashKeyField

=head1 DESCRIPTION

Defines an action to write to the Amazon DynamoDB table that you
created. The standard action payload contains all the information about
the detector model instance and the event that triggered the action.
You can customize the payload
(https://docs.aws.amazon.com/iotevents/latest/apireference/API_Payload.html).
One column of the DynamoDB table receives all attribute-value pairs in
the payload that you specify.

You must use expressions for all parameters in C<DynamoDBAction>. The
expressions accept literals, operators, functions, references, and
substitution templates.

B<Examples>

=over

=item *

For literal values, the expressions must contain single quotes. For
example, the value for the C<hashKeyType> parameter can be C<'STRING'>.

=item *

For references, you must specify either variables or input values. For
example, the value for the C<hashKeyField> parameter can be
C<$input.GreenhouseInput.name>.

=item *

For a substitution template, you must use C<${}>, and the template must
be in single quotes. A substitution template can also contain a
combination of literals, operators, functions, references, and
substitution templates.

In the following example, the value for the C<hashKeyValue> parameter
uses a substitution template.

C<'${$input.GreenhouseInput.temperature * 6 / 5 + 32} in Fahrenheit'>

=item *

For a string concatenation, you must use C<+>. A string concatenation
can also contain a combination of literals, operators, functions,
references, and substitution templates.

In the following example, the value for the C<tableName> parameter uses
a string concatenation.

C<'GreenhouseTemperatureTable ' + $input.GreenhouseInput.date>

=back

For more information, see Expressions
(https://docs.aws.amazon.com/iotevents/latest/developerguide/iotevents-expressions.html)
in the I<AWS IoT Events Developer Guide>.

If the defined payload type is a string, C<DynamoDBAction> writes
non-JSON data to the DynamoDB table as binary data. The DynamoDB
console displays the data as Base64-encoded text. The value for the
C<payloadField> parameter is C<E<lt>payload-fieldE<gt>_raw>.

=head1 ATTRIBUTES


=head2 B<REQUIRED> HashKeyField => Str

The name of the hash key (also called the partition key). The
C<hashKeyField> value must match the partition key of the target
DynamoDB table.


=head2 HashKeyType => Str

The data type for the hash key (also called the partition key). You can
specify the following values:

=over

=item *

C<'STRING'> - The hash key is a string.

=item *

C<'NUMBER'> - The hash key is a number.

=back

If you don't specify C<hashKeyType>, the default value is C<'STRING'>.


=head2 B<REQUIRED> HashKeyValue => Str

The value of the hash key (also called the partition key).


=head2 Operation => Str

The type of operation to perform. You can specify the following values:

=over

=item *

C<'INSERT'> - Insert data as a new item into the DynamoDB table. This
item uses the specified hash key as a partition key. If you specified a
range key, the item uses the range key as a sort key.

=item *

C<'UPDATE'> - Update an existing item of the DynamoDB table with new
data. This item's partition key must match the specified hash key. If
you specified a range key, the range key must match the item's sort
key.

=item *

C<'DELETE'> - Delete an existing item of the DynamoDB table. This
item's partition key must match the specified hash key. If you
specified a range key, the range key must match the item's sort key.

=back

If you don't specify this parameter, AWS IoT Events triggers the
C<'INSERT'> operation.


=head2 Payload => L<Paws::IoTEvents::Payload>




=head2 PayloadField => Str

The name of the DynamoDB column that receives the action payload.

If you don't specify this parameter, the name of the DynamoDB column is
C<payload>.


=head2 RangeKeyField => Str

The name of the range key (also called the sort key). The
C<rangeKeyField> value must match the sort key of the target DynamoDB
table.


=head2 RangeKeyType => Str

The data type for the range key (also called the sort key), You can
specify the following values:

=over

=item *

C<'STRING'> - The range key is a string.

=item *

C<'NUMBER'> - The range key is number.

=back

If you don't specify C<rangeKeyField>, the default value is
C<'STRING'>.


=head2 RangeKeyValue => Str

The value of the range key (also called the sort key).


=head2 B<REQUIRED> TableName => Str

The name of the DynamoDB table. The C<tableName> value must match the
table name of the target DynamoDB table.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::IoTEvents>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

