# Generated by default/object.tt
package Paws::Synthetics::CanaryRunStatus;
  use Moose;
  has State => (is => 'ro', isa => 'Str');
  has StateReason => (is => 'ro', isa => 'Str');
  has StateReasonCode => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::Synthetics::CanaryRunStatus

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Synthetics::CanaryRunStatus object:

  $service_obj->Method(Att1 => { State => $value, ..., StateReasonCode => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Synthetics::CanaryRunStatus object:

  $result = $service_obj->Method(...);
  $result->Att1->State

=head1 DESCRIPTION

This structure contains the status information about a canary run.

=head1 ATTRIBUTES


=head2 State => Str

The current state of the run.


=head2 StateReason => Str

If run of the canary failed, this field contains the reason for the
error.


=head2 StateReasonCode => Str

If this value is C<CANARY_FAILURE>, an exception occurred in the canary
code. If this value is C<EXECUTION_FAILURE>, an exception occurred in
CloudWatch Synthetics.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Synthetics>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

