# Generated by default/object.tt
package Paws::GreengrassV2::DeploymentComponentUpdatePolicy;
  use Moose;
  has Action => (is => 'ro', isa => 'Str', request_name => 'action', traits => ['NameInRequest']);
  has TimeoutInSeconds => (is => 'ro', isa => 'Int', request_name => 'timeoutInSeconds', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::GreengrassV2::DeploymentComponentUpdatePolicy

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::GreengrassV2::DeploymentComponentUpdatePolicy object:

  $service_obj->Method(Att1 => { Action => $value, ..., TimeoutInSeconds => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::GreengrassV2::DeploymentComponentUpdatePolicy object:

  $result = $service_obj->Method(...);
  $result->Att1->Action

=head1 DESCRIPTION

Contains information about a deployment's policy that defines when
components are safe to update.

Each component on a device can report whether or not it's ready to
update. After a component and its dependencies are ready, they can
apply the update in the deployment. You can configure whether or not
the deployment notifies components of an update and waits for a
response. You specify the amount of time each component has to respond
to the update notification.

=head1 ATTRIBUTES


=head2 Action => Str

Whether or not to notify components and wait for components to become
safe to update. Choose from the following options:

=over

=item *

C<NOTIFY_COMPONENTS> E<ndash> The deployment notifies each component
before it stops and updates that component. Components can use the
SubscribeToComponentUpdates
(https://docs.aws.amazon.com/greengrass/v2/developerguide/interprocess-communication.html#ipc-operation-subscribetocomponentupdates)
IPC operation to receive these notifications. Then, components can
respond with the DeferComponentUpdate
(https://docs.aws.amazon.com/greengrass/v2/developerguide/interprocess-communication.html#ipc-operation-defercomponentupdate)
IPC operation. For more information, see Create deployments
(https://docs.aws.amazon.com/greengrass/v2/developerguide/create-deployments.html)
in the I<AWS IoT Greengrass V2 Developer Guide>.

=item *

C<SKIP_NOTIFY_COMPONENTS> E<ndash> The deployment doesn't notify
components or wait for them to be safe to update.

=back

Default: C<NOTIFY_COMPONENTS>


=head2 TimeoutInSeconds => Int

The amount of time in seconds that each component on a device has to
report that it's safe to update. If the component waits for longer than
this timeout, then the deployment proceeds on the device.

Default: C<60>



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::GreengrassV2>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

