# Generated by default/object.tt
package Paws::AmplifyBackend::GetBackendRespObj;
  use Moose;
  has AmplifyMetaConfig => (is => 'ro', isa => 'Str', request_name => 'amplifyMetaConfig', traits => ['NameInRequest']);
  has AppId => (is => 'ro', isa => 'Str', request_name => 'appId', traits => ['NameInRequest'], required => 1);
  has AppName => (is => 'ro', isa => 'Str', request_name => 'appName', traits => ['NameInRequest']);
  has BackendEnvironmentList => (is => 'ro', isa => 'ArrayRef[Str|Undef]', request_name => 'backendEnvironmentList', traits => ['NameInRequest']);
  has BackendEnvironmentName => (is => 'ro', isa => 'Str', request_name => 'backendEnvironmentName', traits => ['NameInRequest']);
  has Error => (is => 'ro', isa => 'Str', request_name => 'error', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::AmplifyBackend::GetBackendRespObj

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::AmplifyBackend::GetBackendRespObj object:

  $service_obj->Method(Att1 => { AmplifyMetaConfig => $value, ..., Error => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::AmplifyBackend::GetBackendRespObj object:

  $result = $service_obj->Method(...);
  $result->Att1->AmplifyMetaConfig

=head1 DESCRIPTION

The response object for this operation.

=head1 ATTRIBUTES


=head2 AmplifyMetaConfig => Str

A stringified version of the current configs for your Amplify project.


=head2 B<REQUIRED> AppId => Str

The app ID.


=head2 AppName => Str

The name of the app.


=head2 BackendEnvironmentList => ArrayRef[Str|Undef]

A list of backend environments in an array.


=head2 BackendEnvironmentName => Str

The name of the backend environment.


=head2 Error => Str

If the request failed, this is the returned error.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::AmplifyBackend>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

