# Before `make install' is performed this script should be runnable with
# `make test'. After `make install' it should work as `perl 1.t'

#########################

# change 'tests => 1' to 'tests => last_test_to_print';

use Test::More tests => 87;
BEGIN { use_ok('Lingua::PT::Words2Nums') };

#########################

# Insert your test code below, the Test::More module is use()ed here so read
# its man page ( perldoc Test::More ) for help writing this test script.

is(word2num('um milho'),1000000);
is(word2num('um milho e um'),1000001);
is(word2num('um milho e mil'),1001000);
is(word2num('um milho mil e um'),1001001);
is(word2num('dois milhes vinte mil duzentos e dois'),2020202);
is(word2num('trs milhes trezentos mil trezentos e trinta'),3300330);
is(word2num('quatro milhes quatro mil e quatro'),4004004);
is(word2num('cinco milhes cinquenta mil e cinquenta e cinco'),5050055);
is(word2num('seis milhes seiscentos e sessenta mil'),6660000);
is(word2num('sete milhes setecentos mil setecentos e setenta e sete'),7700777);
is(word2num('oito milhes oitocentos e oitenta e oito mil oitocentos e oitenta e oito'),8888888);
is(word2num('nove milhes novecentos e noventa e nove mil e novecentos'),9999900);

is(word2num('dez milhes'),10000000);
is(word2num('vinte milhes duzentos e dois mil e vinte'),20202020);
is(word2num('trinta e trs milhes trs mil e trezentos'),33003300);
is(word2num('quarenta milhes quarenta e quatro mil e quatro'),40044004);
is(word2num('cinquenta e cinco milhes quinhentos mil e cinquenta e cinco'),55500055);
is(word2num('sessenta e seis milhes'),66000000);
is(word2num('setenta milhes e sete'),70000007);
is(word2num('oitenta e oito milhes oitenta mil oitocentos e oito'),88080808);
is(word2num('noventa e oito milhes novecentos e oitenta e nove mil oitocentos e noventa e oito'),98989898);
is(word2num('noventa e nove milhes novecentos e noventa e nove mil novecentos e noventa e nove'),99999999);

is(word2num('cem milhes'),100000000);
is(word2num('duzentos e dois milhes vinte mil e duzentos'),202020200);
is(word2num('trezentos e trs milhes trezentos e trs mil trezentos e trs'),303303303);
is(word2num('quatrocentos e quarenta e quatro milhes quatrocentos e quarenta e quatro mil quatrocentos e quarenta e quatro'),444444444);
is(word2num('quinhentos e cinquenta milhes e cinquenta e cinco mil'),550055000);
is(word2num('seiscentos e sessenta e seis milhes e seiscentos mil'),666600000);
is(word2num('setecentos milhes e sete'),700000007);
is(word2num('oitocentos e oitenta e um milhes duzentos e trinta e quatro mil quinhentos e noventa e nove'),881234599);
is(word2num('novecentos e noventa e nove milhes novecentos e noventa e nove mil novecentos e noventa e nove'),999999999);

is(word2num('mil milhes'),1000000000);
is(word2num('dois mil e vinte milhes duzentos e dois mil e vinte'),2020202020);
is(word2num('trs mil e trinta e trs milhes trinta e trs mil e trinta'),3033033030);
is(word2num('quatro mil quatrocentos e quarenta e quatro milhes quatrocentos e quarenta e quatro mil quatrocentos e quarenta e quatro'),4444444444);
is(word2num('cinco mil e quinhentos milhes quinhentos e cinquenta mil'),5500550000);
is(word2num('seis mil seiscentos e sessenta e seis milhes e seiscentos mil'),6666600000);
is(word2num('sete mil milhes e sete'),7000000007);
is(word2num('oito mil oitocentos e doze milhes trezentos e quarenta e cinco mil novecentos e noventa e nove'),8812345999);
is(word2num('nove mil novecentos e noventa e nove milhes novecentos e noventa e nove mil novecentos e noventa e nove'),9999999999);

is(word2num('dez mil milhes'),10000000000);
is(word2num('vinte mil duzentos e dois milhes vinte mil e duzentos'),20202020200);
is(word2num('trinta mil trezentos e trinta milhes trezentos e trinta mil e trezentos'),30330330300);
is(word2num('quarenta e quatro mil quatrocentos e quarenta e quatro milhes quatrocentos e quarenta e quatro mil quatrocentos e quarenta e quatro'),44444444444);
is(word2num('cinquenta e cinco mil e cinco milhes e quinhentos mil'),55005500000);
is(word2num('sessenta e seis mil seiscentos e sessenta e seis milhes'),66666000000);
is(word2num('setenta mil milhes e sete'),70000000007);
is(word2num('oitenta e oito mil cento e vinte e trs milhes quatrocentos e cinquenta e nove mil novecentos e noventa e nove'),88123459999);
is(word2num('noventa e nove mil novecentos e noventa e nove milhes novecentos e noventa e nove mil novecentos e noventa e nove'),99999999999);

is(word2num('cem mil milhes'),100000000000);
is(word2num('duzentos e dois mil e vinte milhes duzentos e dois mil e vinte'),202020202020);
is(word2num('trezentos e trs mil trezentos e trs milhes trezentos e trs mil trezentos e trs'),303303303303);
is(word2num('quatrocentos e quarenta e quatro mil quatrocentos e quarenta e quatro milhes quatrocentos e quarenta e quatro mil quatrocentos e quarenta e quatro'),444444444444);
is(word2num('quinhentos e cinquenta mil e cinquenta e cinco milhes cinco mil e quinhentos'),550055005500);
is(word2num('seiscentos e sessenta e seis mil seiscentos e sessenta e seis milhes'),666666000000);
is(word2num('setecentos mil milhes e sete'),700000000007);
is(word2num('oitocentos e oitenta e um mil duzentos e trinta e quatro milhes quinhentos e noventa e nove mil novecentos e noventa e nove'),881234599999);
is(word2num('novecentos e noventa e nove mil novecentos e noventa e nove milhes novecentos e noventa e nove mil novecentos e noventa e nove'),999999999999);

is(word2num('um bilio'),1000000000000);
is(word2num('dois bilies vinte mil duzentos e dois milhes vinte mil e duzentos'),2020202020200);
is(word2num('trs bilies trinta e trs mil e trinta e trs milhes trinta e trs mil e trinta'),3033033033030);
is(word2num('quatro bilies quatrocentos e quarenta e quatro mil quatrocentos e quarenta e quatro milhes quatrocentos e quarenta e quatro mil quatrocentos e quarenta e quatro'),4444444444444);
is(word2num('cinco bilies quinhentos mil quinhentos e cinquenta milhes e cinquenta e cinco mil'),5500550055000);
is(word2num('seis bilies seiscentos e sessenta e seis mil seiscentos e sessenta milhes'),6666660000000);
is(word2num('sete bilies e sete'),7000000000007);
is(word2num('oito bilies oitocentos e doze mil trezentos e quarenta e cinco milhes novecentos e noventa e nove mil novecentos e noventa e nove'),8812345999999);
is(word2num('nove bilies novecentos e noventa e nove mil novecentos e noventa e nove milhes novecentos e noventa e nove mil novecentos e noventa e nove'),9999999999999);

is(word2num('dez bilies'),10000000000000);
is(word2num('vinte bilies duzentos e dois mil e vinte milhes duzentos e dois mil e vinte'),20202020202020);
is(word2num('trinta bilies trezentos e trinta mil trezentos e trinta milhes trezentos e trinta mil e trezentos'),30330330330300);
is(word2num('quarenta e quatro bilies quatrocentos e quarenta e quatro mil quatrocentos e quarenta e quatro milhes quatrocentos e quarenta e quatro mil quatrocentos e quarenta e quatro'),44444444444444);
is(word2num('cinquenta e cinco bilies cinco mil e quinhentos milhes quinhentos e cinquenta mil'),55005500550000);
is(word2num('sessenta e seis bilies seiscentos e sessenta e seis mil seiscentos e sessenta milhes'),66666660000000);
is(word2num('setenta bilies e sete'),70000000000007);
is(word2num('oitenta e oito bilies cento e vinte e trs mil quatrocentos e cinquenta e nove milhes novecentos e noventa e nove mil novecentos e noventa e nove'),88123459999999);
is(word2num('noventa e nove bilies novecentos e noventa e nove mil novecentos e noventa e nove milhes novecentos e noventa e nove mil novecentos e noventa e nove'),99999999999999);

is(word2num('cem bilies'),100000000000000);
is(word2num('duzentos e dois bilies vinte mil duzentos e dois milhes vinte mil e duzentos'),202020202020200);
is(word2num('trezentos e trs bilies trezentos e trs mil trezentos e trs milhes trezentos e trs mil trezentos e trs'),303303303303303);
is(word2num('quatrocentos e quarenta e quatro bilies quatrocentos e quarenta e quatro mil quatrocentos e quarenta e quatro milhes quatrocentos e quarenta e quatro mil quatrocentos e quarenta e quatro'),444444444444444);
is(word2num('quinhentos e cinquenta bilies cinquenta e cinco mil e cinco milhes e quinhentos mil'),550055005500000);
is(word2num('seiscentos e sessenta e seis bilies seiscentos e sessenta e seis mil e seiscentos milhes'),666666600000000);
is(word2num('setecentos bilies e sete'),700000000000007);
is(word2num('oitocentos e oitenta e um bilies duzentos e trinta e quatro mil quinhentos e noventa e nove milhes novecentos e noventa e nove mil novecentos e noventa e nove'),881234599999999);
is(word2num('novecentos e noventa e nove bilies novecentos e noventa e nove mil novecentos e noventa e nove milhes novecentos e noventa e nove mil novecentos e noventa e nove'),999999999999999);
is(word2num('novecentos e noventa e nove mil novecentos e noventa e nove bilies novecentos e noventa e nove mil novecentos e noventa e nove milhes novecentos e noventa e nove mil novecentos e noventa e nove'),999999999999999999);

TODO: {

  local $TODO = 'up, up... and away!!!';

}
