/*
 * Decompiled with CFR 0.152.
 */
package com.zzo.javaserver;

import java.io.FileOutputStream;
import java.io.PrintStream;

public class Debug {
    static final int DEBUG = 1;
    static final int INFO = 2;
    static final int WARN = 3;
    private int debugLevel;
    private PrintStream ps = System.out;

    public Debug() {
        String string = System.getProperty("loglevel");
        if (string != null) {
            String string2;
            if (string.equalsIgnoreCase("debug")) {
                this.debugLevel = 1;
            }
            if (string.equalsIgnoreCase("info")) {
                this.debugLevel = 2;
            }
            if (string.equalsIgnoreCase("warn")) {
                this.debugLevel = 3;
            }
            if ((string2 = System.getProperty("logfile")) != null) {
                try {
                    this.ps = new PrintStream(new FileOutputStream(string2));
                }
                catch (Exception exception) {
                    this.ps = System.out;
                }
            }
        } else {
            this.debugLevel = 0;
        }
    }

    private void dump(Object object, String string) {
        this.ps.print(string + ": ");
        this.ps.println(System.currentTimeMillis() + ": " + object.toString());
        this.ps.flush();
    }

    public void debug(Object object) {
        if (this.debugLevel >= 1) {
            this.dump(object, "DEBUG");
        }
    }

    public void info(Object object) {
        if (this.debugLevel >= 2) {
            this.dump(object, "INFO");
        }
    }

    public void warn(Object object) {
        if (this.debugLevel >= 3) {
            this.dump(object, "WARN");
        }
    }

    public void warn(Object object, Throwable throwable) {
        if (this.debugLevel >= 3) {
            this.dump(object, "WARN");
            this.dump(throwable.getMessage(), "WARN");
        }
    }
}

