/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.mlib;

import com.sun.media.jai.mlib.JaiI18N;
import com.sun.media.jai.mlib.MediaLibAccessor;
import com.sun.medialib.mlib.Image;
import com.sun.medialib.mlib.mediaLibImage;
import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.util.Map;
import javax.media.jai.AreaOpImage;
import javax.media.jai.BorderExtender;
import javax.media.jai.ImageLayout;
import javax.media.jai.operator.MedianFilterDescriptor;
import javax.media.jai.operator.MedianFilterShape;

final class MlibMedianFilterOpImage
extends AreaOpImage {
    protected int maskType;
    protected int maskSize;

    public MlibMedianFilterOpImage(RenderedImage renderedImage, BorderExtender borderExtender, Map map, ImageLayout imageLayout, MedianFilterShape medianFilterShape, int n) {
        super(renderedImage, imageLayout, map, true, borderExtender, (n - 1) / 2, (n - 1) / 2, n / 2, n / 2);
        this.maskType = MlibMedianFilterOpImage.mapToMlibMaskType(medianFilterShape);
        this.maskSize = n;
    }

    private static int mapToMlibMaskType(MedianFilterShape medianFilterShape) {
        if (medianFilterShape.equals(MedianFilterDescriptor.MEDIAN_MASK_SQUARE)) {
            return 0;
        }
        if (medianFilterShape.equals(MedianFilterDescriptor.MEDIAN_MASK_PLUS)) {
            return 1;
        }
        if (medianFilterShape.equals(MedianFilterDescriptor.MEDIAN_MASK_X)) {
            return 2;
        }
        if (medianFilterShape.equals(MedianFilterDescriptor.MEDIAN_MASK_SQUARE_SEPARABLE)) {
            return 3;
        }
        throw new RuntimeException(JaiI18N.getString("MedianFilterOpImage0"));
    }

    protected void computeRect(Raster[] rasterArray, WritableRaster writableRaster, Rectangle rectangle) {
        Raster raster = rasterArray[0];
        Rectangle rectangle2 = this.mapDestRect(rectangle, 0);
        int n = MediaLibAccessor.findCompatibleTag(rasterArray, writableRaster);
        MediaLibAccessor mediaLibAccessor = new MediaLibAccessor(raster, rectangle2, n);
        MediaLibAccessor mediaLibAccessor2 = new MediaLibAccessor(writableRaster, rectangle, n);
        int n2 = this.getSampleModel().getNumBands();
        int n3 = (1 << n2) - 1;
        mediaLibImage[] mediaLibImageArray = mediaLibAccessor.getMediaLibImages();
        mediaLibImage[] mediaLibImageArray2 = mediaLibAccessor2.getMediaLibImages();
        int n4 = 0;
        while (n4 < mediaLibImageArray2.length) {
            switch (mediaLibAccessor2.getDataType()) {
                case 0: 
                case 1: 
                case 2: 
                case 3: {
                    if (this.maskSize == 3) {
                        Image.MedianFilter3x3((mediaLibImage)mediaLibImageArray2[n4], (mediaLibImage)mediaLibImageArray[n4], (int)this.maskType, (int)n3, (int)0);
                        break;
                    }
                    if (this.maskSize == 5) {
                        Image.MedianFilter5x5((mediaLibImage)mediaLibImageArray2[n4], (mediaLibImage)mediaLibImageArray[n4], (int)this.maskType, (int)n3, (int)0);
                        break;
                    }
                    if (this.maskSize == 7) {
                        Image.MedianFilter7x7((mediaLibImage)mediaLibImageArray2[n4], (mediaLibImage)mediaLibImageArray[n4], (int)this.maskType, (int)n3, (int)0);
                        break;
                    }
                    Image.MedianFilterMxN((mediaLibImage)mediaLibImageArray2[n4], (mediaLibImage)mediaLibImageArray[n4], (int)this.maskSize, (int)this.maskSize, (int)this.maskType, (int)n3, (int)0);
                    break;
                }
                case 4: 
                case 5: {
                    if (this.maskSize == 3) {
                        Image.MedianFilter3x3_Fp((mediaLibImage)mediaLibImageArray2[n4], (mediaLibImage)mediaLibImageArray[n4], (int)this.maskType, (int)n3, (int)0);
                        break;
                    }
                    if (this.maskSize == 5) {
                        Image.MedianFilter5x5_Fp((mediaLibImage)mediaLibImageArray2[n4], (mediaLibImage)mediaLibImageArray[n4], (int)this.maskType, (int)n3, (int)0);
                        break;
                    }
                    if (this.maskSize == 7) {
                        Image.MedianFilter7x7_Fp((mediaLibImage)mediaLibImageArray2[n4], (mediaLibImage)mediaLibImageArray[n4], (int)this.maskType, (int)n3, (int)0);
                        break;
                    }
                    Image.MedianFilterMxN_Fp((mediaLibImage)mediaLibImageArray2[n4], (mediaLibImage)mediaLibImageArray[n4], (int)this.maskSize, (int)this.maskSize, (int)this.maskType, (int)n3, (int)0);
                    break;
                }
                default: {
                    String string = this.getClass().getName();
                    throw new RuntimeException(JaiI18N.getString("Generic2"));
                }
            }
            ++n4;
        }
        if (mediaLibAccessor2.isDataCopy()) {
            mediaLibAccessor2.copyDataToRaster();
        }
    }
}

